/*
 * @(#)Bevel2dP.h
 *
 * Copyright 2023  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Bevel2d */

#ifndef _Bevel2dP_h
#define _Bevel2dP_h

#include "Bevel2d.h"

#ifndef WINVER
/* This gets around C's inability to do inheritance */
typedef struct _Bevel2DClassPart {
	int ignore;
} Bevel2DClassPart;

typedef struct _Bevel2DClassRec {
	CoreClassPart coreClass;
	BevelClassPart bevelClass;
	Bevel2DClassPart bevel2dClass;
} Bevel2DClassRec;

extern Bevel2DClassRec bevel2dClassRec;
#endif

#define FRONT_LOC 0
#define BACK_LOC 11
#define COORD2D 8
#define MAXX 3
#define MAXY 4
#define MAXXY 4			/* (MAX(MAXX,MAXY)) */
#define MAX_RECT (MAXX*MAXY)

typedef struct _Bevel2DPart {
	Position    faceLength;
	Position    viewLength;
	Position    diamondLength;
} Bevel2DPart;

typedef struct _Bevel2DRec {
	CorePart    core;
	BevelPart   bevel;
	Bevel2DPart bevel2d;
} Bevel2DRec;

extern Boolean selectPieces2D(Bevel2DWidget w, int x, int y,
	int *face, int *position);
extern Boolean narrowSelection2D(Bevel2DWidget w,
	int *face, int *direction);
extern void drawFrame2D(Bevel2DWidget w, Boolean focus);
extern void drawInnerTriangle2D(Bevel2DWidget w, int face, int position,
	int offset);
extern void drawOuterTriangle2D(Bevel2DWidget w, int face, int position,
	int offset);
#ifdef WINVER
extern void initializePuzzle2D(Bevel2DWidget w);
extern void resizePuzzle2D(Bevel2DWidget w);
extern void exposePuzzle2D(Bevel2DWidget w);
#endif

#endif /* _Bevel2dP_h */
