# -*- encoding: utf-8 -*-
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import sqlalchemy

from ceilometer.openstack.common import timeutils
from ceilometer.storage.sqlalchemy import models


def upgrade(migrate_engine):
    meta = sqlalchemy.MetaData(bind=migrate_engine)
    meter = sqlalchemy.Table('meter', meta, autoload=True)
    c = sqlalchemy.Column('recorded_at', models.PreciseTimestamp(),
                          default=timeutils.utcnow)
    meter.create_column(c)


def downgrade(migrate_engine):
    meta = sqlalchemy.MetaData(bind=migrate_engine)
    meter = sqlalchemy.Table('meter', meta, autoload=True)
    meter.drop_column('recorded_at')
