/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: TTFOutputStream.java 1357883 2012-07-05 20:29:53Z gadams $ */

package org.apache.fop.fonts.truetype;

import java.io.IOException;

/**
 * An interface for writing a TrueType font to an output stream.
 */
public interface TTFOutputStream {

    /**
     * Starts writing the font.
     */
    void startFontStream() throws IOException;

    /**
     * Returns an object for streaming TrueType tables.
     */
    TTFTableOutputStream getTableOutputStream();

    /**
     * Returns an object for streaming TrueType glyphs in the glyf table.
     */
    TTFGlyphOutputStream getGlyphOutputStream();

    /**
     * Ends writing the font.
     */
    void endFontStream() throws IOException;

}
