; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-arm-none-eabi -verify-machineinstrs -mattr=+mve %s -o - | FileCheck %s

define arm_aapcs_vfpcc <2 x i64> @brv_2i64_t(<2 x i64> %src){
; CHECK-LABEL: brv_2i64_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev64.8 q1, q0
; CHECK-NEXT:    movs r0, #8
; CHECK-NEXT:    vbrsr.8 q0, q1, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %src)
  ret <2 x i64> %0
}

define arm_aapcs_vfpcc <4 x i32> @brv_4i32_t(<4 x i32> %src){
; CHECK-LABEL: brv_4i32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movs r0, #32
; CHECK-NEXT:    vbrsr.32 q0, q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> %src)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <8 x i16> @brv_8i16_t(<8 x i16> %src){
; CHECK-LABEL: brv_8i16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movs r0, #16
; CHECK-NEXT:    vbrsr.16 q0, q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> %src)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <16 x i8> @brv_16i8_t(<16 x i8> %src){
; CHECK-LABEL: brv_16i8_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movs r0, #8
; CHECK-NEXT:    vbrsr.8 q0, q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.bitreverse.v16i8(<16 x i8> %src)
  ret <16 x i8> %0
}

declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>)
declare <4 x i32> @llvm.bitreverse.v4i32(<4 x i32>)
declare <8 x i16> @llvm.bitreverse.v8i16(<8 x i16>)
declare <16 x i8> @llvm.bitreverse.v16i8(<16 x i8>)
