// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv32 -target-feature +v -target-feature +zfh -target-feature +xsfvcp -disable-O0-optnone -emit-llvm %s -o - | opt -S -passes=mem2reg | FileCheck --check-prefix=CHECK-RV32 %s
// RUN: %clang_cc1 -triple riscv64 -target-feature +v -target-feature +zfh -target-feature +xsfvcp -disable-O0-optnone -emit-llvm %s -o - | opt -S -passes=mem2reg | FileCheck --check-prefix=CHECK-RV64 %s

#include <sifive_vector.h>

#define p27_26 (0b11)
#define p26    (0b1)
#define simm5  (10)

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv1i8.nxv1i8.i32(i32 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv1i8.nxv1i8.i64(i64 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u8mf8(vuint8mf8_t vd, vuint8mf8_t vs2, vuint8mf8_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u8mf8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv2i8.nxv2i8.i32(i32 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv2i8.nxv2i8.i64(i64 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u8mf4(vuint8mf4_t vd, vuint8mf4_t vs2, vuint8mf4_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u8mf4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv4i8.nxv4i8.i32(i32 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv4i8.nxv4i8.i64(i64 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u8mf2(vuint8mf2_t vd, vuint8mf2_t vs2, vuint8mf2_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u8mf2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv8i8.nxv8i8.i32(i32 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv8i8.nxv8i8.i64(i64 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u8m1(vuint8m1_t vd, vuint8m1_t vs2, vuint8m1_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u8m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv16i8.nxv16i8.i32(i32 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv16i8.nxv16i8.i64(i64 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u8m2(vuint8m2_t vd, vuint8m2_t vs2, vuint8m2_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u8m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv32i8.nxv32i8.i32(i32 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv32i8.nxv32i8.i64(i64 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u8m4(vuint8m4_t vd, vuint8m4_t vs2, vuint8m4_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u8m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv64i8.nxv64i8.i32(i32 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv64i8.nxv64i8.i64(i64 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u8m8(vuint8m8_t vd, vuint8m8_t vs2, vuint8m8_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u8m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv1i16.nxv1i16.i32(i32 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv1i16.nxv1i16.i64(i64 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, vuint16mf4_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u16mf4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv2i16.nxv2i16.i32(i32 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv2i16.nxv2i16.i64(i64 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, vuint16mf2_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u16mf2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv4i16.nxv4i16.i32(i32 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv4i16.nxv4i16.i64(i64 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u16m1(vuint16m1_t vd, vuint16m1_t vs2, vuint16m1_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u16m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv8i16.nxv8i16.i32(i32 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv8i16.nxv8i16.i64(i64 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u16m2(vuint16m2_t vd, vuint16m2_t vs2, vuint16m2_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u16m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv16i16.nxv16i16.i32(i32 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv16i16.nxv16i16.i64(i64 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u16m4(vuint16m4_t vd, vuint16m4_t vs2, vuint16m4_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u16m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv32i16.nxv32i16.i32(i32 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv32i16.nxv32i16.i64(i64 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u16m8(vuint16m8_t vd, vuint16m8_t vs2, vuint16m8_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u16m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv1i32.nxv1i32.i32(i32 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv1i32.nxv1i32.i64(i64 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, vuint32mf2_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u32mf2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv2i32.nxv2i32.i32(i32 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv2i32.nxv2i32.i64(i64 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u32m1(vuint32m1_t vd, vuint32m1_t vs2, vuint32m1_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u32m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv4i32.nxv4i32.i32(i32 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv4i32.nxv4i32.i64(i64 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u32m2(vuint32m2_t vd, vuint32m2_t vs2, vuint32m2_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u32m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv8i32.nxv8i32.i32(i32 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv8i32.nxv8i32.i64(i64 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u32m4(vuint32m4_t vd, vuint32m4_t vs2, vuint32m4_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u32m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv16i32.nxv16i32.i32(i32 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv16i32.nxv16i32.i64(i64 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u32m8(vuint32m8_t vd, vuint32m8_t vs2, vuint32m8_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u32m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv1i64.nxv1i64.i32(i32 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv1i64.nxv1i64.i64(i64 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u64m1(vuint64m1_t vd, vuint64m1_t vs2, vuint64m1_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u64m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv2i64.nxv2i64.i32(i32 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv2i64.nxv2i64.i64(i64 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u64m2(vuint64m2_t vd, vuint64m2_t vs2, vuint64m2_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u64m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv4i64.nxv4i64.i32(i32 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv4i64.nxv4i64.i64(i64 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u64m4(vuint64m4_t vd, vuint64m4_t vs2, vuint64m4_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u64m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_vvv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i32.nxv8i64.nxv8i64.i32(i32 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_vvv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.vvv.se.i64.nxv8i64.nxv8i64.i64(i64 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_vvv_se_u64m8(vuint64m8_t vd, vuint64m8_t vs2, vuint64m8_t vs1, size_t vl) {
  __riscv_sf_vc_vvv_se_u64m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv1i8.i32.nxv1i8.i32(i32 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv1i8.i64.nxv1i8.i64(i64 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_vvv_se_u8mf8(vuint8mf8_t vd, vuint8mf8_t vs2, vuint8mf8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u8mf8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv2i8.i32.nxv2i8.i32(i32 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv2i8.i64.nxv2i8.i64(i64 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_vvv_se_u8mf4(vuint8mf4_t vd, vuint8mf4_t vs2, vuint8mf4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u8mf4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv4i8.i32.nxv4i8.i32(i32 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv4i8.i64.nxv4i8.i64(i64 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_vvv_se_u8mf2(vuint8mf2_t vd, vuint8mf2_t vs2, vuint8mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u8mf2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv8i8.i32.nxv8i8.i32(i32 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv8i8.i64.nxv8i8.i64(i64 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_vvv_se_u8m1(vuint8m1_t vd, vuint8m1_t vs2, vuint8m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u8m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv16i8.i32.nxv16i8.i32(i32 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv16i8.i64.nxv16i8.i64(i64 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_vvv_se_u8m2(vuint8m2_t vd, vuint8m2_t vs2, vuint8m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u8m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv32i8.i32.nxv32i8.i32(i32 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv32i8.i64.nxv32i8.i64(i64 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_vvv_se_u8m4(vuint8m4_t vd, vuint8m4_t vs2, vuint8m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u8m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv64i8.i32.nxv64i8.i32(i32 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vvv.se.nxv64i8.i64.nxv64i8.i64(i64 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_vvv_se_u8m8(vuint8m8_t vd, vuint8m8_t vs2, vuint8m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u8m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv1i16.i32.nxv1i16.i32(i32 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv1i16.i64.nxv1i16.i64(i64 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_vvv_se_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, vuint16mf4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u16mf4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv2i16.i32.nxv2i16.i32(i32 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv2i16.i64.nxv2i16.i64(i64 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_vvv_se_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, vuint16mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u16mf2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv4i16.i32.nxv4i16.i32(i32 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv4i16.i64.nxv4i16.i64(i64 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_vvv_se_u16m1(vuint16m1_t vd, vuint16m1_t vs2, vuint16m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u16m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv8i16.i32.nxv8i16.i32(i32 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv8i16.i64.nxv8i16.i64(i64 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_vvv_se_u16m2(vuint16m2_t vd, vuint16m2_t vs2, vuint16m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u16m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv16i16.i32.nxv16i16.i32(i32 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv16i16.i64.nxv16i16.i64(i64 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_vvv_se_u16m4(vuint16m4_t vd, vuint16m4_t vs2, vuint16m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u16m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv32i16.i32.nxv32i16.i32(i32 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vvv.se.nxv32i16.i64.nxv32i16.i64(i64 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_vvv_se_u16m8(vuint16m8_t vd, vuint16m8_t vs2, vuint16m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u16m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv1i32.i32.nxv1i32.i32(i32 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv1i32.i64.nxv1i32.i64(i64 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_vvv_se_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, vuint32mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u32mf2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv2i32.i32.nxv2i32.i32(i32 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv2i32.i64.nxv2i32.i64(i64 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_vvv_se_u32m1(vuint32m1_t vd, vuint32m1_t vs2, vuint32m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u32m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv4i32.i32.nxv4i32.i32(i32 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv4i32.i64.nxv4i32.i64(i64 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_vvv_se_u32m2(vuint32m2_t vd, vuint32m2_t vs2, vuint32m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u32m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv8i32.i32.nxv8i32.i32(i32 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv8i32.i64.nxv8i32.i64(i64 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_vvv_se_u32m4(vuint32m4_t vd, vuint32m4_t vs2, vuint32m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u32m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv16i32.i32.nxv16i32.i32(i32 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vvv.se.nxv16i32.i64.nxv16i32.i64(i64 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_vvv_se_u32m8(vuint32m8_t vd, vuint32m8_t vs2, vuint32m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u32m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv1i64.i32.nxv1i64.i32(i32 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv1i64.i64.nxv1i64.i64(i64 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_vvv_se_u64m1(vuint64m1_t vd, vuint64m1_t vs2, vuint64m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u64m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv2i64.i32.nxv2i64.i32(i32 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv2i64.i64.nxv2i64.i64(i64 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_vvv_se_u64m2(vuint64m2_t vd, vuint64m2_t vs2, vuint64m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u64m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv4i64.i32.nxv4i64.i32(i32 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv4i64.i64.nxv4i64.i64(i64 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_vvv_se_u64m4(vuint64m4_t vd, vuint64m4_t vs2, vuint64m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u64m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv8i64.i32.nxv8i64.i32(i32 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vvv.se.nxv8i64.i64.nxv8i64.i64(i64 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_vvv_se_u64m8(vuint64m8_t vd, vuint64m8_t vs2, vuint64m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_se_u64m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vvv.nxv1i8.i32.nxv1i8.i32(i32 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.vvv.nxv1i8.i64.nxv1i8.i64(i64 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_vvv_u8mf8(vuint8mf8_t vd, vuint8mf8_t vs2, vuint8mf8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u8mf8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vvv.nxv2i8.i32.nxv2i8.i32(i32 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.vvv.nxv2i8.i64.nxv2i8.i64(i64 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_vvv_u8mf4(vuint8mf4_t vd, vuint8mf4_t vs2, vuint8mf4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u8mf4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vvv.nxv4i8.i32.nxv4i8.i32(i32 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.vvv.nxv4i8.i64.nxv4i8.i64(i64 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_vvv_u8mf2(vuint8mf2_t vd, vuint8mf2_t vs2, vuint8mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u8mf2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vvv.nxv8i8.i32.nxv8i8.i32(i32 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.vvv.nxv8i8.i64.nxv8i8.i64(i64 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_vvv_u8m1(vuint8m1_t vd, vuint8m1_t vs2, vuint8m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u8m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vvv.nxv16i8.i32.nxv16i8.i32(i32 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.vvv.nxv16i8.i64.nxv16i8.i64(i64 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_vvv_u8m2(vuint8m2_t vd, vuint8m2_t vs2, vuint8m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u8m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vvv.nxv32i8.i32.nxv32i8.i32(i32 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.vvv.nxv32i8.i64.nxv32i8.i64(i64 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_vvv_u8m4(vuint8m4_t vd, vuint8m4_t vs2, vuint8m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u8m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vvv.nxv64i8.i32.nxv64i8.i32(i32 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.vvv.nxv64i8.i64.nxv64i8.i64(i64 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_vvv_u8m8(vuint8m8_t vd, vuint8m8_t vs2, vuint8m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u8m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vvv.nxv1i16.i32.nxv1i16.i32(i32 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vvv.nxv1i16.i64.nxv1i16.i64(i64 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_vvv_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, vuint16mf4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u16mf4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vvv.nxv2i16.i32.nxv2i16.i32(i32 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vvv.nxv2i16.i64.nxv2i16.i64(i64 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_vvv_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, vuint16mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u16mf2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vvv.nxv4i16.i32.nxv4i16.i32(i32 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vvv.nxv4i16.i64.nxv4i16.i64(i64 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_vvv_u16m1(vuint16m1_t vd, vuint16m1_t vs2, vuint16m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u16m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vvv.nxv8i16.i32.nxv8i16.i32(i32 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vvv.nxv8i16.i64.nxv8i16.i64(i64 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_vvv_u16m2(vuint16m2_t vd, vuint16m2_t vs2, vuint16m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u16m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vvv.nxv16i16.i32.nxv16i16.i32(i32 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vvv.nxv16i16.i64.nxv16i16.i64(i64 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_vvv_u16m4(vuint16m4_t vd, vuint16m4_t vs2, vuint16m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u16m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vvv.nxv32i16.i32.nxv32i16.i32(i32 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vvv.nxv32i16.i64.nxv32i16.i64(i64 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_vvv_u16m8(vuint16m8_t vd, vuint16m8_t vs2, vuint16m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u16m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vvv.nxv1i32.i32.nxv1i32.i32(i32 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vvv.nxv1i32.i64.nxv1i32.i64(i64 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], <vscale x 1 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_vvv_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, vuint32mf2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u32mf2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vvv.nxv2i32.i32.nxv2i32.i32(i32 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vvv.nxv2i32.i64.nxv2i32.i64(i64 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], <vscale x 2 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_vvv_u32m1(vuint32m1_t vd, vuint32m1_t vs2, vuint32m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u32m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vvv.nxv4i32.i32.nxv4i32.i32(i32 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vvv.nxv4i32.i64.nxv4i32.i64(i64 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], <vscale x 4 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_vvv_u32m2(vuint32m2_t vd, vuint32m2_t vs2, vuint32m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u32m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vvv.nxv8i32.i32.nxv8i32.i32(i32 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vvv.nxv8i32.i64.nxv8i32.i64(i64 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], <vscale x 8 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_vvv_u32m4(vuint32m4_t vd, vuint32m4_t vs2, vuint32m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u32m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vvv.nxv16i32.i32.nxv16i32.i32(i32 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vvv.nxv16i32.i64.nxv16i32.i64(i64 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], <vscale x 16 x i32> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_vvv_u32m8(vuint32m8_t vd, vuint32m8_t vs2, vuint32m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u32m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vvv.nxv1i64.i32.nxv1i64.i32(i32 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vvv.nxv1i64.i64.nxv1i64.i64(i64 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], <vscale x 1 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_vvv_u64m1(vuint64m1_t vd, vuint64m1_t vs2, vuint64m1_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u64m1(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vvv.nxv2i64.i32.nxv2i64.i32(i32 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vvv.nxv2i64.i64.nxv2i64.i64(i64 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], <vscale x 2 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_vvv_u64m2(vuint64m2_t vd, vuint64m2_t vs2, vuint64m2_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u64m2(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vvv.nxv4i64.i32.nxv4i64.i32(i32 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vvv.nxv4i64.i64.nxv4i64.i64(i64 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], <vscale x 4 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_vvv_u64m4(vuint64m4_t vd, vuint64m4_t vs2, vuint64m4_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u64m4(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_vvv_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vvv.nxv8i64.i32.nxv8i64.i32(i32 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_vvv_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vvv.nxv8i64.i64.nxv8i64.i64(i64 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], <vscale x 8 x i64> [[VS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_vvv_u64m8(vuint64m8_t vd, vuint64m8_t vs2, vuint64m8_t vs1, size_t vl) {
  return __riscv_sf_vc_v_vvv_u64m8(p27_26, vd, vs2, vs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv1i8.i8.i32(i32 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv1i8.i8.i64(i64 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u8mf8(vuint8mf8_t vd, vuint8mf8_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u8mf8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv2i8.i8.i32(i32 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv2i8.i8.i64(i64 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u8mf4(vuint8mf4_t vd, vuint8mf4_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u8mf4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv4i8.i8.i32(i32 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv4i8.i8.i64(i64 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u8mf2(vuint8mf2_t vd, vuint8mf2_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u8mf2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv8i8.i8.i32(i32 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv8i8.i8.i64(i64 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u8m1(vuint8m1_t vd, vuint8m1_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u8m1(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv16i8.i8.i32(i32 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv16i8.i8.i64(i64 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u8m2(vuint8m2_t vd, vuint8m2_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u8m2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv32i8.i8.i32(i32 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv32i8.i8.i64(i64 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u8m4(vuint8m4_t vd, vuint8m4_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u8m4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv64i8.i8.i32(i32 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv64i8.i8.i64(i64 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u8m8(vuint8m8_t vd, vuint8m8_t vs2, uint8_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u8m8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv1i16.i16.i32(i32 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv1i16.i16.i64(i64 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u16mf4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv2i16.i16.i32(i32 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv2i16.i16.i64(i64 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u16mf2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv4i16.i16.i32(i32 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv4i16.i16.i64(i64 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u16m1(vuint16m1_t vd, vuint16m1_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u16m1(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv8i16.i16.i32(i32 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv8i16.i16.i64(i64 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u16m2(vuint16m2_t vd, vuint16m2_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u16m2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv16i16.i16.i32(i32 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv16i16.i16.i64(i64 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u16m4(vuint16m4_t vd, vuint16m4_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u16m4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv32i16.i16.i32(i32 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv32i16.i16.i64(i64 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u16m8(vuint16m8_t vd, vuint16m8_t vs2, uint16_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u16m8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv1i32.i32.i32(i32 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv1i32.i32.i64(i64 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, uint32_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u32mf2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv2i32.i32.i32(i32 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv2i32.i32.i64(i64 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u32m1(vuint32m1_t vd, vuint32m1_t vs2, uint32_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u32m1(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv4i32.i32.i32(i32 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv4i32.i32.i64(i64 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u32m2(vuint32m2_t vd, vuint32m2_t vs2, uint32_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u32m2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv8i32.i32.i32(i32 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv8i32.i32.i64(i64 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u32m4(vuint32m4_t vd, vuint32m4_t vs2, uint32_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u32m4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_xvv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i32.nxv16i32.i32.i32(i32 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_xvv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.xvv.se.i64.nxv16i32.i32.i64(i64 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_xvv_se_u32m8(vuint32m8_t vd, vuint32m8_t vs2, uint32_t rs1, size_t vl) {
  __riscv_sf_vc_xvv_se_u32m8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv1i8.i32.i8.i32(i32 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv1i8.i64.i8.i64(i64 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_xvv_se_u8mf8(vuint8mf8_t vd, vuint8mf8_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u8mf8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv2i8.i32.i8.i32(i32 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv2i8.i64.i8.i64(i64 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_xvv_se_u8mf4(vuint8mf4_t vd, vuint8mf4_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u8mf4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv4i8.i32.i8.i32(i32 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv4i8.i64.i8.i64(i64 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_xvv_se_u8mf2(vuint8mf2_t vd, vuint8mf2_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u8mf2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv8i8.i32.i8.i32(i32 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv8i8.i64.i8.i64(i64 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_xvv_se_u8m1(vuint8m1_t vd, vuint8m1_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u8m1(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv16i8.i32.i8.i32(i32 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv16i8.i64.i8.i64(i64 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_xvv_se_u8m2(vuint8m2_t vd, vuint8m2_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u8m2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv32i8.i32.i8.i32(i32 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv32i8.i64.i8.i64(i64 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_xvv_se_u8m4(vuint8m4_t vd, vuint8m4_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u8m4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv64i8.i32.i8.i32(i32 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xvv.se.nxv64i8.i64.i8.i64(i64 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_xvv_se_u8m8(vuint8m8_t vd, vuint8m8_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u8m8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv1i16.i32.i16.i32(i32 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv1i16.i64.i16.i64(i64 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_xvv_se_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u16mf4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv2i16.i32.i16.i32(i32 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv2i16.i64.i16.i64(i64 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_xvv_se_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u16mf2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv4i16.i32.i16.i32(i32 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv4i16.i64.i16.i64(i64 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_xvv_se_u16m1(vuint16m1_t vd, vuint16m1_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u16m1(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv8i16.i32.i16.i32(i32 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv8i16.i64.i16.i64(i64 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_xvv_se_u16m2(vuint16m2_t vd, vuint16m2_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u16m2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv16i16.i32.i16.i32(i32 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv16i16.i64.i16.i64(i64 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_xvv_se_u16m4(vuint16m4_t vd, vuint16m4_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u16m4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv32i16.i32.i16.i32(i32 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xvv.se.nxv32i16.i64.i16.i64(i64 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_xvv_se_u16m8(vuint16m8_t vd, vuint16m8_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u16m8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv1i32.i32.i32.i32(i32 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv1i32.i64.i32.i64(i64 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_xvv_se_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u32mf2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv2i32.i32.i32.i32(i32 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv2i32.i64.i32.i64(i64 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_xvv_se_u32m1(vuint32m1_t vd, vuint32m1_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u32m1(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv4i32.i32.i32.i32(i32 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv4i32.i64.i32.i64(i64 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_xvv_se_u32m2(vuint32m2_t vd, vuint32m2_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u32m2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv8i32.i32.i32.i32(i32 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv8i32.i64.i32.i64(i64 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_xvv_se_u32m4(vuint32m4_t vd, vuint32m4_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u32m4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv16i32.i32.i32.i32(i32 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xvv.se.nxv16i32.i64.i32.i64(i64 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_xvv_se_u32m8(vuint32m8_t vd, vuint32m8_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_se_u32m8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xvv.nxv1i8.i32.i8.i32(i32 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.xvv.nxv1i8.i64.i8.i64(i64 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_xvv_u8mf8(vuint8mf8_t vd, vuint8mf8_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u8mf8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xvv.nxv2i8.i32.i8.i32(i32 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.xvv.nxv2i8.i64.i8.i64(i64 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_xvv_u8mf4(vuint8mf4_t vd, vuint8mf4_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u8mf4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xvv.nxv4i8.i32.i8.i32(i32 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.xvv.nxv4i8.i64.i8.i64(i64 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_xvv_u8mf2(vuint8mf2_t vd, vuint8mf2_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u8mf2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xvv.nxv8i8.i32.i8.i32(i32 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.xvv.nxv8i8.i64.i8.i64(i64 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_xvv_u8m1(vuint8m1_t vd, vuint8m1_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u8m1(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xvv.nxv16i8.i32.i8.i32(i32 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.xvv.nxv16i8.i64.i8.i64(i64 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_xvv_u8m2(vuint8m2_t vd, vuint8m2_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u8m2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xvv.nxv32i8.i32.i8.i32(i32 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.xvv.nxv32i8.i64.i8.i64(i64 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_xvv_u8m4(vuint8m4_t vd, vuint8m4_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u8m4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xvv.nxv64i8.i32.i8.i32(i32 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.xvv.nxv64i8.i64.i8.i64(i64 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_xvv_u8m8(vuint8m8_t vd, vuint8m8_t vs2, uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u8m8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xvv.nxv1i16.i32.i16.i32(i32 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xvv.nxv1i16.i64.i16.i64(i64 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_xvv_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u16mf4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xvv.nxv2i16.i32.i16.i32(i32 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xvv.nxv2i16.i64.i16.i64(i64 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_xvv_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u16mf2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xvv.nxv4i16.i32.i16.i32(i32 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xvv.nxv4i16.i64.i16.i64(i64 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_xvv_u16m1(vuint16m1_t vd, vuint16m1_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u16m1(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xvv.nxv8i16.i32.i16.i32(i32 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xvv.nxv8i16.i64.i16.i64(i64 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_xvv_u16m2(vuint16m2_t vd, vuint16m2_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u16m2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xvv.nxv16i16.i32.i16.i32(i32 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xvv.nxv16i16.i64.i16.i64(i64 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_xvv_u16m4(vuint16m4_t vd, vuint16m4_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u16m4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xvv.nxv32i16.i32.i16.i32(i32 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xvv.nxv32i16.i64.i16.i64(i64 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_xvv_u16m8(vuint16m8_t vd, vuint16m8_t vs2, uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u16m8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xvv.nxv1i32.i32.i32.i32(i32 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xvv.nxv1i32.i64.i32.i64(i64 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_xvv_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u32mf2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xvv.nxv2i32.i32.i32.i32(i32 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xvv.nxv2i32.i64.i32.i64(i64 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_xvv_u32m1(vuint32m1_t vd, vuint32m1_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u32m1(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xvv.nxv4i32.i32.i32.i32(i32 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xvv.nxv4i32.i64.i32.i64(i64 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_xvv_u32m2(vuint32m2_t vd, vuint32m2_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u32m2(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xvv.nxv8i32.i32.i32.i32(i32 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xvv.nxv8i32.i64.i32.i64(i64 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_xvv_u32m4(vuint32m4_t vd, vuint32m4_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u32m4(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_xvv_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xvv.nxv16i32.i32.i32.i32(i32 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_xvv_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xvv.nxv16i32.i64.i32.i64(i64 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_xvv_u32m8(vuint32m8_t vd, vuint32m8_t vs2, uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_xvv_u32m8(p27_26, vd, vs2, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv1i8.i32.i32(i32 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv1i8.i64.i64(i64 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u8mf8(vuint8mf8_t vd, vuint8mf8_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u8mf8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv2i8.i32.i32(i32 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv2i8.i64.i64(i64 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u8mf4(vuint8mf4_t vd, vuint8mf4_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u8mf4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv4i8.i32.i32(i32 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv4i8.i64.i64(i64 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u8mf2(vuint8mf2_t vd, vuint8mf2_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u8mf2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv8i8.i32.i32(i32 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv8i8.i64.i64(i64 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u8m1(vuint8m1_t vd, vuint8m1_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u8m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv16i8.i32.i32(i32 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv16i8.i64.i64(i64 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u8m2(vuint8m2_t vd, vuint8m2_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u8m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv32i8.i32.i32(i32 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv32i8.i64.i64(i64 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u8m4(vuint8m4_t vd, vuint8m4_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u8m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv64i8.i32.i32(i32 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv64i8.i64.i64(i64 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u8m8(vuint8m8_t vd, vuint8m8_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u8m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv1i16.i32.i32(i32 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv1i16.i64.i64(i64 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u16mf4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv2i16.i32.i32(i32 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv2i16.i64.i64(i64 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u16mf2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv4i16.i32.i32(i32 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv4i16.i64.i64(i64 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u16m1(vuint16m1_t vd, vuint16m1_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u16m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv8i16.i32.i32(i32 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv8i16.i64.i64(i64 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u16m2(vuint16m2_t vd, vuint16m2_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u16m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv16i16.i32.i32(i32 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv16i16.i64.i64(i64 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u16m4(vuint16m4_t vd, vuint16m4_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u16m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv32i16.i32.i32(i32 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv32i16.i64.i64(i64 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u16m8(vuint16m8_t vd, vuint16m8_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u16m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv1i32.i32.i32(i32 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv1i32.i64.i64(i64 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u32mf2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv2i32.i32.i32(i32 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv2i32.i64.i64(i64 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u32m1(vuint32m1_t vd, vuint32m1_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u32m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv4i32.i32.i32(i32 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv4i32.i64.i64(i64 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u32m2(vuint32m2_t vd, vuint32m2_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u32m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv8i32.i32.i32(i32 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv8i32.i64.i64(i64 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u32m4(vuint32m4_t vd, vuint32m4_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u32m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv16i32.i32.i32(i32 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv16i32.i64.i64(i64 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u32m8(vuint32m8_t vd, vuint32m8_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u32m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv1i64.i32.i32(i32 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv1i64.i64.i64(i64 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u64m1(vuint64m1_t vd, vuint64m1_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u64m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv2i64.i32.i32(i32 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv2i64.i64.i64(i64 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u64m2(vuint64m2_t vd, vuint64m2_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u64m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv4i64.i32.i32(i32 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv4i64.i64.i64(i64 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u64m4(vuint64m4_t vd, vuint64m4_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u64m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_ivv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i32.nxv8i64.i32.i32(i32 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_ivv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.ivv.se.i64.nxv8i64.i64.i64(i64 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_ivv_se_u64m8(vuint64m8_t vd, vuint64m8_t vs2, size_t vl) {
  __riscv_sf_vc_ivv_se_u64m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv1i8.i32.i32.i32(i32 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv1i8.i64.i64.i64(i64 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_ivv_se_u8mf8(vuint8mf8_t vd, vuint8mf8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u8mf8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv2i8.i32.i32.i32(i32 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv2i8.i64.i64.i64(i64 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_ivv_se_u8mf4(vuint8mf4_t vd, vuint8mf4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u8mf4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv4i8.i32.i32.i32(i32 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv4i8.i64.i64.i64(i64 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_ivv_se_u8mf2(vuint8mf2_t vd, vuint8mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u8mf2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv8i8.i32.i32.i32(i32 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv8i8.i64.i64.i64(i64 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_ivv_se_u8m1(vuint8m1_t vd, vuint8m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u8m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv16i8.i32.i32.i32(i32 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv16i8.i64.i64.i64(i64 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_ivv_se_u8m2(vuint8m2_t vd, vuint8m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u8m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv32i8.i32.i32.i32(i32 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv32i8.i64.i64.i64(i64 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_ivv_se_u8m4(vuint8m4_t vd, vuint8m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u8m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv64i8.i32.i32.i32(i32 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.ivv.se.nxv64i8.i64.i64.i64(i64 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_ivv_se_u8m8(vuint8m8_t vd, vuint8m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u8m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv1i16.i32.i32.i32(i32 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv1i16.i64.i64.i64(i64 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_ivv_se_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u16mf4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv2i16.i32.i32.i32(i32 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv2i16.i64.i64.i64(i64 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_ivv_se_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u16mf2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv4i16.i32.i32.i32(i32 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv4i16.i64.i64.i64(i64 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_ivv_se_u16m1(vuint16m1_t vd, vuint16m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u16m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv8i16.i32.i32.i32(i32 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv8i16.i64.i64.i64(i64 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_ivv_se_u16m2(vuint16m2_t vd, vuint16m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u16m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv16i16.i32.i32.i32(i32 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv16i16.i64.i64.i64(i64 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_ivv_se_u16m4(vuint16m4_t vd, vuint16m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u16m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv32i16.i32.i32.i32(i32 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.ivv.se.nxv32i16.i64.i64.i64(i64 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_ivv_se_u16m8(vuint16m8_t vd, vuint16m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u16m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv1i32.i32.i32.i32(i32 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv1i32.i64.i64.i64(i64 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_ivv_se_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u32mf2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv2i32.i32.i32.i32(i32 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv2i32.i64.i64.i64(i64 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_ivv_se_u32m1(vuint32m1_t vd, vuint32m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u32m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv4i32.i32.i32.i32(i32 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv4i32.i64.i64.i64(i64 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_ivv_se_u32m2(vuint32m2_t vd, vuint32m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u32m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv8i32.i32.i32.i32(i32 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv8i32.i64.i64.i64(i64 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_ivv_se_u32m4(vuint32m4_t vd, vuint32m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u32m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv16i32.i32.i32.i32(i32 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.ivv.se.nxv16i32.i64.i64.i64(i64 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_ivv_se_u32m8(vuint32m8_t vd, vuint32m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u32m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv1i64.i32.i32.i32(i32 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv1i64.i64.i64.i64(i64 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_ivv_se_u64m1(vuint64m1_t vd, vuint64m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u64m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv2i64.i32.i32.i32(i32 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv2i64.i64.i64.i64(i64 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_ivv_se_u64m2(vuint64m2_t vd, vuint64m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u64m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv4i64.i32.i32.i32(i32 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv4i64.i64.i64.i64(i64 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_ivv_se_u64m4(vuint64m4_t vd, vuint64m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u64m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv8i64.i32.i32.i32(i32 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.ivv.se.nxv8i64.i64.i64.i64(i64 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_ivv_se_u64m8(vuint64m8_t vd, vuint64m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_se_u64m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.ivv.nxv1i8.i32.i32.i32(i32 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.ivv.nxv1i8.i64.i64.i64(i64 3, <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_ivv_u8mf8(vuint8mf8_t vd, vuint8mf8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u8mf8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.ivv.nxv2i8.i32.i32.i32(i32 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.ivv.nxv2i8.i64.i64.i64(i64 3, <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_ivv_u8mf4(vuint8mf4_t vd, vuint8mf4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u8mf4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.ivv.nxv4i8.i32.i32.i32(i32 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.ivv.nxv4i8.i64.i64.i64(i64 3, <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_ivv_u8mf2(vuint8mf2_t vd, vuint8mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u8mf2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.ivv.nxv8i8.i32.i32.i32(i32 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.ivv.nxv8i8.i64.i64.i64(i64 3, <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_ivv_u8m1(vuint8m1_t vd, vuint8m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u8m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.ivv.nxv16i8.i32.i32.i32(i32 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.ivv.nxv16i8.i64.i64.i64(i64 3, <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_ivv_u8m2(vuint8m2_t vd, vuint8m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u8m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.ivv.nxv32i8.i32.i32.i32(i32 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.ivv.nxv32i8.i64.i64.i64(i64 3, <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_ivv_u8m4(vuint8m4_t vd, vuint8m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u8m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.ivv.nxv64i8.i32.i32.i32(i32 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.ivv.nxv64i8.i64.i64.i64(i64 3, <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_ivv_u8m8(vuint8m8_t vd, vuint8m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u8m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.ivv.nxv1i16.i32.i32.i32(i32 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.ivv.nxv1i16.i64.i64.i64(i64 3, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_ivv_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u16mf4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.ivv.nxv2i16.i32.i32.i32(i32 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.ivv.nxv2i16.i64.i64.i64(i64 3, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_ivv_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u16mf2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.ivv.nxv4i16.i32.i32.i32(i32 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.ivv.nxv4i16.i64.i64.i64(i64 3, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_ivv_u16m1(vuint16m1_t vd, vuint16m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u16m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.ivv.nxv8i16.i32.i32.i32(i32 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.ivv.nxv8i16.i64.i64.i64(i64 3, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_ivv_u16m2(vuint16m2_t vd, vuint16m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u16m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.ivv.nxv16i16.i32.i32.i32(i32 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.ivv.nxv16i16.i64.i64.i64(i64 3, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_ivv_u16m4(vuint16m4_t vd, vuint16m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u16m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.ivv.nxv32i16.i32.i32.i32(i32 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.ivv.nxv32i16.i64.i64.i64(i64 3, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_ivv_u16m8(vuint16m8_t vd, vuint16m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u16m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.ivv.nxv1i32.i32.i32.i32(i32 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.ivv.nxv1i32.i64.i64.i64(i64 3, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_ivv_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u32mf2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.ivv.nxv2i32.i32.i32.i32(i32 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.ivv.nxv2i32.i64.i64.i64(i64 3, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_ivv_u32m1(vuint32m1_t vd, vuint32m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u32m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.ivv.nxv4i32.i32.i32.i32(i32 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.ivv.nxv4i32.i64.i64.i64(i64 3, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_ivv_u32m2(vuint32m2_t vd, vuint32m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u32m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.ivv.nxv8i32.i32.i32.i32(i32 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.ivv.nxv8i32.i64.i64.i64(i64 3, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_ivv_u32m4(vuint32m4_t vd, vuint32m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u32m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.ivv.nxv16i32.i32.i32.i32(i32 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.ivv.nxv16i32.i64.i64.i64(i64 3, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_ivv_u32m8(vuint32m8_t vd, vuint32m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u32m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.ivv.nxv1i64.i32.i32.i32(i32 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.ivv.nxv1i64.i64.i64.i64(i64 3, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_ivv_u64m1(vuint64m1_t vd, vuint64m1_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u64m1(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.ivv.nxv2i64.i32.i32.i32(i32 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.ivv.nxv2i64.i64.i64.i64(i64 3, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_ivv_u64m2(vuint64m2_t vd, vuint64m2_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u64m2(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.ivv.nxv4i64.i32.i32.i32(i32 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.ivv.nxv4i64.i64.i64.i64(i64 3, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_ivv_u64m4(vuint64m4_t vd, vuint64m4_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u64m4(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_ivv_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.ivv.nxv8i64.i32.i32.i32(i32 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_ivv_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.ivv.nxv8i64.i64.i64.i64(i64 3, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_ivv_u64m8(vuint64m8_t vd, vuint64m8_t vs2, size_t vl) {
  return __riscv_sf_vc_v_ivv_u64m8(p27_26, vd, vs2, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv1i16.f16.i32(i32 1, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv1i16.f16.i64(i64 1, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u16mf4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv2i16.f16.i32(i32 1, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv2i16.f16.i64(i64 1, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u16mf2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv4i16.f16.i32(i32 1, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv4i16.f16.i64(i64 1, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u16m1(vuint16m1_t vd, vuint16m1_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u16m1(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv8i16.f16.i32(i32 1, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv8i16.f16.i64(i64 1, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u16m2(vuint16m2_t vd, vuint16m2_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u16m2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv16i16.f16.i32(i32 1, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv16i16.f16.i64(i64 1, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u16m4(vuint16m4_t vd, vuint16m4_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u16m4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv32i16.f16.i32(i32 1, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv32i16.f16.i64(i64 1, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u16m8(vuint16m8_t vd, vuint16m8_t vs2, _Float16 fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u16m8(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv1i32.f32.i32(i32 1, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv1i32.f32.i64(i64 1, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, float fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u32mf2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv2i32.f32.i32(i32 1, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv2i32.f32.i64(i64 1, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u32m1(vuint32m1_t vd, vuint32m1_t vs2, float fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u32m1(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv4i32.f32.i32(i32 1, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv4i32.f32.i64(i64 1, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u32m2(vuint32m2_t vd, vuint32m2_t vs2, float fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u32m2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv8i32.f32.i32(i32 1, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv8i32.f32.i64(i64 1, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u32m4(vuint32m4_t vd, vuint32m4_t vs2, float fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u32m4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv16i32.f32.i32(i32 1, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv16i32.f32.i64(i64 1, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u32m8(vuint32m8_t vd, vuint32m8_t vs2, float fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u32m8(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv1i64.f64.i32(i32 1, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv1i64.f64.i64(i64 1, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u64m1(vuint64m1_t vd, vuint64m1_t vs2, double fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u64m1(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv2i64.f64.i32(i32 1, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv2i64.f64.i64(i64 1, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u64m2(vuint64m2_t vd, vuint64m2_t vs2, double fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u64m2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv4i64.f64.i32(i32 1, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv4i64.f64.i64(i64 1, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u64m4(vuint64m4_t vd, vuint64m4_t vs2, double fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u64m4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_fvv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i32.nxv8i64.f64.i32(i32 1, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_fvv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.fvv.se.i64.nxv8i64.f64.i64(i64 1, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_fvv_se_u64m8(vuint64m8_t vd, vuint64m8_t vs2, double fs1, size_t vl) {
  __riscv_sf_vc_fvv_se_u64m8(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv1i16.i32.f16.i32(i32 1, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv1i16.i64.f16.i64(i64 1, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_fvv_se_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u16mf4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv2i16.i32.f16.i32(i32 1, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv2i16.i64.f16.i64(i64 1, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_fvv_se_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u16mf2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv4i16.i32.f16.i32(i32 1, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv4i16.i64.f16.i64(i64 1, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_fvv_se_u16m1(vuint16m1_t vd, vuint16m1_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u16m1(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv8i16.i32.f16.i32(i32 1, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv8i16.i64.f16.i64(i64 1, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_fvv_se_u16m2(vuint16m2_t vd, vuint16m2_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u16m2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv16i16.i32.f16.i32(i32 1, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv16i16.i64.f16.i64(i64 1, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_fvv_se_u16m4(vuint16m4_t vd, vuint16m4_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u16m4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv32i16.i32.f16.i32(i32 1, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fvv.se.nxv32i16.i64.f16.i64(i64 1, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_fvv_se_u16m8(vuint16m8_t vd, vuint16m8_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u16m8(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fvv.se.nxv1i32.i32.f32.i32(i32 1, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fvv.se.nxv1i32.i64.f32.i64(i64 1, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_fvv_se_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u32mf2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fvv.se.nxv2i32.i32.f32.i32(i32 1, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fvv.se.nxv2i32.i64.f32.i64(i64 1, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_fvv_se_u32m1(vuint32m1_t vd, vuint32m1_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u32m1(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fvv.se.nxv4i32.i32.f32.i32(i32 1, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fvv.se.nxv4i32.i64.f32.i64(i64 1, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_fvv_se_u32m2(vuint32m2_t vd, vuint32m2_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u32m2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fvv.se.nxv8i32.i32.f32.i32(i32 1, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fvv.se.nxv8i32.i64.f32.i64(i64 1, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_fvv_se_u32m4(vuint32m4_t vd, vuint32m4_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u32m4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fvv.se.nxv16i32.i32.f32.i32(i32 1, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fvv.se.nxv16i32.i64.f32.i64(i64 1, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_fvv_se_u32m8(vuint32m8_t vd, vuint32m8_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u32m8(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fvv.se.nxv1i64.i32.f64.i32(i32 1, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fvv.se.nxv1i64.i64.f64.i64(i64 1, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_fvv_se_u64m1(vuint64m1_t vd, vuint64m1_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u64m1(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fvv.se.nxv2i64.i32.f64.i32(i32 1, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fvv.se.nxv2i64.i64.f64.i64(i64 1, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_fvv_se_u64m2(vuint64m2_t vd, vuint64m2_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u64m2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fvv.se.nxv4i64.i32.f64.i32(i32 1, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fvv.se.nxv4i64.i64.f64.i64(i64 1, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_fvv_se_u64m4(vuint64m4_t vd, vuint64m4_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u64m4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fvv.se.nxv8i64.i32.f64.i32(i32 1, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fvv.se.nxv8i64.i64.f64.i64(i64 1, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_fvv_se_u64m8(vuint64m8_t vd, vuint64m8_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_se_u64m8(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fvv.nxv1i16.i32.f16.i32(i32 1, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.fvv.nxv1i16.i64.f16.i64(i64 1, <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_fvv_u16mf4(vuint16mf4_t vd, vuint16mf4_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u16mf4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fvv.nxv2i16.i32.f16.i32(i32 1, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.fvv.nxv2i16.i64.f16.i64(i64 1, <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_fvv_u16mf2(vuint16mf2_t vd, vuint16mf2_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u16mf2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fvv.nxv4i16.i32.f16.i32(i32 1, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.fvv.nxv4i16.i64.f16.i64(i64 1, <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_fvv_u16m1(vuint16m1_t vd, vuint16m1_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u16m1(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fvv.nxv8i16.i32.f16.i32(i32 1, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.fvv.nxv8i16.i64.f16.i64(i64 1, <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_fvv_u16m2(vuint16m2_t vd, vuint16m2_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u16m2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fvv.nxv16i16.i32.f16.i32(i32 1, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.fvv.nxv16i16.i64.f16.i64(i64 1, <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_fvv_u16m4(vuint16m4_t vd, vuint16m4_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u16m4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fvv.nxv32i16.i32.f16.i32(i32 1, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.fvv.nxv32i16.i64.f16.i64(i64 1, <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], half [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_fvv_u16m8(vuint16m8_t vd, vuint16m8_t vs2, _Float16 fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u16m8(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fvv.nxv1i32.i32.f32.i32(i32 1, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.fvv.nxv1i32.i64.f32.i64(i64 1, <vscale x 1 x i32> [[VD:%.*]], <vscale x 1 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_fvv_u32mf2(vuint32mf2_t vd, vuint32mf2_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u32mf2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fvv.nxv2i32.i32.f32.i32(i32 1, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.fvv.nxv2i32.i64.f32.i64(i64 1, <vscale x 2 x i32> [[VD:%.*]], <vscale x 2 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_fvv_u32m1(vuint32m1_t vd, vuint32m1_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u32m1(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fvv.nxv4i32.i32.f32.i32(i32 1, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.fvv.nxv4i32.i64.f32.i64(i64 1, <vscale x 4 x i32> [[VD:%.*]], <vscale x 4 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_fvv_u32m2(vuint32m2_t vd, vuint32m2_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u32m2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fvv.nxv8i32.i32.f32.i32(i32 1, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.fvv.nxv8i32.i64.f32.i64(i64 1, <vscale x 8 x i32> [[VD:%.*]], <vscale x 8 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_fvv_u32m4(vuint32m4_t vd, vuint32m4_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u32m4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fvv.nxv16i32.i32.f32.i32(i32 1, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.fvv.nxv16i32.i64.f32.i64(i64 1, <vscale x 16 x i32> [[VD:%.*]], <vscale x 16 x i32> [[VS2:%.*]], float [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_fvv_u32m8(vuint32m8_t vd, vuint32m8_t vs2, float fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u32m8(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fvv.nxv1i64.i32.f64.i32(i32 1, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.fvv.nxv1i64.i64.f64.i64(i64 1, <vscale x 1 x i64> [[VD:%.*]], <vscale x 1 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_fvv_u64m1(vuint64m1_t vd, vuint64m1_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u64m1(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fvv.nxv2i64.i32.f64.i32(i32 1, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.fvv.nxv2i64.i64.f64.i64(i64 1, <vscale x 2 x i64> [[VD:%.*]], <vscale x 2 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_fvv_u64m2(vuint64m2_t vd, vuint64m2_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u64m2(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fvv.nxv4i64.i32.f64.i32(i32 1, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.fvv.nxv4i64.i64.f64.i64(i64 1, <vscale x 4 x i64> [[VD:%.*]], <vscale x 4 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_fvv_u64m4(vuint64m4_t vd, vuint64m4_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u64m4(p26, vd, vs2, fs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_fvv_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fvv.nxv8i64.i32.f64.i32(i32 1, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_fvv_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.fvv.nxv8i64.i64.f64.i64(i64 1, <vscale x 8 x i64> [[VD:%.*]], <vscale x 8 x i64> [[VS2:%.*]], double [[FS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_fvv_u64m8(vuint64m8_t vd, vuint64m8_t vs2, double fs1, size_t vl) {
  return __riscv_sf_vc_v_fvv_u64m8(p26, vd, vs2, fs1, vl);
}
