/*
 * unity-webapps-available-application.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <glib.h>

#include "unity-webapps-available-application.h"

#include "../unity-webapps-debug.h"

struct _UnityWebappsAvailableApplicationPrivate {
  gpointer fill;
};


G_DEFINE_ABSTRACT_TYPE(UnityWebappsAvailableApplication, unity_webapps_available_application, G_TYPE_OBJECT)

#define UNITY_WEBAPPS_AVAILABLE_APPLICATION_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE ((object), UNITY_WEBAPPS_TYPE_AVAILABLE_APPLICATION, UnityWebappsAvailableApplicationPrivate))

static void
unity_webapps_available_application_class_init (UnityWebappsAvailableApplicationClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  
  g_type_class_add_private (object_class, sizeof(UnityWebappsAvailableApplicationPrivate));
}

static void
unity_webapps_available_application_init (UnityWebappsAvailableApplication *app)
{
  app->priv = UNITY_WEBAPPS_AVAILABLE_APPLICATION_GET_PRIVATE (app);
}

const gchar *
unity_webapps_available_application_get_name (UnityWebappsAvailableApplication *app)
{
  return UNITY_WEBAPPS_AVAILABLE_APPLICATION_GET_CLASS (app)->get_name (app);
}

const gchar *
unity_webapps_available_application_get_application_name (UnityWebappsAvailableApplication *app)
{
  return UNITY_WEBAPPS_AVAILABLE_APPLICATION_GET_CLASS (app)->get_application_name (app);
}

const gchar *
unity_webapps_available_application_get_application_domain (UnityWebappsAvailableApplication *app)
{
  return UNITY_WEBAPPS_AVAILABLE_APPLICATION_GET_CLASS (app)->get_application_domain (app);
}


void 
unity_webapps_available_application_get_is_installed (UnityWebappsAvailableApplication *self,
						      UnityWebappsAvailableApplicationInstalledQueryCallback callback,
						      gpointer user_data)
{
  UNITY_WEBAPPS_AVAILABLE_APPLICATION_GET_CLASS (self)->get_is_installed (self, callback, user_data);
}
