/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-dbus-util.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_DBUS_UTIL_H
#define __UNITY_WEBAPPS_DBUS_UTIL_H

#define UNITY_WEBAPPS_DEFINE_VOID_DBUS_HANDLER(M,l,m,U,S) \
	static void M##_complete_callback (GObject *source_object, GAsyncResult *res, gpointer user_data) { \
	  UnityWebappsGen##m *proxy; GError *error; \
      proxy = UNITY_WEBAPPS_GEN_##U (source_object); \
	  error = NULL; \
	  unity_webapps_gen_##l##_call_##M##_finish (proxy, res, &error); \
	  if (error != NULL) { \
	    g_warning ("Error calling "#M " method of "#m  "context: %s" , error->message);  \
	    g_error_free (error);  \
      } UNITY_WEBAPPS_NOTE (U, "Received response: "#S);}

#endif







