/*
 * Decompiled with CFR 0.152.
 */
package com.wombatinvasion.pmwikidraw;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PmWikiDrawingConverter {
    List lines = new ArrayList();

    public void convert(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        this.lines.clear();
        while ((string = bufferedReader.readLine()) != null) {
            this.lines.add(string);
        }
        if (this.lines.size() > 1) {
            int n;
            String string2 = (String)this.lines.get(1);
            if (string2.indexOf("org.jhotdraw.standard.StandardDrawing") > -1) {
                n = string2.indexOf("org.jhotdraw.standard.StandardDrawing");
                String string3 = string2.substring(n + "org.jhotdraw.standard.StandardDrawing".length(), string2.length()).trim();
                int n2 = this.nestingLevel(string2);
                String string4 = this.buildNestingSegment(n2) + "com.wombatinvasion.pmwikidraw.PmWikiDrawing" + " 0 " + string3;
                this.lines.set(1, string4);
            }
            if ((n = this.getDrawingVersion()) != 2) {
                if (n > 2) {
                    System.err.println("Please upgrade this version of PmWikiDraw, you seem to have drawings that are more recent than I can handle :(!");
                } else {
                    System.out.println("Converting drawing with " + this.lines.size() + " lines.");
                    switch (n) {
                        case 0: {
                            System.err.println("Performing archaic upgrade.");
                            this.removeAttributeLinesandConnectors();
                            this.fixLineFiguresandConnectors();
                        }
                        case 1: {
                            this.fixTextFigureBorders();
                        }
                    }
                    this.setDrawingVersion();
                }
            }
        }
    }

    private void fixTextFigureBorders() {
        for (int i = 0; i < this.lines.size(); ++i) {
            String string;
            String string2 = (String)this.lines.get(i);
            if (string2.indexOf("org.jhotdraw.figures.TextFigure") <= -1) continue;
            if (string2.indexOf("FrameColor") > -1) break;
            if (string2.indexOf("\"no_attributes\"") > -1) {
                int n = string2.indexOf("\"no_attributes\"");
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + "\"no_attributes\"".length());
                string = "\"attributes\" \"attributes\" 2 \"FrameColor\" \"Color\" 255 199 158 \"FillColor\" \"Color\" 255 199 158";
                this.lines.set(i, string3 + string + string4);
                continue;
            }
            String string5 = string2;
            int n = string2.indexOf("\"attributes\"");
            int n2 = n + "\"attributes\"".length() * 2 + 2;
            string = string2.substring(0, n2);
            String string6 = string2.substring(n2);
            int n3 = string6.indexOf(34);
            String string7 = string6.substring(n3);
            String string8 = string6.substring(0, n3).trim();
            int n4 = Integer.parseInt(string8);
            string5 = string + (n4 + 1) + " \"FrameColor\" \"Color\" 255 199 158 " + string7;
            this.lines.set(i, string5);
        }
    }

    private void fixLineFiguresandConnectors() {
        for (int i = 0; i < this.lines.size(); ++i) {
            String string = (String)this.lines.get(i);
            if (string.indexOf("org.jhotdraw.figures.LineConnection") <= -1 && string.indexOf("org.jhotdraw.figures.LineFigure") <= -1 && string.indexOf("org.jhotdraw.figures.PolyLineFigure") <= -1 && string.indexOf("org.jhotdraw.figures.ElbowConnection") <= -1) continue;
            String string2 = this.getClassName(i);
            int n = this.nestingLevel(string);
            String string3 = string.substring(n + string2.length()).trim();
            String string4 = string.substring(0, n + string2.length()) + " \"no_attributes\" " + string3;
            this.lines.set(i, string4);
        }
    }

    private void removeAttributeLinesandConnectors() {
        boolean bl = true;
        do {
            int n = 0;
            for (n = 0; n < this.lines.size(); ++n) {
                String string = (String)this.lines.get(n);
                if (string.indexOf("org.jhotdraw.contrib.AttributeConnectorFigure") <= -1 && string.indexOf("org.jhotdraw.contrib.AttributeLineFigure") <= -1) continue;
                int n2 = this.findNextObjectLine(n, this.nestingLevel(string));
                if (n2 >= 0) {
                    for (int i = n + 1; i < n2; ++i) {
                        this.reduceIndent(i);
                    }
                }
                this.lines.remove(n);
                this.fixReferences(n - 1);
                break;
            }
            if (n < this.lines.size()) continue;
            bl = false;
        } while (bl);
    }

    public InputStream getConvertedStream() throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream));
        Iterator iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            bufferedWriter.write((String)object);
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return object;
    }

    private int nestingLevel(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ' || string.charAt(i) == '\t') continue;
            return i;
        }
        return string.length();
    }

    private int findNextObjectLine(int n, int n2) {
        if (n == this.lines.size() - 1) {
            return -1;
        }
        for (int i = n + 1; i < this.lines.size(); ++i) {
            if (this.nestingLevel((String)this.lines.get(i)) > n2) continue;
            return i;
        }
        return this.lines.size() - 1;
    }

    public int getDrawingVersion() {
        String string = (String)this.lines.get(1);
        int n = string.indexOf("com.wombatinvasion.pmwikidraw.PmWikiDrawing");
        String string2 = string.substring(n + "com.wombatinvasion.pmwikidraw.PmWikiDrawing".length(), string.length()).trim();
        int n2 = string2.indexOf(32);
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1, string2.length());
        return Integer.parseInt(string3);
    }

    public void setDrawingVersion() {
        String string = (String)this.lines.get(1);
        int n = string.indexOf("com.wombatinvasion.pmwikidraw.PmWikiDrawing");
        int n2 = this.nestingLevel(string);
        String string2 = string.substring(n + "com.wombatinvasion.pmwikidraw.PmWikiDrawing".length(), string.length()).trim();
        int n3 = string2.indexOf(32);
        String string3 = string2.substring(n3).trim();
        String string4 = "2";
        this.lines.set(1, this.buildNestingSegment(n2) + "com.wombatinvasion.pmwikidraw.PmWikiDrawing" + " " + string4 + " " + string3);
    }

    public String buildNestingSegment(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void reduceIndent(int n) {
        String string = (String)this.lines.get(n);
        if (this.nestingLevel(string) <= 0) {
            System.err.println("Error condition, shouldn't be trying to reduceIndent, not possible!");
        } else {
            string = string.substring(4);
            this.lines.set(n, string);
        }
    }

    private String getClassName(int n) {
        String string = ((String)this.lines.get(n)).trim();
        int n2 = string.indexOf(32);
        string = string.substring(0, n2);
        return string;
    }

    private void fixReferences(int n) {
        for (int i = 0; i < this.lines.size(); ++i) {
            String string = (String)this.lines.get(i);
            int n2 = string.indexOf("REF");
            if (n2 <= -1) continue;
            String string2 = string.substring(n2 + 4).trim();
            int n3 = Integer.parseInt(string2);
            if (n3 > n) {
                --n3;
            }
            String string3 = string.substring(0, n2) + "REF " + n3;
            this.lines.set(i, string3);
        }
    }
}

