/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.JTextField;

public class FloatingTextField {
    private JTextField fEditWidget = new JTextField(20);
    private Container fContainer;

    public void createOverlay(Container container) {
        this.createOverlay(container, null);
    }

    public void createOverlay(Container container, Font font) {
        container.add((Component)this.fEditWidget, 0);
        if (font != null) {
            this.fEditWidget.setFont(font);
        }
        this.fContainer = container;
    }

    public void addActionListener(ActionListener actionListener) {
        this.fEditWidget.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fEditWidget.removeActionListener(actionListener);
    }

    public void setBounds(Rectangle rectangle, String string) {
        this.fEditWidget.setText(string);
        this.fEditWidget.setLocation(rectangle.x, rectangle.y);
        this.fEditWidget.setSize(rectangle.width, rectangle.height);
        this.fEditWidget.setVisible(true);
        this.fEditWidget.selectAll();
        this.fEditWidget.requestFocus();
    }

    public String getText() {
        return this.fEditWidget.getText();
    }

    public Dimension getPreferredSize(int n) {
        this.fEditWidget.setColumns(n);
        return this.fEditWidget.getPreferredSize();
    }

    public void endOverlay() {
        this.fContainer.requestFocus();
        if (this.fEditWidget != null) {
            this.fEditWidget.setVisible(false);
            this.fContainer.remove(this.fEditWidget);
            Rectangle rectangle = this.fEditWidget.getBounds();
            this.fContainer.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

