/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.RouteDescription;
import com.amazon.aes.webservices.client.RouteResourceType;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ReplaceRoute
extends BaseCmd {
    public static final String[] CIDR_DESC = new String[]{"The IP range to be routed."};
    public static final String[] GATEWAY_DESC = new String[]{"The gateway associated with the route.", "Must specify this, -i/--instance, or -n/--network."};
    public static final String[] INSTANCE_DESC = new String[]{"The instance associated with the route.", "Must specify this, -g/--gateway, or -n/--network."};
    public static final String[] NETWORK_INTERFACE_DESC = new String[]{"The network interface associated with the route.", "Must specify this, -i/instance, or -g/--gateway."};

    public ReplaceRoute(String[] args) {
        super("ec2reprt", "ec2-replace-route");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"cidr");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"CIDR");
        OptionBuilder.withDescription((String)ReplaceRoute.joinDescription(CIDR_DESC));
        o.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"gateway");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"GATEWAY");
        OptionBuilder.withDescription((String)ReplaceRoute.joinDescription(GATEWAY_DESC));
        o.addOption(OptionBuilder.create((String)"g"));
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"INSTANCE");
        OptionBuilder.withDescription((String)ReplaceRoute.joinDescription(INSTANCE_DESC));
        o.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"network-interface");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"NETWORKINTERFACE");
        OptionBuilder.withDescription((String)ReplaceRoute.joinDescription(NETWORK_INTERFACE_DESC));
        o.addOption(OptionBuilder.create((String)"n"));
        return o;
    }

    @Override
    public String getOptionString() {
        return "ROUTE_TABLE -r CIDR { -g GATEWAY | -i INSTANCE | -n NETWORK_INTERFACE }";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Replaces a route in a given route table.");
        System.out.println("     ROUTE_TABLE is the ID of the route table in which to replace a route.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        super.printOption("gateway");
        super.printOption("instance");
        super.printOption("network-interface");
        super.printOption("cidr");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RouteResourceType routeResourceType;
        String id;
        this.assertNonOptionSet("ROUTE_TABLE");
        this.assertOptionSet("cidr");
        this.assertOnlyOneOptionSet(new String[]{"gateway", "instance", "network-interface"});
        this.warnIfTooManyNonOptions();
        String routeTableId = this.getNonOptions()[0];
        String cidrBlock = this.getOptionValue("cidr");
        String gatewayId = this.getOptionValue("gateway");
        String instanceId = this.getOptionValue("instance");
        String networkInterfaceId = this.getOptionValue("network-interface");
        if (gatewayId != null && gatewayId.length() > 0) {
            id = gatewayId;
            routeResourceType = RouteResourceType.gateway;
        } else if (instanceId != null && instanceId.length() > 0) {
            id = instanceId;
            routeResourceType = RouteResourceType.instance;
        } else if (networkInterfaceId != null && networkInterfaceId.length() > 0) {
            id = networkInterfaceId;
            routeResourceType = RouteResourceType.networkInterface;
        } else {
            System.err.println("You must specify either GATEWAY, INSTANCE, or NETWORK ATTACHMENT");
            return false;
        }
        RequestResultPair result = jec2.replaceRoute(routeTableId, cidrBlock, id, routeResourceType);
        out.output(System.out, (RouteDescription)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new ReplaceRoute(args).invoke();
    }
}

