/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.RouteTableAssociationDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ReplaceRouteTableAssociation
extends BaseCmd {
    public static final String[] ROUTE_TABLE_DESC = new String[]{"ROUTE_TABLE is the ID of the new route table."};

    public ReplaceRouteTableAssociation(String[] args) {
        super("ec2reprtbassoc", "ec2-replace-route-table-association");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"route-table");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"ROUTE_TABLE");
        OptionBuilder.withDescription((String)ReplaceRouteTableAssociation.joinDescription(ROUTE_TABLE_DESC));
        o.addOption(OptionBuilder.create((String)"r"));
        return o;
    }

    @Override
    public String getOptionString() {
        return "ASSOCIATION -r ROUTE_TABLE";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Replace an association between a subnet and a route table with a new route table.");
        System.out.println("     ASSOCIATION is the ID of the association to replace.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        super.printOption("route-table");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("ASSOCIATION");
        this.assertOptionSet("route-table");
        this.warnIfTooManyNonOptions();
        String associationId = this.getNonOptions()[0];
        String routeTableId = this.getOptionValue("route-table");
        RequestResultPair result = jec2.replaceRouteTableAssociation(associationId, routeTableId);
        RouteTableAssociationDescription assoc = new RouteTableAssociationDescription((String)result.getResponse(), routeTableId, null, Boolean.valueOf(false));
        out.output(System.out, assoc);
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new ReplaceRouteTableAssociation(args).invoke();
    }
}

