cmdlist = [
("Pmv","SLCommands","SL","""Command that performs Bsp tree operations such as 'union',\n    'difference', 'intersect'."""),
("Pmv","SLCommands","SaveBspt","""Command to save a Bspt set in a file."""),
("Pmv","SLCommands","RestoreBspt","""Command to build a geometric object out of previously built and\n    saved in a file Bspt set. Adds the new object to the viewer.\n    The object can be linked to a molecule."""),
("Pmv","SLCommands","BindGeomToMolecularFragment","""Command to bind an Indexed Geometry to a molecule."""),
("Pmv","SLCommands","DisplayBoundGeom","""Command to display/undisplay geometries that were bound to molecules with\n    'BindGeomToMolecularFragment' command. """),
("Pmv","SLCommands","UndisplayBoundGeom",""""""),
("Pmv","amberCommands","setup_Amber94","""\nThis command creates an instance of Amber94 class and enters it in Amber94Config dictionary with specified name as the key. The Amber94 instance requires a Parm instance, which can be built from scratch or readin from a file.\n    """),
("Pmv","amberCommands","setminimOpts_Amber94","""\n    This class allows you to set minimization options of a Amber94 instance \nThese options include cut, nsnb, dield and verbose. NB: this is written as \na separate class in order to create a clear log.\n\n    """),
("Pmv","amberCommands","setmdOpts_Amber94","""\n    This class allows you to set md options of a Amber94 instance \nThese options include t, dt, tautp, temp0, verbose, vlimit, ntpr_md, zerov,\ntempi and idum. NB: this is written as a separate class in order to \ncreate a straight-forward log.\n\n    """),
("Pmv","amberCommands","minimize_Amber94","""\n    This class allows you to select an Amber94 instance from Amber94Config\nwhose keys are ids specified in setup_Amber94 for the Amber94 instances.\nYou can also set minimization options, freeze atoms, specify constrained \natoms and anchor atoms and set maxIter, drms and dfpred. The minimization \ncan be run repeatedly.\n\n    """),
("Pmv","amberCommands","md_Amber94","""\n    This class allows you to select an Amber94 instance from Amber94Config\nwhose keys are ids specified in setup_Amber94 for the Amber94 instances.\nYou can also set md options, freeze atoms, specify constrained \natoms and anchor atoms and set maxStep. The md \ncan be run repeatedly.\n\n    """),
("Pmv","amberCommands","play_md_trj_Amber94","""\n    This class allows you to select an Amber94 instance from Amber94Config\nwhose keys are ids specified in setup_Amber94 for the Amber94 instances, and\na molecular dynamics trajectory file and play the trajectory.\n\n    """),
("Pmv","amberCommands","freezeAtoms_Amber94","""\n    This class allows you to freeze atoms of an Amber94 instance\n\n    """),
("Pmv","amberCommands","constrainAtoms_Amber94","""\n    This class allows you to constrain atoms of an Amber94 instance\n\n    """),
("Pmv","amberCommands","fixAmberHNames","""\nThis class checks hydrogen atom names and modifies them to conform to\nAmber conventions: \n\n        Single hydrogen atoms bonded to N are named 'H'. \n        Single hydrogen atoms bonded to atoms with 2 or 3 character \n    names are named 'H'+ bonded-atom's name[1:].  \n    eg. \n        hydrogen bonded to atom 'CA' is named 'HA'\n        hydrogen bonded to atom 'OG1' of THR is named 'HG1'.\n\n        Pairs of hydrogens bonded to atoms append '2' or '3' to names \n    formed as above.\n    eg. \n        hydrogens bonded to n-terminus 'N' of PRO are named 'H2' and 'H3'.\n        hydrogens bonded to atom 'CA' of GLY are named 'HA2' and 'HA3'.\n        hydrogens bonded to atom 'CG1' of ILE are named 'HG12' and 'HG13'.\n\n        Trios of hydrogens bonded to atoms append '1', '2' or '3' to \n    names formed as above.\n    eg. \n        hydrogens bonded to n-terminus 'N' of ALA are named 'H1', 'H2' and 'H3'.\n        hydrogens bonded to atom 'CB' of ALA are named 'HB1','HB2' and 'HB3'.\n        hydrogens bonded to atom 'CB' of ALA are named 'HB1','HB2' and 'HB3'.\n        hydrogens bonded to atom 'CD1' of ILE are named 'HD11','HD12' and\n        'HD13'.\n    """),
("Pmv","amberCommands","fixAmberHNamesGC","""\nThis class provides Graphical User Interface to FixAmberHAtomsNameCommand\nwhich is invoked by it with the current selection, if there is one.\n    """),
("Pmv","amberCommands","fixAmberResNamesOrder","""\nThis class reorders atoms to conform to Amber conventions: \n\n        for residues with no cycles:\n        N,[H*],_A,[HA*],_B,[HB*],_G,[HG*],_D,[HD*],_E,[HE*],_Z,[HZ*],_H,[HH*],C,O\n\n        for HIS:\n            HID: (has HD1)\n            N,[H*],CA,HA,CB,HB2,HB3,CG,ND1,HD1,CE1,HE1,NE2,CD2,HD2,C,O\n            HIE: (has HE2)\n            N,[H*],CA,HA,CB,HB2,HB3,CG,ND1,CE1,HE1,NE2,HE2,CD2,HD2,C,O\n            HIP: (has both)\n            N,[H*],CA,HA,CB,HB2,HB3,CG,ND1,HD1,CE1,HE1,NE2,HE2,CD2,HD2,C,O\n\n        for PHE:\n            N,[H*],CA,HA,CB,HB2,HB3,CG,CD1,HD1,CE1,HE1,CZ,HZ,CE2,HE2,CD2,HD2,C,O\n\n        for PRO:\n            N,[H*], CD, HD2, HD3, CG, HG2, HG3, CB, HB2, HB3, CA, HA, C, O\n        \n        for TRP:\n            N,[H*],CA,HA,CB,HB2,HB3,CG,CD1,HD1,NE1,HE1,CE2,CZ2,HZ2,CH2,HH2,\n                CZ3,HZ3,CE3,HE3,CD2,C,O\n\n        for TYR:\n            N,[H*],CA,HA,CB,HB2,HB3,CG,CD1,HD1,CE1,HE1,CZ,OH,HH,\n                CE2,HE2,CD2,HD2,C,O\n    """),
("Pmv","artCommands","SetAsPointer",""" This command will set a pattern to be use as a pointer.\n    The pointer is represent as a sphere.\n    A sphere(object name:'sph') is created in the viewer,\n    its dpylist is associated to a pattern.\n    We only allow one pointer to be set for now(Jan 17 2003)\n    \n    Synopsis:\n            None <-SetAsPointer(patname,**kw)\n    Required packages:\n            ARTK\n    Required commands:\n            None\n    """),
("Pmv","artCommands","stopART",""" This command stop the grabbing of the video and detection.\n    Synopsis:\n            None <-StopART(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","loadPattern","""This command select the patterns to be loaded and use as\n    marker for recogniition.\n    Synopsis:\n            None <-LoadPattern(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","loadGroup","""This command select patterns to be loaded and use as\n    group of marker for recogniition.\n    Synopsis:\n            None <-LoadGroup(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","startPatternManager",""" This command start a ARTK patternmanager.The patternmanager is\n    handle in ARTK/pattern.py\n    Synopsis:\n            None <-startPatternManager(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","SetpatWidth",""" This command allow to set the width of  a pattern"""),
("Pmv","artCommands","SetAnim",""" This command allow to assign a animation to a pattern"""),
("Pmv","artCommands","SetGeoms",""" This command allow to assign a geom to a pattern"""),
("Pmv","artCommands","SetMask",""" This command allow to assign a mask to a pattern"""),
("Pmv","artCommands","maskOnOff",""" This command allow to toggle on/off the mask display for the pattern"""),
("Pmv","artCommands","playerGuiOnOff ",""" This command allow to toggle on/off the player gui for the pattern"""),
("Pmv","artCommands","setPosition",""" This Command allow to transform the position of the 3D object\n    relative to the center of the marker.\n    It use the Pmv window and the current object to get the transformation.\n    """),
("Pmv","artCommands","loadPosition",""" This command allow to load the transformation matrix from a file\n    to be applied to a marker.\n    """),
("Pmv","artCommands","savePosition",""" This command allow to save the transformation matrix of a pattern or\n    a list of pattern to a file.\n    """),
("Pmv","artCommands","measureDist",""" This command allow to Show distance between two selected\n    recognize markers.\n    Synopsis:\n            None <-measureDist(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","clearMeasureDist","""This command stop displaying the distance between\n    two selected markers.\n    Synopsis:\n            None <-clearMeasureDist(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","averagetransfoOn",""" This command start the averaging of the transformation matrix\n    used to display a object on the detected pattern. It set the number\n    of previous frame to use.The matrix use will be the average of the\n    n previous matrix.This command is used to stop the jigglering of\n    the 3Dmodel when the pattern face the camera.\n    Synopsis:\n            None <-AveragetransfoOn(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","averagetransfoOff",""" This command is use to stop averaging the transformation matrix \n    with the n previous one of a detected pattern.\n    Synopsis:\n            None <-averagetransfoOff(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","startART","""This command start the video grabbing and display of the image\n    and the 3D object when a pattern is detected.\n    Synopsis:\n            None <-StartART(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","initViewer",""" This command provide the initialisation step of PyART Viewer.\n    it will start the video initialisation and create the ARTViewer.\n    """),
("Pmv","artCommands","VideoTexOnOff",""" This command toggle on/off display of video texture in ARTviewer.\n    Synopsis:\n            None <-VideoTexOnOff(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","changeVconf",""" This command change the video setting.\n    Synopsis:\n            None <-ChangeVconf(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","artCommands","closeVideo",""" This command close the video.\n    Synopsis:\n            None <-CloseVideo(**kw)\n\n    Required packages:\n        ARTK\n    Required commands:\n        None\n    """),
("Pmv","bondsCommands","buildBondsByDistance","""\n    Package : Pmv\n    Module  : bondsCommands\n    Class   : BuildBondsByDistance\n    Command : buildBondsByDistance\n    keywords: bonds, build\n    Description:\n    This command creates the bonds between atoms of the given set of nodes and\n    connect the residues when necessary. The cut_off distance is based on the\n    bond order radius of the two atoms to be bound. The command will use the\n    bhtree functionality to find the pairs of atoms to be found when available.\n    This command can be applied on a current selection or used interactively\n    when bound to the mouse event.\n    Synopsis:\n        None <- buildBondsByDistance( nodes, display = True, **kw)\n        nodes  : any set for MolKit nodes describing molecular components\n        display: when set to 1 the displayLines command is called and the\n                 bonds are displayed as lines.\n        kw     : any of the additional optional keywords supported by commands\n               (see ViewerFramework.VFCommands.Command documentation).\n    Required Commands:\n      displayLines ?\n\n    Known bugs:\n      None\n    Examples:\n      mol = mv.Mols[0]\n      mv.buildBondsByDistance(mol, display=1)\n    """),
("Pmv","bondsCommands","addBonds","""\n    The AddBondGUICommand provides an interactive way of creating bonds between\n    two given atoms by picking on them. To use this command you need first to\n    load it into PMV.\n    Then you can find the entry 'addBonds' under the Edit menu. To add bonds\n    you just need to pick on the 2 atoms you want to bind. This command is\n    undoable\n    """),
("Pmv","bondsCommands","removeBonds",""" The RemoveBondsCommand provides an interactive way of deleting\n    picked bonds. To use this command you need to first load it in the\n    application. Once loaded you will find an entry called 'delete bonds' under\n    the Edit menu. You can then pick on the bonds you wish to delete. This\n    command is undoable.\n    """),
("Pmv","colorCommands","color","""\n    Package : Pmv\n    Module  : colorCommands\n    Class   : ColorCommand\n    Command : color\n    \n    Description:\n    The ColorCommand class is the base class from which all the color commands\n    implemented for PMV will derive.\n    It implements the general functionalities to color the specified geometries\n    representing the specified nodes with the given list of colors.\n\n    Synopsis:\n      None <- color(nodes, colors[(1.,1.,1.),], geomsToColor='all', **kw)\n      nodes       : any set of MolKit nodes describing molecular components\n      colors      : list of rgb tuple\n      geomsToColor: list of the name of geometries to color default is 'all'\n    \n    Keywords: color\n    """),
("Pmv","colorCommands","colorByAtomType","""\n    Package : Pmv\n    Module  : colorCommands\n    Class   :  ColorByAtomType\n    Command : colorbyAtomType\n    \n    Description:\n    The colorByAtomType command allows the user to color the given geometry\n    representing the given nodes using the atomtype coloring scheme where:\n    N :Blue ; C : White ; O : Red ; S : Yellow ; H : Cyan; P: Magenta;\n    UNK:green.\n    This coloring scheme gives some information on the atomic composition of\n    the given nodes.\n\n    Synopsis:\n      None <- colorByAtomType(nodes, geomsToColor='all', **kw)\n      nodes       : any set of MolKit nodes describing molecular components\n      geomsToColor: list of the name of geometries to color default is 'all'\n\n    Keywords: color, atom type\n    """),
("Pmv","colorCommands","colorByResidueType","""\n    Package : Pmv\n    Module  : colorCommands\n    Class   : ColorByResidueType\n    Command : colorByResidueType\n    \n    Description:\n    The colorByResidueType command allows the user to color the given\n    geometries representing the given nodes using the Rasmol coloring scheme\n    where:\n    ASP, GLU    bright red       CYS, MET       yellow\n    LYS, ARG    blue             SER, THR       orange\n    PHE, TYR    mid blue         ASN, GLN       cyan\n    GLY         light grey       LEU, VAL, ILE  green\n    ALA         dark grey        TRP            pink\n    HIS         pale blue        PRO            flesh\n    \n    Synopsis:\n      None <- colorByResidueType(nodes, geomsToColor='all', **kw)\n      nodes       : any set of MolKit nodes describing molecular components\n      geomsToColor: list of the name of geometries to color default is 'all'\n\n    Keywords: color, Rasmol, residue type\n    """),
("Pmv","colorCommands","colorAtomsUsingDG","""\n    Package : Pmv\n    Module  : colorCommands\n    Class   : ColorByDG\n    Command : colorByDG\n    \n    Description:\n    The colorByDG command allows the user to color the given geometries\n    representing the given nodes using the following David Goodsell coloring\n    scheme.\n\n    Synopsis:\n      None <- colorByDG(nodes, geomsToColor='all', **kw)\n      nodes       : any set of MolKit nodes describing molecular components\n      geomsToColor: list of the name of geometries to color default is 'all'\n\n    Keywords: color, David Goodsell coloring scheme\n    """),
("Pmv","colorCommands","colorResiduesUsingShapely","""\n    Package : Pmv\n    Module  : colorCommands\n    Class   : ColorByResidueType\n    Command : colorByResidueType\n    \n    Description:\n    The colorByShapely command allows the user to color the given\n    geometries representing the given nodes using the Shapely coloring scheme\n    where each residue has a different color. (For more information\n    please refer to the pmv tutorial).\n\n    Synopsis:\n      None <- colorByShapely(nodes, geomsToColor='all', **kw)\n      nodes       : any set of MolKit nodes describing molecular components\n      geomsToColor: list of the name of geometries to color default is 'all'\n\n    Keywords: color, shapely, residue type\n    """),
("Pmv","colorCommands","colorByChains","""\n    Package : Pmv\n    Module  : colorCommands\n    Class   : ColorByChain\n    Command : colorByChain\n    \n    Description:\n    The colorByChain command allows the user to color the given\n    geometries representing the given nodes by chain. A different color is\n    assigned to each chain. \n\n    Synopsis:\n      None <- colorByChain(nodes, geomsToColor='all', **kw)\n      nodes       : any set of MolKit nodes describing molecular components\n      geomsToColor: list of the name of geometries to color default is 'all'\n\n    Keywords: color, chain\n    """),
("Pmv","colorCommands","colorByMolecules","""\n    Package : Pmv\n    Module  : colorCommands\n    Class   : ColorByChain\n    Command : colorByChain\n    \n    Description:\n    The colorByChain command allows the user to color the given\n    geometries representing the given nodes by molecules. A different color is\n    assigned to each molecule. \n\n    Synopsis:\n      None <- colorByChain(nodes, geomsToColor='all', **kw)\n      nodes       : any set of MolKit nodes describing molecular components\n      geomsToColor: list of the name of geometries to color default is 'all'\n\n    Keywords: color, chain\n    """),
("Pmv","colorCommands","colorByInstance","""Command to color the current selection by instance using a\n    Rainbow palette.\n    """),
("Pmv","colorCommands","colorByProperty","""\n    Command to color the current selection according to the integer\n    or float properties, or by defining a function.\n    """),
("Pmv","colorCommands","colorByExpression",""""""),
("Pmv","deleteCommands","deleteMol",""" Command to delete a molecule from the MoleculeViewer"""),
("Pmv","deleteCommands","deleteAtomSet",""" Command to remove an AtomSet from the MoleculeViewer"""),
("Pmv","deleteCommands","deleteHydrogens",""" Command to remove hydrogen atoms from the MoleculeViewer"""),
("Pmv","displayCommands","displaySticksAndBalls","""\n    Package : Pmv\n    Module  : displayCommands\n    Class   : DisplaySticksAndBalls\n    Command : displaySticksAndBalls\n    keywords: display sticks and balls representation\n    Description:\n    The displaySticksAndBalls command allows the user to display/undisplay the\n    given nodes using the sticks and balls representation, where the bonds\n    are represented by cylinders and the atoms by balls.\n    The radii of the cylinders and the balls, and the quality of the spheres\n    are user defined. The user can chose to display or not the balls.\n\n    Synopsis:\n        None <- displaySticksAndBalls(nodes,  only=0, negate=0, noballs=0,\n                                      bradii=0.4, bquality=4, cradius=0.2,\n                                      absolute=1, **kw)\n        nodes   : any set of MolKit nodes describing molecular components\n        only    : Boolean flag specifying whether or not to only display\n                  the current selection\n        negate  : Boolean flag specifying whether or not to undisplay\n                  the current selection\n        noballs : Boolean flag specifying whether or not to undisplay the\n                  balls geometry of the current selection\n        cradius : specifies the cylinder radius\n        bradii  : specifies the radius of the balls if displayed.\n        bquality: specifies the quality of the balls if displayed.\n        **kw\n    """),
("Pmv","displayCommands","displayCPK","""\n    Package : Pmv\n    Module  : displayCommands\n    Class   : DisplayCPK\n    Command : displayCPK\n    keywords: display, CPK, space filling, undisplay.\n    Description:\n    The displayCPK command allows the user to display/undisplay the\n    given nodes using a CPK representation, where each atom is represented\n    with a sphere. A scale factor and the quality of the spheres are user\n    defined parameters.\n\n    Synopsis:\n        None <- displayCPK(nodes, only=False, negate=False, \n                           scaleFactor=None, quality=None, **kw)\n        nodes      : any set of MolKit nodes describing molecular components\n        only       : Boolean flag specifying whether or not to only display\n                     the current selection\n        negate     : Boolean flag specifying whether or not to undisplay\n                     the current selection\n        scaleFactor: specifies a scale factor that will be applied to the atom\n                     radii to compute the spheres radii. (default is 1.0)\n        quality    : specifies the quality of the spheres. (default 10)\n        **kw       :\n    """),
("Pmv","displayCommands","displayLines","""\n    Package : Pmv\n    Module  : displayCommands\n    Class   : DisplayLines\n    Command : displayLines\n    Description:\n    The displayLines allows the user to display/undisplay the selected nodes\n    using a lines for bonded atoms, dots for non bonded atoms and doted lines\n    for an aromatic ring. The number of lines when representing a bond will\n    vary depending on the bondOrder.\n    Synopsis:\n    None <- displayLines(self, nodes, lineWidth=2, displayBO = 1, only = 0,\n                         negate = 0, **kw)\n    required arguments:\n    nodes -- any set of MolKit nodes describing molecular components\n\n    optional arguments:\n    lineWidth -- int specifying the width of the lines, dots or doted lines\n                 representing the selection. (default = 2)\n    displayBO -- boolean flag specifying whether or not to display the\n                 bond order (default = False)\n    only      -- boolean flag specifying whether or not to display only the\n                 current selection. (default = False)\n    negate    -- boolean flag  specifying whether or not to negate the current\n                 selection. (default = False)\n                 \n\n    keywords: display wireframe, lines, bond order, non bonded atoms.\n    """),
("Pmv","displayCommands","showMolecules","""\n    Package : Pmv\n    Module  : displayCommands\n    Class   : ShowMolecules\n    Command : showMolecules\n    keywords: show hide molecules\n    Description:\n    The showMolecules command allows the user to show or hide chosen molecules.\n\n    Synopsis:\n        None <- showMolecules(molName, negate = 0, **kw)\n        molName : list of the string representing the name of the molecules\n                  to be hidden or shown\n        negate  : Boolean Flag when True the molecules corresponding to\n                  the given names are hidden, when set to 0 they will be\n                  shown\n        **kw\n    """),
("Pmv","displayCommands","undisplayLines","""\n    Package : Pmv\n    Module  : displayCommands\n    Class   : UnDisplayLines\n    Command : undisplayLines\n    keywords: undisplay, lines\n    Description:\n    The undisplayLines command is a picking command allowing the user to\n    undisplay the lines geometry representing the picked nodes.\n    This command can also be called from the Python shell with a set of nodes.\n\n    Synopsis:\n        None <- undisplayLines(nodes, **kw)\n        nodes  : any set of MolKit nodes describing molecular components\n        **kw   :\n    """),
("Pmv","displayCommands","undisplayCPK","""\n    Package : Pmv\n    Module  : displayCommands\n    Class   : UnDisplayCPK\n    Command : undisplayCPK\n    keywords: undisplay, CPK\n    Description:\n    The undisplayCPK command is a picking command allowing the user to\n    undisplay the CPK geometry representing the picked nodes when used as\n    a picking command or the given nodes when called from the Python shell.\n\n    Synopsis:\n        None <- undisplayCPK(nodes, **kw)\n        nodes : any set of MolKit nodes describing molecular components\n        **kw  : \n    """),
("Pmv","displayCommands","undisplaySticksAndBalls",""" The UndisplaySticksAndBalls command is an interactive command to\n    undisplay part of the molecule when represented as sticks and balls."""),
("Pmv","editCommands","editAtomTypeGC",""" None <- editAtomTypeGC(nodes, **kw)\nnodes: TreeNodeSet \nThis class provides the GUI to EditAtom Type which allows the user \nto change assigned atom types.\n\n    """),
("Pmv","editCommands","editAtomChargeGC",""" None <- editAtomChargeGC(nodes, **kw)\nnodes: TreeNodeSet \nThis class provides the GUI to EditAtomCharge which allows the user \nto change atom charge.\n\n    """),
("Pmv","editCommands","typeAtoms",""" None <- typeAtoms(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\nThis class uses the AtomHybridization class to assign atom types.\n\nexample:\n\n      >>> atype = AtomHybridization()\n      >>> atype.assignHybridization(atoms)\n\n      atoms has to be a list of atom objects\n      Atom:\n          a.element : atom's chemical element symbol (string)\n          a.coords : 3-sequence of floats\n          a.bonds : list of Bond objects\n      Bond:\n          b.atom1 : instance of Atom\n          b.atom2 : instance of Atom\n\n      after completion each atom has the following additional members:\n          babel_type: string\n          babel_atomic_number: int\n          babel_organic\n\nreimplementation of Babel1.6 in Python by Michel Sanner April 2000\nOriginal code by W. Patrick Walters and Matthew T. Stahl\n\n    """),
("Pmv","editCommands","editAtomType",""" None <- editAtomType(ats, btype, **kw)\n    at: atom \n    btype: babel_type\n    This class allows the user to change assigned atom types.\n\n    """),
("Pmv","editCommands","assignAtomsRadii","""\n    None <- mv.assignAtomsRadii(nodes, united=1, overwrite=1,**kw)\n    required arguments:\n    nodes    --\n\n    optional arguments:\n    united   -- (default=1) flag to specify whether or not to consider\n            hydrogen atoms. When hydrogen are there the atom radii\n            is smaller. \n\n    overwrite --(default=1) flag to specify whether or not to overwrite\n            existing radii information.\n\n    This commands adds radii to all the atoms loaded so far in the\n    application. Only default radii for now\n    """),
("Pmv","editCommands","typeBonds",""" None <- typeBonds(nodes, withRings=0, **kw)\n           nodes: TreeNodeSet holding the current selection\n           withRings: default is 0\nThis class uses the BondOrder class to compute bond order.\n\nBefore a BondOrder object can be used, atoms must have been assigned\na type see (AtomHybridization in types.py).\n\nBond order can be calculated using 2 different methods depending on whether\nrings have been identified previously or not. Babel decides to use the first\nmethod for molecules with more than 200 atoms and the second one else.\n\nexample:\n\n      >>> atype = AtomHybridization()\n      >>> atype.assignHybridization(atoms)\n      >>> bo = BondOrder()\n      >>> bo.assignBondOrder( atoms, bonds )\n\n      or\n\n      >>> atype = AtomHybridization()\n      >>> atype.assignHybridization(atoms)\n      >>> rings = RingFinder()\n      >>> rings.findRings(allAtoms, bonds)\n      >>> bo = BondOrder()\n      >>> bo.assignBondOrder( atoms, bonds, rings )\n\n      atoms has to be a list of atom objects\n      Atom:\n          a.coords : 3-sequence of floats\n          a.bonds : list of Bond objects\n          babel_type: string\n          babel_atomic_number: int\n\n      Bond:\n          b.atom1 : instance of Atom\n          b.atom2 : instance of Atom\n\n      after completion each bond has a 'bondOrder' attribute (integer)\n\nreimplementation of Babel1.6 in Python by Michel Sanner April 2000\nOriginal code by W. Patrick Walters and Matthew T. Stahl\n\n    """),
("Pmv","editCommands","addKollmanChargesGC",""" totalCharge <- addKollmanChargesGC(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\n    Kollman united atom charges are added to atoms in peptides by looking up each atom's parent and name in table in Pmv.qkollua.  Missing entries are assigned charge 0.0"""),
("Pmv","editCommands","addKollmanCharges","""totalCharge <- addKollmanCharges(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\ntotalCharge: sum of partial charges on nodes.\n\nKollman united atom partial charges are added to atoms by looking up each atom's parent's type to get a dictionary of charges for specific atom names (from Pmv.qkollua).  Missing entries are assigned charge 0.0.  These partial charges are entered in each atom's '_charges' dictionary as value for key 'Kollman'. Sets the current charge (its chargeSet field) of each atom to 'Kollman'.\n"""),
("Pmv","editCommands","computeGasteigerGC",""" None <-computeGasteigerGC(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\ncalls computeGasteiger which does work of computing gasteiger partial charges\nfor each atom and entering each atom's charge in its _charges dictionary.\n    """),
("Pmv","editCommands","computeGasteiger",""" None <-computeGasteiger(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\ndoes work of computing gasteiger partial charges\nfor each atom and entering each atom's charge in its \n'_charges' dictionary as value for key 'gasteiger' \n(rounded to 4 decimal places).  Calls babel.assignHybridization(mol.allAtoms)\nfor each molecule with atoms in nodes.\nSets the current charge (its chargeSet field) of each atom to\ngasteiger.\n    """),
("Pmv","editCommands","checkChargesGC",""" None <- checkChargesGC(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\n    allows user to call checkResCharges on each residue in selection"""),
("Pmv","editCommands","checkResCharges",""" None <- checkResCharges(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\n    allows user to check charges on each residue + whole molecule"""),
("Pmv","editCommands","averageChargeError",""" None <- averageChargeError(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\n    Adjusts the charge on each atom in  residue with non-integral overall\n    charge so that the sum of the charge on all the atoms in the residue is an\n    integer.  Determines if initial sum is closer to the ceiling or the floor\n    and then adds or subtracts the difference from this nearer value divided\n    by the number of atoms to each atom.  The new chargeSet is called\n    'adjustedCharges'."""),
("Pmv","editCommands","setChargeSet",""" None <- setChargeSet(nodes, key, **kw)\nnodes: TreeNodeSet holding the current selection\nkey:   what charges (keyword of the _charges dictionary).\n    allows user to set string used to index into _charges dictionary"""),
("Pmv","editCommands","add_hGC",""" None<- add_hGC(nodes, polarOnly=0, method='noBondOrder', renumber=1,**kw)\nnodes: TreeNodeSet holding the current selection\npolarOnly: default is 0\nmethod: Hydrogen atoms can be added using 2 different methods, ex: method='withBondOrder', default is 'noBondOrder'\nrenumber: default is 1\nThis GUICOMMAND class calls the AddHydrogenCommand class.\n\n    """),
("Pmv","editCommands","add_h",""" AtomSet <- add_h(nodes, polarOnly=0, method='noBondOrder,\n                         renumber=1,**kw)\nnodes: TreeNodeSet holding the current selection\npolarOnly: default is 0\nmethod: Hydrogen atoms can be added using 2 different methods, ex: method='withBondOrder', default is 'noBondOrder'\nrenumber: default is 1 \n\nReturns an atomSet containing the created H atoms\nNOTE: This command adds hydrogens to all atoms in the molecule\nspecified using the nodes argument.\nThe hydrogen atoms added to each molecule are also saved as a set\ncalled mol.name + '_addedH'\nThis class uses the AddHydrogens class from the PyBabel package.\n\nThis command adds hydrogen atoms to all atoms in all molecules that have\nat least one member (i.e atom, residue, chain, base-pair etc..) specified\nin the first argument.\n\n\nBefore this AddHydrogens object can be used, atoms must have been assigned\na type see (AtomHybridization in types.py).\n\nHydrogen atoms can be added using 2 different methods. The first one requires\nbondOrders to have been calculated previousely.\n\nexample:\n\n      >>> atype = AtomHybridization()\n      >>> atype.assignHybridization(atoms)\n      >>> addh = AddHydrogens()\n      >>> hat = addh.addHydrogens(atoms)\n\n      atoms has to be a list of atom objects\n      Atom:\n          a.coords : 3-sequence of floats\n          a.bonds : list of Bond objects\n          babel_type: string\n          babel_atomic_number: int\n\n      Bond:\n          b.atom1 : instance of Atom\n          b.atom2 : instance of Atom\n\n      or\n      >>> addh = AddHydrogens()\n      >>> hat = addh.addHydrogens(atoms, method='withBondOrder')\n\n      atoms has to be a list of atom objects as above and\n      Bond:\n          b.atom1 : instance of Atom\n          b.atom2 : instance of Atom\n          b.bondOrder : integer\n\n      these calls return a list 'hat' containing a tuple for each Hydrogen\n      atom to be added. This tuple provides:\n          coordsH       : 3-float coordinates of the H atom\n          atom          : the atom to which the H atom is to be connected\n          atomic_number : the babel_atomic_number of the H atom\n          type          : tyhe b:wabel_type of the H atom\n\nreimplementation of Babel1.6 in Python by Michel Sanner April 2000\nOriginal code by W. Patrick Walters and Matthew T. Stahl\n    """),
("Pmv","editCommands","mergeNPHSGC",""" None <- mergeNPHSGC(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\nThis class implements GUICommand for MergeNPHsCommand below\n    """),
("Pmv","editCommands","mergeNPHS",""" None <- mergeNPHS(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\nThis class merges non-polar hydrogens and the carbons to which they are attached. There are three parts to the process:\n         the charge(s) of non-polar hydrogens are added to those their carbons\n         the bond between the npH and its carbon is removed from the \n            carbon's bonds\n         the hydrogen atoms are removed.\n    """),
("Pmv","editCommands","fixHNamesGC","""\nThis class provides Graphical User Interface to FixHydrogenAtomsNameCommand\nwhich is invoked by it with the current selection, if there is one.\n    """),
("Pmv","editCommands","fixHNames","""\nThis class checks hydrogen atom names and modifies them to conform to\nIUPAC-IUB conventions: \n\nHydrogen names have 4 spaces:'H _ _ _', (here referred to as 1-4). \n    'H' is always in space 1. \n    Space 2 references the name of the atom to which H is bonded \n        using the following scheme: \n    IF the name has 1 letter, space 2 is that letter. \n    IF the name has more than 1 letter, space 2 is the second letter \n        in that name and space 3 the third letter if it exists. \n(Please note that the second space in the bonded atom name is a 'remoteness'\nindicator and the third used to number items equally remote.)\n\n    In all cases, the LAST space (which could be space 3 or space 4 \ndepending on the bonded-atom's name) is used to number hydrogen atoms \nwhen more than one are bound to the same atom.\n\nEXAMPLES:\n        HN <- hydrogen bonded to atom named 'N'\n        HA <- hydrogen bonded to atom named 'CA'\n        HE <- hydrogen bonded to atom named 'NE'\n        HH11 <- first hydrogen bonded to atom named 'NH1'\n        HH12 <- second hydrogen bonded to atom named 'NH1'\n        HD21 <- first hydrogen bonded to atom named 'CD2'\n________________________________________________________________________\nA final complexity results when these names are written in pdb files:\nThe name of the atom appears RIGHT-JUSTIFIED in the first two columns of\nthe 4 columns involved (13-16). Thus 'H' appears in column 14 for all hydrogen\natoms. This creates a problem for 4 character hydrogen names. They are \naccommodated by wrapping so that space 4 appears in column 13.\n\nEXAMPLE:\n        1HD2 <- first hydrogen bonded to atom named 'CD2' as represented \nin a pdb file.\n    """),
("Pmv","editCommands","mergeLPSGC",""" None <- mergeLPSGC(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\nThis class presents GUI for MergeLonePairsCommand below\n    """),
("Pmv","editCommands","mergeLPS",""" None <- mergeLPS(nodes, **kw)\nnodes: TreeNodeSet holding the current selection\nThis class merges lone-pairs and the sulfur atoms to which they are attached. \nThere are three parts to the process:\n         the charges of lone-pairs, if any, are added to those of the sulfurs\n         the bond between the lone-pair and its sulfur is removed from the \n            sulfur's bonds\n         the lone-pair 'atoms' are deleted\nNB: the lone pairs are identified by these criteria:\n    the element field of the lone pair 'atom' is 'Xx' and its name has a 'L'\nin the first or second position.\n    """),
("Pmv","editCommands","splitNodesGC",""" None <- splitNodesGC(nodes, levelToSplit, top, renumber=1, **kw)\nnodes: TreeNodeSet holding the current selection\nlevelToSplit: splitting level\ntop:\nrenumber: default is 1\nThis class presents GUI for SplitNodesCommand below\n    """),
("Pmv","editCommands","splitNodes",""" mol <- splitNodes(nodes, levelToSplit, top, renumber=1, **kw)\nnodes: TreeNodeSet holding the current selection\nlevelToSplit: the splitting level\ntop:\nrenumber: default is 1\nif levelToSplit is Molecule/Protein, the new molecule is returned\nOTHERWISE the modified molecule is returned\nThis class allows the user to split current selection from unselected nodes.\nThe split is done at a level above nodes.  If more than one level above nodes exists, \nthe user chooses the level at which to split. Result of split depends on the designated\nsplitting level: \n    splits at the Protein/Molecule level result in a new Protein/Molecule \n    splits at other levels result in adding new nodes to the Protein/Molecule: \n        eg. splitting at the chain level adds a new chain to the Protein, etc. etc.\n\n    """),
("Pmv","extrusionCommands","computeSheet2D","""\n    Package : Pmv\n    Module  : extrusionCommands\n    Class   : ComputeSheet2DCommand\n    Command name : computeSheet2D\n    Description: \n    The ComputeSheet2DCommand class implements methods to compute the sheet2D\n    for each chain of the contained in the current selection. Need to specify\n    two control atoms.\n    synopsis:\n        None <- ComputeSheet2D(nodes, buildIsHelix=1, nbrib=2,\n                               nbchords=4, width=1.5, offset=1.2, **kw)\n        nodes       : any set for MolKit nodes describing molecular components\n        ctlAtmsName : tuple of two atom name specifying the two control atoms\n                      the second atom is used to limit the torsion of the sheet\n                      2D.\n        buildIsHelix: flag when set to 1 specifies that an helix is defined.\n        nbrib       : integer specifying the number of ribbon of the sheet2D.\n        nbchords    : integer specifying the number of points per residues\n        width       : float specifying the width of the sheet2D\n        offset      : float specifying the offset of ?\n\n    Required Packages:\n      MolKit, DejaVu, mglutil, OpenGL, Tkinter, Pmw, types, ViewerFramework\n    Required Commands:\n      ExtrusionCommands.ComputeSheet2D, \n    Known bugs:\n      None\n    Examples:\n      mol = mv.Mols[0]\n      mv.extrudeCATrace(mv.getSelection())\n    \n    """),
("Pmv","extrusionCommands","displayPath3D",""""""),
("Pmv","fileCommands","writePDBQS","""Command to write PDBQS files using a PDBQS spec compliant writer"""),
("Pmv","fileCommands","writePDBQ","""Command to write PDBQ files using a PDBQ spec compliant writer"""),
("Pmv","fileCommands","writePDB","""\n    Command to write the given molecule or the given subset of atoms\n    of one molecule as PDB file.\n    """),
("Pmv","fileCommands","writePQR","""Command to write PQR files using a PQR spec compliant writer"""),
("Pmv","fileCommands","readPDB","""Command to load PDB files using a PDB spec compliant parser"""),
("Pmv","fileCommands","readMolecule",""""""),
("Pmv","fileCommands","readPDBQ","""Command to load AutoDoc PDBQ files"""),
("Pmv","fileCommands","readPDBQS","""Command to load AutoDoc PDBQS files"""),
("Pmv","fileCommands","readPQR","""Command to load MEAD PQR files"""),
("Pmv","fileCommands","readMOL2","""Command to load MOL2 files"""),
("Pmv","fileCommands","writeSTL","""Command to write coords&normals of currently displayed geometries as\n    ASCII STL files (STL = stereolithography, don't confuse with standard\n    template library)\n    """),
("Pmv","fileCommands","writeVRML2","""Command to save currently displayed geometries in VRML 2.0 format\n    """),
("Pmv","fileCommands","saveImage","""This command allows to save the content of the current frambuffer as\nan image into a file. The file format will be defined by the extension used\nin the filename. Currently de follwoing foramt are supported:\nBMP, EPS, GIF, IM, JPEG, PNG, PPM, TIFF or TIF, PDF.\n\nDependencies: require the Python Imaging Library\n\nregression test: testdir/testSaveImage.py\n"""),
("Pmv","genparserCommands","genreadPDB",""" Command to load PDB files using parser with user defined\n    specifications """),
("Pmv","genparserCommands","defPdbSpecs",""" class to define some pdb specifications in a dictionary and save them\n    in a file """),
("Pmv","gridCommands","readAUTOGRID",""" Command to load autogrid data files, creating an 'AutoGrid' object"""),
("Pmv","gridCommands","getIsosurface",""" Command to create: \n            an isosurface for a 'Grid' object ,\n            a bounding box of the grid,\n            and a GUI to manipulate the srf and the visibility of the box . \n    """),
("Pmv","gridCommands","getOrthoSlice","""allows the user to see a slice through a set of volume data"""),
("Pmv","hbondCommands","getHBDonors","""\nThis class allows user to get AtomSets of sp2 hydridized and sp3 hybridized\nhydrogenBond Donors\n\n    """),
("Pmv","hbondCommands","getHBAcceptors","""\nThis class allows user to get AtomSets of sp2 hydridized and sp3 hybridized\nhydrogenBond Acceptors\n\n    """),
("Pmv","hbondCommands","getHBondEnergies","""\nThis class allows user to get a list of energies of HydrogenBonds. For this\ncalculation, the bond must have a hydrogen atom AND it must know its type.\nEnergy calculation based on "Protein Flexibility and dynamics using constraint\ntheory", J. Molecular Graphics and Modelling 19, 60-69, 2001. MF Thorpe, Ming\nLei, AJ Rader, Donald J.Jacobs and Leslie A. Kuhn.\n\n    """),
("Pmv","hbondCommands","showHBDA","""\nThis class allows user to show AtomSets of HydrogenBond donors and acceptors\n    """),
("Pmv","hbondCommands","showHBonds","""\nThis class allows user to visualize pre-existing HydrogenBonds between \natoms in viewer\n    """),
("Pmv","hbondCommands","buildHBondsGC","""\nThis class provides Graphical User Interface to BuildHydrogenBonds\nwhich is invoked by it.\n    """),
("Pmv","hbondCommands","buildHBonds","""\nThis command finds hydrogen donor atoms within 2.4*percentCutoff angstrom \ndistance of hydrogen acceptor atoms. It builds and returns a dictionary\natDict whose keys are hydrogen atoms (or hydrogenbond donor atoms if there\nare no hydrogens) and whose values are potential h-bond acceptors and \ndistances to these atoms, respectively\n    """),
("Pmv","hbondCommands","addHBondHsGC","""\nThis class provides Graphical User Interface to AddHBondHydrogens\nwhich is invoked by it.\n    """),
("Pmv","hbondCommands","addHBondHs","""\nThis command adds hydrogen atoms to preexisting hydrogen bonds\n    """),
("Pmv","hbondCommands","hbondsAsSpheres","""\nThis class allows user to visualize pre-existing HydrogenBonds between \natoms in viewer as small spheres\n    """),
("Pmv","hbondCommands","hbondsAsCylinders","""\nThis class allows user to visualize pre-existing HydrogenBonds between \natoms in viewer as cylinders\n    """),
("Pmv","hbondCommands","extrudeHBonds","""\nThis class allows user to visualize pre-existing HydrogenBonds between \natoms in viewer using extruded geometries\n    """),
("Pmv","hbondCommands","addHBondGC","""\n    GUI command wrapper for AddHBondCommand which allows user to add hbonds\n    between selected atoms. Hydrogen bonds are built assuming user picked\n    hydrogen atom (or donor atom if there is no hydrogen atom) first followed\n    by the acceptor atom.\n    """),
("Pmv","hbondCommands","addHBond","""\n    AddHBondCommand allows user to add hydrogen bonds between pairs of atoms.\n    """),
("Pmv","hbondCommands","removeHBondGC","""\n    RemoveHBondCommandGUICommand allows user to remove hbonds between\n    picked atoms.\n    """),
("Pmv","hbondCommands","removeHBond","""\n    RemoveHBondCommand allows user to remove hydrogen bonds between specified\n    atoms.\n    """),
("Pmv","hbondCommands","limitHBonds","""\nThis class allows user to detect pre-existing HydrogenBonds with energy values \n'lower' than a designated cutoff.  Optionally the user can remove these bonds.\n    """),
("Pmv","hbondCommands","readIntermolHBonds","""Command to read files specifying intermolecular hydrogen bonds"""),
("Pmv","hbondCommands","writeIntermolHBonds","""Command to write files specifying intermolecular hydrogen bonds"""),
("Pmv","hbondCommands","writeHBondAssembly","""Command to write a file specifying >1 chain with hydrogen bonds. Chains\n    which are hydrogen-bonded are written in one pdb file.  They may or may\n    not be part of the same molecule"""),
("Pmv","interactiveCommands","setICOM",""""""),
("Pmv","interactiveCommands","ICOMbar",""""""),
("Pmv","interactiveCommands","bindCmdToKey",""""""),
("Pmv","labelCommands","labelByProperty","""selector.selection,property,textcolor,font,location,only,negate,funcItems \n    Command to label the current selection items according to different\n    properties of the selection level (Actually of the first item in the \n    current selection.) Color can be specified as 'red','green','blue', \n    'white' or 'yellow'. Other values can be entered as a RGB tuple. \n    One font can selected per label level: Atom,Residue,Chain,Molecule. \n    Labels can be centered on first atom of selection level item, last \n    atom of item or on the center of the item which is found by averaging \n    the coordinates of all the atoms in the item. (eg all atoms in a\n    residue if labelling at the Residue Level)\n    """),
("Pmv","labelCommands","labelByExpression",""""""),
("Pmv","measureCommands","measureDistance","""\n        Computes the distance between atom1, atom2, atom3.\n        All coordinates are Cartesian; result is in Angstrom.\n    """),
("Pmv","measureCommands","measureAngle","""\n        Compute the angle between atom1, atom2, atom3.\n        All coordinates are Cartesian; result is in degrees.\n    """),
("Pmv","measureCommands","measureTorsion","""\n        Compute the torsion between atom1, atom2, atom3, atom4.\n        All coordinates are Cartesian; result is in degrees.\n    """),
("Pmv","measureCommands","measureDistanceGC",""" \n       Accumulates picked atoms. \n       Draws lines between pairs of selected atoms, labeled by distance \n       (color-coded yellow).\n       Userpref 'Number of Measure Distances' sets the 'snakeLength' which is\n       how many distance measures can be displayed at the same time. \n       When more than that number are measured, the first distance\n       measured is no longer labeled.\n    """),
("Pmv","measureCommands","measureAngleGC",""" \n       Accumulates picked atoms.\n       Draws fans, lines and labels labelling the angle between \n       trios of selected atoms (color-coded orange).\n       Userpref 'measureAngleSL' sets the 'snakeLength' which is\n       how many angle measureDisplays can be seen at the same time. \n       When more than that number are measured, the first angle\n       measured is no longer labeled.\n    """),
("Pmv","measureCommands","measureTorsionGC",""" \n       Label torsion between four atoms (color coded cyan)\n       Accumulates picked atoms.\n       Draws polygons and labels showing the torsion angle between \n       groups of 4 selected atoms (color-coded cyan).\n       Userpref 'measureTorsionSL' sets the 'snakeLength' which is\n       how many torsion measureDisplays can be seen at the same time. \n       When more than that number are measured, the first torsion\n       measured is no longer labeled.\n    """),
("Pmv","msmsCommands","readMSMS",""" reads .face and .vert file, creates the msms surface and links it\n    to the selection if can\n    """),
("Pmv","msmsCommands","computeMSMS","""\n    Package : Pmv\n    Module  : msmsCommands\n    Class   : ComputeMSMS\n    Command name : computeMSMS\n    Description:\n    The computeMSMS command will compute a triangulated solvent excluded\n    surface for the current selection.\n\n    Synopsis:\n    None <- mv.computeMSMS(nodes, surfName=None, pRadius=1.5,\n                           density=1.0, perMol=True,\n                           display=1)\n    required arguments:\n    nodes    --  current selection\n    \n    optional arguments:\n    surfName -- name of the surfname which will be used as the key in\n                mol.geomContainer.msms dictionary. If the surfName is\n                already a key of the msms dictionary the surface is\n                recreated. By default mol.name-MSMS\n    pRadius  -- probe radius (1.5)\n    density  -- triangle density to represent the surface. (1.0)\n    perMol   -- when this flag is True a surface is computed for each molecule\n                having at least one node in the current selection\n                else the surface is computed for the current selection. (True)\n    display  -- flag when set to 1 the displayMSMS will be executed to\n                display the new msms surface.\n                    \n    """),
("Pmv","msmsCommands","displayMSMS","""\n    Package : Pmv\n    Module  : msmsCommands\n    Class   : DisplayMSMS\n    Command name : displayMSMS\n    Description:\n    The displayMSMS command allows the user to display/undisplay or display\n    only the given MSMS surface corresponding to the current selection.\n\n    Synopsis:\n    nodes  -- TreeNodeSet holding the current selection\n    optional arguments:\n    only     -- flag when set to 1 only the current selection will be\n              displayed\n    negate   -- flag when set to 1 undisplay the current selection\n    surfName -- name of the selection, default = 'all'\n    nbVert   --  Nb of vertices per triangle needed to select a triangle.\n    \n    """),
("Pmv","msmsCommands","undisplayMSMS",""""""),
("Pmv","msmsCommands","saveMSMS","""\n    Package : Pmv\n    Module  : msmsCommands\n    Class   : SaveMSMS\n    Command name : saveMSMS\n    Description:\n    \n    The SaveMSMS commands allows the user to save a chosen MSMS surface\n    (tri-angulated solvant excluded surface) resulting from a calculation.\n    Two files will be created, one for\n    vertices     (.vert) and one for faces (.face). \n    If the component number is 0, files called filename.vert and filename.face\n    are created.\n    For other components, the component number is inserted in the file name,\n    for example for the component number 3 the files are called\n    filename_3.vert and filename_3.face.\n\n    The face file contains three header lines followed by one triangle per\n    line. The first header line provides a comment and the filename of the\n    sphere set.\n    The second header line holds comments about the content of the third line.\n    The third header line provides the number of triangles, the number of\n    spheres in the set, the triangulation density and the probe sphere radius.\n    The first three numbers are (1 based) vertex indices. The next field\n    can be: 1 for a triangle in a toric reentrant face, 2 for a triangle in\n    a spheric reentrant face and 3 for a triangle in a contact face.\n    The last number on the line is the (1 based) face number in the\n    analytical description of the solvent excluded surface. These values\n    are written in the following format ''%6d %6d %6d %2d %6d''.\n\n    The vertex file contains three header lines (similar to the header\n    in the .face file) followed by one vertex per line and provides the\n    coordinates (x,y,z) and the normals (nx,ny,nz) followed by the number of\n    the face (in the analytical description of the solvent excluded surface)\n    to which the vertex belongs.\n    The vertices of the analytical surface have a value 0 in that field and\n    the vertices lying on edges of this surface have nega tive values.\n    The next field holds the (1 based) index of the closest sphere.\n    The next field is 1 for vertices which belong to toric reentrant faces\n    (including vertices of the analytical surface), 2 for vertices inside\n    reentrant faces and 3 for vertices inside contact faces.\n    Finally, if atom names were present in the input file, the name of the\n    closest atom is written for each vertex. These values are written in\n    the following format\n    ''%9.3f %9.3f %9.3f %9.3f %9.3f %9.3f %7d %7d %2d %s''.\n\n    Synopsis:\n    None <- saveMSMS(filename, mol, surfacename, withHeader=1, component=0,\n                     format='MS_TSES_ASCII', **kw)\n    filename : name of the output file\n    mol      : molecule associated with the surface\n    surfacename : name of the surface to save\n    withHeader  : flag to either write the headers or not\n    component   : specifies which component of the surface to write out\n    format      : specifies in which format to save the surface. It can be\n                  one of the following :\n                  'MS_TSES_ASCII' Triangulated surface in ASCII format\n                  'MS_ASES_ASCII' Analytical surface in ASCII format. This is\n                  actually a discrete representation of the analytical model.\n                  'MS_TSES_ASCII_AVS' Triangulated surface in ASCII with\n                  AVS header\n                  'MS_ASES_ASCII_AVS'  Analytical surface in ASCII format\n                  with AVS header\n\n    """),
("Pmv","msmsCommands","computeMSMSApprox","""Computes an approximative molecular surface for a selected set of \n    atoms by molecule. This approximation is done by replacing each residue by\n    a sphere. The center of the sphere is geometric center of the atoms in the\n    residue. The radius is set to include all atoms."""),
("Pmv","msmsCommands","identifyBuriedVertices","""\n    This command enables finding out and tagging the vertices of a Solvent\n    excluded surface that are buried by a set of atoms.\n    After running this command the vertices that are buried are tagged in\n    the MSMS data structure with the buried flag (which is return by the\n    ses.getTriangles() method. Each vertex of the triangulated ses also\n    has a member called sesArea and sasArea that hold the surface area\n    corresponding to each vertex of the triagulation.\n    """),
("Pmv","msmsCommands","displayBuriedTriangles",""""""),
("Pmv","msmsCommands","assignBuriedAreas","""Command to sum the areas of the buried vertices ofr each atom.\nThis command assumes that a command to find buried vertices has been run\npreviousely"""),
("Pmv","povrayCommands","povray",""""""),
("Pmv","repairCommands","editHist_hGC","""allows user to call editHistHydrogens on each histidine residue in selection"""),
("Pmv","repairCommands","editHist_h","""allows user to edit hydrogens in histidine residues"""),
("Pmv","repairCommands","checkForMissingAtomsGC","""\nThis class provides Graphical User Interface to CheckForMissingAtomsCommand\nwhich is invoked by it with the current selection, if there is one.\n    """),
("Pmv","repairCommands","checkForMissingAtoms","""\nThis command compares atoms present in residues with those expected by the\ndictionary used to assign Kollman charges, qkollua. It returns a dictionary of\nwhose keys are residues missing atoms and whose values are the names of the\nmissing atoms.  The keys are strings built from the residue name + its chain\nid.\n    """),
("Pmv","repairCommands","checkForCloseContactsGC","""\nThis class provides Graphical User Interface to CheckForCloseContactsCommand\nwhich is invoked by it with .\n    """),
("Pmv","repairCommands","checkForCloseContacts","""\nThis command detects atoms within combined atomic radii distance of nodes.\n    """),
("Pmv","repairCommands","repairMissingAtomsGC","""\nThis class provides Graphical User Interface to RepairMissingAtomsCommand\nwhich is invoked by it with the current selection, if there is one.\n    """),
("Pmv","repairCommands","repairMissingAtoms","""\nThis command compares atoms present in residues with those expected by the\ndictionary used to assign Kollman charges, qkollua. It builds the missing\natoms.\n    """),
("Pmv","repairCommands","add_oxtGC",""" \nThis class provides GUICommand for AddOXT which adds oxygen atom to\nterminal carbon atom.\n    """),
("Pmv","repairCommands","add_oxt",""" \nThis class uses add_sp2_hydrogen method of the AddHydrogens class from the \nPyBabel package to compute coordinates of oxygen to be added to carbon atom.\nThe carbon atom is bonded to another oxygen and a CA. If it is bonded to a\nhydrogen, the hydrogen is removed and replaced by the new OXT atom.\n    """),
("Pmv","repairCommands","modifyCTerminus",""" \nThis command removes hydrogens from C-atom of internal c-termini residues.\nAn internal c-terminus occurs when residues are missing from a chain.\n\n    """),
("Pmv","repairCommands","modifyNTerminus",""" \nThis command is used to modify residues which become internal n-termini\nbecause some residues are missing within a chain in a crystal structure. \nHydrogens are added or subtracted from nitrogen atom of the internal \nn-terminus so that the natom ends up with one sp2-hydrogen which is what it\nwould have in an intact chain.\n\n\n    """),
("Pmv","repairCommands","modifyTermini","""\nThis class detects residues within a chain which are not bonded to a previous\nresidue in the chain and those not bonded to a subsequent residue in the\nchain.  It calls ModifyNTerminus to edit hydrogens bonded to the nitrogen\natom of the first kind of residue  and ModifyCTerminus to edit hydrogens bonded terminal carbon in the second kind of intra-chain breaks.\n    """),
("Pmv","sdCommands","readTransformations",""" This command is invoked everytime the Qlist Filename entryfield is\n        invoked. If the Center Chooser checkbutton is on, the CenterChooser\n        popup dialog will come up to allow the center of rotation to be\n        defined before the transformation list is read in. If this is turned\n        off, the center of rotation defaults to either the previous center (if\n        readTransformations has been invoked previously for this molecule), or to\n        the molecules center of gravity.\n        readTransformations then reads in lines from the file, which have the\n        format 'score tx ty tz rx ry rz theta rank'. These are converted into\n        a list of raw transformations (needed for writing out the preferred\n        list), and also a list of total transformations (which take into\n        account the center of rotation)\n        """),
("Pmv","sdCommands","applyTransformations",""" Opens up the Transformation Control GUI which allows reading in and\n    scanning through transformations. The molecule of interest is selected via\n    the pull-down 'Molecule List...' menu. Selecting the directory and file of\n    interest in the Qlist menus will cause that file to be read in (to update\n    the list of files one must hit return in the Qlist directory entry field).\n\n    The qlist files have the format 'score tx ty tz rx ry rz theta rank', where\n    tx,ty,tz is the translation, rx,ry,rz the direction of the rotation axis,\n    theta the angle of rotation (in degrees) and rank the rank in the docking.\n\n    On reading in a file of transformations, the default center of rotation is\n    the molecule's center of gravity. To change this, read in the quaternions\n    with the Center Chooser Dialog button activated. The center of rotation\n    can then be set to the current selection, or a type-in value. The center\n    of rotation is remembered, so for a series of files the center need only\n    be set on reading the first file, after which the toggle can be turned off.\n\n    Transformations of interest can be added to and removed from the preferred\n    list, which can be written out to a file. The rank column in such a file\n    contains the transformation's position in the original list.\n\n    All the data shown in the GUI are stored as attributes of the molecule.\n    Thus, dockings for several molecules can be shown at once, and the GUI\n    retrieves the information when a previous molecule is reselected.\n    """),
("Pmv","sdCommands","readMolIndexedPolygons",""" Reads in the indexed polygons vert and tri files for a MolIndexedPolygon and\n    puts it in the appropriate molecule's geomContainer\n    vertfile has x y z nx ny nz prop1 .... propn atomindex\n    trifile is a list of vertex number triplets describing the triangles"""),
("Pmv","sdCommands","readDockdata",""" Subclass of ReadIndexedPolygons to read a dockdata file. The propertyList,\n    triangle connectivity file and name for the surface are automatically generated\n    to fit the format produced by the Docking File Generator (with the extra column\n    giving the atomIndices added using the cluster program"""),
("Pmv","sdCommands","readMSMS",""" Subclass of ReadIndexedPolygons to read a surface file generated by Harmony.\n    This class is for the triangle tesselation mode of Harmony. The propertyList,\n    triangle connectivity file and name for the surface are automatically generated\n    to fit the format produced by the Docking File Generator (with the extra column\n    giving the atomIndices added using the cluster program)"""),
("Pmv","sdCommands","readHarmony",""" Subclass of ReadIndexedPolygons to read a surface file generated by Harmony.\n    This class is for the triangle tesselation mode of Harmony. The propertyList,\n    triangle connectivity file and name for the surface are automatically generated\n    to fit the format produced by the Docking File Generator (with the extra column\n    giving the atomIndices added using the cluster program)"""),
("Pmv","sdCommands","readDualHarmony",""" Subclass of ReadIndexedPolygons to read a surface file generated by Harmony.\n    This class is for the dual triangle tesselation mode of Harmony. The propertyList,\n    triangle connectivity file and name for the surface are automatically generated\n    to fit the format produced by the Docking File Generator (with the extra column\n    giving the atomIndices added using the cluster program)"""),
("Pmv","sdCommands","displayHarmonySurface",""""""),
("Pmv","sdCommands","colorHarmonySurface","""Command to color a MolIndexedPolygons surface by one of its properties\n    """),
("Pmv","secondaryStructureCommands","computeSecondaryStructure","""\n    Package : Pmv\n    Module  : secondaryStructureCommands\n    Class   : ComputeSecondaryStructureCommand\n    Command name : computeSecondaryStructure\n    Description: \n    The computeSecondaryStructure command gets the information on the\n    secondary structure of each molecule contained in the current selection.\n    This information is then used to create object describing the various\n    secondary structure elements.\n    The SS element object belonging to a chain are then grouped into sets.\n    A new level is added in the 4 level hierarchy...\n    The information is taken from the file when available or using stride when\n    available.\n    This command can be used as an interactive command.\n    Synopsis:\n        None <- ComputeSS(nodes, molMode={}, **kw)\n        nodes       : any set for MolKit nodes describing molecular components\n        molmode     : dictionary key: molecule name, value : 'From File' or\n                      'From Stride'.\n\n    Required Packages:\n      MolKit, DejaVu, mglutil, OpenGL, Tkinter, Pmw, types, ViewerFramework\n\n    Required Commands:\n\n    Known bugs:\n      None\n    Examples:\n      mol = mv.Mols[0]\n      mv.computeSecondaryStructure(mv.getSelection())\n    \n    """),
("Pmv","secondaryStructureCommands","extrudeSecondaryStructure","""\n    The ExtrudeCommand allows the user to represent the secondary structure\n    elements by extruding 2D geometries along a 3D path.\n    To execute this command use the entry 'extrude Secondary Structure' under\n    the 'Compute' menu in the menu bar. The panel that appears lets the user\n    choose the 2D shapes for the extrusion. The entry 'default' in the\n    listChooser lets do a traditional ribbon representation.\n    nbchords represents the number of points in the path3D\n    corresponding to one residue. The higher this parameter is the smoother the\n    extruded geometries will look.\n    gapBeg allows the user to introduce a gap of gapBeg points the extruded\n    geometrie before each residues.\n    gapEnd allows the user to introduce a gap of gapEnd points the extruded\n    geometrie after each residues.\n    The value of this two parameters depend on the value of the nbchords\n    parameter and on each other's value.\n    Once you clique OK on this panel another panel appears to let the user\n    caracterize the chosen 2D geometry.\n    Once the user chose all the parameters an ExtrudeSSElt object is created\n    for each secondary structure element. The geometries associated to each\n    secondary structure element are then updated with the new vertices and\n    faces.\n    Finally the displaySSCommand is executed.\n\n    This command has the objArgsOnly flag.\n    """),
("Pmv","secondaryStructureCommands","displayExtrudedSS",""" The DisplaySSCommand displays the geometries representing the secondary\n    structure elements of the current selection.\n    To execute this command use the 'Display Secondary Structure' entry under\n    the 'Display' menu in the menu bar.\n    only: allows the user to display only the current selection when set to 1\n    negate:  allows to undisplay the current selection when set to 1.\n    This command is undoable.\n    """),
("Pmv","secondaryStructureCommands","colorBySecondaryStructure",""""""),
("Pmv","secondaryStructureCommands","undisplayExtrudedSS",""" UndisplaySSCommand is an interactive command to undisplay part of\n    the molecule when represented as extruded secondary structure."""),
("Pmv","secondaryStructureCommands","ribbon",""" The RibbonCommand is a shortcut to visualize a traditional Ribbon\n    representation of the current selection. It first executes getSSCommand\n    then the extrudeSSCommand with the default values for all the parameters.\n    This command is undoable."""),
("Pmv","selectionCommands","select","""class for modfying the current selection in a molecule Viewer\n\n        - selection: a TreeNodeSet holding the current selection. Modfied by\n                     SubClasses implementing a specific selection operation\n        - level: level at which selection occurs\n    """),
("Pmv","selectionCommands","deselect",""""""),
("Pmv","selectionCommands","clearSelection",""" MVClearSelect implements method to clear the current selection."""),
("Pmv","selectionCommands","saveSet","""Save a selection under a user specified name"""),
("Pmv","selectionCommands","createSetIfNeeded","""create a set, but only if it does not already exist"""),
("Pmv","selectionCommands","invertSelection","""Inverts current selection. If there is None, the user is given \n       the option of setting the level to Atom and selecting all the atoms"""),
("Pmv","selectionCommands","selectSet","""setNameStr,only,negate\n    Select a set defined previously:\n    only=negate=0:selected set is added to the selection\n    only=0,negate=1: selected set is removed from the selection\n    only=1,negate=0: selected set is the only thing selected"""),
("Pmv","selectionCommands","selectFromString",""" molStr,chainStr,residueStr,atomStr\n        Select items by typed-in strings: one for\n        each level. No entry corresponds to select\n        everything at this level. Strings are parsed\n        as would-be regular expressions, replacing * by\n        .*.... """),
("Pmv","selectionCommands","directSelect",""""""),
("Pmv","selectionCommands","selectInSphere",""""""),
("Pmv","setangleCommands","setTorsionGC",""""""),
("Pmv","setangleCommands","setRelativeTorsion","""\n        Transform the coords of atoms in subTree defined by atom1-atom2\n        Set the coords of these atoms to the new values and return new coords\n    """),
("Pmv","setangleCommands","setTorsion","""\n        Transform the coords of atoms in subTree defined by atom1-atom2\n        by angle less initial torsion defined by atom0, atom1, atom2, atom3\n        Set the coords of these atoms to the new values and return new coords\n    """),
("Pmv","setangleCommands","setTranslation","""\n        Transform the coords by array\n        Set the coords of these atoms to the new values and return new coords\n    """),
("Pmv","setangleCommands","setQuaternion","""\n        Transform the coords by quaternion\n        Set the coords of these atoms to the new values and return new coords\n    """),
("Pmv","splineCommands","computeSpline","""\n    The CompueSplineCommand omplements a set of method to create an\n    DejaVu.splineObject per chain given:\n    - a TreeNodeSet,\n    - type of control Atoms (atmtype),\n    - number of points per control point in the smooth array (nbchords)\n    - continuity of the curves (continuity)\n    """),
("Pmv","splineCommands","computeSplineGC",""" The ComputeSplineGUICommand  provides a GUI to the user and calls\n    computeSplineCommand to compute the splineObject. This class also\n    implement a createGeometries method to create the geometrie to represent\n    the splineObject here a IndexedPolylines."""),
("Pmv","splineCommands","extrudeSpline","""\n    The extrudeSplineCommand implements a set of method to create the\n    extrude Geometries DejaVu.GleExtrude resulting of the extrusion of a\n    shape2D along a path3D computed by the DejaVu.SplineObject using the GLE\n    library.\n    """),
("Pmv","splineCommands","displayExtrudedSpline",""" The DisplayExtrudeSplineCommand implements a set of methods to\n    display/undisplay part of the geometries created by the\n    ExtrudeSplineCommand. This command is undoable."""),
("Pmv","splineCommands","undisplayExtrudedSpline",""" UndisplayExtrudeSplineCommand is the interactive command to undisplay\n    part of the molecule when displayed as an extruded spline.\n    It calls the displatExtrudedSpline with negate =1"""),
("Pmv","splineCommands","displaySplineAsLine",""" DisplaySplineAsLineCommand implements a set of method to display/\n    undisplay part of the spline when represented as line."""),
("Pmv","splineCommands","undisplaySplineAsLine",""" UndisplaySPlineAsLineCommand calls the displaySplineAsLine command\n    with the flag negate set to 1"""),
("Pmv","superImposeCommands","superimposeAtoms",""""""),
("Pmv","superImposeCommands","superimposeCoords",""""""),
("Pmv","traceCommands","computeTrace","""\n    Package : Pmv\n    Module  : traceCommands\n    Class   : ComputeTraceCommand\n    Command : computeTrace\n    keywords: compute trace\n    Description:\n    This command computes the oriented spline (trace) for the molecules in\n    the current selection. It creates a Coil object for each chaine of the\n    molecule having at least one node in the current selection.\n    The Coil object can only be created for the residues having the chosen\n    ctlAtm and torsAtm.\n\n    Synopsis:\n        None <- computeTrace(nodes, traceName='CATrace', ctlAtmName='CA',\n                             torsAtmName='O',nbchords = 4, **kw)\n        nodes      : any set of MolKit nodes describing molecular components\n        traceName  : string representing the name of the computed trace.\n                     default 'CATrace'\n        ctlAtmName : name of the atom to be used for control (defaul='CA')\n        torsAtmName: name of the atom to be used to control the torsion.\n                     default='O'\n        nbchords   : number of points per residue. The higher the number the\n                     smoother the trace will be.\n    """),
("Pmv","traceCommands","extrudeTrace","""\n    Package : Pmv\n    Module  : traceCommands\n    Class   : ComputeTraceCommand\n    Command : computeTrace\n    keywords: compute trace\n    Description:\n    This command extrude a shape 2D along the path 3D of a given trace computed\n    by the computeTrace command.\n    Synopsis:\n       None <- extrudeTrace(nodes, traceName='CATrace', shape2D=None,\n                            frontCap=1, endCap=1, display=1, **kw)\n       nodes    : any set of MolKit nodes describing molecular components.\n       traceName: string representing the name of the trace to be represented\n                  the default value is 'CATrace'.\n       shape2D  : instance of a DejaVu.Shape class describing the shape 2D\n                  to be extruded along the path3D of the selected trace.\n                  By default a Circle2D will be extruded\n       frontCap : when set to 1 a cap is added to all the front of the extruded\n                  geometry created to represent the selected trace.\n       endCap   : when set to 1 a cap is added to all the end of the extruded\n                  geometry representing the selected trace.\n       display  : when set to 1 the displayTrace command is called.\n\n    \n    """),
("Pmv","traceCommands","displayTrace","""\n    Package : Pmv\n    Module  : traceCommands\n    Class   : DisplayTraceCommand\n    Command : displayTrace\n    keywords: display trace CA...\n    Description:\n    This command allows the user to display, undisplay or display only the\n    current selection using the extruded trace representation of the given\n    traceName.\n    Synopsis:\n        None <- displayTrace(nodes, traceName, negate=0, only=0, **kw)\n        nodes     : any set of MolKit nodes describing molecular components.\n        traceName : string representing the extruded trace to be displayed,\n                    undisplayed or displayed only\n        negate    : flag when set to 1 undisplay the trace corresponding to\n                    the current selection\n        only      : flag when set to 1 the part of the trace geometry\n                    corresponding to the current selection will be displayed\n                    only.\n     """),
("Pmv","vectfieldCommands","loadVect",""" Command to load a Vect field for a molecule."""),
("Pmv","vectfieldCommands","loadVUFile",""" Command  to a load a VU file to display"""),
("Pmv","visionCommands","vision",""""""),
("Pmv","visionCommands","exportSets","""Command to export PMV sets (sets defined through the selection command)\ninto Vision. Each set is exported as a Vision node, added to the Pmv Library\ninto the category Molecules."""),
("Pmv","writeMsmsAsCommands","writeCM",""""""),
]
