cmake_minimum_required(VERSION 3.0)

function(target_set_WORD_SIZE target)
  if(APPLE)
    if(${LINK_WORD_SIZE} EQUAL 32)
      set_target_properties(${target} PROPERTIES OSX_ARCHITECTURES "i386")
    elseif(${LINK_WORD_SIZE} EQUAL 64)
      set_target_properties(${target} PROPERTIES OSX_ARCHITECTURES "x86_64")
    else()
      message(FATAL_ERROR "Invalid word size '${LINK_WORD_SIZE}', must be either 32 or 64.")
    endif()
  elseif(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
    if(${LINK_WORD_SIZE} EQUAL 32)
      set_target_properties(${target} PROPERTIES COMPILE_FLAGS "-m32")
      set_target_properties(${target} PROPERTIES LINK_FLAGS "-m32")
    elseif(${LINK_WORD_SIZE} EQUAL 64)
      set_target_properties(${target} PROPERTIES COMPILE_FLAGS "-m64")
      set_target_properties(${target} PROPERTIES LINK_FLAGS "-m64")
    else()
      message(FATAL_ERROR "Invalid word size '${LINK_WORD_SIZE}', must be either 32 or 64.")
    endif()
  endif()

  add_definitions(-DLINK_WORD_SIZE=${LINK_WORD_SIZE})
endfunction()
