/*
 * Decompiled with CFR 0.152.
 */
package amap;

import amap.Alignment;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class AlignmentPanel
extends JPanel
implements ComponentListener {
    List<Alignment> aligns;
    List<String> orderedKeys;
    int index;
    int xOff;
    int yOff;
    int numCharsAcross;
    int nameWidth;
    int glyphWidth;
    int len;
    int groupOff;
    Font defaultFont;
    int height;
    int width;
    int os;
    Map<String, Color> backColMap;
    Map<String, Color> textColMap;

    public AlignmentPanel(List<Alignment> aligns, int initWidth) {
        this.aligns = aligns;
        this.width = initWidth;
        Map<String, String> seqs = aligns.get(0).getSequences();
        this.orderedKeys = aligns.get(0).getOrderedKeys();
        this.defaultFont = new Font("Courier", 1, 12);
        this.index = 0;
        this.os = System.getProperty("os.name").matches(".*[Mm][Aa][Cc].*") ? -1 : 1;
        this.backColMap = new HashMap<String, Color>();
        this.backColMap.put("0", new Color(255, 255, 255));
        this.backColMap.put("1", new Color(0, 128, 255));
        this.backColMap.put("2", new Color(64, 25, 255));
        this.backColMap.put("3", new Color(255, 0, 255));
        this.textColMap = new HashMap<String, Color>();
        this.textColMap.put("0", Color.black);
        this.textColMap.put("1", Color.white);
        this.textColMap.put("2", new Color(255, 230, 41));
        this.textColMap.put("3", Color.black);
        this.sizeScreen(new Dimension(initWidth, 0));
    }

    private void sizeScreen(Dimension d) {
        this.width = (int)d.getWidth();
        this.glyphWidth = 10;
        FontMetrics fm = this.getFontMetrics(this.defaultFont);
        this.nameWidth = 0;
        for (String key : this.orderedKeys) {
            this.nameWidth = Math.max(this.nameWidth, fm.stringWidth(key));
        }
        this.nameWidth += this.glyphWidth;
        this.xOff = 20;
        this.yOff = 20;
        this.groupOff = this.yOff * (this.orderedKeys.size() + 1);
        int seqAllowedWidth = this.width - this.xOff - this.nameWidth - this.xOff - this.xOff;
        this.numCharsAcross = seqAllowedWidth / this.glyphWidth;
        this.len = this.aligns.get(0).getSequences().get(this.orderedKeys.get(0)).length();
        this.height = (this.len / this.numCharsAcross + 1) * this.groupOff;
        this.height = Math.max(this.height, (int)d.getHeight());
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    public void setIndex(int i) {
        if (i >= 0 && i < this.aligns.size()) {
            this.index = i;
        } else {
            System.out.println("invalid index: " + i);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(Color.white);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, this.width, this.height);
        g2.setPaint(Color.black);
        g2.setFont(this.defaultFont);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontRenderContext frc = g2.getFontRenderContext();
        Map<String, String> seqs = this.aligns.get(this.index).getSequences();
        Map<String, String> cols = this.aligns.get(this.index).getColors();
        int i = 0;
        for (String name : this.orderedKeys) {
            ++i;
            String seq = seqs.get(name);
            String colString = cols.get(name);
            if (seq == null) continue;
            GlyphVector gv = this.defaultFont.createGlyphVector(frc, seq);
            for (int j = 0; j < gv.getNumGlyphs(); ++j) {
                int xLoc = this.xOff + this.nameWidth + j % this.numCharsAcross * this.glyphWidth;
                int yLoc = j / this.numCharsAcross * this.groupOff + this.yOff * i;
                Point2D pos = gv.getGlyphPosition(j);
                pos.setLocation(xLoc, yLoc);
                gv.setGlyphPosition(j, pos);
                String colCode = colString.substring(j, j + 1);
                g2.setPaint(this.backColMap.get(colCode));
                g2.fillRect(xLoc - 1, yLoc - this.yOff + 6, this.glyphWidth, this.yOff);
                if (j % this.numCharsAcross == 0) {
                    g2.setPaint(Color.black);
                    g2.drawString(name, this.xOff, yLoc);
                }
                Shape glyph = gv.getGlyphOutline(j);
                g2.setPaint(this.textColMap.get(colCode));
                g2.fill(glyph);
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.sizeScreen(e.getComponent().getSize());
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }
}

