# Contributing

Thanks for your interest in amsynth!

## Testing

Testing is a great way to help the project. Because there many setups and combinations of other software packages that can be used with amsynth, it's likely your
exact scenario has not been tested by the maintainers. Therefore your help in testing changes would definitely be welcome.

The `develop` branch contains the next, unreleased version of amsynth, and should always be in a working stable state. If you spot any issues there, please report
them!

## Reporting issues :fire:

If you think you have found a bug in amsynth, there are a few things to check beforehand:

* Are you using the latest version of amsynth? Your Linux distribution may not include the latest version of amsynth, and your issue may already be fixed.

* Has the issue [been reported already](https://github.com/amsynth/amsynth/issues?q=is%3Aissue)? If so, please add comments to the existing issue rather than
  opening a new issue.

If you still think you have found a new issue in amsynth, please [create a new issue](https://github.com/amsynth/amsynth/issues/new/choose) and describe it in
detail, along with relevant information about your setup.

## Fixing issues :heavy_check_mark:

If you have found a fix for a new or existing issue; great! Your contributions are most welcome :grinning:

You can also have a look at the [existing issues](https://github.com/amsynth/amsynth/issues?q=is%3Aopen+is%3Aissue) to see if there's anything there you feel
comfortable working on. Please add a comment to the issue if you would like to do that.

The normal workflow is to [create your own fork](https://help.github.com/articles/fork-a-repo) of amsynth on GitHub, create your fixes there, and then open [a
pull request](https://help.github.com/articles/using-pull-requests) to have it integrated into amsynth.

## Requesting features :bulb:

Feature requests are welcome, however please realize that this a hobby project and development time is scarce. Small feature enhancements are more likely to become
a reality than things that require a lot of work.

## Adding features :construction:

The best way to make your new feature idea a reality is to work on it yourself!

It's a good idea to create a feature request ticket beforehand to discuss the idea and see if it's likely to be accepted into the main project.
Some ideas may simply not be compatible with the project's goals, or be too much of a maintenance burden to include in the long term.

## Contributing patches / sound banks :musical_note:

If you would like to have your own sound bank included in amsynth for everyone to enjoy, you can
[open an issue](https://github.com/amsynth/amsynth/issues/new/choose) and attach your .bank file

## Becoming a maintainer :muscle:

If you are interested in becoming a maintainer of this project, please first contribute some fixes or new features!

## Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

- (a) The contribution was created in whole or in part by me and I
      have the right to submit it under the open source license
      indicated in the file; or

- (b) The contribution is based upon previous work that, to the best
      of my knowledge, is covered under an appropriate open source
      license and I have the right under that license to submit that
      work with modifications, whether created in whole or in part
      by me, under the same open source license (unless I am
      permitted to submit under a different license), as indicated
      in the file; or

- (c) The contribution was provided directly to me by some other
      person who certified (a), (b) or (c) and I have not modified
      it.

- (d) I understand and agree that this project and the contribution
      are public and that a record of the contribution (including all
      personal information I submit with it, including my sign-off) is
      maintained indefinitely and may be redistributed consistent with
      this project or the open source license(s) involved.
