/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import com.kreative.binpack.BitInputStream;
import com.kreative.binpack.BitOutputStream;
import com.kreative.binpack.DFExpression;
import java.util.Map;

public class DFUnaryExpression
implements DFExpression {
    private Operation op;
    private DFExpression expr;

    public DFUnaryExpression(Operation op, DFExpression expr) {
        this.op = op;
        this.expr = expr;
    }

    @Override
    public int evaluate() {
        switch (this.op) {
            case BOOLEAN_IDENTITY: {
                return this.expr.evaluate() == 0 ? 0 : 1;
            }
            case BOOLEAN_NOT: {
                return this.expr.evaluate() == 0 ? 1 : 0;
            }
            case BITWISE_NOT: {
                return ~this.expr.evaluate();
            }
            case IDENTITY: {
                return this.expr.evaluate();
            }
            case ABS: {
                return Math.abs(this.expr.evaluate());
            }
            case NEGATE: {
                return -this.expr.evaluate();
            }
            case REVERSE_BITS: {
                return Integer.reverse(this.expr.evaluate());
            }
            case REVERSE_BYTES: {
                return Integer.reverseBytes(this.expr.evaluate());
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> fieldValues, BitInputStream in, long length) {
        switch (this.op) {
            case BOOLEAN_IDENTITY: {
                return this.expr.evaluate(fieldValues, in, length) == 0 ? 0 : 1;
            }
            case BOOLEAN_NOT: {
                return this.expr.evaluate(fieldValues, in, length) == 0 ? 1 : 0;
            }
            case BITWISE_NOT: {
                return ~this.expr.evaluate(fieldValues, in, length);
            }
            case IDENTITY: {
                return this.expr.evaluate(fieldValues, in, length);
            }
            case ABS: {
                return Math.abs(this.expr.evaluate(fieldValues, in, length));
            }
            case NEGATE: {
                return -this.expr.evaluate(fieldValues, in, length);
            }
            case REVERSE_BITS: {
                return Integer.reverse(this.expr.evaluate(fieldValues, in, length));
            }
            case REVERSE_BYTES: {
                return Integer.reverseBytes(this.expr.evaluate(fieldValues, in, length));
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> fieldValues, BitOutputStream out) {
        switch (this.op) {
            case BOOLEAN_IDENTITY: {
                return this.expr.evaluate(fieldValues, out) == 0 ? 0 : 1;
            }
            case BOOLEAN_NOT: {
                return this.expr.evaluate(fieldValues, out) == 0 ? 1 : 0;
            }
            case BITWISE_NOT: {
                return ~this.expr.evaluate(fieldValues, out);
            }
            case IDENTITY: {
                return this.expr.evaluate(fieldValues, out);
            }
            case ABS: {
                return Math.abs(this.expr.evaluate(fieldValues, out));
            }
            case NEGATE: {
                return -this.expr.evaluate(fieldValues, out);
            }
            case REVERSE_BITS: {
                return Integer.reverse(this.expr.evaluate(fieldValues, out));
            }
            case REVERSE_BYTES: {
                return Integer.reverseBytes(this.expr.evaluate(fieldValues, out));
            }
        }
        return 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("(");
        switch (this.op) {
            case BOOLEAN_IDENTITY: {
                s.append("!!");
                break;
            }
            case BOOLEAN_NOT: {
                s.append("!");
                break;
            }
            case BITWISE_NOT: {
                s.append("~");
                break;
            }
            case IDENTITY: {
                s.append("+");
                break;
            }
            case NEGATE: {
                s.append("-");
                break;
            }
            default: {
                s.append("<" + this.op.name().toLowerCase() + ">");
            }
        }
        s.append(this.expr.toString());
        s.append(")");
        return s.toString();
    }

    public static enum Operation {
        BOOLEAN_IDENTITY,
        BOOLEAN_NOT,
        BITWISE_NOT,
        IDENTITY,
        ABS,
        NEGATE,
        REVERSE_BITS,
        REVERSE_BYTES;

    }
}

