#!/usr/bin/python
# Update dependencies based on __init__.py
# Copyright (C) 2010 Jelmer Vernooij <jelmer@debian.org>
# Licensed under the GNU GPL, version 2 or later.

from debian.deb822 import Deb822, PkgRelation

from bzrlib.plugin import _load_plugin_module, PluginImporter
import os
plugin_path = os.path.abspath(os.path.join(os.path.dirname(__file__), ".."))
PluginImporter.specific_paths['bzrlib.plugins.pipeline'] = plugin_path
_load_plugin_module("pipeline", plugin_path)

from bzrlib.plugins.pipeline import minimum_bzrlib_version, maximum_bzrlib_version

def update_relation(l, pkg, kind, version):
    found = False
    for pr in l:
        if len(pr) != 1: # only update simple build deps
            continue
        e = pr[0]
        if e["name"] == pkg and e["version"] and e["version"][0] == kind:
            e["version"] = (kind, version)
            found = True
    if not found:
        l.append([{"version": (kind, version), "name": pkg, "arch": None}])

f = open('debian/control', 'r')

source = Deb822(f)

def update_deps(control, field):
    bdi = PkgRelation.parse_relations(control[field])
    update_relation(bdi, "python-bzrlib", ">=", "%d.%d~" % minimum_bzrlib_version[:2])
    update_relation(bdi, "python-bzrlib", "<<", "%d.%d.0" % (maximum_bzrlib_version[0], maximum_bzrlib_version[1]+1))
    control[field] = PkgRelation.str(bdi)

update_deps(source, "Build-Depends")

binary = Deb822(f)

update_deps(binary, "Depends")

f = open("debian/control", "w+")
try:
    source.dump(f)
    f.write("\n")
    binary.dump(f)
finally:
    f.close()
