/***
 *  This file is part of Clutter-Gesture.
 *
 *	Copyright 2009 (c) Intel Corp.
 *	Author: Long Bu		(long.bu@intel.com)
 *		Forrest Zhao	(forrest.zhao@intel.com)
 *
 *  Referenced clutter code
 *  Copyright (C) 2006 OpenedHand
 *
 *  Clutter-Gesture is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published
 *  by the Free Software Foundation; either version 2.1 of the License,
 *  or (at your option) any later version.
 *
 *  Clutter-Gesture is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with ClutterGesture; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 *  USA.
 ***/
#ifndef __GESTURE_EVENTS_H__
#define __GESTURE_EVENTS_H__


typedef enum {
  GESTURE_SLIDE = 1,
  GESTURE_HOLD,
  GESTURE_PINCH,
  GESTURE_ROTATE,
  GESTURE_NAVIGATE,
  GESTURE_ANY
} ClutterGestureEventType;

typedef enum {
  SLIDE_UP = 1,
  SLIDE_DOWN,
  SLIDE_LEFT,
  SLIDE_RIGHT
} ClutterGestureSlideDirection;

typedef enum
{
  LONG_PRESS_QUERY,
  LONG_PRESS_ACTION,
  LONG_PRESS_CANCEL
} ClutterGestureTouchholdAction;

typedef struct {
  ClutterGestureEventType type;              //gesture event type, GESTURE_SLIDE
  guint32 time;                              //event time
  ClutterEventFlags flags;                   //event flags
  ClutterStage *stage;                       //event source stage
  ClutterActor *source;                      //event source actor
  guint32 start_time;                        //gesture start time
  gfloat x_start;                              //X coordinate of start point
  gfloat y_start;                              //Y coordinate of start point
  gfloat x_end;                                //X coordinate of end point
  gfloat y_end;                                //Y coordinate of end point
  ClutterGestureSlideDirection direction;    //1: up, 2: down, 3: left, 4: right
  gint device_id;                            //the device id on which the slide is active
} ClutterGestureSlideEvent;

typedef struct {
  ClutterGestureEventType type;              //gesture event type, GESTURE_HOLD
  guint32 time;                              //event time
  ClutterEventFlags flags;                   //event flags
  ClutterStage *stage;                       //event source stage
  ClutterActor *source;                      //event source actor
  gfloat x;                                  //X coordinate of hold point
  gfloat y;                                  //Y coordinate of hold point
  ClutterGestureTouchholdAction action;      //touch&hold action
}ClutterGestureHoldEvent;

typedef struct {
  ClutterGestureEventType type;  //gesture event type, GESTURE_PINCH 
  guint32 time;                     //event time
  ClutterEventFlags flags;           //event flags
  ClutterStage *stage;               //event source stage
  ClutterActor *source;              //event source actor
  guint32 start_time;                //gesture start time
  gint x_start_1;                    //X coordinate of start point of first finger
  gint y_start_1;                    //Y coordinate of start point of first finger
  gint x_end_1;                      //X coordinate of end point of first finger
  gint y_end_1;                      //Y coordinate of end point of first finger
  gint x_start_2;                    //X coordinate of start point of second finger
  gint y_start_2;                    //Y coordinate of start point of second finger
  gint x_end_2;                      //X coordinate of end point of second finger
  gint y_end_2;                      //Y coordinate of end point of second finger
} ClutterGesturePinchEvent;


typedef struct {
  ClutterGestureEventType type;  //gesture event type, GESTURE_ROTATE 
  guint32 time;                      //event time
  ClutterEventFlags flags;           //event flags
  ClutterStage *stage;               //event source stage
  ClutterActor *source;              //event source actor
  guint32 start_time;                //gesture start time
  gint x_start_1;                    //X coordinate of start point of first finger
  gint y_start_1;                    //Y coordinate of start point of first finger
  gint x_end_1;                      //X coordinate of end point of first finger
  gint y_end_1;                      //Y coordinate of end point of first finger
  gint x_start_2;                    //X coordinate of start point of second finger
  gint y_start_2;                    //Y coordinate of start point of second finger
  gint x_end_2;                      //X coordinate of end point of second finger
  gint y_end_2;                      //Y coordinate of end point of second finger
} ClutterGestureRotateEvent;

typedef struct {
  ClutterGestureEventType type;      //gesture event type, GESTURE_NAVIGATE 
  guint32 time;                      //event time
  ClutterEventFlags flags;           //event flags
  ClutterStage *stage;               //event source stage
  ClutterActor *source;              //event source actor
  guint32 start_time;                //gesture start time
  gint x_start_1;                    //X coordinate of start point of first finger
  gint y_start_1;                    //Y coordinate of start point of first finger
  gint x_end_1;                      //X coordinate of end point of first finger
  gint y_end_1;                      //Y coordinate of end point of first finger
  gint x_start_2;                    //X coordinate of start point of second finger
  gint y_start_2;                    //Y coordinate of start point of second finger
  gint x_end_2;                      //X coordinate of end point of second finger
  gint y_end_2;                      //Y coordinate of end point of second finger
} ClutterGestureNavigateEvent;


typedef struct {
  ClutterGestureEventType type;  //gesture event type, 
  guint32 time;                      //event time
  ClutterEventFlags flags;           //event flags
  ClutterStage *stage;               //event source stage
  ClutterActor *source;              //event source actor
} ClutterGestureEvent;

#endif
