#ifndef __cppcheckreportpage__
#define __cppcheckreportpage__

/**
@file
Subclass of CppCheckReportBasePage, which is generated by wxFormBuilder.
*/

#include "cppcheckreportbasepage.h"
#include "cppchecktestresults.h"
#include <vector>
#include <map>

extern const wxEventType wxEVT_CPPCHECK_ASK_STOP;

class IManager;
class CppCheckPlugin;

/** Implementing CppCheckReportBasePage */
class CppCheckReportPage : public CppCheckReportBasePage
{
	IManager*           m_mgr;
	CppCheckPlugin*     m_plugin;

protected:
	static int ColorLine ( int, const char *text, size_t &start, size_t &len );

protected:
	// Handlers for CppCheckReportBasePage events.

	void OnClearReport          ( wxCommandEvent& event );
	void OnStopChecking         ( wxCommandEvent& event );
	void OnStopCheckingUI       (wxUpdateUIEvent &event);
	void OnClearReportUI        (wxUpdateUIEvent &event);

	// Scintilla events
	void OnOpenFile             (wxScintillaEvent &e);

public:
	/** Constructor */
	CppCheckReportPage(wxWindow* parent, IManager* mgr, CppCheckPlugin* plugin);
	virtual ~CppCheckReportPage();

	void   Clear        ();
	size_t GetErrorCount() const;
	void   AppendLine   (const wxString &line);
	void   PrintStatusMessage();
	void   SetGaugeRange(int range);
	void   SetMessage(const wxString &msg);
};

#endif // __cppcheckreportpage__
