/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.SecondsDurationValue;

public class SaxonDuration
extends Duration {
    private DurationValue duration;

    public SaxonDuration(DurationValue durationValue) {
        this.duration = durationValue;
    }

    public DurationValue getDurationValue() {
        return this.duration;
    }

    public QName getXMLSchemaType() {
        if (this.duration instanceof SecondsDurationValue) {
            return new QName("http://www.w3.org/2001/XMLSchema", "dayTimeDuration");
        }
        if (this.duration instanceof MonthDurationValue) {
            return new QName("http://www.w3.org/2001/XMLSchema", "yearMonthDuration");
        }
        return new QName("http://www.w3.org/2001/XMLSchema", "duration");
    }

    public int getSign() {
        return this.duration.signum();
    }

    public Number getField(DatatypeConstants.Field field) {
        try {
            if (field == DatatypeConstants.YEARS) {
                return BigInteger.valueOf(((IntegerValue)this.duration.getComponent(1)).longValue());
            }
            if (field == DatatypeConstants.MONTHS) {
                return BigInteger.valueOf(((IntegerValue)this.duration.getComponent(2)).longValue());
            }
            if (field == DatatypeConstants.DAYS) {
                return BigInteger.valueOf(((IntegerValue)this.duration.getComponent(3)).longValue());
            }
            if (field == DatatypeConstants.HOURS) {
                return BigInteger.valueOf(((IntegerValue)this.duration.getComponent(4)).longValue());
            }
            if (field == DatatypeConstants.MINUTES) {
                return BigInteger.valueOf(((IntegerValue)this.duration.getComponent(5)).longValue());
            }
            if (field == DatatypeConstants.SECONDS) {
                return ((DecimalValue)this.duration.getComponent(6)).getValue();
            }
            throw new IllegalArgumentException("Invalid field");
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)"Component extraction on duration failed");
        }
    }

    public boolean isSet(DatatypeConstants.Field field) {
        return true;
    }

    public Duration add(Duration duration) {
        try {
            return new SaxonDuration(this.duration.add(((SaxonDuration)duration).duration));
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException.getMessage());
        }
    }

    public Duration subtract(Duration duration) {
        try {
            return new SaxonDuration(this.duration.subtract(((SaxonDuration)duration).duration));
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException.getMessage());
        }
    }

    public void addTo(Calendar calendar) {
        int n = this.getSign();
        if (n == 0) {
            return;
        }
        try {
            calendar.add(this.getYears() * n, 1);
            calendar.add(this.getMonths() * n, 2);
            calendar.add(this.getDays() * n, 5);
            calendar.add(this.getHours() * n, 11);
            calendar.add(this.getMinutes() * n, 12);
            calendar.add((int)((IntegerValue)this.duration.getComponent(12)).longValue() * n, 13);
            calendar.add((int)((IntegerValue)this.duration.getComponent(11)).longValue() * n / 1000, 14);
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException.getMessage());
        }
    }

    public Duration multiply(BigDecimal bigDecimal) {
        try {
            return new SaxonDuration(this.duration.multiply(bigDecimal.doubleValue()));
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException.getMessage());
        }
    }

    public Duration negate() {
        return new SaxonDuration(this.duration.negate());
    }

    public Duration normalizeWith(Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public int compare(Duration duration) {
        if (this.duration instanceof MonthDurationValue) {
            return ((MonthDurationValue)this.duration).compareTo((MonthDurationValue)((SaxonDuration)duration).duration);
        }
        if (this.duration instanceof SecondsDurationValue) {
            return ((SecondsDurationValue)this.duration).compareTo((SecondsDurationValue)((SaxonDuration)duration).duration);
        }
        throw new IllegalArgumentException("Non-comparable durations");
    }

    public int hashCode() {
        return this.duration.hashCode();
    }
}

