/*
Copyright (C) 2000-2002 Jos Roberto B. de A. Monteiro <jrm@sel.eesc.usp.br>
                        and Pedro Zorzenon Neto <pzn@vztech.com.br>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Do not forget to visit Free Software Foundation site: http://fsf.org

$Id: mcdelay.c,v 1.2 2003/06/30 17:20:25 pzn Exp $
*/

/*
 From http://www.linuxdoc.org/HOWTO/mini/IO-Port-Programming.html
 an outb to port 0x80 gives a delay of aprox 1microsec independent
 of your machine type/clock.
 See also documentation in asm/io.h
*/

#include "common.h"
#include "mcdelay.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef __dos__
# include <dos.h>
#else
# include <unistd.h>
# include <sys/io.h>
# include <sys/types.h>
#endif

int old_port_value;
unsigned int m_f;

void microdelay_init(int multiply_factor) {
    /* permition to write in port 0x80
     nothing is suposed to use this port
    however, we will write the same value we read... */
#ifdef __dos__
    old_port_value=inportb(0x80);
#else
    if (geteuid()!=0) {
	fprintf(stderr,"ERROR: this programs needs root permisions to access parallel port. Please use root user to run or setuid bit.\n");
	abort();
    }
    ioperm(0x80,1,1);
    old_port_value=inb(0x80);
#endif
    m_f = multiply_factor;
}

void microdelay(unsigned int microsec) {
  unsigned int i;
  i = m_f;
  while (i)
    {
      while (microsec)
	{
#ifdef __dos__
	  outportb(0x80, old_port_value);
#else
	  outb(old_port_value,0x80);
#endif
	  microsec--;
	}
      i--;
    }
}
