/* im-details.c generated by valac 0.36.1.697-2b74, the Vala compiler
 * generated from im-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;
typedef struct _FolksAbstractFieldDetailsPrivate FolksAbstractFieldDetailsPrivate;

#define FOLKS_TYPE_IM_FIELD_DETAILS (folks_im_field_details_get_type ())
#define FOLKS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetails))
#define FOLKS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))
#define FOLKS_IS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IM_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))

typedef struct _FolksImFieldDetails FolksImFieldDetails;
typedef struct _FolksImFieldDetailsClass FolksImFieldDetailsClass;
typedef struct _FolksImFieldDetailsPrivate FolksImFieldDetailsPrivate;
enum  {
	FOLKS_IM_FIELD_DETAILS_DUMMY_PROPERTY,
	FOLKS_IM_FIELD_DETAILS_LAST_PROPERTY
};
static GParamSpec* folks_im_field_details_properties[FOLKS_IM_FIELD_DETAILS_LAST_PROPERTY];

#define FOLKS_TYPE_IM_DETAILS (folks_im_details_get_type ())
#define FOLKS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetails))
#define FOLKS_IS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_DETAILS))
#define FOLKS_IM_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetailsIface))

typedef struct _FolksImDetails FolksImDetails;
typedef struct _FolksImDetailsIface FolksImDetailsIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksImDetailsChangeImAddressesData FolksImDetailsChangeImAddressesData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

/**
 * Errors related to IM addresses and IM address handling.
 */
typedef enum  {
	FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS
} FolksImDetailsError;
#define FOLKS_IM_DETAILS_ERROR folks_im_details_error_quark ()
struct _FolksAbstractFieldDetails {
	GObject parent_instance;
	FolksAbstractFieldDetailsPrivate * priv;
};

struct _FolksAbstractFieldDetailsClass {
	GObjectClass parent_class;
	gboolean (*equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	gboolean (*parameters_equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	gboolean (*values_equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	guint (*hash) (FolksAbstractFieldDetails* self);
	gconstpointer (*get_value) (FolksAbstractFieldDetails* self);
	void (*set_value) (FolksAbstractFieldDetails* self, gconstpointer value);
	const gchar* (*get_id) (FolksAbstractFieldDetails* self);
	void (*set_id) (FolksAbstractFieldDetails* self, const gchar* value);
	GeeMultiMap* (*get_parameters) (FolksAbstractFieldDetails* self);
	void (*set_parameters) (FolksAbstractFieldDetails* self, GeeMultiMap* value);
};

struct _FolksImFieldDetails {
	FolksAbstractFieldDetails parent_instance;
	FolksImFieldDetailsPrivate * priv;
};

struct _FolksImFieldDetailsClass {
	FolksAbstractFieldDetailsClass parent_class;
};

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR,
	FOLKS_PROPERTY_ERROR_UNAVAILABLE
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksImDetailsIface {
	GTypeInterface parent_iface;
	void (*change_im_addresses) (FolksImDetails* self, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_im_addresses_finish) (FolksImDetails* self, GAsyncResult* _res_, GError** error);
	GeeMultiMap* (*get_im_addresses) (FolksImDetails* self);
	void (*set_im_addresses) (FolksImDetails* self, GeeMultiMap* value);
};

struct _FolksImDetailsChangeImAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	FolksImDetails* self;
	GeeMultiMap* im_addresses;
	GError* _tmp0_;
	GError * _inner_error_;
};


static gpointer folks_im_field_details_parent_class = NULL;

GQuark folks_im_details_error_quark (void);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_im_field_details_get_type (void) G_GNUC_CONST;
FolksImFieldDetails* folks_im_field_details_new (const gchar* value, GeeMultiMap* parameters);
FolksImFieldDetails* folks_im_field_details_construct (GType object_type, const gchar* value, GeeMultiMap* parameters);
FolksAbstractFieldDetails* folks_abstract_field_details_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
void folks_abstract_field_details_set_value (FolksAbstractFieldDetails* self, gconstpointer value);
void folks_abstract_field_details_set_parameters (FolksAbstractFieldDetails* self, GeeMultiMap* value);
static gboolean folks_im_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that);
gboolean folks_abstract_field_details_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
static guint folks_im_field_details_real_hash (FolksAbstractFieldDetails* base);
guint folks_abstract_field_details_hash (FolksAbstractFieldDetails* self);
GQuark folks_property_error_quark (void);
GType folks_im_details_get_type (void) G_GNUC_CONST;
static void folks_im_details_real_change_im_addresses_data_free (gpointer _data);
static void folks_im_details_real_change_im_addresses_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void folks_im_details_real_change_im_addresses (FolksImDetails* self, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_im_details_change_im_addresses (FolksImDetails* self, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_im_details_change_im_addresses_finish (FolksImDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_im_details_real_change_im_addresses_co (FolksImDetailsChangeImAddressesData* _data_);
gchar* folks_im_details_normalise_im_address (const gchar* im_address, const gchar* protocol, GError** error);
GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self);
void folks_im_details_set_im_addresses (FolksImDetails* self, GeeMultiMap* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark folks_im_details_error_quark (void) {
	return g_quark_from_static_string ("folks_im_details_error-quark");
}


/**
   * Create a new ImFieldDetails.
   *
   * @param value the value of the field, which should be a valid, non-empty
   * IM address
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to
   * an empty map of parameters.
   *
   * @return a new ImFieldDetails
   *
   * @since 0.6.0
   */
FolksImFieldDetails* folks_im_field_details_construct (GType object_type, const gchar* value, GeeMultiMap* parameters) {
	FolksImFieldDetails * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeMultiMap* _tmp2_;
	g_return_val_if_fail (value != NULL, NULL);
	self = (FolksImFieldDetails*) folks_abstract_field_details_construct (object_type, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free);
	_tmp0_ = value;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		g_warning ("im-details.vala:64: Empty IM address passed to ImFieldDetails.");
	}
	_tmp1_ = value;
	folks_abstract_field_details_set_value ((FolksAbstractFieldDetails*) self, _tmp1_);
	_tmp2_ = parameters;
	if (_tmp2_ != NULL) {
		GeeMultiMap* _tmp3_;
		_tmp3_ = parameters;
		folks_abstract_field_details_set_parameters ((FolksAbstractFieldDetails*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
	}
	return self;
}


FolksImFieldDetails* folks_im_field_details_new (const gchar* value, GeeMultiMap* parameters) {
	return folks_im_field_details_construct (FOLKS_TYPE_IM_FIELD_DETAILS, value, parameters);
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean folks_im_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that) {
	FolksImFieldDetails * self;
	gboolean result = FALSE;
	FolksAbstractFieldDetails* _tmp0_;
	gboolean _tmp1_;
	self = (FolksImFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = that;
	_tmp1_ = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_im_field_details_parent_class)->equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), _tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint folks_im_field_details_real_hash (FolksAbstractFieldDetails* base) {
	FolksImFieldDetails * self;
	guint result = 0U;
	guint _tmp0_;
	self = (FolksImFieldDetails*) base;
	_tmp0_ = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_im_field_details_parent_class)->hash (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	result = _tmp0_;
	return result;
}


static void folks_im_field_details_class_init (FolksImFieldDetailsClass * klass) {
	folks_im_field_details_parent_class = g_type_class_peek_parent (klass);
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails *, FolksAbstractFieldDetails*)) folks_im_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails *)) folks_im_field_details_real_hash;
}


static void folks_im_field_details_instance_init (FolksImFieldDetails * self) {
}


/**
 * Object representing an IM address value that can have some parameters
 * associated with it.
 *
 * See {@link Folks.AbstractFieldDetails}.
 *
 * @since 0.6.0
 */
GType folks_im_field_details_get_type (void) {
	static volatile gsize folks_im_field_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_im_field_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_im_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImFieldDetails), 0, (GInstanceInitFunc) folks_im_field_details_instance_init, NULL };
		GType folks_im_field_details_type_id;
		folks_im_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksImFieldDetails", &g_define_type_info, 0);
		g_once_init_leave (&folks_im_field_details_type_id__volatile, folks_im_field_details_type_id);
	}
	return folks_im_field_details_type_id__volatile;
}


static void folks_im_details_real_change_im_addresses_data_free (gpointer _data) {
	FolksImDetailsChangeImAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->im_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksImDetailsChangeImAddressesData, _data_);
}


static void folks_im_details_real_change_im_addresses_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	FolksImDetailsChangeImAddressesData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_im_details_real_change_im_addresses (FolksImDetails* self, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImDetailsChangeImAddressesData* _data_;
	FolksImDetails* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	_data_ = g_slice_new0 (FolksImDetailsChangeImAddressesData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, folks_im_details_real_change_im_addresses_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, folks_im_details_real_change_im_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = im_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->im_addresses);
	_data_->im_addresses = _tmp2_;
	folks_im_details_real_change_im_addresses_co (_data_);
}


static void folks_im_details_real_change_im_addresses_finish (FolksImDetails* self, GAsyncResult* _res_, GError** error) {
	FolksImDetailsChangeImAddressesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


/**
   * Change the contact's set of IM addresses.
   *
   * It's preferred to call this rather than setting
   * {@link ImDetails.im_addresses} directly, as this method gives error
   * notification and will only return once the IM addresses have been written
   * to the relevant backing store (or the operation's failed).
   *
   * @param im_addresses the new map of protocols to IM addresses
   * @throws PropertyError if setting the IM addresses failed
   * @since 0.6.2
   */
static gboolean folks_im_details_real_change_im_addresses_co (FolksImDetailsChangeImAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("IM addresses are not writeable on this contact."));
	_data_->_inner_error_ = _data_->_tmp0_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_im_details_change_im_addresses (FolksImDetails* self, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_IM_DETAILS_GET_INTERFACE (self)->change_im_addresses (self, im_addresses, _callback_, _user_data_);
}


void folks_im_details_change_im_addresses_finish (FolksImDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_IM_DETAILS_GET_INTERFACE (self)->change_im_addresses_finish (self, _res_, error);
}


/**
   * Normalise an IM address so that it's suitable for string comparison.
   *
   * IM addresses for various protocols can be represented in different ways,
   * only one of which is canonical. In order to allow simple string comparisons
   * of IM addresses to work, the IM addresses must be normalised beforehand.
   *
   * If the provided IM address is invalid,
   * {@link Folks.ImDetailsError.INVALID_IM_ADDRESS} will be thrown. Note that
   * this isn't guaranteed to be thrown for all invalid addresses, but if it is
   * thrown, the address is guaranteed to be invalid.
   *
   * @param im_address the address to normalise
   * @param protocol the protocol of this im_address
   *
   * @since 0.2.0
   * @throws Folks.ImDetailsError if the provided IM address was invalid
   */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* folks_im_details_normalise_im_address (const gchar* im_address, const gchar* protocol, GError** error) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (im_address != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp1_ = protocol;
	if (g_strcmp0 (_tmp1_, "aim") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = protocol;
		_tmp0_ = g_strcmp0 (_tmp2_, "myspace") == 0;
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp3_ = im_address;
		_tmp4_ = string_replace (_tmp3_, " ", "");
		_tmp5_ = _tmp4_;
		_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_utf8_normalize (_tmp7_, (gssize) -1, G_NORMALIZE_DEFAULT);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		result = _tmp9_;
		return result;
	} else {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
		_tmp13_ = protocol;
		if (g_strcmp0 (_tmp13_, "irc") == 0) {
			_tmp12_ = TRUE;
		} else {
			const gchar* _tmp14_;
			_tmp14_ = protocol;
			_tmp12_ = g_strcmp0 (_tmp14_, "yahoo") == 0;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp15_;
			_tmp15_ = protocol;
			_tmp11_ = g_strcmp0 (_tmp15_, "yahoojp") == 0;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			const gchar* _tmp16_;
			_tmp16_ = protocol;
			_tmp10_ = g_strcmp0 (_tmp16_, "groupwise") == 0;
		}
		if (_tmp10_) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp17_ = im_address;
			_tmp18_ = g_utf8_strdown (_tmp17_, (gssize) -1);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_utf8_normalize (_tmp19_, (gssize) -1, G_NORMALIZE_DEFAULT);
			_tmp21_ = _tmp20_;
			_g_free0 (_tmp19_);
			result = _tmp21_;
			return result;
		} else {
			const gchar* _tmp22_;
			_tmp22_ = protocol;
			if (g_strcmp0 (_tmp22_, "jabber") == 0) {
				gchar** parts = NULL;
				const gchar* _tmp23_;
				gchar** _tmp24_;
				gchar** _tmp25_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				gchar* resource = NULL;
				gchar** _tmp29_;
				gint _tmp29__length1;
				gchar** _tmp33_;
				gint _tmp33__length1;
				const gchar* _tmp34_;
				gchar** _tmp35_;
				gchar** _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				gchar* node = NULL;
				gchar* _domain = NULL;
				gchar** _tmp40_;
				gint _tmp40__length1;
				gboolean _tmp50_ = FALSE;
				gboolean _tmp51_ = FALSE;
				gboolean _tmp52_ = FALSE;
				const gchar* _tmp53_;
				gchar* domain = NULL;
				const gchar* _tmp63_;
				gchar* _tmp64_;
				const gchar* _tmp65_;
				gchar* normalised = NULL;
				gboolean _tmp68_ = FALSE;
				const gchar* _tmp69_;
				const gchar* _tmp85_;
				gchar* _tmp86_;
				_tmp23_ = im_address;
				_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "/", 2);
				parts = _tmp25_;
				parts_length1 = _vala_array_length (_tmp24_);
				_parts_size_ = parts_length1;
				_tmp26_ = parts;
				_tmp26__length1 = parts_length1;
				if (_tmp26__length1 < 1) {
					const gchar* _tmp27_;
					GError* _tmp28_;
					_tmp27_ = im_address;
					_tmp28_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _ ("The IM address ‘%s’ could not be understood."), _tmp27_);
					_inner_error_ = _tmp28_;
					if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error_);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				resource = NULL;
				_tmp29_ = parts;
				_tmp29__length1 = parts_length1;
				if (_tmp29__length1 == 2) {
					gchar** _tmp30_;
					gint _tmp30__length1;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp30_ = parts;
					_tmp30__length1 = parts_length1;
					_tmp31_ = _tmp30_[1];
					_tmp32_ = g_strdup (_tmp31_);
					_g_free0 (resource);
					resource = _tmp32_;
				}
				_tmp33_ = parts;
				_tmp33__length1 = parts_length1;
				_tmp34_ = _tmp33_[0];
				_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, "@", 2);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				parts = _tmp36_;
				parts_length1 = _vala_array_length (_tmp35_);
				_parts_size_ = parts_length1;
				_tmp37_ = parts;
				_tmp37__length1 = parts_length1;
				if (_tmp37__length1 < 1) {
					const gchar* _tmp38_;
					GError* _tmp39_;
					_tmp38_ = im_address;
					_tmp39_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _ ("The IM address ‘%s’ could not be understood."), _tmp38_);
					_inner_error_ = _tmp39_;
					if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp40_ = parts;
				_tmp40__length1 = parts_length1;
				if (_tmp40__length1 == 2) {
					gchar** _tmp41_;
					gint _tmp41__length1;
					const gchar* _tmp42_;
					gchar* _tmp43_;
					gchar** _tmp44_;
					gint _tmp44__length1;
					const gchar* _tmp45_;
					gchar* _tmp46_;
					_tmp41_ = parts;
					_tmp41__length1 = parts_length1;
					_tmp42_ = _tmp41_[0];
					_tmp43_ = g_strdup (_tmp42_);
					_g_free0 (node);
					node = _tmp43_;
					_tmp44_ = parts;
					_tmp44__length1 = parts_length1;
					_tmp45_ = _tmp44_[1];
					_tmp46_ = g_strdup (_tmp45_);
					_g_free0 (_domain);
					_domain = _tmp46_;
				} else {
					gchar** _tmp47_;
					gint _tmp47__length1;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					_g_free0 (node);
					node = NULL;
					_tmp47_ = parts;
					_tmp47__length1 = parts_length1;
					_tmp48_ = _tmp47_[0];
					_tmp49_ = g_strdup (_tmp48_);
					_g_free0 (_domain);
					_domain = _tmp49_;
				}
				_tmp53_ = node;
				if (_tmp53_ != NULL) {
					const gchar* _tmp54_;
					_tmp54_ = node;
					_tmp52_ = g_strcmp0 (_tmp54_, "") == 0;
				} else {
					_tmp52_ = FALSE;
				}
				if (_tmp52_) {
					_tmp51_ = TRUE;
				} else {
					gboolean _tmp55_ = FALSE;
					const gchar* _tmp56_;
					_tmp56_ = _domain;
					if (_tmp56_ == NULL) {
						_tmp55_ = TRUE;
					} else {
						const gchar* _tmp57_;
						_tmp57_ = _domain;
						_tmp55_ = g_strcmp0 (_tmp57_, "") == 0;
					}
					_tmp51_ = _tmp55_;
				}
				if (_tmp51_) {
					_tmp50_ = TRUE;
				} else {
					gboolean _tmp58_ = FALSE;
					const gchar* _tmp59_;
					_tmp59_ = resource;
					if (_tmp59_ != NULL) {
						const gchar* _tmp60_;
						_tmp60_ = resource;
						_tmp58_ = g_strcmp0 (_tmp60_, "") == 0;
					} else {
						_tmp58_ = FALSE;
					}
					_tmp50_ = _tmp58_;
				}
				if (_tmp50_) {
					const gchar* _tmp61_;
					GError* _tmp62_;
					_tmp61_ = im_address;
					_tmp62_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _ ("The IM address ‘%s’ could not be understood."), _tmp61_);
					_inner_error_ = _tmp62_;
					if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_domain);
						_g_free0 (node);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						_g_free0 (_domain);
						_g_free0 (node);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp63_ = _domain;
				_tmp64_ = g_utf8_strdown ((const gchar*) _tmp63_, (gssize) -1);
				domain = _tmp64_;
				_tmp65_ = node;
				if (_tmp65_ != NULL) {
					const gchar* _tmp66_;
					gchar* _tmp67_;
					_tmp66_ = node;
					_tmp67_ = g_utf8_strdown ((const gchar*) _tmp66_, (gssize) -1);
					_g_free0 (node);
					node = _tmp67_;
				}
				normalised = NULL;
				_tmp69_ = node;
				if (_tmp69_ != NULL) {
					const gchar* _tmp70_;
					_tmp70_ = resource;
					_tmp68_ = _tmp70_ != NULL;
				} else {
					_tmp68_ = FALSE;
				}
				if (_tmp68_) {
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_;
					gchar* _tmp74_;
					_tmp71_ = node;
					_tmp72_ = domain;
					_tmp73_ = resource;
					_tmp74_ = g_strdup_printf ("%s@%s/%s", (const gchar*) _tmp71_, _tmp72_, (const gchar*) _tmp73_);
					_g_free0 (normalised);
					normalised = _tmp74_;
				} else {
					const gchar* _tmp75_;
					_tmp75_ = node;
					if (_tmp75_ != NULL) {
						const gchar* _tmp76_;
						const gchar* _tmp77_;
						gchar* _tmp78_;
						_tmp76_ = node;
						_tmp77_ = domain;
						_tmp78_ = g_strdup_printf ("%s@%s", (const gchar*) _tmp76_, _tmp77_);
						_g_free0 (normalised);
						normalised = _tmp78_;
					} else {
						const gchar* _tmp79_;
						_tmp79_ = resource;
						if (_tmp79_ != NULL) {
							const gchar* _tmp80_;
							const gchar* _tmp81_;
							gchar* _tmp82_;
							_tmp80_ = domain;
							_tmp81_ = resource;
							_tmp82_ = g_strdup_printf ("%s/%s", _tmp80_, (const gchar*) _tmp81_);
							_g_free0 (normalised);
							normalised = _tmp82_;
						} else {
							const gchar* _tmp83_;
							GError* _tmp84_;
							_tmp83_ = im_address;
							_tmp84_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _ ("The IM address ‘%s’ could not be understood."), _tmp83_);
							_inner_error_ = _tmp84_;
							if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (normalised);
								_g_free0 (domain);
								_g_free0 (_domain);
								_g_free0 (node);
								_g_free0 (resource);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								return NULL;
							} else {
								_g_free0 (normalised);
								_g_free0 (domain);
								_g_free0 (_domain);
								_g_free0 (node);
								_g_free0 (resource);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
				}
				_tmp85_ = normalised;
				_tmp86_ = g_utf8_normalize ((const gchar*) _tmp85_, (gssize) -1, G_NORMALIZE_NFKC);
				result = _tmp86_;
				_g_free0 (normalised);
				_g_free0 (domain);
				_g_free0 (_domain);
				_g_free0 (node);
				_g_free0 (resource);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				const gchar* _tmp87_;
				gchar* _tmp88_;
				_tmp87_ = im_address;
				_tmp88_ = g_utf8_normalize (_tmp87_, (gssize) -1, G_NORMALIZE_DEFAULT);
				result = _tmp88_;
				return result;
			}
		}
	}
}


GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_IM_DETAILS_GET_INTERFACE (self)->get_im_addresses (self);
}


void folks_im_details_set_im_addresses (FolksImDetails* self, GeeMultiMap* value) {
	g_return_if_fail (self != NULL);
	FOLKS_IM_DETAILS_GET_INTERFACE (self)->set_im_addresses (self, value);
}


static void folks_im_details_base_init (FolksImDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * A mapping of IM protocol to an (unordered) set of IM addresses.
		   *
		   * Each mapping is from an arbitrary protocol identifier to a set of IM
		   * addresses on that protocol for the contact, listed in no particular order.
		   *
		   * There must be no duplicate IM addresses in each set, though a given
		   * IM address may be present in the sets for different protocols.
		   *
		   * All the IM addresses must be normalised using
		   * {@link ImDetails.normalise_im_address} before being added to this property.
		   *
		   * @since 0.5.1
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("im-addresses", "im-addresses", "im-addresses", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_im_addresses = folks_im_details_real_change_im_addresses;
		iface->change_im_addresses_finish = folks_im_details_real_change_im_addresses_finish;
	}
}


/**
 * IM addresses exposed by an object implementing {@link PresenceDetails}.
 *
 * @since 0.1.13
 */
GType folks_im_details_get_type (void) {
	static volatile gsize folks_im_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_im_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImDetailsIface), (GBaseInitFunc) folks_im_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_im_details_type_id;
		folks_im_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksImDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_im_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_im_details_type_id__volatile, folks_im_details_type_id);
	}
	return folks_im_details_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



