#!/usr/bin/env python

import sys
import os.path
import glob
from distutils.core import setup
from DistUtilsExtra.command import *

for line in open(os.path.join(os.path.dirname(sys.argv[0]), 'fusslauncher/conf.py')):
    if line.startswith('VERSION='):
        version = eval(line.split('=')[-1])

setup(name='fuss-launcher',
      version=version,
      description='FUSS application launcher',
#      long_description=''
      author=['Enrico Zini', 'Christopher R. Gabriel'],
      author_email=['enrico@truelite.it', 'cgabriel@truelite.it'],
      url='https://devel.fuss.bz.it/wiki/FussLauncher',
#      install_requires = [
#          "axi", "xdg", "xapian",
#      ],
#      data_files=[
#          ('share/software-properties/designer',
#           glob.glob("data/designer/*.ui")
#          ),
#          ('share/software-properties/glade',
#           glob.glob("data/glade/*.glade")
#          ),
#      ],
      license='GPL',
      platforms='any',
      packages=['fusslauncher'],
      scripts=['fuss-launcher'],
      cmdclass = { "build" : build_extra.build_extra,
                   "build_i18n" :  build_i18n.build_i18n,
                   "build_help" :  build_help.build_help,
                   "build_icons" :  build_icons.build_icons }
)
