
"The base Node class."

class Node(object):
    def __init__(self, children=[]):
        """
        @param children: A list of child nodes.
        """

        self.children = list(children)

    def render(self, ctx):
        "Call C{self.draw()}, then render children."

        self.draw(ctx)

        for c in self.children:
            c.render(ctx)

    def draw(self, ctx):
        "Perform drawing for this node."

    def __repr__(self):
        return '%s(children=%r)' % (self.__class__.__name__, self.children)
