package metrics

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AggregationType enumerates the values for aggregation type.
type AggregationType string

const (
	// Average ...
	Average AggregationType = "Average"
	// Count ...
	Count AggregationType = "Count"
	// Maximum ...
	Maximum AggregationType = "Maximum"
	// Minimum ...
	Minimum AggregationType = "Minimum"
	// None ...
	None AggregationType = "None"
	// Total ...
	Total AggregationType = "Total"
)

// PossibleAggregationTypeValues returns an array of possible values for the AggregationType const type.
func PossibleAggregationTypeValues() []AggregationType {
	return []AggregationType{Average, Count, Maximum, Minimum, None, Total}
}

// AggregationTypeEnum enumerates the values for aggregation type enum.
type AggregationTypeEnum string

const (
	// AggregationTypeEnumAverage ...
	AggregationTypeEnumAverage AggregationTypeEnum = "Average"
	// AggregationTypeEnumCount ...
	AggregationTypeEnumCount AggregationTypeEnum = "Count"
	// AggregationTypeEnumMaximum ...
	AggregationTypeEnumMaximum AggregationTypeEnum = "Maximum"
	// AggregationTypeEnumMinimum ...
	AggregationTypeEnumMinimum AggregationTypeEnum = "Minimum"
	// AggregationTypeEnumTotal ...
	AggregationTypeEnumTotal AggregationTypeEnum = "Total"
)

// PossibleAggregationTypeEnumValues returns an array of possible values for the AggregationTypeEnum const type.
func PossibleAggregationTypeEnumValues() []AggregationTypeEnum {
	return []AggregationTypeEnum{AggregationTypeEnumAverage, AggregationTypeEnumCount, AggregationTypeEnumMaximum, AggregationTypeEnumMinimum, AggregationTypeEnumTotal}
}

// BaselineSensitivity enumerates the values for baseline sensitivity.
type BaselineSensitivity string

const (
	// High ...
	High BaselineSensitivity = "High"
	// Low ...
	Low BaselineSensitivity = "Low"
	// Medium ...
	Medium BaselineSensitivity = "Medium"
)

// PossibleBaselineSensitivityValues returns an array of possible values for the BaselineSensitivity const type.
func PossibleBaselineSensitivityValues() []BaselineSensitivity {
	return []BaselineSensitivity{High, Low, Medium}
}

// CriterionType enumerates the values for criterion type.
type CriterionType string

const (
	// CriterionTypeDynamicThresholdCriterion ...
	CriterionTypeDynamicThresholdCriterion CriterionType = "DynamicThresholdCriterion"
	// CriterionTypeMultiMetricCriteria ...
	CriterionTypeMultiMetricCriteria CriterionType = "MultiMetricCriteria"
	// CriterionTypeStaticThresholdCriterion ...
	CriterionTypeStaticThresholdCriterion CriterionType = "StaticThresholdCriterion"
)

// PossibleCriterionTypeValues returns an array of possible values for the CriterionType const type.
func PossibleCriterionTypeValues() []CriterionType {
	return []CriterionType{CriterionTypeDynamicThresholdCriterion, CriterionTypeMultiMetricCriteria, CriterionTypeStaticThresholdCriterion}
}

// DynamicThresholdOperator enumerates the values for dynamic threshold operator.
type DynamicThresholdOperator string

const (
	// GreaterOrLessThan ...
	GreaterOrLessThan DynamicThresholdOperator = "GreaterOrLessThan"
	// GreaterThan ...
	GreaterThan DynamicThresholdOperator = "GreaterThan"
	// LessThan ...
	LessThan DynamicThresholdOperator = "LessThan"
)

// PossibleDynamicThresholdOperatorValues returns an array of possible values for the DynamicThresholdOperator const type.
func PossibleDynamicThresholdOperatorValues() []DynamicThresholdOperator {
	return []DynamicThresholdOperator{GreaterOrLessThan, GreaterThan, LessThan}
}

// DynamicThresholdSensitivity enumerates the values for dynamic threshold sensitivity.
type DynamicThresholdSensitivity string

const (
	// DynamicThresholdSensitivityHigh ...
	DynamicThresholdSensitivityHigh DynamicThresholdSensitivity = "High"
	// DynamicThresholdSensitivityLow ...
	DynamicThresholdSensitivityLow DynamicThresholdSensitivity = "Low"
	// DynamicThresholdSensitivityMedium ...
	DynamicThresholdSensitivityMedium DynamicThresholdSensitivity = "Medium"
)

// PossibleDynamicThresholdSensitivityValues returns an array of possible values for the DynamicThresholdSensitivity const type.
func PossibleDynamicThresholdSensitivityValues() []DynamicThresholdSensitivity {
	return []DynamicThresholdSensitivity{DynamicThresholdSensitivityHigh, DynamicThresholdSensitivityLow, DynamicThresholdSensitivityMedium}
}

// MetricAggregationType enumerates the values for metric aggregation type.
type MetricAggregationType string

const (
	// MetricAggregationTypeAverage ...
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	// MetricAggregationTypeCount ...
	MetricAggregationTypeCount MetricAggregationType = "Count"
	// MetricAggregationTypeMaximum ...
	MetricAggregationTypeMaximum MetricAggregationType = "Maximum"
	// MetricAggregationTypeMinimum ...
	MetricAggregationTypeMinimum MetricAggregationType = "Minimum"
	// MetricAggregationTypeNone ...
	MetricAggregationTypeNone MetricAggregationType = "None"
	// MetricAggregationTypeTotal ...
	MetricAggregationTypeTotal MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns an array of possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{MetricAggregationTypeAverage, MetricAggregationTypeCount, MetricAggregationTypeMaximum, MetricAggregationTypeMinimum, MetricAggregationTypeNone, MetricAggregationTypeTotal}
}

// MetricClass enumerates the values for metric class.
type MetricClass string

const (
	// MetricClassAvailability ...
	MetricClassAvailability MetricClass = "Availability"
	// MetricClassErrors ...
	MetricClassErrors MetricClass = "Errors"
	// MetricClassLatency ...
	MetricClassLatency MetricClass = "Latency"
	// MetricClassSaturation ...
	MetricClassSaturation MetricClass = "Saturation"
	// MetricClassTransactions ...
	MetricClassTransactions MetricClass = "Transactions"
)

// PossibleMetricClassValues returns an array of possible values for the MetricClass const type.
func PossibleMetricClassValues() []MetricClass {
	return []MetricClass{MetricClassAvailability, MetricClassErrors, MetricClassLatency, MetricClassSaturation, MetricClassTransactions}
}

// MetricResultType enumerates the values for metric result type.
type MetricResultType string

const (
	// Data ...
	Data MetricResultType = "Data"
	// Metadata ...
	Metadata MetricResultType = "Metadata"
)

// PossibleMetricResultTypeValues returns an array of possible values for the MetricResultType const type.
func PossibleMetricResultTypeValues() []MetricResultType {
	return []MetricResultType{Data, Metadata}
}

// MetricUnit enumerates the values for metric unit.
type MetricUnit string

const (
	// MetricUnitBitsPerSecond ...
	MetricUnitBitsPerSecond MetricUnit = "BitsPerSecond"
	// MetricUnitBytes ...
	MetricUnitBytes MetricUnit = "Bytes"
	// MetricUnitByteSeconds ...
	MetricUnitByteSeconds MetricUnit = "ByteSeconds"
	// MetricUnitBytesPerSecond ...
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	// MetricUnitCores ...
	MetricUnitCores MetricUnit = "Cores"
	// MetricUnitCount ...
	MetricUnitCount MetricUnit = "Count"
	// MetricUnitCountPerSecond ...
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	// MetricUnitMilliCores ...
	MetricUnitMilliCores MetricUnit = "MilliCores"
	// MetricUnitMilliSeconds ...
	MetricUnitMilliSeconds MetricUnit = "MilliSeconds"
	// MetricUnitNanoCores ...
	MetricUnitNanoCores MetricUnit = "NanoCores"
	// MetricUnitPercent ...
	MetricUnitPercent MetricUnit = "Percent"
	// MetricUnitSeconds ...
	MetricUnitSeconds MetricUnit = "Seconds"
	// MetricUnitUnspecified ...
	MetricUnitUnspecified MetricUnit = "Unspecified"
)

// PossibleMetricUnitValues returns an array of possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{MetricUnitBitsPerSecond, MetricUnitBytes, MetricUnitByteSeconds, MetricUnitBytesPerSecond, MetricUnitCores, MetricUnitCount, MetricUnitCountPerSecond, MetricUnitMilliCores, MetricUnitMilliSeconds, MetricUnitNanoCores, MetricUnitPercent, MetricUnitSeconds, MetricUnitUnspecified}
}

// NamespaceClassification enumerates the values for namespace classification.
type NamespaceClassification string

const (
	// Custom ...
	Custom NamespaceClassification = "Custom"
	// Platform ...
	Platform NamespaceClassification = "Platform"
	// Qos ...
	Qos NamespaceClassification = "Qos"
)

// PossibleNamespaceClassificationValues returns an array of possible values for the NamespaceClassification const type.
func PossibleNamespaceClassificationValues() []NamespaceClassification {
	return []NamespaceClassification{Custom, Platform, Qos}
}

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// OdataTypeMetricAlertCriteria ...
	OdataTypeMetricAlertCriteria OdataType = "MetricAlertCriteria"
	// OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria ...
	OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria"
	// OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria ...
	OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria OdataType = "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria"
	// OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria ...
	OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria OdataType = "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria"
)

// PossibleOdataTypeValues returns an array of possible values for the OdataType const type.
func PossibleOdataTypeValues() []OdataType {
	return []OdataType{OdataTypeMetricAlertCriteria, OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria, OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria, OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// OperatorEquals ...
	OperatorEquals Operator = "Equals"
	// OperatorGreaterThan ...
	OperatorGreaterThan Operator = "GreaterThan"
	// OperatorGreaterThanOrEqual ...
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// OperatorLessThan ...
	OperatorLessThan Operator = "LessThan"
	// OperatorLessThanOrEqual ...
	OperatorLessThanOrEqual Operator = "LessThanOrEqual"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{OperatorEquals, OperatorGreaterThan, OperatorGreaterThanOrEqual, OperatorLessThan, OperatorLessThanOrEqual}
}

// ResultType enumerates the values for result type.
type ResultType string

const (
	// ResultTypeData ...
	ResultTypeData ResultType = "Data"
	// ResultTypeMetadata ...
	ResultTypeMetadata ResultType = "Metadata"
)

// PossibleResultTypeValues returns an array of possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{ResultTypeData, ResultTypeMetadata}
}

// Unit enumerates the values for unit.
type Unit string

const (
	// UnitBitsPerSecond ...
	UnitBitsPerSecond Unit = "BitsPerSecond"
	// UnitBytes ...
	UnitBytes Unit = "Bytes"
	// UnitByteSeconds ...
	UnitByteSeconds Unit = "ByteSeconds"
	// UnitBytesPerSecond ...
	UnitBytesPerSecond Unit = "BytesPerSecond"
	// UnitCores ...
	UnitCores Unit = "Cores"
	// UnitCount ...
	UnitCount Unit = "Count"
	// UnitCountPerSecond ...
	UnitCountPerSecond Unit = "CountPerSecond"
	// UnitMilliCores ...
	UnitMilliCores Unit = "MilliCores"
	// UnitMilliSeconds ...
	UnitMilliSeconds Unit = "MilliSeconds"
	// UnitNanoCores ...
	UnitNanoCores Unit = "NanoCores"
	// UnitPercent ...
	UnitPercent Unit = "Percent"
	// UnitSeconds ...
	UnitSeconds Unit = "Seconds"
	// UnitUnspecified ...
	UnitUnspecified Unit = "Unspecified"
)

// PossibleUnitValues returns an array of possible values for the Unit const type.
func PossibleUnitValues() []Unit {
	return []Unit{UnitBitsPerSecond, UnitBytes, UnitByteSeconds, UnitBytesPerSecond, UnitCores, UnitCount, UnitCountPerSecond, UnitMilliCores, UnitMilliSeconds, UnitNanoCores, UnitPercent, UnitSeconds, UnitUnspecified}
}
