/*
 * Decompiled with CFR 0.152.
 */
package haxe.jvm;

import haxe.Exception;
import haxe.Rest;
import haxe.ds.Option;
import haxe.jvm.ClosureDispatch;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

@ClassReflectionInformation(hasSuperClass=true)
public class Closure
extends ClosureDispatch {
    public Object context;
    public Method method;
    public boolean isStatic;
    public Class<Object>[] params;

    public Closure bindTo(Object context) {
        return new Closure(context, this.method);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Closure)) {
            return false;
        }
        Closure other2 = (Closure)other;
        if (Jvm.compare(this.context, other2.context) == 0) {
            return this.method == other2.method;
        }
        return false;
    }

    @Override
    public Object invokeDynamic(Object[] args) throws RuntimeException {
        if (this.isStatic && this.context != null) {
            Object[] newArgs = new Object[args.length + 1];
            System.arraycopy(args, 0, newArgs, 1, args.length);
            newArgs[0] = this.context;
            args = newArgs;
        }
        Object[] args1 = null;
        Option _g = Jvm.unifyCallArguments(args, this.params, true);
        switch (_g.ordinal()) {
            case 0: {
                Object[] args2 = (Object[])((Option.Some)_g).v;
                args1 = args2;
                break;
            }
            case 1: {
                args1 = args;
            }
        }
        try {
            return this.method.invoke(this.context, Rest.Rest_Impl_.ofNative(args1));
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)Exception.thrown(e.getCause());
        }
    }

    public Closure(Object context, Method method) {
        this.context = context;
        this.method = method;
        this.isStatic = (method.getModifiers() & Modifier.STATIC) != 0;
        this.params = method.getParameterTypes();
    }

    public /* synthetic */ Closure(EmptyConstructor _) {
        super(_);
    }
}

