---
title: Editor Plug-ins for Hugo
linktitle: Editor Plug-ins
description: The Hugo community uses a wide range of preferred tools and has developed plug-ins for some of the most popular text editors to help automate parts of your workflow.
date: 2017-02-01
publishdate: 2017-02-01
lastmod: 2017-02-01
categories: [developer tools]
keywords: [editor, plug-ins]
menu:
  docs:
    parent: "tools"
    weight: 50
weight: 50
sections_weight: 50
draft: false
aliases: []
toc: false
---

The Hugo community uses a wide range of preferred tools and has developed plug-ins for some of the most popular text editors to help automate parts of your workflow.

## Sublime Text

* [Hugofy](https://github.com/akmittal/Hugofy). Hugofy is a plugin for Sublime Text 3 to make life easier to use Hugo static site generator.

## Visual Studio Code

* [Hugofy](https://marketplace.visualstudio.com/items?itemName=akmittal.hugofy). Hugofy is a plugin for Visual Studio Code to "make life easier" when developing with Hugo. The source code can be found [here](https://github.com/akmittal/hugofy-vscode).

## Emacs

* [emacs-easy-hugo](https://github.com/masasam/emacs-easy-hugo). Emacs major mode for managing hugo blogs. Note that Hugo also supports [Org-mode][formats].
* [ox-hugo.el](https://ox-hugo.scripter.co). Native Org-mode exporter that exports to Blackfriday Markdown with Hugo front-matter. `ox-hugo` supports two common Org blogging flows --- exporting multiple Org sub-trees in a single file to multiple Hugo posts, and exporting a single Org file to a single Hugo post. It also leverages the Org tag and property inheritance features. See [*Why ox-hugo?*](https://ox-hugo.scripter.co/doc/why-ox-hugo/) for more.

## Vim

* [Vim Hugo Helper](https://github.com/robertbasic/vim-hugo-helper). A small Vim plugin to help me with writing posts with Hugo.

## Atom

* [Hugofy](https://atom.io/packages/hugofy). A Hugo Static Website Generator package for Atom.
* [language-hugo](https://atom.io/packages/language-hugo). Adds syntax highlighting to Hugo files.

[formats]: /content-management/formats/
