/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.osjava.jardiff.DOMDiffHandler;
import org.osjava.jardiff.JarDiff;
import org.osjava.jardiff.SimpleDiffCriteria;

public class Main {
    private static final Set FORMATS = new HashSet();
    static /* synthetic */ Class class$org$osjava$jardiff$JarDiff;

    private Main() {
    }

    private static void showHelp(Options options, String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("JarDiff -f <from jar> -t <to jar> [-F <from name>] [-T <to name>] [[-o <xml|html|xhtml|text>]|[-x <xsl file>]] [-O <file>] [-s <href>] [-fa <href>] [-ta <href>]", options);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        try {
            void var6_9;
            Transformer ot;
            Options options = new Options();
            Option tmp = new Option("f", "from", true, "from jar file");
            options.addOption(tmp);
            tmp = new Option("t", "to", true, "to jar file");
            options.addOption(tmp);
            tmp = new Option("F", "from-name", true, "from name");
            options.addOption(tmp);
            tmp = new Option("T", "to-name", true, "to name");
            options.addOption(tmp);
            tmp = new Option("o", "output-format", true, "output format, xml or html");
            options.addOption(tmp);
            tmp = new Option("O", "out", true, "output file");
            options.addOption(tmp);
            tmp = new Option("h", "help", false, "print help on command line arguments");
            options.addOption(tmp);
            tmp = new Option("x", "xsl", true, "custom xsl sheet to format output with");
            options.addOption(tmp);
            tmp = new Option("s", "stylesheet", true, "stylesheet to link to when generating html");
            options.addOption(tmp);
            tmp = new Option("fa", "from-api", true, "relative location of from api");
            options.addOption(tmp);
            tmp = new Option("ta", "to-api", true, "relative location of to api");
            options.addOption(tmp);
            GnuParser parser = new GnuParser();
            CommandLine cli = null;
            try {
                cli = parser.parse(options, args);
            }
            catch (ParseException pe) {
                Main.showHelp(options, pe.getMessage());
                return;
            }
            args = cli.getArgs();
            if (cli.hasOption('h')) {
                Main.showHelp(options, null);
                return;
            }
            if (args.length > 0) {
                Main.showHelp(options, "Additional arguments specified");
                return;
            }
            if (!cli.hasOption('f')) {
                Main.showHelp(options, "Missing required argument: -f");
                return;
            }
            if (!cli.hasOption('t')) {
                Main.showHelp(options, "Missing required argument: -t");
                return;
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setErrorListener(new ErrorListener(){

                public void warning(TransformerException te) {
                    System.err.println("xslt warning: " + te.getMessageAndLocation());
                }

                public void error(TransformerException te) {
                    System.err.println("xslt error: " + te.getMessageAndLocation());
                }

                public void fatalError(TransformerException te) {
                    System.err.println("xslt fatal error: " + te.getMessageAndLocation());
                }
            });
            if (cli.hasOption('o')) {
                if (cli.hasOption('x')) {
                    Main.showHelp(options, "Cannot use both -x and -o");
                    return;
                }
                String val = cli.getOptionValue('o');
                if ("xml".equals(val)) {
                    ot = tf.newTransformer();
                } else {
                    if (!FORMATS.contains(val)) {
                        Main.showHelp(options, "Invalid output format: " + val);
                        return;
                    }
                    URL url = (class$org$osjava$jardiff$JarDiff == null ? (class$org$osjava$jardiff$JarDiff = Main.class$("org.osjava.jardiff.JarDiff")) : class$org$osjava$jardiff$JarDiff).getClassLoader().getResource("style/jardiff-" + val + ".xsl");
                    ot = tf.newTransformer(new StreamSource(url.toString()));
                }
            } else if (cli.hasOption('x')) {
                File xsl = new File(cli.getOptionValue('x'));
                ot = tf.newTransformer(new StreamSource(xsl));
            } else {
                ot = tf.newTransformer();
            }
            if (cli.hasOption("s")) {
                var6_9.setParameter("stylesheet", cli.getOptionValue("s"));
            }
            if (cli.hasOption("fa")) {
                var6_9.setParameter("from-api", cli.getOptionValue("fa"));
            }
            if (cli.hasOption("ta")) {
                var6_9.setParameter("to-api", cli.getOptionValue("ta"));
            }
            OutputStream out = cli.hasOption('O') ? new FileOutputStream(cli.getOptionValue('O')) : System.out;
            JarDiff jd = new JarDiff();
            File oldFile = new File(cli.getOptionValue('f'));
            File newFile = new File(cli.getOptionValue('t'));
            if (cli.hasOption('F')) {
                jd.setOldVersion(cli.getOptionValue('F'));
            } else {
                jd.setOldVersion(oldFile.getName());
            }
            if (cli.hasOption('T')) {
                jd.setNewVersion(cli.getOptionValue('T'));
            } else {
                jd.setNewVersion(newFile.getName());
            }
            jd.loadOldClasses(oldFile);
            jd.loadNewClasses(newFile);
            jd.diff(new DOMDiffHandler((Transformer)var6_9, new StreamResult(out)), new SimpleDiffCriteria());
            out.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FORMATS.add("html");
        FORMATS.add("xhtml");
        FORMATS.add("text");
    }
}

