# ChangeLog

## 1.0.12 - 2015-10-27

 - Release 1.0.12

 - Fix log10 expected test result

 - Print correct number of digits testing ulps

 - Fix quantize test inputs

 - Remove a workaround from make-release.sh

 - Minor fixes to make-release.sh

 - Ensure hardware dfp is disabled with sw only

 - Fix configure when --with-cpu not supplied

 - Fix edge case with strtod*

 - libdfp: powerpc: Simplify _Decimal128 implementation

 - libdfp: powerpc: Fix fabsd128 implementation

 - Update the list of contributors

 - Harden check for the sign bit in the tests

 - Fix the usage of mfcr extended mnemonic

## 1.0.11 - 2015-07-13

 - Release 1.0.11

 - Install ChangeLog.md

 - Fix handle of tags in generate-changelog.sh

 - Add a bootstrap script and fix warnings

 - Add release script

 - Add ChangeLog generator script

 - Add a printf test for 2 variables

 - Honor value passed through --docdir

 - Move system header inclusion

 - Automatically detect hardware DFP support

 - Do not clobber configure output

 - Stop using ldconfig to create symbolic links

 - Ignore automatically generated files

 - Cleanup all files after running 'make clean'

 - Add removing of libdfp-test-ulps.h

 - Adding support for LDFLAGS passed from env

 - Allow building from the source code directory

 - Fix cross compilation

## 1.0.10 - 2015-03-04

 - libdfp: Update version for 1.0.10 release.

 - libdfp: Update copyright dates with scripts/update-copyrights.

 - libdecnumber: Fixed initialization of int 128 bits.

 - libdfp: Added more tests to the test-bfp-conversion.

 - libdfp: Fixed the conversion from float to Decimal32 in x86.

 - libdfp: truncdddf fixed

 - libdfp: Add missing ChangeLog

 - libdfp: Add missing ChangeLog

 - libdfp: Add missing ChangeLog

 - libdfp: Add missing ChangeLog

 - libdfp: Add missing ChangeLog

 - libdfp: Add missing ChangeLog

 - libdfp: x86 support added to test-bfp-conversions.

 - libdfp: Added definitions for the number of digits in strings.

 - libdfp: Disable C++ tests if compiler does not support it

 - libdecnumber: Fix warning due braced-groups within expressions

 - libdfp: Fix __SIZEOF_INT128__ dependency

 - libdfp: Clean configure.ac from GLIBC support

 - libdfp: Enable BID for 32bits

 - libdecnumber: Fix decDebug64 extension

 - bdfp: Fix setexpd[32|64|128] for x86/BID.

 - libdfp: Fix NaN1/mask definition for LE/DPD

 - libdfp: Fix test internal buffer size

 - libdfp: Add not equal to BID hack alias

 - Function left_justify fixed for x86/BID.

 - libdecnumber: Fix potentially out of the bound array access

 - libdfp: Function left_justify fixed for PPC/DPD.

 - libdfp: Always link tests with libdfp

 - libdp: Update documentation

 - libdfp: Add weak_alias assembler definition

 - libdfp: Fixes for BID left_justify

 - libdfp: Makefile.in flags

 - libdfp: Fix DPD symbol hacks to PLT calls

 - libdfp: Add BID symbol-hacks to avoid PLT calls

 - libdfp: base-math symbol hidden_def

 - libdfp: removing uneeded BID implementation

 - libdfp: add -shared-libgcc

 - libdfp: base ABI list for BID encoding

 - libdfp: Add software expected ULPs

 - libdfp: implement decode.c for BID encoding

 - libdfp: Implement sysdeps/soft-dfp/bid/numdigits.h

 - libdfp: Remove empty decode.c file

 - libdecnumber: bid-coeffbits optimization

 - libdfp: test-decode cleanup

 - libdfp: test_justify cleanup

 - libdfp: Remove GDB testcase hacks

 - libdfp: islessd[32|64|128] cleanup

 - libdfp: islessequald[32|64|128] cleanup

 - libdfp: isgreaterequald[32|64|128] cleanup

 - libdfp: isgreaterd32 cleanup

 - libdfp: islessgreaterd[32|64|128] cleanup

 - libdecnumber: Fix BID encoding for large coefficients

 - libdfp: logbd[32|64|128] cleanup

 - libdfp: test-numdigits cleanup

 - libdfp: Add test-setexp

 - libdfp: Add more tests for getexp

 - libdecnumber: Add initial BID support for _Decimal128

 - libdfp: quantumd[32|64|128] refactor

 - libdecnumber: Add initial BID support for _Decimal32

 - libdfp: Remove duplicated function call in truncd

 - libdecnumber: Add initial BID support for _Decimal64

 - libdecnumber: Move common debug directive to common header

 - libdecnumber: Move common definition under DPD

 - libdfp: Use libdecnumber compare on ilogbd

 - libdfp: libdecnumber symbol name cleanup

 - libdfp: decContextSymbols names cleanup

 - libcecnumber: decNumberSymbols.h name cleanup

 - libdecnumber: Cleanup symbol names

 - libdpf: Fix sign compare compiler warning

 - libdfp: Fix symbol-hacks paths for BID and DPD

 - libdfp: _get_digits for BID decoding developed

 - libdfp: Test get digits improved.

 - libdfp: Initial BID support

 - libdfp: Fix quantize decimal128 inputs

 - libdfp: Add islessequal testcase.

 - libdfp: Add isless testcase.

 - libdfp: Add isgreaterequal testcase.

 - libdfp: Add isgreater testcase.

 - libdfp: Inputs added to the quantized tests.

 - PowerPC: quantized[32|64|128] refactor.

 - libdfp: Fix ChangeLog dates

 - libdfp: Correct expected output for quantize tests

 - PowerPC: refactor numdigits

 - libdfp: Rewrite fpclassify to use libdecnumber

 - libdfp: Add local PLT calls check

 - libdfp: Fix missing __dpd_trunctdsd2 software DFP

 - libdfp: Add check-abi test

 - libdfp: Move soft-dfp code to soft-dfp folder

 - libdfp: Move common code to generic place

 - PowerPC: Optimized copysign implementation

 - libdfp: Add copysign test using the new framework

 - libdfp: Fix powerpc/fpu ULPs

 - libdfp: Fix powerpc/dfpu ULPs

 - libdfp: Add dfpu in front of fpu in sysdeps selection

 - PowerPC: Optimized fabsd[32|64|128]

 - libdfp: Add fabs test using new framework

 - libdfp: Add log1p test using the new framework

 - libdfp: Add log10 test using the new framework

 - libdfp: Adapt exp to new test framework

 - libdfp: Add support to ULPs file in new test framework

 - libdfp: Remove compiler warning when including scaffold.c

 - libdfp: Remove unused constant from test-numdigit

 - libdfp: Fix test-getexp constant

 - libdfp: Format test-decode indentation

 - libdfp: Name change for test-round.c

 - libdfp: Remove unnecessary tests

 - libdfp: Adapt quantize test to new framework

 - libdfp: Adapt fpclassify to new test framework

 - libdpf: Adapt rounding tests to new framework

 - libdfp: Adapt quantum test to new test framework

 - libdfp: Adapt ilogb/llogb tests to new framework

 - libdfp: Adapt issignaling test to new test framework

 - libdfp: Adapt isnan/isinf/isfinite to new test framework

 - libdfp: Adapt llquantexp test to new framework

 - libdfp: Adapt logb test to new framework

 - libdfp: Adapt samequantum test to new framework

 - libdfp: New framework for tests

 - libdfp: Add HUGE_VAL_D32 and HUGE_VAL_D128

 - libdfp: Add entry point for shared-libraries

 - libdfp: Add fpclassifyd[32|64|128] prototypes

 - libdfp: Add FP_LLOGB0 and FP_LLOGBNAN return codes

 - libdfp: Fix logbd[32|64]128] return for negative infinity

 - libdpf: Remove legacy Makefile support for GLIBC

 - libdfp: Fix NOT_in_libdfp for cxx tests

 - PowerPC: Fix issignaling issue with zero values

 - PowerPC: POWER8 build fixes

 - PowerPC: Fix powerpc32 build

 - libdfp: Define DEC_NAN as __builtin_nan

 - libdfp: Fix configure with compiler plus flags

 - libdfp: Regenerate using autoconf 2.68

 - libdfp: Fix PLT issues with Decima convertion symbols

 - libdfp: Define __decNumber functions as hidden_proto

 - PowerPC: More PLT calls fixes

 - libdfp: More PLT calls fixes

 - libdfp: Add hidden_def for signbitd

 - libdfp: Add hidden_def for fabsd[32|64|128]

## 1.0.9-1 - 2014-02-25

 - libdfp: Add fpclassifyd[32|64|128] prototypes

 - PowerPC: Fix issignaling issue with zero values

 - PowerPC: POWER8 build fixes

 - libdfp: Fix configure with compiler plus flags

## 1.0.9 - 2014-02-12

 - libdfp: Change project maintainer

 - libdfp: Add NEWS file

 - libdfp: Fix PLT calls for FP classify functions.

 - PowerPC: Remove ununsed files

 - libdfp: Add hidden definitions to FP classify functions

 - PowerPC: Fix samequantum software implementation

 - PowerPC: Optimized samequantum implementation

 - libdfp: Fix test-logb

 - PowerPC: optimized llquantexpd[32|64|128]

 - libdfp: Add llquantexpd[32|64|128] software implementation

 - PowerPC: optimized quantumd[32|64|128] implementation

 - libdfp: Add quantumd[32|64|128] software implementation

 - libdfp: Endian fix for floating point classify

 - PowerPC: optimized roundevend[32|64|128]

 - libdfp: Add roundevend[32|64|128] implementation

 - PowerPC: optimized roundd[32|64|128]

 - PowerPC: optimized nearbyintd[32|64|128]

 - PowerPC: Optimized floord[32|64|128]

 - PowerPC: Optimized truncd[32|64|128]

 - PowerPC: Optimized ceild[32|64|128]

 - libdfp: Add rounding function tests

 - libdfp: Cleanup _IEEE_LIBDFP and _IEEE_LIBM

 - libdfp: Add llogbd[32|64|128] implementation

 - libdfp: isfinite refactor

 - libdfp: isinfd refactor

 - libdfp: Refactor generic isnand

 - libdfp: Fix test-bfp-convertion tests

 - libdfp: Sync libdecnumber with GCC

 - libdfp: New <math.h> macro named issignaling to check for a signaling NaN (sNaN).

 - libdfp: Add generic macros and functions

 - libdfp: Update version for 1.0.9 release.

 - PowerPC: Fix left_justify for Little Endian

 - PowerPC: Fix endianess issue with setexp

 - libdfp: Fix LE issues with decimal to decNumber

 - libdfp: Add more coverage for logd tests

 - libdfp: Optimize the host to/from ieee functions

 - libdfp: Fix compile warnings in tests

 - PowerPC: fix the numdigits for LE

 - PowerPC: fix endian issue when reading rounding mode

 - libdfp: Add support to POWER8

 - libdfp: Fix test-bfp-conversions segfault due recursive calls

 - libdfp: Remove compiler warnings by unused variables

 - libdfp: Fix issues with getexp when exp is DECIMAL_BIAS

 - libdfp: Fixes for isfinited

 - libdfp: Fixes for isinfd

 - libdfp: Fix endian macro check

 - PowerPC: initial support for LE build

 - Miscellaneous changes
    - Makefile.in (distclean): Add as rule to remove files generated by
      configure.

 - Miscellaneous changes
    - README.user: Added new section on compliance With ISO/IEC TR 24732,
      the C++ DFP Draft Technical Report, including instructions on how to
      use (ios::fixed | ios::scientific) as ios\_base::fmtflags in order to
      get fully encoded precision in output string representation.

 - Miscellaneous changes
    - tests/test-printf.c: Add missing 'D' to a/A conv tests.
    - tests/scaffold.c: Correct comments for \_OSC and added a/A support.
    - tests/test-ostream.cpp: Modified expectations such that a/A ignores
      precision and always uses the num of significant digits in the
      mantissa when output.
    - tests/test-ostream-g-spec.cpp: Removed unnecessary define that used
      to be used to get g/G support.
    - dfp/decimal/decimal (FIND\_DEC\_MANT\_DIG): Remove ".*" from default
      string string.
      (LIBDFP\_META): Make g/G spec default. Enable a/A spec by checking
      flags for ios::fixed | ios::scientific. Condense uppercase/lowercase
      check. Don't call printf with a precision specifier if a/A is the
      desires spec conv.

 - Miscellaneous changes
    - tests/test-negate.c: New testcase.
    - Makefile.in (libdfp\_c\_tests): Add test-negate.

 - Miscellaneous changes
    - Makefile.in (test-printf.os, test-strtod.os): New rules to depend on
      printf\_dfp.os and strtod[32|64|128].os respectively.
    - strtod128.c (\_\_DEC\_MANT\_DIG\_\_, \_\_DEC\_MAX\_EXP\_\_, \_\_DEC\_MIN\_EXP\_\_):
      Define to \_Decimal128 values.
    - tests/test-strtod.c: Added tests near \_\_DEC*\_MAX\_EXP\_\_ and
      \_\_DEC*\_MIN\_EXP\_\_.
    - strtod64.c (\_\_DEC\_MANT\_DIG\_\_, \_\_DEC\_MAX\_EXP\_\_, \_\_DEC\_MIN\_EXP\_\_):
      Define to \_Decimal64 values.
    - sysdeps/powerpc/dfpu/numdigits.h (left\_justify): Fix VSX case by
      replacing xxlxor with xxlor insn.
      (getexp): Replace stfwix with stfd to prevent erroneous sign extend.
    - sysdeps/soft-dfp/dpd/numdigits.h (getexp): Make return value
      congruent with hardware-dfp for NaN.
    - strtod32.c (\_\_DEC\_MANT\_DIG\_\_, \_\_DEC\_MAX\_EXP\_\_, \_\_DEC\_MIN\_EXP\_\_):
      Define to \_Decimal32 values.
      (FUNCTION\_L\_INTERNAL): Add left\_justify call if proposed exponent is
      sufficiently close to \_\_DEC*\_MAX\_EXP\_\_.  Add zero return if proposed
      exponent is smaller than \_\_DEC*\_MIN\_EXP\_\_.

 - Miscellaneous changes
    - Makefile.in (libdfp\_c\_tests): Added test-getexp.
    - tests/test-getexp.c: New test.
    - tests/test-decode.c (d64types): Added test for \_\_DEC64\_MAX\_\_ and
      \_\_DEC64\_MIN\_\_.
    - sysdeps/powerpc/dfpu/numdigits.h (getexpd[32|64|128]): Fixed in
      order to prevent erroneous sign extension due to using stfiwx.

 - Miscellaneous changes
    - sysdeps/powerpc/dfpu/numdigits.h: Cleaned up inline asm DEC\_TYPE
      declarations.  Removed redundant macros.  Merged macros under similar
      guards.

 - Miscellaneous changes
    - sysdeps/powerpc/dfpu/numdigits.h (numdigits*): Fix inline asm to
      place result of drrnd[q] into DEC\_TYPE instead of double.  Update
      copyright years to range.
    - tests/test-decode.c: Update copyright years to range.
    - tests/test-param.c: Likewise.
    - tests/test-printf.c: Likewise.
    - tests/test-numdigits.c: Likewise.
    - tests/test-istream.cpp: Likewise.
    - tests/test-strtod.c: Likewise.
    - sysdeps/dpd/dpd-private.c: Likewise.
    - printf\_dfp.c: Fix erroneous test for \_Decimal64.  Update copyright
      years to range.

 - Miscellaneous changes
    - Makefile.in (check): Add printf\_dfp.o dependency to check in order to
      have make check automatically rebuild libdfp is printf\_dfp.c has
      changed.
    - tests/test-decode.c: Add tests for decoding numbers with high
      exponents near \_\_DEC*\_MAX\_EXP\_\_.
    - tests/test-param.c (param\_test): Remove unnecessary assingments.
    - tests/test-printf.c: Add tests for \_\_DEC64\_MAX\_\_.
    - tests/test-numdigits.c: Add tests for \_\_DEC64\_MAX\_\_ and numbers
      approaching \_\_DEC*\_MAX\_EXP\_\_.
    - tests/test-GCC-PR52140.c (main): Remove unnecessary assignments.
    - tests/test-ostream.cpp: Formatting.
    - tests/debug-test.sh: Add ./ as a path prefix.
    - sysdeps/powerpc/dfpu/numdigits.h (numdigitsd*): Fix for numbers with
      exponent approaching \_\_DEC*\_MAX\_EXP\_\_ by biasing the exponent toward
      zero.
    - sysdeps/dpd/dpd-private.c: Formatting.
    - TODO: New items.
    - printf\_dfp.c (\_\_printf\_dfp): Fix for g/G specifier that converst to
      f/F form.  Fix for a/A when the user supplied precision is 0, i.e.
      %.Ha.

 - Miscellaneous changes
    - Makefile.in (libdfp\_c\_tests): Add test-GCC-PR52140.c.
    - tests/test-istream.cpp: Comment out NaN tests.  Two nans can't be
      compared.
    - tests/test-GCC-PR52140.c: New testcase for ICE.
    - TODO: Add item to upgrade libdecnumber version.

 - Miscellaneous changes
    - Makefile.in (install-readme): New target.
      (install): Consolidated by making install-headers and install-readme
      as dependent rules.
    - README.maintainer: Updated info on Versioning.
    - README.user: Added discussion on \_\_STDC\_DEC\_FP\_\_
    - README.developer: Updated info on Versioning.

 - Miscellaneous changes
    - sysdeps/powerpc/powerpc32/power6x/Implies: Points to power6.
    - sysdeps/powerpc/powerpc32/power6x/fpu/Implies: Points to power6.
    - sysdeps/powerpc/powerpc64/power6x/Implies: Points to power6.
    - sysdeps/powerpc/powerpc64/power6x/fpu/Implies: Points to power6.

 - Miscellaneous changes
    - Makefile.in (libdfp\_cxx\_tests): Add test-ostream-g-spec test.
    - tests/test-ostream-g-spec.cpp: New file to test decimal/decimal's
      \_LIBDFP\_G\_CONV\_SPEC guard.
    - tests/test-printf.c: Add newly discovered %DDg failures.
    - tests/scaffold.c (\_OSC\_P): Add comment regarding
      \_LIBDFP\_G\_CONV\_SPEC.
    - tests/test-istream.cpp: Removed unused variable.
    - README.user: Update with information about NOT using #include
      <dfp/*header*>.
    - dfp/float.h: Remove commented out decimal class predeclares.
    - dfp/decimal/decimal: Move #include <float.h> to before #include\_next
      <decimal/decimal> to prevent missing \_Decimal[32|64|128] definition
      errors.

 - Miscellaneous changes
    - Makefile.in (libdfp\_cxx\_tests): Added test-istream.
    - tests/scaffold.c (\_ISC \_ISC\_P): Added new istream compare macros
      conditional on #ifdef \_\_cplusplus.
    - tests/test-istream.cpp: New test for operator>>.
    - tests/test-strtod.c: Added a new value to test.
    - dfp/float.h: Correct \_Decimal[32|64|128] declarations.
    - dfp/decimal/decimal: Added operator>> support for decimal[32|64|128]
      C++ decimal floating point types.
    - README.user: Updated information on operator<< and operator>>
      support.

 - Miscellaneous changes
    - tests/test-log10d.c: Added missing #include "decode.h".
    - tests/scaffold.c (\_OSC \_OSC\_P): Added new ostream compare macros
      conditional on #ifdef \_\_cpluspluc.
    - tests/test-ostream.cpp: Added scaffold.c based tests.

 - Miscellaneous changes
    - dfp/decimal/decimal(operator<< decimal128): Removed now spurious
      call to ostream\_d128() (which has been removed from libdfp) in the
      decimal128 operator<< overload.
      Updated comments clarifying use of 'a/A' over 'g/G' for the default.

 - Miscellaneous changes
    - dfp/decimal/decimal: Added back in erroneously removed #include
      <stdio.h>.

 - Miscellaneous changes
    - dfp/decimal/decimal: Removed ostreamd32, ostreamd64, and
      ostreamd128 prototypes.

 - Miscellaneous changes
    - decode.h: Added \_\_BEGIN\_DECLS and \_\_END\_DECLS around
      decoded[32|64|128] prototypes in order to allow them to be used in C++
      compatibility testcases without warnings.
    - scaffold.c: Removed extra #include "decode.h". 
    - test-strtod.c: Likewise.

 - Miscellaneous changes
    - Makefile.in: Copied contents of $(system\_header\_dirs) into
      $(header\_dirs) in order to have -I added automatically to the compiler
      invocation.  This makes sure that dfp/decimal/decimal always comes
      before the system include/decimal/decimal header.

 - Miscellaneous changes
    - README.user: Add instructions for using <decimal/decimal> to pick up
      operator<< and operator>> overloads for decimal[32|64|128] types.
    - README.developer: Removed necessity of including -isystem in
      CPPFLAGS in order to pick up decimal headers.
    - dfp/decimal: Created dfp/decimal/ header include directory.
    - dfp/decimal.tmp: Moved decimal.tmp to decimal/decimal.
    - dfp/decimal/decimal: Moved decimal.tmp to decimal/decimal.

 - Miscellaneous changes
    - Makefile.in: Install dfp/decimal/ directory.  Add
      dfp/decimal/decimal path.
    - tests/test-ostream.cpp: Change <decimal> to <decimal/decimal>
    - TODO: Added directive to test decimal/ directory installs.
    - dfp/decimal: Moved file "decimal" to "decimal.tmp".
    - dfp/decimal.tmp: Moved file "decimal" to "decimal.tmp".

 - Miscellaneous changes
    - configure: Regenerated.
    - Makefile.in:
      (@CXX@, @LLD@, @OBDJUMP@, @GDB@, @CXXFLAGS@, and @CPPFLAGS@): New
      imports.
      (header\_dirs): Move dfp/ to $(system\_header\_dirs).
      (CXX\_DEFINES CXX\_WARNS): New variables.
      (.c.o): Add $(CPPFLAGS). Add -I$(system\_header\_dirs).
      (.c.os): Likewise
      (.S.o): Add -I$(system\_headers).
      (.cpp.os) Likewise.
      (GLIBC\_LIBS): Remove unnecessary libpthread.so linkage.
      (libdfp\_cxx\_tests): New variable.
      (libdfp\_tests): Renamed to (libdfp\_c\_tests) and replaced with
      $(libdfp\_c\_tests) $(libdp\_cxx\_tests).
      Added new rule for $(libdfp\_cxx\_tests).os dependencies on float.h.
      Added new rule for $(libdfp\_tests) to rely on tests/scaffold.c.
      Added new rule to link $(libdfp\_cxx\_tests) to their .os files.
      (.SUFFIXES): Added .cpp.
    - ieee754r/lgammad32.c: Changed <dfp/math.h> to <math.h>.
    - tests/test-printf.c: Discovered a bug in %.Ha.  If there is a '.'
      with no precision specifier it prints a bogus value.  This adds this
      failure to the test suite.
    - tests/test-ostream.cpp: New test to test operator<< header file
      additions in dfp/decimal.
    - configure.ac: Added AC\_PATH\_PROG for OBJDUMP, LDD, GDB.  Added
      AC\_SUBST for CXXFLAGS, CPPFLAGS.
    - README.user: Added instructions for printf "a,A" Conversion
      Specifier usage.
    - README.developer: Added instructions for specifying PATH to pick up
      toolchain default programs.  Added instructions for LDD, GDB, OBJDUMP,
      CXX, CXXFLAGS, and CPPLAGS.
    - Versions.def
    - Makefile.gdb: Use configure exported 'objdump' via $(OBJDUMP). Use
      configure exported 'ldd' via $(LDD).  Use configure exported 'gdb' via
      $(GDB).
    - dfp/stdlib.h: Comment update.
    - dfp/float.h: New file adds \_Decimal[32|64|128] types #ifdef
      \_\_cplusplus and if they aren't added by the compiler.  At the time of
      this writing the compiler hasn't added them to float.h yet.
    - dfp/decimal: New file adds operator<< for decimal[32|64|128] C++
      types.  This use C++ template metaprogramming to create functions that
      call printf.
    - printf\_dfp.c: Comment change for a/A spec char.
    - TODO: New item.

 - Miscellaneous changes
    - Makefile.in (libdfp\_tests): Add test-expd, testing
      expd[64|128]\(-1.0\) which was previously failing.
      (libdfp\_tests.so): New dummy rule to add
      $(top\_srcdir)/tests/scaffold.c as a dependency so that scaffold.c
      changes result in rebuilding the libdfp\_test .so files on make check.
    - tests/test-expd.c: New file testing expd[32|64|128].
    - tests/scaffold.c (\_AVC \_AVC\_P): New macros which do a value compare
      but allow a +/- variation.
    - README.user: Added instructions for C++ types compatibility with
      ISO-C DFP types.
    - sysdeps/powerpc/dfpu/expd64.c: Existing code only accounts for
      positive 'n' in e^n.  This fix allows for e^-n, which is just 1/(e^n).

 - Miscellaneous changes
    - README.user: Updated with instructions for using #include <dfp/  >.
    - sysdeps/soft-dfp/dpd/Versions: Moved \_\_dpd\_extend* and \_\_dpd\_trunc*
      symbol definitions from here to...
    - sysdeps/dpd/Versions: here, since these are needed for all versions
      of libdfp, not just the soft-dfp version.

 - Miscellaneous changes
    - Makefile.in: Replace erroneous usage of $? with $^.  Fix
      libdfp\_tests based rules to correct prerequisite usage so that a
      complete rebuild isn't required when only a few of the test case
      dependencies change.
    - Makefile.gdb: Correct prerequisite usage to not require a complete
      rebuild when only a few of the test case dependencies change.

 - Miscellaneous changes
    - dfp/stdlib.h: Added #include <features.h> to correct include order
      problem.
    - dfp/wchar.h: Likewise.
    - tests/test-stdlib.c: New test to verify <features.h> inclusion.
    - tests/test-wchar.c: New test to verify <features.h> inclusion.
    - Makefile.in (libdfp\_tests): Added test-stdlib and test-wchar.

 - Miscellaneous changes
    - configure: Regenerated.
    - configure.ac: Incremented the version number to 1.0.8.
    - Versions.def: Incremented the version number to 1.0.8.
    - tests/test-bfp-conversions.c: Added tests for extendsddf extendsdtf
      extenddfdd extendddtf extenddftd and extendtftd.

 - Miscellaneous changes
    - base-math/Makefile: Moved 'classify' from sysdeps/soft-dfp/Makefile.
    - base-math/classify.c: Moved from sysdeps/soft-dfp/ because it's
      required for the power6 build as well.
    - base-math/extendsftd.c: Likewise.
    - base-math/extendsdtf.c: Likewise.
    - base-math/extenddfdd.c: Likewise.
    - base-math/trunctdsf.c: Likewise.
    - base-math/trunctfsd.c: Likewise.
    - base-math/extendddtf.c: Likewise.
    - base-math/extenddftd.c: Likewise.
    - base-math/extendsfsd.c: Likewise.
    - base-math/extendtftd.c: Likewise.
    - base-math/truncdddf.c: Likewise.
    - base-math/trunctfdd.c: Likewise.
    - base-math/trunctddf.c: Likewise.
    - base-math/truncsdsf.c: Likewise.
    - base-math/trunctdtf.c: Likewise.
    - base-math/extendsddf.c: Likewise.
    - base-math/extendsfdd.c: Likewise.
    - base-math/truncddsf.c: Likewise.
    - base-math/truncdfsd.c: Likewise.
    - tests/scaffold.c (\_VC\_P): Updated spacing in "Expected" and "Result"
      output.
    - tests/test-bfp-conversions.c: Added float -> \_Decimal128 tests.
    - sysdeps/soft-dfp/Makefile: Moved 'classify' to base-math/Makefile.
    - sysdeps/soft-dfp/classify.c: Moved to base-math/ because it's
      required for the power6 build as well.
    - sysdeps/soft-dfp/extendsftd.c: Likewise.
    - sysdeps/soft-dfp/extendsdtf.c: Likewise.
    - sysdeps/soft-dfp/extenddfdd.c: Likewise.
    - sysdeps/soft-dfp/trunctfsd.c: Likewise.
    - sysdeps/soft-dfp/trunctdsf.c: Likewise.
    - sysdeps/soft-dfp/extenddftd.c: Likewise.
    - sysdeps/soft-dfp/extendddtf.c: Likewise.
    - sysdeps/soft-dfp/extendsfsd.c: Likewise.
    - sysdeps/soft-dfp/extendtftd.c: Likewise.
    - sysdeps/soft-dfp/truncdddf.c: Likewise.
    - sysdeps/soft-dfp/trunctfdd.c: Likewise.
    - sysdeps/soft-dfp/trunctddf.c: Likewise.
    - sysdeps/soft-dfp/truncsdsf.c: Likewise.
    - sysdeps/soft-dfp/trunctdtf.c: Likewise.
    - sysdeps/soft-dfp/extendsfdd.c: Likewise.
    - sysdeps/soft-dfp/extendsddf.c: Likewise.
    - sysdeps/soft-dfp/truncddsf.c: Likewise.
    - sysdeps/soft-dfp/truncdfsd.c: Likewise.

 - Miscellaneous changes
    - Makefile.in (libdfp\_tests): Added test-bfp-conversions.
    - base-math/Makefile (libdfp\_files): Moved extendsfsd extendsddf
      extendsdtf extendsfdd extenddfdd extendddtf extendsftd extenddftd
      extendtftd truncsdsf truncdfsd trunctfsd truncddsf truncdddf
      trunctfdd trunctdsf trunctddf trunctdtf from sysdeps/soft-dfp/Makefile
      since they're required in all builds.
    - tests/test-bfp-conversions.c: New file to test bfp -> dfp and dfp ->
      bfp conversions.
    - include/convert.h: Moved from sysdeps/soft-dfp/ in preparation for
      moving extend and trunc bfp->dfp and dfp->bfp conversion functions.
    - sysdeps/soft-dfp/Makefile (libdfp\_files): Removed extendsfsd
      extendsddf extendsdtf extendsfdd extenddfdd extendddtf extendsftd
      extenddftd extendtftd truncsdsf truncdfsd trunctfsd truncddsf
      truncdddf trunctfdd trunctdsf trunctddf trunctdtf and moved to
      base-math/Makefile since they're required in all builds.
    - sysdeps/soft-dfp/extendsfsd.c: Replaced magic number '24' with
      \_\_FLT\_MANT\_DIG\_\_.
    - sysdeps/soft-dfp/convert.h: Moved to include/convert.h.
    - sysdeps/soft-dfp/truncdfsd.c: Replaced magic number '53' with
      \_\_DBL\_MANT\_DIG\_\_.

 - Miscellaneous changes
    - tests/gdb\_start\_address.py: New file which provides the
      start\_address() python convenience function to GDB.
    - Makefile.gdb (*.gdb): Break on \_dl\_start\_user for powerpc64 and
      \_dl\_main\_dispatch on powerpc32.  Call new python convenience function
      start\_address() to get the start address of libc and libdfp for the
      scripts.

 - Miscellaneous changes
    - sysdeps/powerpc/powerpc32/power6/fpu/Makefile (ASFLAGS): Remove
      HAVE\_ASM\_PPC\_REL16 as it is no longer needed since we no longer
      support building the power[6|7] optimized libdfp with -mbss-plt.
    - sysdeps/powerpc/powerpc32/power6/fpu/floatunsdisd.S: Remove
      HAVE\_ASM\_PPC\_REL16 guard and remove the bss-plt form of GOT access.
      We no longer support building the power[6|7] optimized libdfp with
      -mbss-plt.
    - sysdeps/powerpc/powerpc32/power6/fpu/fixunssddi.S: Likewise.
    - sysdeps/powerpc/powerpc32/power6/fpu/fixunsdddi.S: Likewise.
    - sysdeps/powerpc/powerpc32/power6/fpu/fixunstddi.S: Likewise.
    - sysdeps/powerpc/powerpc32/power6/fpu/floatunsdidd.S: Likewise.
    - sysdeps/powerpc/powerpc32/power6/fpu/floatunsditd.S: Likewise.

 - Miscellaneous changes
    - configure: Regenerated.

 - Miscellaneous changes
    - Makefile.in: Added $(CFLAGS) to .S.o: rules.
    - configure.ac: Added -DSHARED to picflag in order to enforce PIC when
      compiling hand rolled asm functions.
    - sysdeps/powerpc/powerpc32/power6/fpu/Makefile: Added
      -DHAVE\_ASM\_PPC\_REL16 to ASFLAGS in order to enforce secure-plt
      style GOT access.

 - Miscellaneous changes
    - sysdeps/s390/dfpu/fe\_decround.c (\_\_init\_printf\_dfp\_getround): Added
      function definition for callback and added callback pointer.  The
      printf\_dfp () function was graciously skipping over the rounding mode
      modifiers due to this missing definition.
    - README.developer: Updated compatibility matrix to put x86 and x86\_64
      under TODO.  Changed all instances of at05 to at4.0.

 - Miscellaneous changes
    - fe\_decround.c (\_\_init\_printf\_dfp\_getround): Remove unnecessary
      prototype and declare constructor 'static.  Remove unnecessary
      hidden\_def(\_\_init\_printf\_dfp\_getround).
    - sysdeps/powerpc/dfpu/fe\_decround.c (\_\_init\_printf\_dfp\_getround):
      Remove unnecessary prototype and declare constructor 'static.  Remove
      unnecessary hidden\_def(\_\_init\_printf\_dfp\_getround).
    - sysdeps/s390/dfpu/fe\_decround.c: Added <dfpfenv\_private.h>
    - printf\_dfp.c: Add hidden\_def (\_\_register\_printf\_dfp).
    - include/libdfp-symbols.h (hidden\_def): Fix macro definition.

 - Miscellaneous changes
    - printf\_dfp.c (\_\_printf\_dfp): Finished cleaning up 'decimal'.
    - sysdeps/powerpc/sysdep.h: Updated copyright year.

 - Miscellaneous changes
    - README.maintainer: Updated.
    - sysdeps/powerpc/powerpc32/power6/fpu/fixunstdsi.S (END): Fix
      erroneous \_\_dpd\_fixunstssi to \_\_dpd\_fixunstdsi.
    - sysdeps/powerpc/powerpc32/sysdep.h (PROF): Removed PROF macros.
      (CALL\_MCOUNT): Removed CALL\_MCOUNT.
      (ENTRY): Removed CALL\_MCOUNT and C\_SYMBOL\_NAME from macro body.
      Replaced C\_LABEL with LABEL.
      (C\_TEXT): Removed macro as unnecessary.
    - sysdeps/powerpc/sysdep.h (C\_LABEL): Removed macro.
    - include/libdfp-symbols.h (LABEL): New macro which replaces C\_LABEL
      by removing preceding underscore.
    - printf\_dfp.c (\_\_dfp\_ais): Return -1 if info->user doesn't match any of
      the DFP mod\_[H|D|DD] identifiers.
      (\_\_printf\_dfp): Started cleaning up 'decimal' per Jakub Jelinek's
      suggestion.  Fixed bug found by Jakub Jelinek where random garbage is
      printed if the modifier is not H/D/DD.  The default was dropping into
      the \_Decimal32 case when it should have been returning -2.

 - Miscellaneous changes
    - README.maintainer: Added todo for "Commit Access"

 - Miscellaneous changes
    - README.maintainer: New file.
    - README.developer: Added several TODO items.
    - TODO: Added an item.
    - CONTRIBUTORS: Moved DCO from here to...
    - CONTRIBUTING: here.
   2011-1-21  Ryan S. Arnold  <rsa@us.ibm.com>
    - configure: Regenerated.
    - configure.ac: Incremented the version number to 1.0.7.
    - Versions.def: Incremented the version number to 1.0.7.
   2011-1-21  Andreas Krebbel  <Andreas.Krebbel@de.ibm.com>
    - sysdeps/s390/dfpu/numdigits.h (setexp): Bias the exponent and return
      '1' for z zero mantissa, which is what is done for soft-dfp.
    - sysdeps/s390/dfpu/fe\_decround.c (\_\_fe\_dec\_setround): Enable extended
      rounding modes (5,6 and 7) which are not covered by the standard.
   2011-1-18  Ryan S. Arnold  <rsa@us.ibm.com>
    - configure: Regenerated.
    - tests/test-isfinite.c: Changed expectation on isfinite() for
      negative numbers on Power5 to '1'.  Power6 (hardware isfinite) returns
      '-1' on isfinite.  The spec simply says that non-zero means finite.
    - tests/test-logd.c: Removed half completed 'quantize compare'
      functionality which was throwing a false error.
    - tests/test-decode.c: Removed dangling printf that wasn't useful.
    - tests/test-printf.c: Added a \_Decimal128 test for printing (1.0DL /
      1.000000e-123DL) which has a sufficiently negative exponent that it
      forced the 'index' (rounding digit) position to be negative and caused
      a segv when \_\_printf\_dfp() tried to erroneously round the result on
      s390.  We got lucky up until now on PowerPC due to the kernel
      reserving space on the top of the stack.
    - configure.ac: Incremented the version number to 1.0.6.
    - Versions.def: Incremented the version number to 1.0.6.
   2011-1-18  Andreas Krebbel  <Andreas.Krebbel@de.ibm.com>
    - printf\_dfp.c (\_\_printf\_dfp): Fixed segv where, if the exponent is
      sufficiently negative it pushes 'index' (the digit used to round
      values to the left) into a negative number.  In that case we simply
      don't need to round at all.
   2011-1-18  Ryan S. Arnold  <rsa@us.ibm.com>
    - tests/test-strtod.c: Adjusted assumptions of tests from truncation
      on too long of an input to rounding to nearest.
   2011-1-18  Andreas Krebbel  <Andreas.Krebbel@de.ibm.com>
    - strtod32.c (FUNCTION\_L\_INTERNAL): Check an extra digit on the input
      to see if we need to round rather than truncate.
   2011-1-17  Ryan S. Arnold  <rsa@us.ibm.com>
    - configure: Regenerated.
    - tests/test-strtod.c: Removed unnecessary test cases.
    - configure.ac: Incremented the version number to 1.0.5.
    - Versions.def: Incremented the version number to 1.0.5.

 - Miscellaneous changes
    - Makefile.in (libdfp\_tests): Added test-log10d.
    - tests/test-decode.c: Added decode of log10d128(0.0000000011DL) to
      verify that it prints correctly in declets.
    - tests/test-logd.c (main): Added pbuf[CHAR\_MAX] so that tests work
      properly.
    - tests/test-log10d.c: New test-case which verifies that printf now
      works properly for the result of log10d128(0.0000000011DL).
    - sysdeps/dpd/dpd-private.c: Fixed dpd\_to\_char[0x3f4] from "974" to
      "774" since the previous was a typo which was making values print
      incorrectly.

 - Miscellaneous changes
    - configure: Regenerated.
    - configure.ac: Removed addition of -fPIC to CFLAGS and instead export
      it to Makefile.in who is now responsible for adding it to CFLAGS.  Set
      (picflags): Default to -fpic since the GOT for libdfp should be small
      enough that -fPIC isn't needed.
    - Makefile.in: (BACKEND\_CFLAGS): New variable which passes -mcpu=foo
      and -fpic to the backend sub make invocation in -DEFS to get around
      the fact that libdecnumber/Makefile.in won't allow overridden CFLAGS.
    - sysdeps/dpd/dpd-private.c: Fixed 'used when uninitialized' warning
      by switching "else if" case to "else" for Decimal128.

 - Miscellaneous changes
    - strtod32.c: Fix precedence of arithmetic operation.
    - tests/test-strtod.c: Add new testcase and fix wrong tests.

 - Miscellaneous changes
    - configure: Regenerated.
    - configure.ac: Incremented the version number to 1.0.4
    - README.user: Marked empty sections with (TODO).
    - Versions.def: Incremented the version number to 1.0.4

 - Miscellaneous changes
    - README.user: Added clarification of how to include dfp/stdlib.h,
      dfp/fenv.h and dfp/wchar.h.

 - Miscellaneous changes
    - README.user: Added clarification of how to include dfp/math.h.

 - Miscellaneous changes
    - dfp/math.h: Move #include\_next <math.h> so that if the compiler
      invocation has -I/<path>/include/dfp/ but doesn't define
      \_\_STDC\_WANT\_DEC\_FP\_\_ that they still get the system math.h.

 - Miscellaneous changes
    - CONTRIBUTORS: Added Luis Machado.  Added DCO requirements.

 - Miscellaneous changes
    - strtod32.c (FUNCTION\_L\_INTERNAL): Fix comparison operator.

 - Miscellaneous changes
    - sysdeps/s390/dfpu/numdigits.h: Remove include guards.
    - sysdeps/powerpc/dfpu/numdigits.h: Likewise.
    - sysdeps/soft-dfp/dpd/numdigits.h: Likewise.

 - Miscellaneous changes
    - tests/test-printf.c (printf\_d128s): Added 0.9999999999DL which
      reported 0.100000 rather than 1.000000 and was fixed by Andreas'
      patch from 2010-10-04.

 - Miscellaneous changes
    - printf\_dfp.c (\_\_printf\_dfp): Fix up nd when rounding overflows
      beyond first digit.

 - Miscellaneous changes
    - sysdeps/soft-dfp/floatsisd.c: Don't generate additional decimal
      digit.

 - Miscellaneous changes
    - README.developer: Documentation update.
    - TODO: Mark some items as [DONE].

 - Miscellaneous changes
    - init\_dfp.c: Changed #include <dfp/dfp.h> to #include <dfp.h>.

 - Miscellaneous changes
    - tests/test-amort.c: Added license and copyright.
    - tests/test-printf.c: Updated copyright year.
    - tests/test-strtod.c: Added license and copyright.  Corrected
      incorrect expected values.
    - strtod32.c: Fixed several conversion bugs.

 - Miscellaneous changes
    - Makefile.in: Removed test-left\_justify from execution since it is a
      known failure case for non-power6 systems.  No worries since
      left\_justify isn't used right now.
    - tests/test-amort.c: Removed spurious #include <dfp.h>.
    - tests/test-get\_digits.c: Likewise.
    - tests/test-decode.c: Likewise.
    - tests/test-quantize.c: Likewise.
    - tests/test-printf.c: Likewise.
    - tests/test-fpclassify.c: Likewise.
    - tests/test-numdigits.c: Likewise.
    - tests/test-left\_justify.c: Likewise.
    - tests/test-isinf.c: Likewise.
    - tests/test-isnan.c: Likewise.
    - tests/test-isfinite.c: Likewise.
    - tests/test-strtod.c: Likewise.  Also changed one value compare test
      to a decode test since the visual representation was 0.0.
    - README.user: Added further user notes.
    - dfp/dfp.h: Moved this to ...
    - include/dfp.h: here since the user no longer has to call the
      printf\_dfp registration hooks, and thus doens't need the prototype.
       configure: Regenerated.
       configure.ac: Added AC\_SUBST(mzarch) back.  We shouldn't be editing
       CFLAGS.
       Makefile.in: Pass $(mzarch) along with CFLAGS if it is defined.

 - Miscellaneous changes
    - configure: Regenerated.
    - Makefile.in: Added special sed script which changes
      libdecnumber/Makefile:CFLAGS = foo into CFLAGS ?= foo.  This allows
      libdfp/Makefile's sub make invocation of libdecnumber/Makefile to
      accept the updated CFLAGS.  This was necessary to allow configure to
      update CFLAGS with -mzarch for s390 z9-ec and z10.  GCC should fix
      this in their version of libdecnumber.
    - configure.ac: -mzarch added to CFLAGS when s390 system is z9-ec or
      z10.
    - README.developer: Added indication that configure.ac sets -mzarch in
      CFLAGS when appropriate.

 - Miscellaneous changes
    - Makefile.gdb (libdfp\_tests.gdb): Add
      LD\_LIBRARY\_PATH=./:$LD\_LIBRARY\_PATH to ldd invocations to make sure
      it reports ./libdfp.so.1 as a dependency and not the system or
      toolchain libdfp.so.1.

 - Miscellaneous changes
    - ieee754r/Versions: Added \_\_fabsd* and \_\_fpclassifyd* under the
      correct libdfp version number 1.0.3.

 - Miscellaneous changes
    - dfp/math.h: Restructure to cleanup presentation.

 - Miscellaneous changes
    - ieee754r/Versions: Moved some of the \_\_is* functions under LIBDFP\_1.0.2
      and LIBDFP\_1.0.3.  Removed unnecessary \_\_is* functions from export
      that don't have polymorphic versions in math.h
    - dfp/math.h: Removed accidental undef of isunordered.  This was
      never implemented as a polymorphic function because it doesn't need to
      be (per the spec).  Removed redundant polymoprhic isnan().
    - Versions.def: Added Versions LIBDFP\_1.0.2 and LIBDFP\_1.0.3 for Libdfp.

 - Miscellaneous changes
    - configure: Regenerated.
    - configure.ac: Apparently AC\_CANONICAL\_SYSTEM is only for compilers.
      I removed it, and support for --target.  Now you must use --build
      only.
    - README.developer: Removed directions for using --target.

 - Miscellaneous changes
    - sysdeps/powerpc/dfpu/fe\_decround.c (stdio.h): Removed unnecessary
      include.

 - Miscellaneous changes
    - sysdeps/powerpc/dfpu/fe\_decround.c (\_\_fe\_dec\_getround): The
      structure which defined the DRN was to small and the compiler started
      generating code that wasn't properly extracting the DRN field from the
      structure holding the FPSCR value.  This is fixed.
    - tests/test-round.c: Testcase to prove fe\_dec\_getround() and
      fe\_dec\_setround().
    - Makefile.in (libdfp\_tests): Added test-round.

 - Miscellaneous changes
    - configure: Regenerated.
    - config.log: Removed as unnecessary.
    - configure.ac: --target now works in lieu of --build.  --host is no
      longer necessary.
    - README.developer: Removed directive to use --host and replaced with a
      diective to use --target.

 - Miscellaneous changes
    - configure: Regenerated file.
    - Makefile.in: Removed last comments dealing with -mzarch.
    - configure.ac: Removed last fragments dealing with -mzarch.

 - Miscellaneous changes
    - ieee754r/isinfd32.c: Removed unnecessary static char buffer used for
      testing.

 - Miscellaneous changes
    - ieee754r/isinfd32.c: Removed test-code that shouldn't have been
      checked in.

 - Miscellaneous changes
    - ieee754r/isinfd32.c (isinf): Changed Infinity check such that
      DEC\_NAN doesn't pass as inf.  There was an incorrect mask check which
      was true for DEC\_NAN as well as Inf.
    - tests/test-isfinite.c: Added Conditional expectations for s390 for
      isfinite return values from negative number inputs.

 - Miscellaneous changes
    - tests/test-logd.c: Removed unnecessary comments.
    - tests/test-fpclassify.c: Removed unnecessary comments.
    - configure.ac: Removed unnecessary comments.
    - printf\_dfp.c: Removed unnecessary comments.

 - Miscellaneous changes
    - Makefile.in: Removed commented out code.
    - tests/test-logd.c: Corrected expected values for a \_Decimal64 NAN
      declet series.
    - tests/test-fpclassify.c: Added cases for + and -
      \_\_DEC[32|64|128]\_SUBNORMAL\_MIN\_\_.
    - tests/scaffold.c: Modified spacing in macro output for 'Success'.
    - tests/test-isfinite.c: Corrected expected values for negative
      numbers to return -1.  Corrected expected value for DEC\_NAN to '0'.
    - tests/test-strtod.c: Cleaned up.  Still failing.
    - sysdeps/powerpc/dfpu/fpclassifyd32.c (fpclassifyd32): Since
      \_Decimal32 is promoted to \_Decimal64 and \_\_DEC32\_SUBNORMAL\_MIN\_\_ falls
      within the bounds of \_Decimal64 a special case to range check for
      \_Decimal32 as required.
    - sysdeps/powerpc/dfpu/powd64.c: Whitespace correction.
    - strtod32.c: Started to cleanup the code.

 - Miscellaneous changes
    - Makefile.in: Added test-numdigits, test-get\_digits, and test-left\_justify.
    - base-math/Makefile: Fixed missing truncd* exports which was exposed
      by GCC 4.4.
    - base-math/lttd2.c (lttd3): Renamed lttd3 to lttd2.  Typo.
    - tests/test-get\_digits.c: Added test-cases to show previously failing
      numdigits for soft-dfp when coefficient was zero.  It was returning
      '0' intead of '1', which is what hardware DFP returns.
    - tests/test-printf.c: Added test-cases to show failing tests.
    - tests/test-fpclassify.c: (printf\_d32s): Changed DENORMAL to
      SUBNORMAL in constant usage.  GCC changed usage.
    - tests/test-numdigits.c: New test.
    - tests/scaffold.c: Updated output formatting of macros to make output
      clearer (columns and test numbering).
    - tests/test-left\_justify.c: New test.
    - tests/test-strtod.c: Added test-cases to show failing tests.
    - sysdeps/powerpc/dfpu/numdigits.h (\_NUMDIGITS\_H): Removed guard to
      allow multiple #includes with different preconditions.
      (numdigits): New implementation which avoids clobbers and avoids
      modifying a parameter.
      (left\_justify): New implementation which avoids clobbers and avoids
      modifyinig a parameter.
      (getexp): New implementation which avoids modifying a parameter.
    - sysdeps/powerpc/dfpu/fe\_decround.c (\_\_fe\_dec\_setround): Fixed
      errorneous usage of mtfsfi instruction.  Previous usage resulted in
      the set rounding mode not being permanent.
    - sysdeps/soft-dfp/dpd/numdigits.h (numdigits): Return '1' if
      coefficient is zero, which is what hardware DFP does.
      (\_\_dfp\_declet\_to\_dpd): Moved to ...
    - sysdeps/dpd/dpd-private.h: ... this file.
    - sysdeps/dpd/dpd-private.c: Formatting.
    - printf\_dfp.c (printf\_dfp): Major fixes to correct a variety of
      printing errors.  It should now fully support %f, %e, %g, and %a in
      the myriad of bizarre combinations.

 - Miscellaneous changes
    - Makefile.in: Added test-strtod testcase.
    - tests/test-logd.c: Cleaned up some comments.
    - tests/scaffold.c: Cleaned up \_QC\_P macro.  It is incomplete at this
      point.
    - tests/test-strtod.c: New testcase.
    - sysdeps/powerpc/dfpu/isfinited128.c: Removed spurious <dfpmacro.h>.
    - sysdeps/powerpc/dfpu/isfinited32.c: Likewise.
    - sysdeps/powerpc/dfpu/isfinited64.c: Likewise.
    - sysdeps/powerpc/dfpu/is\_template.h: Added <dfpmacro.h> and removed
      redundant macro definitions.
    - strtod32.c: Fixed bug when calling newlocale(LC\_ALL\_MASK,NULL,NULL);
      Changed it to newlocale(LC\_ALL\_MASK, setlocale (LC\_ALL, NULL),NULL);

 - Miscellaneous changes
    - tests/test-logd.c: Added more expressive output on failure.
    - sysdeps/powerpc/dfpu/isfinited128.c: Added #include <dfpmacro.h>.
    - sysdeps/powerpc/dfpu/isfinited32.c: Likewise.
    - sysdeps/powerpc/dfpu/isfinited64.c: Likewise.

 - Miscellaneous changes
    - configure: Regenerated.
    - ieee754r/Versions: Re-added \_\_isfinited* for backward compatability.
    - configure.ac: Increment library version to 1.0.3 due to interface changes.
    - README.user: Whitespace.
    - ieee754r/isfinited32.c: Use 'isfinite' instead of 'finite'.
    - sysdeps/powerpc/dfpu/isfinited128.c: Use 'isfinite' instead of
    - 'finite'.
    - sysdeps/powerpc/dfpu/isfinited32.c: Use 'isfinite' instead of
    - 'finite'.
    - sysdeps/powerpc/dfpu/isfinited64.c: Use 'isfinite' instead of
    - 'finite'.
    - dfp/math.h: Whitespace.

 - Miscellaneous changes
    - ieee754r/isfinited128.c: Change finite to isfinite.
    - ieee754r/isfinited32.c: Likewise.
    - ieee754r/isfinited64.c: Likewise.

 - Miscellaneous changes
    - Makefile.in: Added new test cases.  Changed finited to isfinited.
    - ieee754r/scalbnd32.c: Changed usage of finited to isfinited.
    - ieee754r/scalblnd32.c: Likewise.
    - ieee754r/cbrtd32.c: Likewise.
    - ieee754r/expd32.c: Likewise.
    - ieee754r/nextafterd32.c: Likewise.
    - ieee754r/exp2d32.c: Likewise.
    - ieee754r/Makefile: Likewise.
    - ieee754r/expm1d32.c: Likewise.
    - ieee754r/hypotd32.c: Likewise.
    - ieee754r/powd32.c: Likewise.
    - ieee754r/ldexpd32.c: Likewise.
    - ieee754r/fdimd32.c: Likewise.
    - ieee754r/nearbyintd32.c: Likewise.
    - ieee754r/coshd32.c: Likewise.
    - ieee754r/lgammad32.c: Likewise.
    - ieee754r/sinhd32.c: Likewise.
    - ieee754r/tgammad32.c: Likewise.
    - ieee754r/nexttowardd32.c: Likewise.
    - ieee754r/Versions: Likewise.
    - ieee754r/tand32.c: Likewise.
    - ieee754r/frexpd32.c: Likewise.
    - ieee754r/isfinited64.c: Renamed to this from...
    - ieee754r/finited64.c: ...this.
    - ieee754r/isfinited32.c: Renamed to this from...
    - ieee754r/finited32.c: ...this.
    - ieee754r/isfinited128.c: Renamed to this from...
    - ieee754r/finited128.c: ...this.
    - tests/test-logd.c: New test.
    - tests/test-quantize.c: New test.
    - tests/test-fpclassify.c: New test.
    - tests/scaffold.c: Started adding \_QC and QC\_P.
    - tests/test-isfinite.c: Renamed this...
    - tests/test-finite.c: ...from this.
    - sysdeps/powerpc/dfpu/logd64.c: Added hard-dfp optimizations.
    - sysdeps/powerpc/dfpu/isinfd128.c: Likewise.
    - sysdeps/powerpc/dfpu/isfinited128.c: Likewise.
    - sysdeps/powerpc/dfpu/expd64.c: Likewise.
    - sysdeps/powerpc/dfpu/rintd128.c: Likewise.
    - sysdeps/powerpc/dfpu/isfinited32.c: Likewise.
    - sysdeps/powerpc/dfpu/powd64.c: Likewise.
    - sysdeps/powerpc/dfpu/rintd32.c: Likewise.
    - sysdeps/powerpc/dfpu/finited32.c: Likewise.
    - sysdeps/powerpc/dfpu/logd32.c: Likewise.
    - sysdeps/powerpc/dfpu/isnormald64.c: Likewise.
    - sysdeps/powerpc/dfpu/fpclassifyd128.c: Likewise.
    - sysdeps/powerpc/dfpu/expd32.c: Likewise.
    - sysdeps/powerpc/dfpu/isnand128.c: Likewise.
    - sysdeps/powerpc/dfpu/is\_template.h: Likewise.
    - sysdeps/powerpc/dfpu/powd32.c: Likewise.
    - sysdeps/powerpc/dfpu/ddlogtbls.h: Likewise.
    - sysdeps/powerpc/dfpu/isnormald128.c: Likewise.
    - sysdeps/powerpc/dfpu/isfinited64.c: Likewise.
    - sysdeps/powerpc/dfpu/rintd64.c: Likewise.
    - sysdeps/powerpc/dfpu/finited64.c: Likewise.
    - sysdeps/powerpc/dfpu/isnormald32.c: Likewise.
    - dfp/math.h: added islessgreaterd prototypes, etc.  Added isnormald
      prototypes.

 - Miscellaneous changes
    - configure: Updated version to 1.0.2.
    - Makefile.in: Added test cases.
    - ieee754r/Versions: Exported \_\_isnand*, \_\_isinfd*, etc.
    - tests/test-printf.c: Define \_WANT\_PC.
    - tests/test-decode.c: Define \_WANT\_DC.
    - tests/scaffold.c: Added \_VC\_P and \_VC as well as \_WANT\_PC, \_WANT\_DC,
      and \_WANT\_VC.
    - tests/test-fpclassify.c: New classification function test.
    - tests/test-isnan.c: Likewise.
    - tests/test-isinf.c: Likewise.
    - tests/test-finite.c: Likewise.
    - tests/test-param.c: Likewise.
    - tests/test-quantize.c: Likewise.
    - sysdeps/powerpc/dfpu/quantized64.c: Hard-dfp implementation.
    - sysdeps/powerpc/dfpu/quantized128.c: Likewise.
    - sysdeps/powerpc/dfpu/fpclassifyd64.c: Likewise.
    - sysdeps/powerpc/dfpu/isnand32.c: Likewise.
    - sysdeps/powerpc/dfpu/isinfd32.c: Likewise.
    - sysdeps/powerpc/dfpu/isnand64.c: Likewise.
    - sysdeps/powerpc/dfpu/isinfd64.c: Likewise.
    - sysdeps/powerpc/dfpu/finited32.c: Likewise.
    - sysdeps/powerpc/dfpu/quantized32.c: Likewise.
    - sysdeps/powerpc/dfpu/finited64.c: Likewise.
    - sysdeps/powerpc/dfpu/fpclassifyd32.c: Likewise.

 - Miscellaneous changes
    - Makefile.in: Allow make check to work without --with-glibc-build.
    - tests/test-printf.c: Removed register\_printf\_dfp() invocation.
    - tests/test-amort.c: New file which is an amortiation benchmark.
    - tests/scaffold.c: Changed <decode.h> to "decode.h".
    - tests/decode.h (\_DFP\_DECODE\_H): Added \_DFP onto guard.
    - tests/debug-test.sh: Allow make check to work without
      --with-glibc-build by either debugging the app or the loader.
    - configure.ac: Incrememented the library version from 1.0.1 to 1.0.2
      due to the addition of the libdfp constructor which no longer requires
      register\_printf\_dfp().
    - README.user: More todos.
    - include/init\_dfp.h (\_\_libdfp\_init): New file to add constructor
      prototype.
    - Makefile.gdb: Allow make check to work without --with-glibc-build.
    - init\_dfp.c (\_\_libdfp\_init): New file.  Add a constructor to call
      register\_printf\_dfp().

 - Miscellaneous changes
    - configure: Regenerated.
    - Makefile.in: Remove appending of cc\_msize to CFLAGS.  Remove -e from
      submake which builds libdecnumber.
    - configure.ac: Remove cc\_msize and cc\_mzarch and accompanying
      AC\_SUBST.  The preferred method is to require the user to pass
      -m[31|32|64] in CFLAGS as an env variable when configure is invoked.
    - README.user: New file.
    - README.developer: Updated to direct user to pass -m[31|32|64] in
      CFLAGS and to always use --build and --host values that align with the
      -m values.

 - Miscellaneous changes
    - Makefile.in: Removed unneccesary rule -- backend:
      $(dfp\_backend)/$(dfp\_backend\_lib).

 - Miscellaneous changes
    - Makefile.in: Fixed rule $(top\_builddir)/$(dfp\_backend\_lib): to
      $(dfp\_backend)/$(dfp\_backend\_lib) to correct problem with make -j*

 - Miscellaneous changes
    - Makefile.in: Replaced libdfp.so.1 generation using `ln -s' to using
      `ldconfig -l' in both $(top\_builddir)/ and $(install\_root)$(libdir)/.
      Added creation of linkname symlink libdfp.so.
      Strip trailing / from any install\_root=<foo> paths.

 - Miscellaneous changes
    - Makefile.in: Fixed `ln -s' to not have the goofy '(cd..)', e.g. (cd
      $(libdir) ln -s <foo>) when making the .so.1 -> -1.0.1.so symlinks.

 - Miscellaneous changes
    - Makefile.in: Fixed libdir=@prefix@/lib to libdir=@libdir@ and
      includedir=@prefix@/include to includedir=@includedir@.  This will
      allow configure override with --libdir= and --includedir=
      respectively.  This was preventing installation into /<foo>/lib64.
      Fix header install so that dfp/README isn't installed with the header
      files.

 - Miscellaneous changes
    - Makefile.in: `install' doesn't handle symlinks so we've done another
      'ln -s' in the install stage to set $(SHARED\_LIBRARY) ->
      ./$(SHARED\_VERSIONED\_LIBRARY) in the $(install\_root)/$(libdir)/
      directory.

 - Miscellaneous changes
    - Makefile.in: Fixed erroneous attempt to install libdfp.a even if
      --enable-static=no was configured.

 - Miscellaneous changes
    - Makefile.in: Fixed missing libdecnumber.a rule dependency by
      changing the backend rule to be `libdecnumber.a' rather than
      `libdecnumber'.  Fixed `ln -s' error when rebuilding without a make
      clean by adding `-f' to always force overwrite the previous versioned
      library symlink.
    - README: Renamed to README.developer
    - README.developer: New file.

 - Miscellaneous changes
    - configure: Regenerated.
    - configure.ac: Added additional help text when warning about the
      glibc headers lacking the printf-hooks support.
    - README: Clarified version number.
    - TODO: Updated.

 - Miscellaneous changes
    - configure: Regenerated.
    - configure.ac: Add check for glibc headers that support the
      printf-hooks.  Add runtime check for printf-hooks in libc specified by
      --with-glibc-build.
    - TODO: Updated.

 - Miscellaneous changes
    - configure: Regenerated.
    - configure.ac:  Updated libdfp to version 1.0.1 to indicate that
      power7 support has been added.

 - Miscellaneous changes
    - configure.ac: Added POWER 7 support.
    - README: Added notes on POWER 7 support.
    - sysdeps/powerpc/powerpc32/power7: New directory.
    - sysdeps/powerpc/powerpc32/power7/Implies: Imply Power6.
    - sysdeps/powerpc/powerpc32/power7/fpu: New directory.
    - sysdeps/powerpc/powerpc32/power7/fpu/Implies: Imply Power6.
    - sysdeps/powerpc/powerpc64/power7: New directory.
    - sysdeps/powerpc/powerpc64/power7/Implies: Imply Power6.
    - sysdeps/powerpc/powerpc64/power7/fpu: New directory.
    - sysdeps/powerpc/powerpc64/power7/fpu/Implies: Imply Power6.

 - Miscellaneous changes
    - configure: Regenerated.
    - configure.ac (AC\_CACHE\_CHECK): Re-added check for
      decimal-float-support in the compiler by checking whether the compiler
      can handle the \_Decimal64 data type rather than checking whether the
      compiler -v output had a particular flag set.

 - Miscellaneous changes
    - configure: Regenerated.
    - configure.ac (AC\_PROG\_CC): Re-added AC\_PROG\_CC and removed custom
      $(CC).  Removed -m flags from CC and pushed this responsibility onto
      Makefile.in to put into CFLAGS.  These changes allow a user to prepend
      some custom flags onto CFLAGS at configure time.
      (dfp\_opts): Changed to $(cc\_mzarch).  No need to be obscure until we
      have to.
    - Makefile.in (cc\_mzarch): New variable used on s390 only, otherwise
      empty.
      (default\_cflags): Inherit defaults from configure.  Add
      -m$(cc\_msize) and $(cc\_mzarch).
      (default\_asflags): Inherit defaults from configure.  Add
      -m$(cc\_msize) and $(cc\_mzarch).
      (+cflags): Simplified CFLAGS override mechanism.
      (+asflags): Simplified ASFLAGS override mechanism.
      ($(top\_builddir)/$(dfp\_backend)): Manually pass overridden CFLAGS to
      backend 'make' since the -m flags aren't passed in the top level
      configure's CFLAGS.
      ($(top\_builddir)/$(SHARED\_VERSION\_LIBRARY)): Added $(CFLAGS) since
      it's no longer part of $(CC).
      ($(libdfp\_tests)): Added $(CFLAGS) since it's no longer part of $(CC).

 - Miscellaneous changes
    - configure: Regenerated.

 - Miscellaneous changes
    - configure.ac: Add -mzarch when building hw dfp on S/390.
      This is needed for 31 bit which would otherwise default to
      -mesa.

 - Miscellaneous changes
    - configure: Regenerated.
    - Makefile.in (.c.o, .c.os): Added -include $(top\_builddir)/config.h to
      pick up \_BACKEND\_DPD or \_BACKEND\_BID.
      ($(top\_builddir)/$(STATIC\_LIBRARY)): Add $(top\_builddir) to
      dfp\_backend path.
    - README: Added WARNING about making sure to link to a glibc that's
      the same bitness (32|64) and the same optimization as the libdfp
      that's being configure.  Added --with-glibc-build= examples.
    - Versions (libdfp): LIBDFP\_1.0.0 tagged.
    - Versions.def (libdfp): LIBDFP\_1.0.0 tagged.
    - ieee754r/Versions.def (libdfp): LIBDFP\_1.0.0 tagged.
    - config.h.in: Regenerated.
    - configure.ac: (AC\_INIT): Tagged version 1.0.0.
      (\_DPD\_BACKEND): AC\_DEFINE\_UNQUOTED; Set based on backend.
      (\_BID\_BACKEND): AC\_DEFINE\_UNQUOTED; Set based on backend.
      (--with-cpu): Removed submachine\_opt="-mcpu=$withval".
      ($machine): On s390 cc\_msize=31 NOT 32.
      (AC\_SUBST): CFLAGS and ASFLAGS.
      (AC\_CACHE\_CHECK): Removed check for compiler feature
      decimal-float-support.
    - ieee754r/frexpd32.c (INTERNAL\_FUNCTION\_NAME): Initialize 'result' to
      DEC\_NAN because compiler can't see that it's set in a macro and
      generates warnings.
    - sysdeps/bid/Versions (libdfp): LIBDFP\_1.0.0 tagged
    - sysdeps/dpd/Versions (libdfp): LIBDFP\_1.0.0 tagged
    - sysdeps/dpd/dpd-private.c (\_\_get\_digits\_d32, \_\_get\_digits\_d64,
      \_\_get\_digits\_d128): initialize exp = 0;
    - sysdeps/powerpc/dfpu/numdigits.h (numdigits): Conditionally define
      'f' based on \_Decimal size to prevent the compiler from messing up the
      register order requirements.
    - sysdeps/soft-dfp/Versions (libdfp): LIBDFP\_1.0.0 tagged
    - sysdeps/soft-dfp/bid/Versions (libdfp): LIBDFP\_1.0.0 tagged
    - sysdeps/soft-dfp/dpd/Versions (libdfp): LIBDFP\_1.0.0 tagged
    - tests/decode.h: New file providing non-exported decoded[32|64|128]
      prototypes used in tests and debugging.
    - tests/scaffold.c (\_DC, \_DC\_P): Added macros for testing against
      decoded[32|64|128] output.
    - tests/test-param.c (main): Updated to use scaffold.c and test the
      values against the decoded[32|64|128] values that're expected.

 - Miscellaneous changes
    - ieee754r/powd32.c (INTERNAL\_FUNCTION\_NAME): Set \_\_isnan ->
      FUNC\_D(\_\_isnan).  Not strictly necessary since \_\_isnan is a
      polymorphic classification function, but this was we avoid the extra
      steps of detecting the type/size of the input parameter and call the
      appropriate \_\_isnand[32|64|128] directly.

 - Miscellaneous changes
    - ieee754r/powd32.c: Add dfp prefix to \_\_isnan invocation.

 - Miscellaneous changes
    - sysdeps/s390/dfpu/fenv\_libdfp.h: Move file to ...
    - sysdeps/s390/fpu/fenv\_libdfp.h: ... here.

 - Miscellaneous changes
    - configure.ac: Add a march vs mcpu gcc option check.

 - Miscellaneous changes
    - Makefile.in (prefix): Set based on @prefix@ to prevent missing
      --exec-prefix from setting @exec\_prefix@ to the string '$(prefix)',
      i.e. not the context of $prefix.
      ($(top\_builddir)/$(SHARED\_VERSION\_LIBRARY)): Added -W,no-whole-archive
      to close -W,whole-archive to SHARED\_VERSION\_LIBRARY rule.  Removed
      -nodefaultlibs -nostdlib which prevented linking against libc and libm
      which libdfp relies upon.
    - tests/test-printf.c (printf\_d128s): Added correct "expected"
      strings.
    - sysdeps/soft-dfp/dpd/numdigits.h (left\_justify): Changed erroneous
      FUNC\_D (getexp(x)) to FUNC\_D (getexp) (x) to correct macro invocation.

 - Miscellaneous changes
    - README: Updated the S/390 availability section.

 - Miscellaneous changes
    - Makefile.in: Updated comment to reflect update from 0.0.1 to 0.0.9.
    - configure.ac (AC\_INIT): Updated version from 0.0.1 to 0.0.9.
    - README: Added two TODO chapters and clarified the intro paragraphs.
    - Versions.def: Update package versions for symbols.
    - Versions: Update package versions for symbols.

 - Miscellaneous changes
    - Makefile.in: Added test-param to libdfp\_tests.
    - tests/TODO: New file.
    - tests/README: N/A.
    - tests/test-param.c: New test to verify integrity of parameters that
      are spilled to the stack on being passed to a new function.

 - Miscellaneous changes
    - tests/test-printf.c: Added mechanism to easily add new printf test
      cases based upon GLIBC's stdio-common/tfformat.c testcase.

 - Miscellaneous changes
    - tests/scaffold.c: New file which holds \_C, \_C\_P, \_PC, and \_PC\_P
      macros used for printing debugging messages in the event of test case
      failures.

 - Miscellaneous changes
    - Makefile.in: For .out rules send stdout to /dev/null and stderr to
      the .out file.
    - tests/test-printf.c: Added framework for generically adding printf tests.
    - Makefile.gdb: Squelch echos of .conf and .gdb file creation.

 - Miscellaneous changes
    - Makefile.in: Change test-debug to > debug-test.
    - tests/debug-test.sh: Change test-debug.conf -> debug-test.conf.
    - Makefile.gdb: Change test-debug to debug-test.

 - Miscellaneous changes
    - tests/test-debug.sh: Removed and renamed to ...
    - tests/debug-test.sh: New.

 - Miscellaneous changes
    - CONTRIBUTORS: Added Carlos Eduardo Seo for contribution of
      Makefile.in make install and make install-headers feature.
    - README: Added section on Make Rules.
    - TODO: Added additional todo items.

 - Miscellaneous changes
    - Makefile.in: Added 'make install0headers' feature.

 - Miscellaneous changes
    - printf\_dfp.c: (padn, wpadn): Changed usage of size\_t to 'int' to
      avoid compiler warnings about unsigned to signed comparisons.

 - Miscellaneous changes
    - tests/test-printf.c: Added print statements for \_Decimal32 and
      \_Decimal128.
    - sysdeps/powerpc/dfpu/numdigits.h (numdigits getexp): Use FUNC\_D
      wrapper.
      (FUNC\_D PASTE): Conditionally define these macros.

 - Miscellaneous changes
    - include/printf\_dfp.h (\_\_d32\_ais, \_\_d64\_ais, \_\_d128\_ais): Removed
    - printf\_dfp.c (\_\_printf\_dfp): Changed width from unsigned into to
      int in order to prevent negative default.
      (\_\_register\_printf\_dfp): Replaced individual decimal sized
      specifier registrations with a unified registrations.
      (\_\_d32\_ais, \_\_d64\_ais, \_\_d128\_ais): Removed and replaced with unified
      \_\_dfp\_ais().

 - Miscellaneous changes
    - ieee754r/ldexpd32.c (ldexpd32): Use FUNC\_D wrapper around getexp.
    - ieee754r/frexpd32.c (frexpd32): Use FUNC\_D wrapper around numdigits
      and getexp.
    - sysdeps/soft-dfp/dpd/numdigits.h (numdigits getexp): Use FUNC\_D
      wrapper.

 - Miscellaneous changes
    - Makefile.in: Added 'make install' feature.

 - Miscellaneous changes
    - include/printf\_dfp.h: Add #include <stdardg.h>.
    - sysdeps/s390/dfpu/numdigits.h: Wrap function definitions in FUNC\_D
      macro. Add PASTE and FUNC\_D macro definitions.
    - strtod32.c (setexp): Refer to 'getexp' using FUNC\_D() macro. Add
      PASTE and FUNC\_D macro definitions.  Reposition dfp*\_private.h header
      inclusions.

 - General non-functiopnal maintenance.
    - Makefile.in: Cleanup comments.
    - README: Fix typo, spacings, and text.

 - This commit adds the port of libdfp from a GLIBC add-on to a standalone
   library.  This library was written by Ryan S. Arnold <rsa@us.ibm.com>, Joseph
   Kerian <kerian@us.ibm.com>, Pete Eberlein <eberlein@us.ibm.com>, Steve Munroe
   <munroesj@us.ibm.com>, Andreas Krebbel <krebbel@de.ibm.com>, et al.

 - This commit adds the top-level sub-directories for the stand-alone libdfp
   project.  It adds the top-level directory libdfp/ per Mark Mitchell's
   direction on patches@eglibc.org on Mon, 29 Jun 2009.
