package org.jboss.cache.commands.remote;

import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.commands.ReplicableCommand;

/**
 * Removes a buddy from a group.  This is not a {@link org.jboss.cache.commands.VisitableCommand} and hence
 * not passed up the {@link org.jboss.cache.interceptors.base.CommandInterceptor} chain.
 * <p/>
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.2
 */
public class RemoveFromBuddyGroupCommand implements ReplicableCommand
{
   public static final int METHOD_ID = 30;

   private BuddyManager buddyManager;

   private String groupName;

   public RemoveFromBuddyGroupCommand(String groupName)
   {
      this.groupName = groupName;
   }

   public RemoveFromBuddyGroupCommand()
   {
   }

   public void initialize(BuddyManager buddyManager)
   {
      this.buddyManager = buddyManager;
   }

   /**
    * This method calls the relevant handler on the buddy manager to deal with being removed from a buddy group
    *
    * @param ctx invocation context, ignored.
    * @return null
    */
   public Object perform(InvocationContext ctx)
   {
      if (buddyManager != null)
         buddyManager.handleRemoveFromBuddyGroup(groupName);
      return null;
   }

   public int getCommandId()
   {
      return METHOD_ID;
   }

   public String getGroupName()
   {
      return groupName;
   }

   public Object[] getParameters()
   {
      return new Object[]{groupName};
   }

   public void setParameters(int commandId, Object[] args)
   {
      groupName = (String) args[0];
   }

   @Override
   public boolean equals(Object o)
   {
      if (this == o) return true;
      if (o == null || getClass() != o.getClass()) return false;

      RemoveFromBuddyGroupCommand that = (RemoveFromBuddyGroupCommand) o;

      if (groupName != null ? !groupName.equals(that.groupName) : that.groupName != null) return false;

      return true;
   }

   @Override
   public int hashCode()
   {
      return (groupName != null ? groupName.hashCode() : 0);
   }

   @Override
   public String toString()
   {
      return "RemoveFromBuddyGroupCommand{" +
            "buddyManager=" + buddyManager +
            ", groupName='" + groupName + '\'' +
            '}';
   }
}
