//start of LzssOutputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LzssOutputStream.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.OutputStream;
import jp.gr.java_conf.dangan.lang.reflect.Factory;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;
import jp.gr.java_conf.dangan.util.lha.HashAndChainedListSearch;

//import exceptions
import java.io.IOException;
import java.lang.NoSuchMethodException;
import java.lang.ClassNotFoundException;
import java.lang.InstantiationException;
import java.lang.reflect.InvocationTargetException;

import java.lang.Error;
import java.lang.NoSuchMethodError;
import java.lang.InstantiationError;
import java.lang.NoClassDefFoundError;


/**
 * f[^ LZSSkȂ
 * w肳ꂽ PostLzssEncoder ɏo͂鈳kpo̓Xg[B<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: LzssOutputStream.java,v $
 * Revision 1.2  2002/12/06 00:00:00  dangan
 * [change]
 *     flush()  write() ꂽSẴf[^ 
 *     ڑꂽ PostLzssEncoder ɏo͂悤ɏCB
 * [maintenance]
 *     slide DictionarySize oCgɂȂ悤ɏCB
 *
 * Revision 1.1  2002/10/20 00:00:00  dangan
 * [bug fix]
 *     Ԃ flush()  A flush() 
 *     ( lastsearchret  NEEDSEARCH ̎ encode() Ă΂ )
 *      1oCgĂB
 *     flush()  putLength() lĂȂ
 *     @\j󂷂悤 searchAndPut sĂ̂CB
 *     flush()  TextBuffer ŌMaxMatchoCg̃f[^o͂ĂȂB
 *
 * Revision 1.0  2002/07/25 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     getMatchLen()  searchret >> 22 ƂׂƂ낪 
 *     searchret >>> 22 ƂȂĂ̂CB
 * [maintenance]
 *     LhaUtil.createInstance() ̎gp
 *      Factory.createInstance() gpB
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.2 $
 */
public class LzssOutputStream extends OutputStream{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  special value
    //------------------------------------------------------------------
    //  private static final int NEEDSEARCH
    //  private static final int NOMATCH
    //------------------------------------------------------------------
    /**
     * lastsearchret ɓo^lB
     * searchAndPut̏Kvł鎖B
     */
    private static final int NEEDSEARCH = 0;

    /**
     * searchret ̒lꍇA
     * ̌ʁA臒lȏ̈vȂB
     */
    public static final int NOMATCH = -1;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private PostLzssEncoder encoder
    //------------------------------------------------------------------
    /**
     * LZSSkR[hrȍo̓Xg[
     */
    private PostLzssEncoder encoder;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private int DictionarySize
    //  private int Threshold
    //  private int MaxMatch
    //------------------------------------------------------------------
    /**
     * LZSSTCYB
     */
    private int DictionarySize;

    /**
     * LZSSkɎgp臒lB
     * v ̒lȏł΁AkR[ho͂B
     */
    private int Threshold;

    /**
     * LZSSkɎgplB
     * ővB
     */
    private int MaxMatch;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  text buffer
    //------------------------------------------------------------------
    //  private byte[] TextBuffer
    //  private int DictionaryLimit
    //  private int writtenPos
    //  private int putPos
    //  private int searchedPos
    //------------------------------------------------------------------
    /**
     * LZSSk{߂̃obt@B
     * Ö͎A
     * 㔼͈k{߂̃f[^̓obt@B
     */
    private byte[] TextBuffer;

    /**
     * ̌EʒuB 
     * TextBufferO̎̈Ƀf[^ꍇ
     * ̈ɂs̃f[^(Javał0)gp
     * Ĉkŝ}~B
     */
    private int DictionaryLimit;

    /**
     * TextBuffer݊ʒu
     * LzssOutputStream.write() ɂď܂ꂽʒu
     * 
     * ȉ3҂̊֌W putPos <= searchedPos <= writtenPos ƂȂB
     */
    private int writtenPos;

    /**
     * TextBuffer put() ʒu
     * LzssSearchMethod  put()  searchAndPut() 
     * @\ւ̓o^ʒu
     */
    private int putPos;

    /**
     * TextBuffer ݌ʒu
     *  LzssSearchMethod  search()  searchAndPut() 
     * ׂʒu
     */
    private int searchPos;

    /**
     * Oencode̍ŌsearchretۑĂ
     * RXgN^ł lastsearchret ɖ
     * ł鎖 LzssOutputStream.NEEDSEARCH
     * ͂ĂB
     */
    private int lastsearchret;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  search method
    //------------------------------------------------------------------
    //  private LzssSearchMethod method
    //------------------------------------------------------------------
    /**
     * ǂNX
     */
    private LzssSearchMethod method;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private LzssOutputStream()
    //  public LzssOutputStream( PostLzssEncoder encoder )
    //  public LzssOutputStream( PostLzssEncoder encoder, String SearchMethod )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private LzssOutputStream(){ }

    /**
     * write() ɂď܂ꂽf[^
     * LZSSňkAkf[^ encoderɏo͂
     * o̓Xg[\zB
     * 
     * @param encoder LZSSkf[^o̓Xg[
     */
    public LzssOutputStream( PostLzssEncoder encoder ){
        this( encoder, 
              HashAndChainedListSearch.class.getName(),
              new Object[0] );
    }

    /**
     * write() ɂď܂ꂽf[^
     * LZSSňkAkf[^ encoderɏo͂
     * o̓Xg[\zB
     * 
     * @param encoder LZSSkf[^o̓Xg[
     * @param LzssSearchMethodClassName 
     *                LzssSearchMethod ̎pbP[W܂߂NX
     * 
     * @exception NoClassDefFoundError
     *              LzssSearchMethodClassName ŗ^ꂽNX
     *              ȂꍇB
     * @exception InstantiationError
     *              LzssSearchMethodClassName ŗ^ꂽNX
     *              abstract class ł邽߃CX^X𐶐łȂꍇB
     * @exception NoSuchMethodError
     *              LzssSearchMethodClassName ŗ^ꂽNX
     *              RXgN^ LzssSearchMethod( int, int, int, byte[], int )
     *              Ȃꍇ
     */
    public LzssOutputStream( PostLzssEncoder encoder, 
                             String          LzssSearchMethodClassName ){
        this( encoder, 
              LzssSearchMethodClassName,
              new Object[0] );
    }

    /**
     * write() ɂď܂ꂽf[^
     * LZSSňkAkf[^ encoderɏo͂
     * o̓Xg[\zB
     * 
     * @param encoder LZSSkf[^o̓Xg[
     * @param LzssSearchMethodClassName 
     *                LzssSearchMethod ̎pbP[W܂߂NX
     * 
     * @exception NoClassDefFoundError
     *              LzssSearchMethodClassName ŗ^ꂽNX
     *              ȂꍇB
     * @exception InstantiationError
     *              LzssSearchMethodClassName ŗ^ꂽNX
     *              abstract class ł邽߃CX^X𐶐łȂꍇB
     * @exception NoSuchMethodError
     *              LzssSearchMethodClassName ŗ^ꂽNX
     *              RXgN^ LzssSearchMethod( int, int, int, byte[] )
     *              Ȃꍇ
     */
    public LzssOutputStream( PostLzssEncoder encoder, 
                             String   LzssSearchMethodClassName,
                             Object[] LzssSearchMethodExtraArguments ){

        this.DictionarySize  = encoder.getDictionarySize();
        this.MaxMatch        = encoder.getMaxMatch();
        this.Threshold       = encoder.getThreshold();

        this.encoder         = encoder;
        this.TextBuffer      = new byte[ this.DictionarySize * 2 
                                       + this.MaxMatch ];
        this.writtenPos      = this.DictionarySize;
        this.putPos          = this.DictionarySize;
        this.searchPos       = this.DictionarySize;
        this.DictionaryLimit = this.DictionarySize;
        this.lastsearchret   = LzssOutputStream.NEEDSEARCH;

        Object[] arguments   = new Object[ LzssSearchMethodExtraArguments.length + 4 ];
        arguments[0] = new Integer( this.DictionarySize );
        arguments[1] = new Integer( this.MaxMatch );
        arguments[2] = new Integer( this.Threshold );
        arguments[3] = this.TextBuffer;
        for( int i = 0 ; i < LzssSearchMethodExtraArguments.length ; i++ ){
            arguments[4+i] = LzssSearchMethodExtraArguments[i];
        }

        try{
            this.method = (LzssSearchMethod)Factory.createInstance( 
                            LzssSearchMethodClassName, 
                            arguments );                                        //throw ClasNotfoundException, InvocationTargetException, NoSuchMethodException, InstantiationException
        }catch( ClassNotFoundException exception ){
            throw new NoClassDefFoundError( exception.getMessage() );
        }catch( InvocationTargetException exception ){
            throw new Error( exception.getTargetException().getMessage() );
        }catch( NoSuchMethodException exception ){
            throw new NoSuchMethodError( exception.getMessage() );
        }catch( InstantiationException exception ){
            throw new InstantiationError( exception.getMessage() );
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.OutputStream method
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void write( int data )
    //  public void write( byte[] buffer )
    //  public void write( byte[] buffer, int index, int length )
    //------------------------------------------------------------------
    /**
     * k@\1oCg̃f[^o͂B<br>
     * ۂPostLzssEncoder Ƀf[^n̂ 
     * TextBuffer ꂽƂA
     * flush ŖIɏo͂ŵ݁B<br>
     * 
     * @param data 1oCg̃f[^
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void write( int data ) throws IOException {
        this.TextBuffer[ this.writtenPos++ ] = (byte)data;

        if( this.TextBuffer.length <= this.writtenPos ){
            this.encode( false );                                               //throws IOException
            this.slide();                                                       
        }
    }

    /**
     * k@\ buffer ̃f[^Sďo͂B<br>
     * ۂPostLzssEncoder Ƀf[^n̂ 
     * TextBuffer ꂽƂA
     * flush ŖIɏo͂ŵ݁B<br>
     * 
     * @param buffer f[^̊i[ꂽobt@
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void write( byte[] buffer ) throws IOException {
        this.write( buffer, 0, buffer.length );                                 //throws IOException
    }

    /**
     * k@\ buffer  index  lengthoCg̃f[^o͂B<br>
     * ۂPostLzssEncoder Ƀf[^n̂ 
     * TextBuffer ꂽƂA
     * flush ŖIɏo͂ŵ݁B<br>
     * 
     * @param buffer f[^̊i[ꂽobt@
     * @param index  bufferf[^Jnʒu
     * @param length bufferf[^̒
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void write( byte[] buffer, int index, int length ) throws IOException {
        int pos = index;
        int end = index + length;

        while( pos < end ){
            int space = TextBuffer.length - writtenPos;
            if( end - pos < space ){
                System.arraycopy( buffer, pos, 
                                  this.TextBuffer, this.writtenPos, 
                                  end - pos );
                this.writtenPos += end - pos;
                pos = end;
            }else{
                System.arraycopy( buffer, pos, 
                                  this.TextBuffer, this.writtenPos,
                                  space );
                this.writtenPos += space;
                pos += space;
                this.encode( false );                                           //throws IOException
                this.slide();
            }
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.OutputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * k@\ɏ܂ꂽSẴf[^
     * ڑꂽ PostLzssEncoder ɏo͂A
     * ڑꂽ PostLzssEncoder  flush() B<br>
     * ̂ƂAo͂f[^̏I[t߂ł
     *  search() gp邽߈kxቺB
     * ܂ flush() ȂꍇƔׂĈkωB
     *  flush() ʒut߂ł̓f[^p^̌
     * MaxMatch ɖȂf[^p^gp邽߁A
     * ʂsSɂȂ邽߁B
     * ̈k̕ώȀꍇkXቺ邾ł邪A
     * ႦΎ̂悤ȃR[h LZ kSsȂB
     * <pre>
     *  public void wrongCompress( InputStream in, LzssOutputSteam out ){
     *      int r;
     *      while( 0 <= r = in.read() ){
     *          out.write( r );
     *          out.flush();
     *      }
     *  }
     * </pre>
     * ܂Ã\bh PostLzssEncoder.flush() Ăяo
     * flush() ȂꍇƔׂāAo̓f[^ω\B<br>
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PostLzssEncoder#flush()
     */
    public void flush() throws IOException {
        this.encode( false );                                                   //throw IOException
        if( this.DictionarySize * 2 <= this.putPos ){
            this.slide();
            if( this.searchPos < this.writtenPos ){
                this.encode( false );                                           //throw IOException
            }
        }
        this.encoder.flush();                                                   //throw IOException
    }

    /**
     * ̃NXɒꂽSẴf[^ڑꂽ 
     * PostLzssEncoder ɏo͂ ̏o̓Xg[ƁA
     * ڑꂽXg[A
     * gpĂ\[XJB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        while( this.DictionarySize <= this.writtenPos ){
            this.encode( true );                                      //throw IOException
            if( this.writtenPos <= this.searchPos ){
                break;
            }else{
                this.slide();
            }
        }

        this.encoder.close();                                                   //throw IOException
        this.encoder = null;

        this.TextBuffer = null;
        this.method     = null;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  private int encode()
    //  private void slide( int position )
    //------------------------------------------------------------------
    /**
     * TextBuffer ɒꂽf[^kȂ
     * privateϐ this.encoder ɏo͂B
     * 
     * @return TextBuffer ̏o͊f[^̏I[ʒu + 1
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void encode( boolean last ) throws IOException {

        int end = Math.min( this.TextBuffer.length  - this.MaxMatch,
                            this.writtenPos - ( last ? 0 : this.method.putRequires() ) );
        if( this.searchPos < end ){

            //------------------------------------------------------------------
            //  O
            if( this.lastsearchret == LzssOutputStream.NEEDSEARCH ){

                //------------------------------------------------------------------
                //  @\ɖo^̃f[^p^o^
                while( this.putPos < this.searchPos - 1 ){
                    this.method.put( ++this.putPos );

                    //O flush()  put() łȂ
                    //f[^p^ put() ̏ꍇ return
                    if( this.DictionarySize * 2 <= this.putPos ){
                        return;
                    }
                }

                //  lastsearchret  NEEDSEARCH Ȃ̂ searchAndPut ŌB
                this.lastsearchret = this.method.searchAndPut( this.searchPos );
            }

            int searchret = this.lastsearchret;
            int matchlen  = LzssOutputStream.getMatchLen( searchret );
            int matchpos  = LzssOutputStream.getMatchPos( searchret );
            if( this.writtenPos - this.searchPos < matchlen ){
                matchlen = this.writtenPos - this.searchPos;
            }

            //------------------------------------------------------------------
            //  C[v
            while( true ){
                int lastmatchlen = matchlen;
                int lastmatchoff = this.searchPos - matchpos - 1;

                searchret = this.method.searchAndPut( ++this.searchPos );
                matchlen  = LzssOutputStream.getMatchLen( searchret );
                matchpos  = LzssOutputStream.getMatchPos( searchret );
                if( this.writtenPos - this.searchPos < matchlen ){
                    matchlen = this.writtenPos - this.searchPos;
                }

                if( lastmatchlen < matchlen || lastmatchlen < this.Threshold ){
                    this.encoder.writeCode( 0xFF & this.TextBuffer[ this.searchPos - 1 ] ); //throws IOException
                    if( end <= this.searchPos ){
                        this.putPos        = this.searchPos;
                        this.lastsearchret = searchret;
                        break;
                    }
                }else{
                    this.encoder.writeCode( 256 + lastmatchlen - this.Threshold );//throws IOException
                    this.encoder.writeOffset( lastmatchoff );                   //throws IOException

                    lastmatchlen--;
                    if( this.searchPos + lastmatchlen < end ){
                        while( 0 < --lastmatchlen ){
                            this.method.put( ++this.searchPos );
                        }

                        searchret = this.method.searchAndPut( ++this.searchPos );
                        matchlen  = LzssOutputStream.getMatchLen( searchret );
                        matchpos  = LzssOutputStream.getMatchPos( searchret );
                        if( this.writtenPos - this.searchPos < matchlen ){
                            matchlen = this.writtenPos - this.searchPos;
                        }
                    }else if( end < this.searchPos + lastmatchlen ){
                        this.putPos = this.searchPos;
                        while( this.putPos < end ){
                            this.method.put( ++this.putPos );
                        }
                        this.searchPos    += lastmatchlen;
                        this.lastsearchret = LzssOutputStream.NEEDSEARCH;
                        break;
                    }else{
                        this.putPos = this.searchPos;
                        while( this.putPos < end - 1 ){
                            this.method.put( ++this.putPos );
                        }
                        this.putPos++;
                        this.searchPos    += lastmatchlen;
                        this.lastsearchret = this.method.searchAndPut( this.searchPos );
                        break;
                    }
                }// if( lastmatchlen < matchlen || lastmatchlen < this.Threshold )
            }// while( true )
        }// if( this.searchPos < end )

        //------------------------------------------------------------------
        //  flush() p
        //  putPos ͂̂܂܂ searchPos ̂ݐi߂B
        end = Math.min( this.TextBuffer.length  - this.MaxMatch,
                        this.writtenPos );
        if( !last && this.searchPos < end ){
            if( this.lastsearchret == LzssOutputStream.NEEDSEARCH ){
                this.lastsearchret = this.method.search( this.searchPos, this.putPos );
            }
            int searchret = this.lastsearchret;
            int matchlen  = LzssOutputStream.getMatchLen( searchret );
            int matchpos  = LzssOutputStream.getMatchPos( searchret );
            if( this.writtenPos - this.searchPos < matchlen ){
                matchlen = this.writtenPos - this.searchPos;
            }

            while( this.searchPos < end ){
                int lastmatchlen = matchlen;
                int lastmatchoff = this.searchPos - matchpos - 1;

                searchret = this.method.search( ++this.searchPos, this.putPos );
                matchlen  = LzssOutputStream.getMatchLen( searchret );
                matchpos  = LzssOutputStream.getMatchPos( searchret );
                if( this.writtenPos - this.searchPos < matchlen ){
                    matchlen = this.writtenPos - this.searchPos;
                }

                if( lastmatchlen < matchlen || lastmatchlen < this.Threshold ){
                    this.encoder.writeCode( 0xFF & this.TextBuffer[this.searchPos - 1] ); //throws IOException
                }else{
                    this.encoder.writeCode( 256 + lastmatchlen - this.Threshold );  //throws IOException
                    this.encoder.writeOffset( lastmatchoff );                       //throws IOException

                    this.searchPos += lastmatchlen - 1;
                    searchret = this.method.search( this.searchPos, this.putPos );
                    matchlen  = LzssOutputStream.getMatchLen( searchret );
                    matchpos  = LzssOutputStream.getMatchPos( searchret );
                    if( this.writtenPos - this.searchPos < matchlen ){
                        matchlen = this.writtenPos - this.searchPos;
                    }
                }
            }
            this.lastsearchret = LzssOutputStream.NEEDSEARCH;
        }
    }


    /**
     * TextBufferposition܂ł̃f[^
     * Oֈړ
     * 
     * @param position  TextBuffer
     *                 DictionarySize ̈ʒuɗׂ
     *                 vf݂index
     */
    private void slide(){
        this.DictionaryLimit = Math.max( 0, this.DictionaryLimit - this.DictionarySize );

        this.method.slide();

        if( this.lastsearchret != LzssOutputStream.NEEDSEARCH ){
            int matchlen = LzssOutputStream.getMatchLen( this.lastsearchret );
            int matchpos = LzssOutputStream.getMatchPos( this.lastsearchret );
            this.lastsearchret = LzssOutputStream.createSearchReturn( 
                                    matchlen, matchpos - this.DictionarySize );
        }

        this.writtenPos -= this.DictionarySize;
        this.searchPos  -= this.DictionarySize;
        this.putPos     -= this.DictionarySize;
        for( int i = this.DictionaryLimit ; i < this.writtenPos ; i++ )
            this.TextBuffer[ i ] = this.TextBuffer[ i + this.DictionarySize ];
    }


    //------------------------------------------------------------------
    //  shared methods
    //------------------------------------------------------------------
    //  private static final int createSearchReturn( int matchlen, int matchpos )
    //  private static final int getMatchLen( int searchret )
    //  private static final int getMatchPos( int searchret )
    //------------------------------------------------------------------
    /**
     * search ̖߂l𐶐B
     * search ͈vʒuԂAvɕԂق
     * ɕ֗ł邽߁AvʒuvKvȃrbg
     * ȂƂ𗘗p int^ł肷B
     * ̂߂̓ꂵ񑩂֐B
     * ̊֐Őꂽl vʒuvoۂɂ
     * getMatchLenA getMatchPos gpB
     * 
     * @param matchlen v
     * @param matchpos vʒu
     * 
     * @return vƈvʒȕ܂search̖߂l
     */
    public static final int createSearchReturn( int matchlen, int matchpos ){
        return matchlen << 22 | matchpos;
    }

    /**
     * createSearchReturn Őꂽ search̖߂l
     * voB
     * 
     * @param searchret search ̖߂l
     * 
     * @return v
     */
    public static final int getMatchLen( int searchret ){
        return searchret >> 22;
    }

    /**
     * createSearchReturn Őꂽ search̖߂l
     * vʒuoB
     * 
     * @param searchret search ̖߂l
     * 
     * @return vʒu
     */
    public static final int getMatchPos( int searchret ){
        if( 0 <= searchret ) return searchret & 0x3FFFFF;
        else                 return -1;
    }

}
//end of LzssOutputStream.java
