/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBufferImpl;
import java.nio.ShortBuffer;
import java.nio.ShortBufferImpl;

class DirectShortBuffer
extends ShortBufferImpl {
    DirectShortBuffer(ByteBufferImpl byteBufferImpl, int n, int n2) {
        super(byteBufferImpl, n, null, n2);
    }

    public boolean isDirect() {
        return true;
    }

    public ShortBuffer slice() {
        return new DirectShortBuffer(this.parent, this.limit - this.position, this.arrayOffset + (this.position << 1));
    }

    public short get(int n) {
        return ByteBufferImpl._getShort(this.arrayOffset + (this.checkIndex(n) << 1));
    }

    final void copyToArray(short[] sArray, int n, int n2) {
        ByteBufferImpl.memoryToShortArray(this.arrayOffset + (this.position << 1), sArray, n, n2);
    }

    public ShortBuffer put(int n, short s) {
        ByteBufferImpl._putShort(this.arrayOffset + (this.checkIndex(n) << 1), s);
        return this;
    }

    void copyFromArray(short[] sArray, int n, int n2) {
        ByteBufferImpl.shortArrayToMemory(sArray, n, this.arrayOffset + (this.position << 1), n2);
    }

    void copyToShortBuffer(int n, ShortBuffer shortBuffer) {
        shortBuffer.copyFromDirectShortBuffer(this, n);
    }

    void copyFromHeapShortBuffer(ShortBuffer shortBuffer, int n) {
        ByteBufferImpl.shortArrayToMemory(shortBuffer.array, shortBuffer.arrayOffset + shortBuffer.position, this.arrayOffset + (this.position << 1), n);
    }

    void copyFromByteBufferAsShortBuffer(ShortBuffer shortBuffer, int n) {
        byte[] byArray = shortBuffer.parent.array;
        int n2 = shortBuffer.parent.arrayOffset + shortBuffer.arrayOffset + (shortBuffer.position << 1);
        int n3 = this.arrayOffset + (this.position << 1);
        ByteBufferImpl.byteArrayToMemory(byArray, n2, n3, n << 1);
    }

    void copyFromDirectShortBuffer(ShortBuffer shortBuffer, int n) {
        int n2 = shortBuffer.arrayOffset + (shortBuffer.position << 1);
        int n3 = this.arrayOffset + (this.position << 1);
        ByteBufferImpl._copyBytes(n2, n3, n << 1);
    }
}

