/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private Comparator comparator = null;
    private transient Entry root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private volatile transient Set entrySet = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    public TreeMap() {
    }

    public TreeMap(Comparator comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map map) {
        this.putAll(map);
    }

    public TreeMap(SortedMap sortedMap) {
        this.comparator = sortedMap.comparator();
        try {
            this.buildFromSorted(sortedMap.size(), sortedMap.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    public boolean containsValue(Object object) {
        return this.root == null ? false : (object == null ? this.valueSearchNull(this.root) : this.valueSearchNonNull(this.root, object));
    }

    private boolean valueSearchNull(Entry entry) {
        if (entry.value == null) {
            return true;
        }
        return entry.left != null && this.valueSearchNull(entry.left) || entry.right != null && this.valueSearchNull(entry.right);
    }

    private boolean valueSearchNonNull(Entry entry, Object object) {
        if (object.equals(entry.value)) {
            return true;
        }
        return entry.left != null && this.valueSearchNonNull(entry.left, object) || entry.right != null && this.valueSearchNonNull(entry.right, object);
    }

    public Object get(Object object) {
        Entry entry = this.getEntry(object);
        return entry == null ? null : entry.value;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public Object firstKey() {
        return TreeMap.key(this.firstEntry());
    }

    public Object lastKey() {
        return TreeMap.key(this.lastEntry());
    }

    public void putAll(Map map) {
        Comparator comparator;
        int n = map.size();
        if (this.size == 0 && n != 0 && map instanceof SortedMap && ((comparator = ((SortedMap)map).comparator()) == this.comparator || comparator != null && ((Object)comparator).equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(n, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    private Entry getEntry(Object object) {
        Entry entry = this.root;
        while (entry != null) {
            int n = this.compare(object, entry.key);
            if (n == 0) {
                return entry;
            }
            if (n < 0) {
                entry = entry.left;
                continue;
            }
            entry = entry.right;
        }
        return null;
    }

    private Entry getCeilEntry(Object object) {
        Entry entry = this.root;
        if (entry == null) {
            return null;
        }
        while (true) {
            int n;
            if ((n = this.compare(object, entry.key)) == 0) {
                return entry;
            }
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (entry.right == null) break;
            entry = entry.right;
        }
        Entry entry2 = entry.parent;
        Entry entry3 = entry;
        while (entry2 != null && entry3 == entry2.right) {
            entry3 = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    private Entry getPrecedingEntry(Object object) {
        Entry entry = this.root;
        if (entry == null) {
            return null;
        }
        while (true) {
            int n;
            if ((n = this.compare(object, entry.key)) > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (entry.left == null) break;
            entry = entry.left;
        }
        Entry entry2 = entry.parent;
        Entry entry3 = entry;
        while (entry2 != null && entry3 == entry2.left) {
            entry3 = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    private static Object key(Entry entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.key;
    }

    public Object put(Object object, Object object2) {
        Entry entry = this.root;
        if (entry == null) {
            this.incrementSize();
            this.root = new Entry(object, object2, null);
            return null;
        }
        while (true) {
            int n;
            if ((n = this.compare(object, entry.key)) == 0) {
                return entry.setValue(object2);
            }
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize();
                entry.left = new Entry(object, object2, entry);
                this.fixAfterInsertion(entry.left);
                return null;
            }
            if (entry.right == null) break;
            entry = entry.right;
        }
        this.incrementSize();
        entry.right = new Entry(object, object2, entry);
        this.fixAfterInsertion(entry.right);
        return null;
    }

    public Object remove(Object object) {
        Entry entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        Object object2 = entry.value;
        this.deleteEntry(entry);
        return object2;
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    public Object clone() {
        TreeMap treeMap = null;
        try {
            treeMap = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        treeMap.root = null;
        treeMap.size = 0;
        treeMap.modCount = 0;
        treeMap.entrySet = null;
        try {
            treeMap.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return treeMap;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new KeyIterator();
                }

                public int size() {
                    return TreeMap.this.size();
                }

                public boolean contains(Object object) {
                    return TreeMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = TreeMap.this.size;
                    TreeMap.this.remove(object);
                    return TreeMap.this.size != n;
                }

                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return TreeMap.this.size();
                }

                public boolean contains(Object object) {
                    Entry entry = TreeMap.this.firstEntry();
                    while (entry != null) {
                        if (TreeMap.valEquals(entry.getValue(), object)) {
                            return true;
                        }
                        entry = TreeMap.this.successor(entry);
                    }
                    return false;
                }

                public boolean remove(Object object) {
                    Entry entry = TreeMap.this.firstEntry();
                    while (entry != null) {
                        if (TreeMap.valEquals(entry.getValue(), object)) {
                            TreeMap.this.deleteEntry(entry);
                            return true;
                        }
                        entry = TreeMap.this.successor(entry);
                    }
                    return false;
                }

                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new EntryIterator();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = entry.getValue();
                    Entry entry2 = TreeMap.this.getEntry(entry.getKey());
                    return entry2 != null && TreeMap.valEquals(entry2.getValue(), object2);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object2 = entry.getValue();
                    Entry entry2 = TreeMap.this.getEntry(entry.getKey());
                    if (entry2 != null && TreeMap.valEquals(entry2.getValue(), object2)) {
                        TreeMap.this.deleteEntry(entry2);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return TreeMap.this.size();
                }

                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    public SortedMap subMap(Object object, Object object2) {
        return new SubMap(object, object2);
    }

    public SortedMap headMap(Object object) {
        return new SubMap(object, true);
    }

    public SortedMap tailMap(Object object) {
        return new SubMap(object, false);
    }

    private int compare(Object object, Object object2) {
        return this.comparator == null ? ((Comparable)object).compareTo(object2) : this.comparator.compare(object, object2);
    }

    private static boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private Entry firstEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        return entry;
    }

    private Entry lastEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.right != null) {
                entry = entry.right;
            }
        }
        return entry;
    }

    private Entry successor(Entry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            Entry entry2 = entry.right;
            while (entry2.left != null) {
                entry2 = entry2.left;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry entry4 = entry;
        while (entry3 != null && entry4 == entry3.right) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    private static boolean colorOf(Entry entry) {
        return entry == null ? true : entry.color;
    }

    private static Entry parentOf(Entry entry) {
        return entry == null ? null : entry.parent;
    }

    private static void setColor(Entry entry, boolean bl) {
        if (entry != null) {
            entry.color = bl;
        }
    }

    private static Entry leftOf(Entry entry) {
        return entry == null ? null : entry.left;
    }

    private static Entry rightOf(Entry entry) {
        return entry == null ? null : entry.right;
    }

    private void rotateLeft(Entry entry) {
        Entry entry2 = entry.right;
        entry.right = entry2.left;
        if (entry2.left != null) {
            entry2.left.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry.parent.left == entry) {
            entry.parent.left = entry2;
        } else {
            entry.parent.right = entry2;
        }
        entry2.left = entry;
        entry.parent = entry2;
    }

    private void rotateRight(Entry entry) {
        Entry entry2 = entry.left;
        entry.left = entry2.right;
        if (entry2.right != null) {
            entry2.right.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry.parent.right == entry) {
            entry.parent.right = entry2;
        } else {
            entry.parent.left = entry2;
        }
        entry2.right = entry;
        entry.parent = entry2;
    }

    private void fixAfterInsertion(Entry entry) {
        entry.color = false;
        while (entry != null && entry != this.root && !entry.parent.color) {
            Entry entry2;
            if (TreeMap.parentOf(entry) == TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(TreeMap.parentOf(entry), true);
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                    entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                    continue;
                }
                if (entry == TreeMap.rightOf(TreeMap.parentOf(entry))) {
                    entry = TreeMap.parentOf(entry);
                    this.rotateLeft(entry);
                }
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                if (TreeMap.parentOf(TreeMap.parentOf(entry)) == null) continue;
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(entry)));
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                continue;
            }
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry = TreeMap.parentOf(entry);
                this.rotateRight(entry);
            }
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
            if (TreeMap.parentOf(TreeMap.parentOf(entry)) == null) continue;
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(entry)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry entry) {
        Entry entry2;
        this.decrementSize();
        if (entry.left != null && entry.right != null) {
            entry2 = this.successor(entry);
            entry.key = entry2.key;
            entry.value = entry2.value;
            entry = entry2;
        }
        Entry entry3 = entry2 = entry.left != null ? entry.left : entry.right;
        if (entry2 != null) {
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry == entry.parent.left) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry.parent = null;
            entry.right = null;
            entry.left = null;
            if (entry.color) {
                this.fixAfterDeletion(entry2);
            }
        } else if (entry.parent == null) {
            this.root = null;
        } else {
            if (entry.color) {
                this.fixAfterDeletion(entry);
            }
            if (entry.parent != null) {
                if (entry == entry.parent.left) {
                    entry.parent.left = null;
                } else if (entry == entry.parent.right) {
                    entry.parent.right = null;
                }
                entry.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry entry) {
        while (entry != this.root && TreeMap.colorOf(entry)) {
            Entry entry2;
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(entry), false);
                    this.rotateLeft(TreeMap.parentOf(entry));
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(entry2)) && TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(entry2, false);
                    entry = TreeMap.parentOf(entry);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(TreeMap.leftOf(entry2), true);
                    TreeMap.setColor(entry2, false);
                    this.rotateRight(entry2);
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                this.rotateLeft(TreeMap.parentOf(entry));
                entry = this.root;
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(entry), false);
                this.rotateRight(TreeMap.parentOf(entry));
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(entry2)) && TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(entry2, false);
                entry = TreeMap.parentOf(entry);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                TreeMap.setColor(entry2, false);
                this.rotateLeft(entry2);
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.leftOf(entry2), true);
            this.rotateRight(TreeMap.parentOf(entry));
            entry = this.root;
        }
        TreeMap.setColor(entry, true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            objectOutputStream.writeObject(entry.key);
            objectOutputStream.writeObject(entry.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.buildFromSorted(n, null, objectInputStream, null);
    }

    void readTreeSet(int n, ObjectInputStream objectInputStream, Object object) throws IOException, ClassNotFoundException {
        this.buildFromSorted(n, null, objectInputStream, object);
    }

    void addAllForTreeSet(SortedSet sortedSet, Object object) {
        try {
            this.buildFromSorted(sortedSet.size(), sortedSet.iterator(), null, object);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int n, Iterator iterator, ObjectInputStream objectInputStream, Object object) throws IOException, ClassNotFoundException {
        this.size = n;
        this.root = TreeMap.buildFromSorted(0, 0, n - 1, TreeMap.computeRedLevel(n), iterator, objectInputStream, object);
    }

    private static Entry buildFromSorted(int n, int n2, int n3, int n4, Iterator iterator, ObjectInputStream objectInputStream, Object object) throws IOException, ClassNotFoundException {
        Object object2;
        Object object3;
        Map.Entry entry;
        if (n3 < n2) {
            return null;
        }
        int n5 = (n2 + n3) / 2;
        Entry entry2 = null;
        if (n2 < n5) {
            entry2 = TreeMap.buildFromSorted(n + 1, n2, n5 - 1, n4, iterator, objectInputStream, object);
        }
        if (iterator != null) {
            if (object == null) {
                entry = (Map.Entry)iterator.next();
                object3 = entry.getKey();
                object2 = entry.getValue();
            } else {
                object3 = iterator.next();
                object2 = object;
            }
        } else {
            object3 = objectInputStream.readObject();
            object2 = object != null ? object : objectInputStream.readObject();
        }
        entry = new Entry(object3, object2, null);
        if (n == n4) {
            ((Entry)entry).color = false;
        }
        if (entry2 != null) {
            ((Entry)entry).left = entry2;
            entry2.parent = entry;
        }
        if (n5 < n3) {
            Entry entry3;
            ((Entry)entry).right = entry3 = TreeMap.buildFromSorted(n + 1, n5 + 1, n3, n4, iterator, objectInputStream, object);
            entry3.parent = entry;
        }
        return entry;
    }

    private static int computeRedLevel(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            ++n2;
            n3 = n3 / 2 - 1;
        }
        return n2;
    }

    static class Entry
    implements Map.Entry {
        Object key;
        Object value;
        Entry left = null;
        Entry right = null;
        Entry parent;
        boolean color = true;

        Entry(Object object, Object object2, Entry entry) {
            this.key = object;
            this.value = object2;
            this.parent = entry;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return TreeMap.valEquals(this.key, entry.getKey()) && TreeMap.valEquals(this.value, entry.getValue());
        }

        public int hashCode() {
            int n = this.key == null ? 0 : this.key.hashCode();
            int n2 = this.value == null ? 0 : this.value.hashCode();
            return n ^ n2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class SubMapEntryIterator
    extends EntryIterator {
        private final Object firstExcludedKey;

        SubMapEntryIterator(Entry entry, Entry entry2) {
            super(entry);
            this.firstExcludedKey = entry2 == null ? entry2 : entry2.key;
        }

        public boolean hasNext() {
            return this.next != null && this.next.key != this.firstExcludedKey;
        }

        public Object next() {
            if (this.next == null || this.next.key == this.firstExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().key;
        }
    }

    private class EntryIterator
    implements Iterator {
        private int expectedModCount;
        private Entry lastReturned;
        Entry next;

        EntryIterator() {
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.next = TreeMap.this.firstEntry();
        }

        EntryIterator(Entry entry) {
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.next = entry;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        final Entry nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = TreeMap.this.successor(this.next);
            return this.lastReturned;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            TreeMap.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    private class SubMap
    extends AbstractMap
    implements SortedMap,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart = false;
        private boolean toEnd = false;
        private Object fromKey;
        private Object toKey;
        private transient Set entrySet = new EntrySetView();

        SubMap(Object object, Object object2) {
            if (TreeMap.this.compare(object, object2) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = object;
            this.toKey = object2;
        }

        SubMap(Object object, boolean bl) {
            TreeMap.this.compare(object, object);
            if (bl) {
                this.fromStart = true;
                this.toKey = object;
            } else {
                this.toEnd = true;
                this.fromKey = object;
            }
        }

        SubMap(boolean bl, Object object, boolean bl2, Object object2) {
            this.fromStart = bl;
            this.fromKey = object;
            this.toEnd = bl2;
            this.toKey = object2;
        }

        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.inRange(object) && TreeMap.this.containsKey(object);
        }

        public Object get(Object object) {
            if (!this.inRange(object)) {
                return null;
            }
            return TreeMap.this.get(object);
        }

        public Object put(Object object, Object object2) {
            if (!this.inRange(object)) {
                throw new IllegalArgumentException("key out of range");
            }
            return TreeMap.this.put(object, object2);
        }

        public Comparator comparator() {
            return TreeMap.this.comparator;
        }

        public Object firstKey() {
            Object object = TreeMap.key(this.fromStart ? TreeMap.this.firstEntry() : TreeMap.this.getCeilEntry(this.fromKey));
            if (!this.toEnd && TreeMap.this.compare(object, this.toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return object;
        }

        public Object lastKey() {
            Object object = TreeMap.key(this.toEnd ? TreeMap.this.lastEntry() : TreeMap.this.getPrecedingEntry(this.toKey));
            if (!this.fromStart && TreeMap.this.compare(object, this.fromKey) < 0) {
                throw new NoSuchElementException();
            }
            return object;
        }

        public Set entrySet() {
            return this.entrySet;
        }

        public SortedMap subMap(Object object, Object object2) {
            if (!this.inRange2(object)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(object2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(object, object2);
        }

        public SortedMap headMap(Object object) {
            if (!this.inRange2(object)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromStart, this.fromKey, false, object);
        }

        public SortedMap tailMap(Object object) {
            if (!this.inRange2(object)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(false, object, this.toEnd, this.toKey);
        }

        private boolean inRange(Object object) {
            return !(!this.fromStart && TreeMap.this.compare(object, this.fromKey) < 0 || !this.toEnd && TreeMap.this.compare(object, this.toKey) >= 0);
        }

        private boolean inRange2(Object object) {
            return !(!this.fromStart && TreeMap.this.compare(object, this.fromKey) < 0 || !this.toEnd && TreeMap.this.compare(object, this.toKey) > 0);
        }

        private class EntrySetView
        extends AbstractSet {
            private transient int size = -1;
            private transient int sizeModCount;

            private EntrySetView() {
            }

            public int size() {
                if (this.size == -1 || this.sizeModCount != TreeMap.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = TreeMap.this.modCount;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        ++this.size;
                        iterator.next();
                    }
                }
                return this.size;
            }

            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object object2 = entry.getKey();
                if (!SubMap.this.inRange(object2)) {
                    return false;
                }
                Entry entry2 = TreeMap.this.getEntry(object2);
                return entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue());
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object object2 = entry.getKey();
                if (!SubMap.this.inRange(object2)) {
                    return false;
                }
                Entry entry2 = TreeMap.this.getEntry(object2);
                if (entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue())) {
                    TreeMap.this.deleteEntry(entry2);
                    return true;
                }
                return false;
            }

            public Iterator iterator() {
                return new SubMapEntryIterator(SubMap.this.fromStart ? TreeMap.this.firstEntry() : TreeMap.this.getCeilEntry(SubMap.this.fromKey), SubMap.this.toEnd ? null : TreeMap.this.getCeilEntry(SubMap.this.toKey));
            }
        }
    }
}

