#include "mzcbormsfilereader.h"

#include "pappsomspp/core/processing/uimonitor/uimonitorvoid.h"
#include "pappsomspp/core/utils.h"

#include <QFileInfo>

namespace pappso
{


MzcborMsFileReader::MzcborMsFileReader(const QString &file_name) : MsFileReader{file_name}
{
  m_fileFormat = pappso::Enums::MsDataFormat::unknown;
  initialize();
}


MzcborMsFileReader::~MzcborMsFileReader()
{
}


Enums::MsDataFormat
MzcborMsFileReader::getFileFormat()
{
  // std::cout << __FILE__ << " @ " << __LINE__ << " " << __FUNCTION__ << " () "
  //        << std::setprecision(15) << "m_fileFormat: " << (int)m_fileFormat
  //      << std::endl;

  return m_fileFormat;
}

std::size_t
pappso::MzcborMsFileReader::initialize()
{

  pappso::UiMonitorVoid monitor;
  QString str_index_file = m_fileName;
  QFileInfo mzcbor_index_fileinfo(str_index_file.append(".idx"));
  if(mzcbor_index_fileinfo.exists())
    {
      qDebug() << "mzcbor_index_fileinfo.exists()";
      QFile mzcbor_index_file(mzcbor_index_fileinfo.absoluteFilePath());
      mzcbor_index_file.open(QIODevice::ReadOnly);

      m_mzcborIndexReader.readCbor(&mzcbor_index_file);
      if(m_mzcborIndexReader.isMzcborIndex())
        {
          m_fileFormat = pappso::Enums::MsDataFormat::mzcbor;
        }
      m_mzcborIndexReader.close();
      mzcbor_index_file.close();

      qDebug() << m_mzcborIndexReader.getRunIdList().size();

      return m_mzcborIndexReader.getRunIdList().size();
    }
  else
    {
      qDebug();
      QFile mzcbor_file(m_fileName);
      mzcbor_file.open(QIODevice::ReadOnly);

      m_mzcborReaderBase.readCbor(&mzcbor_file, monitor);
      if(m_mzcborReaderBase.isMzcbor())
        {
          m_fileFormat = pappso::Enums::MsDataFormat::mzcbor;
        }
      m_mzcborReaderBase.close();
      mzcbor_file.close();

      qDebug() << m_mzcborReaderBase.getMsrunIdList().join(" ");

      return m_mzcborReaderBase.getMsrunIdList().size();
    }
}


std::vector<MsRunIdCstSPtr>
MzcborMsFileReader::getMsRunIds(const QString &run_prefix)
{
  std::vector<MsRunIdCstSPtr> ms_run_ids;


  if(m_fileFormat == pappso::Enums::MsDataFormat::mzcbor)
    {

      if(m_mzcborIndexReader.getRunIdList().size() > 0)
        {
          qDebug();
          std::size_t iter = 0;
          for(auto &msrun_id_str : m_mzcborIndexReader.getRunIdList())
            {
              MsRunId ms_run_id(m_fileName, msrun_id_str);


              // Set the MS data format as determined in initialize().
              ms_run_id.setMsDataFormat(m_fileFormat);

              // We need to set the unambiguous xmlId string.
              ms_run_id.setXmlId(
                QString("%1%2").arg(run_prefix).arg(Utils::getLexicalOrderedString(iter)));

              // Now set the sample name to the run id : we can not do that, this is not the use
              // sample name ms_run_id.setSampleName(QString::fromStdString(ms_data_ptr->run.id));

              // And if it is possible, the real sample name because this one is for the
              // end user to recognize his sample:
              ms_run_id.setSampleName(msrun_id_str);


              ms_run_ids.push_back(std::make_shared<MsRunId>(ms_run_id));
              iter++;
            }
        }
      else
        {

          std::size_t iter = 0;
          for(auto &msrun_id_str : m_mzcborReaderBase.getMsrunIdList())
            {
              MsRunId ms_run_id(m_fileName, msrun_id_str);


              // Set the MS data format as determined in initialize().
              ms_run_id.setMsDataFormat(m_fileFormat);

              // We need to set the unambiguous xmlId string.
              ms_run_id.setXmlId(
                QString("%1%2").arg(run_prefix).arg(Utils::getLexicalOrderedString(iter)));

              // Now set the sample name to the run id : we can not do that, this is not the use
              // sample name ms_run_id.setSampleName(QString::fromStdString(ms_data_ptr->run.id));

              // And if it is possible, the real sample name because this one is for the
              // end user to recognize his sample:
              ms_run_id.setSampleName(msrun_id_str);


              ms_run_ids.push_back(std::make_shared<MsRunId>(ms_run_id));
              iter++;
            }
        }
    }

  return ms_run_ids;
}
} // namespace pappso
