-- rawCharSeries bug giving what appears to be an incorrect answer.
-- also in 00-rawCharSeries.m2, 00-bug-radical

-----------------
-- example from: 00-bug-radical
-----------------
restart
errorDepth=0
debug Core
Istring = "ideal((v2-1)*(v3-1),
  (v4+1)*(v7+1),
  (v2-1)*(v5-1)*(v6+1),
  (v2+1)*(v6+1)*(v7-1),
  (v1-1)*(v5-1)*(v7+v4),
  v7*v6*v1+v7*v6+v7*v2*v1+v7*v2+2*v6*v4-v6*v1+v6-v4*v3*v1+v4*v3+2*v4*v2-v4*v1+v4-v3*v1+v3-v2*v1+v2-v1+1,
  (v1-1)*(v3+v2)*(v4+1),
  (v1+1)*(v3-1)*(v5-1)*(v6+1),
  (v1-1)*(v3+1)*(v4+1)*(v6+1),
  (v1-1)*(v3+1)*(v4+1)*(v5-1),
  (v1-1)*(v2-1)*(v5-1)*(v7-1))"
codim4primes = "
  {ideal (v2 - 1, v4 + 1, v5 - 1, v6 + 1),
   ideal (v3 - 1, v4 + 1, v5 - 1, v7 - 1),
   ideal (v3 - 1, v4 + 1, v6 + 1, v7 - 1),
   ideal (v2 - 1, v4 + 1, v6 + 1, v7 - 1),
   ideal (v2 - 1, v3 - 1, v4 + 1, v7 - 1),
   ideal (v1 + 1, v2 - 1, v4 + 1, v7 - 1),
   ideal (v2 - 1, v4 + 1, v5 - 1, v7 - 1),
   ideal (v1 - 1, v2 - 1, v4 + 1, v6 + 1),
   ideal (v1 - 1, v2 - 1, v6 + 1, v7 + 1)}"

R1 = QQ[v7,v6,v5,v4,v3,v2,v1, MonomialOrder=>Lex]
I1 = value Istring
P41 = value codim4primes
for p in P41 list (((gens I1)%p) == 0)
P1 = ideal(v1+1,v2-1,v4+1,v7-1)
assert((gens I1) % P1 == 0)
assert(degree I1 == 9)
assert(codim I1 == 4)

R2 = ZZ/101[v7,v6,v5,v4,v3,v2,v1, MonomialOrder=>Lex]
I2 = value Istring
P42 = value codim4primes
for p in P42 list (((gens I2)%p) == 0)
P2 = ideal(v1+1,v2-1,v4+1,v7-1)
assert((gens I2) % P2 == 0)
assert(degree I1 == 9)
assert(codim I1 == 4)

C1 = rawCharSeries raw gens I1 -- this is WRONG (seems to me to be wrong, at least)
C2 = rawCharSeries raw gens I2 -- also seems wrong?  But different from C1!
-- there should be 9 codim 4 components, all degree 1.
-- one should be this one:

-- answer for C1, before "contract" (obtained by stopping in libfac/charset/charsetcc at end of IrrCharSeries,
--   before contract is run.  second part is also obtained through the debugger.
-- 54 char sets, only 6 codim 4 components listed!  It is missing 3!!
( ( v3-1, v4+1, v6+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
 ( v3-1, v4+1, v5-1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1 ),
 ( v3-1, v4+1, v5-1, v6+1, v1*v2*v7+1*v2*v7-v1*v7-1*v7-v1*v2-1*v2+v1+1 ),
 ( v2-1, v4+1, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v5*v7-1*v5*v7-v1*v7+1*v7-v1*v5+1*v5+v1-1 ),
 ( v2-1, v4+1, v5-1, v6+1 ),
 ( v1-1, v2-1, v3*v5-1*v5-v3+1, v6+1, v7+1 ),
 ( v1-1, v2-1, v3-1, v6+1, v7+1 ),
 ( v1-1, v2-1, v3-1, v4+1, v6+1 ),
 ( v1-1, v2-1, v4+1, v3*v5-1*v5-v3+1, v6+1 ),
 ( v2-1, v3+1, v5-1, v6+1, v7+1 ),
 ( v1+1, v2-1, v3+1, v5-1, v6+1, v7+1 ),
 ( v1+1, v2-1, v3+1, v4-1, v6+1, v7+1 ),
 ( v1+1, v2-1, v3+1, v4+1, v6+1, v7-1 ),
 ( v1+1, v2-1, v3+1, v4+1, v5-1, v6+1 ),
 ( v2-1, v3+1, v4+1, v5-1, v6+1 ),
 ( v1+1, v3-1, v4+1, v5-1, v6+1 ),
 ( v1+1, v2-1, v4+1, v6+1, v5*v7-1*v7-v5+1 ),
 ( v1+1, v2-1, v4+1, v5-1, v6+1 ),
 ( v1+1, v2+1, v3-1, v5-1, v6+1, v7+1 ),
 ( v1+1, v2+1, v3-1, v4+1, v5-1 ),
 ( v2-1, v3-1, v4+1, v6+1, v1*v5*v7-1*v5*v7-v1*v7+1*v7-v1*v5+1*v5+v1-1 ),
 ( v2-1, v3-1, v4+1, v5-1, v6+1 ),
 ( v1-1, v2-1, v3+1, v6+1, v7+1 ),
 ( v1-1, v2-1, v3+1, v4+1, v6+1 ),
 ( v1-1, v2-1, v6+1, v7+1 ),
 ( v1-1, v2-1, v4+1, v6+1 ),
 ( v2-1, v3+1, v4-1, v6+1, v7+1 ),
 ( v2-1, v3+1, v4+1, v6+1, v7-1 ),
 ( v1-1, v3-1, v4+1, v6+1, v7-1 ),
 ( v1-1, v2+1, v3-1, v4+1, v6+1, v7-1 ),
 ( v1-1, v2+1, v3-1, v4+1, v5-1, v7-1 ),
 ( v1-1, v2+1, v3-1, v4+1, v5-1, v6-1 ),
 ( v1-1, v3-1, v4-1, v6+1, v7+1 ),
 ( v1-1, v2+1, v3-1, v4-1, v6+1, v7+1 ),
 ( v1-1, v2+1, v3-1, v4-1, v5-1, v7+1 ),
 ( v1-1, v2+1, v3-1, v5-1, v6-1, v7+1 ),
 ( v2+1, v3-1, v4+1, v5-1, v7-1 ),
 ( v2+1, v3-1, v4+1, v5-1, v6-1 ),
 ( v2+1, v3-1, v4-1, v5-1, v6+1, v7+1 ),
 ( v2+1, v3-1, v4+1, v5-1, v1*v6*v7+1*v6*v7-v1*v7-1*v7-v1*v6-1*v6+v1+1 ),
 ( v1-1, v3-1, v2^2*v4-1*v4-v2^2+1, v5-1, v2*v6+1*v6+v2+1, v7+1 ),
 ( v1-1, v2-1, v3-1, v4+1, v7-1 ),
 ( v1-1, v2-1, v4+1, v5-1, v7-1 ),
 ( v1-1, v2-1, v4+1, v5-1, v6+1 ),
 ( v1-1, v3-1, v4-1, v5-1, v6+1, v7+1 ),
 ( v1-1, v3-1, v4+1, v5-1, v7-1 ),
 ( v1-1, v3-1, v4+1, v5-1, v6+1, v7-1 ),
 ( v2-1, v3+1, v4-1, v5-1, v6+1, v7+1 ),
 ( v1+1, v2-1, v3+1, v4+1, v7-1 ),
 ( v1+1, v2-1, v3+1, v4+1, v5-1, v7-1 ),
 ( v2-1, v3+1, v4+1, v5-1, v7-1 ),
 ( v2+1, v3-1, v4+1, v6+1, v7-1 ),
 ( v1+1, v2+1, v3-1, v4+1, v6+1, v7-1 ),
 ( v2+1, v3-1, v4+1, v5*v6-1*v6+v5-1, v7-1 ) )

-- C1 after contract:
-- 25 here, still only 6 of codim 4. (same on ubuntu and mac rMBP)
( ( v3-1, v4+1, v6+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
 ( v3-1, v4+1, v5-1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1 ),
 ( v3-1, v4+1, v5-1, v6+1, v1*v2*v7+1*v2*v7-v1*v7-1*v7-v1*v2-1*v2+v1+1 ),
 ( v2-1, v4+1, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v5*v7-1*v5*v7-v1*v7+1*v7-v1*v5+1*v5+v1-1 ),
 ( v2-1, v4+1, v5-1, v6+1 ),
 ( v2-1, v3+1, v5-1, v6+1, v7+1 ),
 ( v1+1, v3-1, v4+1, v5-1, v6+1 ),
 ( v1+1, v2-1, v4+1, v6+1, v5*v7-1*v7-v5+1 ),
 ( v1+1, v2+1, v3-1, v5-1, v6+1, v7+1 ),
 ( v1+1, v2+1, v3-1, v4+1, v5-1 ),
 ( v2-1, v3-1, v4+1, v6+1, v1*v5*v7-1*v5*v7-v1*v7+1*v7-v1*v5+1*v5+v1-1 ),
 ( v1-1, v2-1, v6+1, v7+1 ),
 ( v1-1, v2-1, v4+1, v6+1 ),
 ( v2-1, v3+1, v4-1, v6+1, v7+1 ),
 ( v1-1, v3-1, v4+1, v6+1, v7-1 ),
 ( v1-1, v3-1, v4-1, v6+1, v7+1 ),
 ( v1-1, v2+1, v3-1, v4-1, v5-1, v7+1 ),
 ( v1-1, v2+1, v3-1, v5-1, v6-1, v7+1 ),
 ( v2+1, v3-1, v4+1, v5-1, v7-1 ),
 ( v2+1, v3-1, v4+1, v5-1, v6-1 ),
 ( v2+1, v3-1, v4-1, v5-1, v6+1, v7+1 ),
 ( v1-1, v2-1, v3-1, v4+1, v7-1 ),
 ( v1-1, v2-1, v4+1, v5-1, v7-1 ),
 ( v1+1, v2-1, v3+1, v4+1, v7-1 ),
 ( v2-1, v3+1, v4+1, v5-1, v7-1 ) )

-- C2 before contract:
-- 92 total, 12 of codim 4
( ( 100*v3+1, v4+1, v6+1, v1*v2*v5*v7+100*v2*v5*v7+100*v1*v5*v7+1*v5*v7+100*v1*v2*v7+1*v2*v7+v1*v7+100*v7+100*v1*v2*v5+1*v2*v5+v1*v5+100*v5+v1*v2+100*v2+100*v1+1 ),
 ( 100*v3+1, v4+1, 100*v5+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7+100*v2*v6+100*v6+100*v2+100 ),
 ( 100*v3+1, v4+1, 100*v5+1, v6+1, v1*v2*v7+1*v2*v7+100*v1*v7+100*v7+100*v1*v2+100*v2+v1+1 ),
 ( 100*v2+1, v4+1, v1*v3*v5*v6+1*v3*v5*v6+100*v1*v5*v6+100*v5*v6+100*v1*v3*v6+100*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5+100*v1*v5+100*v5+100*v1*v3+100*v3+v1+1, v1*v5*v7+100*v5*v7+100*v1*v7+1*v7+100*v1*v5+1*v5+v1+100 ),
 ( 100*v2+1, v4+1, 100*v5+1, v6+1 ),
 ( 100*v2+1, v3+1, 100*v5+1, v6+1, v7+1 ),
 ( v1+1, v2+100, v3+1, 100*v5+1, v6+1, v7+1 ),
 ( v1+1, v2+100, v3+1, v4+100, v6+1, v7+1 ),
 ( v1+1, v2+100, v3+1, v4+1, v6+1, 100*v7+1 ),
 ( v1+1, v2+100, v3+1, v4+1, v5+100, v6+1 ),
 ( 100*v2+1, v3+1, v4+1, 100*v5+1, v6+1 ),
 ( v1+100, v2+100, v3*v5+100*v5+100*v3+1, v6+1, v7+1 ),
 ( v1+100, v2+100, v3+100, v6+1, v7+1 ),
 ( v1+100, v2+100, v3+100, v4+1, v6+1 ),
 ( v1+100, v2+100, v4+1, v3*v5+100*v5+100*v3+1, v6+1 ),
 ( 100*v2+1, v3+100, v4+1, v6+1, v1*v5*v7+100*v5*v7+100*v1*v7+1*v7+100*v1*v5+1*v5+v1+100 ),
 ( 100*v2+1, v3+100, v4+1, 100*v5+1, v6+1 ),
 ( v1+1, v3+100, v4+1, v5+100, v6+1 ),
 ( v1+1, v2+1, v3+100, v5+100, v6+1, v7+1 ),
 ( v1+1, v2+1, v3+100, v4+1, v5+100 ),
 ( v1+1, v3+100, v4+1, 100*v5+1, v6+1 ),
 ( v1+1, v2+100, v3+100, v4+1, v6+1, v5*v7+100*v7+100*v5+1 ),
 ( v1+1, v2+100, v3+100, v4+1, v5+100, v6+1 ),
 ( v1+1, 100*v3+1, v4+1, 100*v5+1, v6+1 ),
 ( v1+1, v2+100, v4+1, v6+1, v5*v7+100*v7+100*v5+1 ),
 ( v1+1, v2+100, v4+1, v5+100, v6+1 ),
 ( v1+100, v2+100, v3+1, v6+1, v7+1 ),
 ( v1+100, v2+100, v3+1, v4+1, v6+1 ),
 ( v1+1, v2+100, v3+1, v5+100, v6+1, v7+1 ),
 ( v1+1, 100*v3+1, v4+1, v5+100, v6+1 ),
 ( v1+100, v2+100, v6+1, v7+1 ),
 ( v1+100, v2+100, v4+1, v6+1 ),
 ( 100*v2+1, v3+1, v4+100, v6+1, v7+1 ),
 ( 100*v2+1, v3+1, v4+1, v6+1, 100*v7+1 ),
 ( 100*v2+1, v3+1, v4+1, v5+100, v6+1 ),
 ( v2+100, v4+1, v1*v3*v5*v6+1*v3*v5*v6+100*v1*v5*v6+100*v5*v6+100*v1*v3*v6+100*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5+100*v1*v5+100*v5+100*v1*v3+100*v3+v1+1, v1*v5*v7+100*v5*v7+100*v1*v7+1*v7+100*v1*v5+1*v5+v1+100 ),
 ( v2+100, v4+1, 100*v5+1, v6+1 ),
 ( v2+100, v3+1, 100*v5+1, v6+1, v7+1 ),
 ( v2+100, v3+1, v4+1, 100*v5+1, v6+1 ),
 ( v1+100, v2+100, 100*v5+1, v6+1, v7+1 ),
 ( v1+100, v2+100, v4+1, 100*v5+1, v6+1 ),
 ( v2+100, v3+100, v4+1, v6+1, v1*v5*v7+100*v5*v7+100*v1*v7+1*v7+100*v1*v5+1*v5+v1+100 ),
 ( v2+100, v3+100, v4+1, 100*v5+1, v6+1 ),
 ( v2+100, v3+1, v4+100, v6+1, v7+1 ),
 ( v2+100, v3+1, v4+1, v6+1, 100*v7+1 ),
 ( v2+100, v3+1, v4+1, v5+100, v6+1 ),
 ( v1+100, 100*v3+1, v4+1, v6+1, 100*v7+1 ),
 ( v1+100, v2+1, 100*v3+1, v4+1, v6+1, 100*v7+1 ),
 ( v1+100, v2+1, 100*v3+1, v4+1, v5+100, 100*v7+1 ),
 ( v1+100, v2+1, 100*v3+1, v4+1, v5+100, v6+100 ),
 ( v1+100, 100*v3+1, v4+100, v6+1, v7+1 ),
 ( v1+100, v2+1, 100*v3+1, v4+100, v6+1, v7+1 ),
 ( v1+100, v2+1, 100*v3+1, v4+100, v5+100, v7+1 ),
 ( v1+100, v2+1, v3+100, 100*v5+1, 100*v6+1, v7+1 ),
 ( v1+100, v2+1, v3+100, v4+100, v6+1, v7+1 ),
 ( v1+100, v2+1, v3+100, v4+100, v5+100, v7+1 ),
 ( v1+100, v2+1, v3+100, v4+1, v6+1, 100*v7+1 ),
 ( v1+100, v2+1, v3+100, v4+1, v5+100, 100*v7+1 ),
 ( v1+100, v2+1, v3+100, v4+1, v5+100, v6+100 ),
 ( v2+1, v3+100, v4+1, 100*v5+1, 100*v7+1 ),
 ( v2+1, v3+100, v4+1, v5+100, v6+100 ),
 ( v2+1, v3+100, v4+100, 100*v5+1, v6+1, v7+1 ),
 ( v2+1, v3+100, v4+1, 100*v5+1, v1*v6*v7+1*v6*v7+100*v1*v7+100*v7+100*v1*v6+100*v6+v1+1 ),
 ( v2+1, v3+100, v4+1, 100*v5+1, 100*v6+1 ),
 ( v2+100, v3+1, v4+100, v5+100, v6+1, v7+1 ),
 ( v1+100, v2+100, v3+1, v4+1, v5+100, 100*v7+1 ),
 ( v1+100, v2+100, v3+1, v4+1, v5+100, v6+1 ),
 ( v1+1, v2+100, v3+1, v4+1, 100*v7+1 ),
 ( v1+1, v2+100, v3+1, v4+1, v5+100, 100*v7+1 ),
 ( v2+100, v3+1, v4+1, v5+100, 100*v7+1 ),
 ( v1+100, v2+100, v4+1, v5+100, 100*v7+1 ),
 ( v1+100, v2+100, v4+1, v5+100, v6+1 ),
 ( v1+100, v2+100, v3+100, v4+1, 100*v7+1 ),
 ( v1+100, 100*v3+1, v2^2*v4+100*v4+100*v2^2+1, 100*v5+1, v2*v6+1*v6+v2+1, v7+1 ),
 ( v1+100, 100*v3+1, v4+100, v5+100, v6+1, v7+1 ),
 ( v1+100, 100*v3+1, v4+1, v5+100, 100*v7+1 ),
 ( v1+100, 100*v3+1, v4+1, v5+100, v6+1, 100*v7+1 ),
 ( v2+1, v3+100, v4+1, v6+1, 100*v7+1 ),
 ( v2+1, v3+100, v4+1, v5+100, 100*v7+1 ),
 ( v1+1, v2+1, v3+100, 100*v5+1, v6+1, v7+1 ),
 ( v1+1, v2+1, v3+100, v4+1, v6+1, 100*v7+1 ),
 ( v2+1, v3+100, v4+1, v5*v6+100*v6+v5+100, 100*v7+1 ),
 ( v1+100, v2+100, v4+100, v5+100, v6+1, v7+1 ),
 ( v1+100, v2+100, v4+100, v6+1, v7+1 ),
 ( v1+100, v2+100, v3+100, v4+100, v6+1, v7+1 ),
 ( 100*v3+1, v4+1, v5+100, v2*v6*v7+1*v6*v7+v2*v7+1*v7+100*v2*v6+100*v6+100*v2+100 ),
 ( 100*v3+1, v4+1, v5+100, v6+1, v1*v2*v7+1*v2*v7+100*v1*v7+100*v7+100*v1*v2+100*v2+v1+1 ),
 ( 100*v2+1, v4+1, v5+100, v6+1 ),
 ( 100*v2+1, v3+1, v5+100, v6+1, v7+1 ),
 ( v2+100, v4+1, v5+100, v6+1 ),
 ( v2+100, v3+1, v5+100, v6+1, v7+1 ),
 ( v2+100, v4+1, v5+100, v6*v7+1*v7+100*v6+100 ) )

-- C2 after contract
-- 24 total, 7 linear!  Still incorrect... (seems same on mac and ubuntu, at least the numbers...)
( ( 100*v3+1, v4+1, v6+1, v1*v2*v5*v7+100*v2*v5*v7+100*v1*v5*v7+1*v5*v7+100*v1*v2*v7+1*v2*v7+v1*v7+100*v7+100*v1*v2*v5+1*v2*v5+v1*v5+100*v5+v1*v2+100*v2+100*v1+1 ),
 ( 100*v3+1, v4+1, 100*v5+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7+100*v2*v6+100*v6+100*v2+100 ),
 ( 100*v3+1, v4+1, 100*v5+1, v6+1, v1*v2*v7+1*v2*v7+100*v1*v7+100*v7+100*v1*v2+100*v2+v1+1 ),
 ( 100*v2+1, v4+1, v1*v3*v5*v6+1*v3*v5*v6+100*v1*v5*v6+100*v5*v6+100*v1*v3*v6+100*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5+100*v1*v5+100*v5+100*v1*v3+100*v3+v1+1, v1*v5*v7+100*v5*v7+100*v1*v7+1*v7+100*v1*v5+1*v5+v1+100 ),
 ( 100*v2+1, v4+1, 100*v5+1, v6+1 ),
 ( 100*v2+1, v3+1, 100*v5+1, v6+1, v7+1 ),
 ( 100*v2+1, v3+100, v4+1, v6+1, v1*v5*v7+100*v5*v7+100*v1*v7+1*v7+100*v1*v5+1*v5+v1+100 ),
 ( v1+1, v3+100, v4+1, v5+100, v6+1 ),
 ( v1+1, v2+1, v3+100, v5+100, v6+1, v7+1 ),
 ( v1+1, v2+1, v3+100, v4+1, v5+100 ),
 ( v1+1, v2+100, v4+1, v6+1, v5*v7+100*v7+100*v5+1 ),
 ( v1+100, v2+100, v6+1, v7+1 ),
 ( v1+100, v2+100, v4+1, v6+1 ),
 ( 100*v2+1, v3+1, v4+100, v6+1, v7+1 ),
 ( v1+100, 100*v3+1, v4+1, v6+1, 100*v7+1 ),
 ( v1+100, 100*v3+1, v4+100, v6+1, v7+1 ),
 ( v1+100, v2+1, 100*v3+1, v4+100, v5+100, v7+1 ),
 ( v1+100, v2+1, v3+100, 100*v5+1, 100*v6+1, v7+1 ),
 ( v2+1, v3+100, v4+1, 100*v5+1, 100*v7+1 ),
 ( v2+1, v3+100, v4+1, v5+100, v6+100 ),
 ( v2+1, v3+100, v4+100, 100*v5+1, v6+1, v7+1 ),
 ( v1+1, v2+100, v3+1, v4+1, 100*v7+1 ),
 ( v1+100, v2+100, v3+100, v4+1, 100*v7+1 ),
 ( v2+100, v4+1, v5+100, v6*v7+1*v7+100*v6+100 ) )

--------------------------------
-- trying to debug this, C1:
-- first cs, nr_of_iteration=1
-- LOOP1
cs = ( v_2*v_3-1*v_3-v_2+1, 
       v_1*v_2^2*v_4-1*v_2^2*v_4-v_1*v_4+1*v_4+v_1*v_2^2-1*v_2^2-v_1+1, 
       v_2*v_5*v_6-1*v_5*v_6-v_2*v_6+1*v_6+v_2*v_5-1*v_5-v_2+1 )

cs = ( v_3-1, v_4+1, v_6+1 )  (after removecontent)
factorset = ( v_2-1, v_1*v_2^2-1*v_2^2-v_1+1, v_2*v_5-1*v_5-v_2+1 )
 -- irras returns: ts=v_6+1, ts2=0, reducible=0
  -- after adding in qs, get:
  ( v_3-1, 
    v_4+1, 
    v_6+1, 
    v_1*v_2*v_5*v_7-1*v_2*v_5*v_7-v_1*v_5*v_7+1*v_5*v_7-v_1*v_2*v_7+1*v_2*v_7+v_1*v_7-1*v_7-v_1*v_2*v_5+1*v_2*v_5+v_1*v_5-1*v_5+v_1*v_2-1*v_2-v_1+1 
  ) -- (ADDED TO qsi)
  -- second call to irras returns ts2=0
  is = ( v_5-1, v_2-1, v_2+1, v_1-1, v_1*v_2*v_5-1*v_2*v_5-v_1*v_5+1*v_5-v_1*v_2+1*v_2+v_1-1 )
  -- iss becomes (just add each of these to orig qs, get 5 new ideals to consider)
  ( ( v_5-1 ) + qs:
      v_2*v_3-1*v_3-v_2+1, 
      v_4*v_7+1*v_7+v_4+1, 
      v_2*v_5*v_6-1*v_5*v_6-v_2*v_6+1*v_6+v_2*v_5-1*v_5-v_2+1, 
      v_2*v_6*v_7+1*v_6*v_7+v_2*v_7+1*v_7-v_2*v_6-1*v_6-v_2-1, 
      v_1*v_5*v_7-1*v_5*v_7-v_1*v_7+1*v_7+v_1*v_4*v_5-1*v_4*v_5-v_1*v_4+1*v_4, 
      v_1*v_6*v_7+1*v_6*v_7+v_1*v_2*v_7+1*v_2*v_7+2*v_4*v_6-v_1*v_6+1*v_6-v_1*v_3*v_4+1*v_3*v_4+2*v_2*v_4-v_1*v_4+1*v_4-v_1*v_3+1*v_3-v_1*v_2+1*v_2-v_1+1, 
      v_1*v_3*v_4-1*v_3*v_4+v_1*v_2*v_4-1*v_2*v_4+v_1*v_3-1*v_3+v_1*v_2-1*v_2, 
      v_1*v_3*v_5*v_6+1*v_3*v_5*v_6-v_1*v_5*v_6-1*v_5*v_6-v_1*v_3*v_6-1*v_3*v_6+v_1*v_6+1*v_6+v_1*v_3*v_5+1*v_3*v_5-v_1*v_5-1*v_5-v_1*v_3-1*v_3+v_1+1, 
      v_1*v_3*v_4*v_6-1*v_3*v_4*v_6+v_1*v_4*v_6-1*v_4*v_6+v_1*v_3*v_6-1*v_3*v_6+v_1*v_6-1*v_6+v_1*v_3*v_4-1*v_3*v_4+v_1*v_4-1*v_4+v_1*v_3-1*v_3+v_1-1, 
      v_1*v_3*v_4*v_5-1*v_3*v_4*v_5+v_1*v_4*v_5-1*v_4*v_5+v_1*v_3*v_5-1*v_3*v_5+v_1*v_5-1*v_5-v_1*v_3*v_4+1*v_3*v_4-v_1*v_4+1*v_4-v_1*v_3+1*v_3-v_1+1, 
      v_1*v_2*v_5*v_7-1*v_2*v_5*v_7-v_1*v_5*v_7+1*v_5*v_7-v_1*v_2*v_7+1*v_2*v_7+v_1*v_7-1*v_7-v_1*v_2*v_5+1*v_2*v_5+v_1*v_5-1*v_5+v_1*v_2-1*v_2-v_1+1 ),
    ( v_2-1, qs)
    ( v_2+1, qs)
    ( v_1-1, qs)
    ( v_1*v_2*v_5-1*v_2*v_5-v_1*v_5+1*v_5-v_1*v_2+1*v_2+v_1-1, qs)
    )
-- LOOP2
  -- sorting does what here?  They all have the same number of elements.
  -- what it does is to put the last one above first.
  cs = ( v_2*v_3-1*v_3-v_2+1,
    v_1*v_2^2*v_4-1*v_2^2*v_4-v_1*v_4+1*v_4+v_1*v_2^2-1*v_2^2-v_1+1,
    v_1*v_2*v_5-1*v_2*v_5-v_1*v_5+1*v_5-v_1*v_2+1*v_2+v_1-1 )
  cs = ( v_3-1, v_4+1, v_5-1 )
  factorset = ( v_2-1, v_1*v_2^2-1*v_2^2-v_1+1, v_1*v_2-1*v_2-v_1+1 )
  -- after charseta:
  cs = ( v_3-1, v_4+1, v_5-1, v_2*v_6*v_7+1*v_6*v_7+v_2*v_7+1*v_7-v_2*v_6-1*v_6-v_2-1 )
  -- (ADDED TO qsi)
  is = ( v_2-1, v_1-1, v_2+1, v_2*v_6+1*v_6+v_2+1 )
  -- iss: add each of these into previous qs (which is orig PS, and last elem of is in LOOP1)
-- LOOP3
  qhi.length() == 8
  -- chooses ((v2+1)(v6+1), (v1-1)(v2-1)(v5-1), PS)
  -- now which ones get placed first in sort?
  cs = ( v_2*v_3-1*v_3-v_2+1, 
      v_1*v_2^2*v_4-1*v_2^2*v_4-v_1*v_4+1*v_4+v_1*v_2^2-1*v_2^2-v_1+1, 
      v_1*v_2*v_5-1*v_2*v_5-v_1*v_5+1*v_5-v_1*v_2+1*v_2+v_1-1, 
      v_2*v_6+1*v_6+v_2+1 )  
  cs becomes ( v_3-1, v_4+1, v_5-1, v_6+1 )
  factorset = ( v_2-1, v_1*v_2^2-1*v_2^2-v_1+1, v_1*v_2-1*v_2-v_1+1, v_2+1 )
  is = v2+1, v2-1, v1-1, (v1-1)(v2-1)
-- LOOP4: (11 in qhi now)
  qs: ((v1-1)(v2-1), (v2+1)(v6+1), (v1-1)(v2-1)(v5-1), PS)
  cs = ( v2-1, 
      v4+1, 
      v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, 
      v1*v5*v7-1*v5*v7-v1*v7+1*v7-v1*v5+1*v5+v1-1 )
  CODIM4, added to qsi
  
( ( v4+1, v3+1, v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v2+1*v2-v1-1, v2*v6+1*v6+v2+1, v1*v2*v5-1*v2*v5-v1*v5+1*v5-v1*v2+1*v2+v1-1, v2*v3-1*v3-v2+1, v4*v7+1*v7+v4+1, v2*v5*v6-1*v5*v6-v2*v6+1*v6+v2*v5-1*v5-v2+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1, v1*v5*v7-1*v5*v7-v1*v7+1*v7+v1*v4*v5-1*v4*v5-v1*v4+1*v4, v1*v6*v7+1*v6*v7+v1*v2*v7+1*v2*v7+2*v4*v6-v1*v6+1*v6-v1*v3*v4+1*v3*v4+2*v2*v4-v1*v4+1*v4-v1*v3+1*v3-v1*v2+1*v2-v1+1, v1*v3*v4-1*v3*v4+v1*v2*v4-1*v2*v4+v1*v3-1*v3+v1*v2-1*v2, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v3*v4*v6-1*v3*v4*v6+v1*v4*v6-1*v4*v6+v1*v3*v6-1*v3*v6+v1*v6-1*v6+v1*v3*v4-1*v3*v4+v1*v4-1*v4+v1*v3-1*v3+v1-1, v1*v3*v4*v5-1*v3*v4*v5+v1*v4*v5-1*v4*v5+v1*v3*v5-1*v3*v5+v1*v5-1*v5-v1*v3*v4+1*v3*v4-v1*v4+1*v4-v1*v3+1*v3-v1+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
   ( v3+1, v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v2+1*v2-v1-1, v2*v6+1*v6+v2+1, v1*v2*v5-1*v2*v5-v1*v5+1*v5-v1*v2+1*v2+v1-1, v2*v3-1*v3-v2+1, v4*v7+1*v7+v4+1, v2*v5*v6-1*v5*v6-v2*v6+1*v6+v2*v5-1*v5-v2+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1, v1*v5*v7-1*v5*v7-v1*v7+1*v7+v1*v4*v5-1*v4*v5-v1*v4+1*v4, v1*v6*v7+1*v6*v7+v1*v2*v7+1*v2*v7+2*v4*v6-v1*v6+1*v6-v1*v3*v4+1*v3*v4+2*v2*v4-v1*v4+1*v4-v1*v3+1*v3-v1*v2+1*v2-v1+1, v1*v3*v4-1*v3*v4+v1*v2*v4-1*v2*v4+v1*v3-1*v3+v1*v2-1*v2, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v3*v4*v6-1*v3*v4*v6+v1*v4*v6-1*v4*v6+v1*v3*v6-1*v3*v6+v1*v6-1*v6+v1*v3*v4-1*v3*v4+v1*v4-1*v4+v1*v3-1*v3+v1-1, v1*v3*v4*v5-1*v3*v4*v5+v1*v4*v5-1*v4*v5+v1*v3*v5-1*v3*v5+v1*v5-1*v5-v1*v3*v4+1*v3*v4-v1*v4+1*v4-v1*v3+1*v3-v1+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
   ( v5-1, v4+1, v1+1, v3+1, v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v2+1*v2-v1-1, v2*v6+1*v6+v2+1, v1*v2*v5-1*v2*v5-v1*v5+1*v5-v1*v2+1*v2+v1-1, v2*v3-1*v3-v2+1, v4*v7+1*v7+v4+1, v2*v5*v6-1*v5*v6-v2*v6+1*v6+v2*v5-1*v5-v2+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1, v1*v5*v7-1*v5*v7-v1*v7+1*v7+v1*v4*v5-1*v4*v5-v1*v4+1*v4, v1*v6*v7+1*v6*v7+v1*v2*v7+1*v2*v7+2*v4*v6-v1*v6+1*v6-v1*v3*v4+1*v3*v4+2*v2*v4-v1*v4+1*v4-v1*v3+1*v3-v1*v2+1*v2-v1+1, v1*v3*v4-1*v3*v4+v1*v2*v4-1*v2*v4+v1*v3-1*v3+v1*v2-1*v2, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v3*v4*v6-1*v3*v4*v6+v1*v4*v6-1*v4*v6+v1*v3*v6-1*v3*v6+v1*v6-1*v6+v1*v3*v4-1*v3*v4+v1*v4-1*v4+v1*v3-1*v3+v1-1, v1*v3*v4*v5-1*v3*v4*v5+v1*v4*v5-1*v4*v5+v1*v3*v5-1*v3*v5+v1*v5-1*v5-v1*v3*v4+1*v3*v4-v1*v4+1*v4-v1*v3+1*v3-v1+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
   ( v4+1, v1+1, v3+1, v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v2+1*v2-v1-1, v2*v6+1*v6+v2+1, v1*v2*v5-1*v2*v5-v1*v5+1*v5-v1*v2+1*v2+v1-1, v2*v3-1*v3-v2+1, v4*v7+1*v7+v4+1, v2*v5*v6-1*v5*v6-v2*v6+1*v6+v2*v5-1*v5-v2+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1, v1*v5*v7-1*v5*v7-v1*v7+1*v7+v1*v4*v5-1*v4*v5-v1*v4+1*v4, v1*v6*v7+1*v6*v7+v1*v2*v7+1*v2*v7+2*v4*v6-v1*v6+1*v6-v1*v3*v4+1*v3*v4+2*v2*v4-v1*v4+1*v4-v1*v3+1*v3-v1*v2+1*v2-v1+1, v1*v3*v4-1*v3*v4+v1*v2*v4-1*v2*v4+v1*v3-1*v3+v1*v2-1*v2, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v3*v4*v6-1*v3*v4*v6+v1*v4*v6-1*v4*v6+v1*v3*v6-1*v3*v6+v1*v6-1*v6+v1*v3*v4-1*v3*v4+v1*v4-1*v4+v1*v3-1*v3+v1-1, v1*v3*v4*v5-1*v3*v4*v5+v1*v4*v5-1*v4*v5+v1*v3*v5-1*v3*v5+v1*v5-1*v5-v1*v3*v4+1*v3*v4-v1*v4+1*v4-v1*v3+1*v3-v1+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
   ( v1+1, v3+1, v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v2+1*v2-v1-1, v2*v6+1*v6+v2+1, v1*v2*v5-1*v2*v5-v1*v5+1*v5-v1*v2+1*v2+v1-1, v2*v3-1*v3-v2+1, v4*v7+1*v7+v4+1, v2*v5*v6-1*v5*v6-v2*v6+1*v6+v2*v5-1*v5-v2+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1, v1*v5*v7-1*v5*v7-v1*v7+1*v7+v1*v4*v5-1*v4*v5-v1*v4+1*v4, v1*v6*v7+1*v6*v7+v1*v2*v7+1*v2*v7+2*v4*v6-v1*v6+1*v6-v1*v3*v4+1*v3*v4+2*v2*v4-v1*v4+1*v4-v1*v3+1*v3-v1*v2+1*v2-v1+1, v1*v3*v4-1*v3*v4+v1*v2*v4-1*v2*v4+v1*v3-1*v3+v1*v2-1*v2, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v3*v4*v6-1*v3*v4*v6+v1*v4*v6-1*v4*v6+v1*v3*v6-1*v3*v6+v1*v6-1*v6+v1*v3*v4-1*v3*v4+v1*v4-1*v4+v1*v3-1*v3+v1-1, v1*v3*v4*v5-1*v3*v4*v5+v1*v4*v5-1*v4*v5+v1*v3*v5-1*v3*v5+v1*v5-1*v5-v1*v3*v4+1*v3*v4-v1*v4+1*v4-v1*v3+1*v3-v1+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
   ( v4-1, v1+1, v3+1, v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v2+1*v2-v1-1, v2*v6+1*v6+v2+1, v1*v2*v5-1*v2*v5-v1*v5+1*v5-v1*v2+1*v2+v1-1, v2*v3-1*v3-v2+1, v4*v7+1*v7+v4+1, v2*v5*v6-1*v5*v6-v2*v6+1*v6+v2*v5-1*v5-v2+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1, v1*v5*v7-1*v5*v7-v1*v7+1*v7+v1*v4*v5-1*v4*v5-v1*v4+1*v4, v1*v6*v7+1*v6*v7+v1*v2*v7+1*v2*v7+2*v4*v6-v1*v6+1*v6-v1*v3*v4+1*v3*v4+2*v2*v4-v1*v4+1*v4-v1*v3+1*v3-v1*v2+1*v2-v1+1, v1*v3*v4-1*v3*v4+v1*v2*v4-1*v2*v4+v1*v3-1*v3+v1*v2-1*v2, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v3*v4*v6-1*v3*v4*v6+v1*v4*v6-1*v4*v6+v1*v3*v6-1*v3*v6+v1*v6-1*v6+v1*v3*v4-1*v3*v4+v1*v4-1*v4+v1*v3-1*v3+v1-1, v1*v3*v4*v5-1*v3*v4*v5+v1*v4*v5-1*v4*v5+v1*v3*v5-1*v3*v5+v1*v5-1*v5-v1*v3*v4+1*v3*v4-v1*v4+1*v4-v1*v3+1*v3-v1+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
   ( v4+1, v1-1, v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v2+1*v2-v1-1, v2*v6+1*v6+v2+1, v1*v2*v5-1*v2*v5-v1*v5+1*v5-v1*v2+1*v2+v1-1, v2*v3-1*v3-v2+1, v4*v7+1*v7+v4+1, v2*v5*v6-1*v5*v6-v2*v6+1*v6+v2*v5-1*v5-v2+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1, v1*v5*v7-1*v5*v7-v1*v7+1*v7+v1*v4*v5-1*v4*v5-v1*v4+1*v4, v1*v6*v7+1*v6*v7+v1*v2*v7+1*v2*v7+2*v4*v6-v1*v6+1*v6-v1*v3*v4+1*v3*v4+2*v2*v4-v1*v4+1*v4-v1*v3+1*v3-v1*v2+1*v2-v1+1, v1*v3*v4-1*v3*v4+v1*v2*v4-1*v2*v4+v1*v3-1*v3+v1*v2-1*v2, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v3*v4*v6-1*v3*v4*v6+v1*v4*v6-1*v4*v6+v1*v3*v6-1*v3*v6+v1*v6-1*v6+v1*v3*v4-1*v3*v4+v1*v4-1*v4+v1*v3-1*v3+v1-1, v1*v3*v4*v5-1*v3*v4*v5+v1*v4*v5-1*v4*v5+v1*v3*v5-1*v3*v5+v1*v5-1*v5-v1*v3*v4+1*v3*v4-v1*v4+1*v4-v1*v3+1*v3-v1+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
   ( v1-1, v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v2+1*v2-v1-1, v2*v6+1*v6+v2+1, v1*v2*v5-1*v2*v5-v1*v5+1*v5-v1*v2+1*v2+v1-1, v2*v3-1*v3-v2+1, v4*v7+1*v7+v4+1, v2*v5*v6-1*v5*v6-v2*v6+1*v6+v2*v5-1*v5-v2+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1, v1*v5*v7-1*v5*v7-v1*v7+1*v7+v1*v4*v5-1*v4*v5-v1*v4+1*v4, v1*v6*v7+1*v6*v7+v1*v2*v7+1*v2*v7+2*v4*v6-v1*v6+1*v6-v1*v3*v4+1*v3*v4+2*v2*v4-v1*v4+1*v4-v1*v3+1*v3-v1*v2+1*v2-v1+1, v1*v3*v4-1*v3*v4+v1*v2*v4-1*v2*v4+v1*v3-1*v3+v1*v2-1*v2, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v3*v4*v6-1*v3*v4*v6+v1*v4*v6-1*v4*v6+v1*v3*v6-1*v3*v6+v1*v6-1*v6+v1*v3*v4-1*v3*v4+v1*v4-1*v4+v1*v3-1*v3+v1-1, v1*v3*v4*v5-1*v3*v4*v5+v1*v4*v5-1*v4*v5+v1*v3*v5-1*v3*v5+v1*v5-1*v5-v1*v3*v4+1*v3*v4-v1*v4+1*v4-v1*v3+1*v3-v1+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
   ( v4+1, v3-1, v1-1, v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v2+1*v2-v1-1, v2*v6+1*v6+v2+1, v1*v2*v5-1*v2*v5-v1*v5+1*v5-v1*v2+1*v2+v1-1, v2*v3-1*v3-v2+1, v4*v7+1*v7+v4+1, v2*v5*v6-1*v5*v6-v2*v6+1*v6+v2*v5-1*v5-v2+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1, v1*v5*v7-1*v5*v7-v1*v7+1*v7+v1*v4*v5-1*v4*v5-v1*v4+1*v4, v1*v6*v7+1*v6*v7+v1*v2*v7+1*v2*v7+2*v4*v6-v1*v6+1*v6-v1*v3*v4+1*v3*v4+2*v2*v4-v1*v4+1*v4-v1*v3+1*v3-v1*v2+1*v2-v1+1, v1*v3*v4-1*v3*v4+v1*v2*v4-1*v2*v4+v1*v3-1*v3+v1*v2-1*v2, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v3*v4*v6-1*v3*v4*v6+v1*v4*v6-1*v4*v6+v1*v3*v6-1*v3*v6+v1*v6-1*v6+v1*v3*v4-1*v3*v4+v1*v4-1*v4+v1*v3-1*v3+v1-1, v1*v3*v4*v5-1*v3*v4*v5+v1*v4*v5-1*v4*v5+v1*v3*v5-1*v3*v5+v1*v5-1*v5-v1*v3*v4+1*v3*v4-v1*v4+1*v4-v1*v3+1*v3-v1+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
   ( v3-1, v1-1, v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v2+1*v2-v1-1, v2*v6+1*v6+v2+1, v1*v2*v5-1*v2*v5-v1*v5+1*v5-v1*v2+1*v2+v1-1, v2*v3-1*v3-v2+1, v4*v7+1*v7+v4+1, v2*v5*v6-1*v5*v6-v2*v6+1*v6+v2*v5-1*v5-v2+1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1, v1*v5*v7-1*v5*v7-v1*v7+1*v7+v1*v4*v5-1*v4*v5-v1*v4+1*v4, v1*v6*v7+1*v6*v7+v1*v2*v7+1*v2*v7+2*v4*v6-v1*v6+1*v6-v1*v3*v4+1*v3*v4+2*v2*v4-v1*v4+1*v4-v1*v3+1*v3-v1*v2+1*v2-v1+1, v1*v3*v4-1*v3*v4+v1*v2*v4-1*v2*v4+v1*v3-1*v3+v1*v2-1*v2, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v3*v4*v6-1*v3*v4*v6+v1*v4*v6-1*v4*v6+v1*v3*v6-1*v3*v6+v1*v6-1*v6+v1*v3*v4-1*v3*v4+v1*v4-1*v4+v1*v3-1*v3+v1-1, v1*v3*v4*v5-1*v3*v4*v5+v1*v4*v5-1*v4*v5+v1*v3*v5-1*v3*v5+v1*v5-1*v5-v1*v3*v4+1*v3*v4-v1*v4+1*v4-v1*v3+1*v3-v1+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ) )  


( ( v3-1, v4+1, v6+1, v1*v2*v5*v7-1*v2*v5*v7-v1*v5*v7+1*v5*v7-v1*v2*v7+1*v2*v7+v1*v7-1*v7-v1*v2*v5+1*v2*v5+v1*v5-1*v5+v1*v2-1*v2-v1+1 ),
   ( v3-1, v4+1, v5-1, v2*v6*v7+1*v6*v7+v2*v7+1*v7-v2*v6-1*v6-v2-1 ),
   ( v3-1, v4+1, v5-1, v6+1, v1*v2*v7+1*v2*v7-v1*v7-1*v7-v1*v2-1*v2+v1+1 ),
   ( v2-1, v4+1, v1*v3*v5*v6+1*v3*v5*v6-v1*v5*v6-1*v5*v6-v1*v3*v6-1*v3*v6+v1*v6+1*v6+v1*v3*v5+1*v3*v5-v1*v5-1*v5-v1*v3-1*v3+v1+1, v1*v5*v7-1*v5*v7-v1*v7+1*v7-v1*v5+1*v5+v1-1 ),
   ( v2-1, v4+1, v5-1, v6+1 ),
   ( v1-1, v2-1, v3*v5-1*v5-v3+1, v6+1, v7+1 ),
   ( v1-1, v2-1, v3-1, v6+1, v7+1 ),
   ( v1-1, v2-1, v3-1, v4+1, v6+1 ),
   ( v1-1, v2-1, v4+1, v3*v5-1*v5-v3+1, v6+1 ),
   ( v2-1, v3+1, v5-1, v6+1, v7+1 ),
   ( v1+1, v2-1, v3+1, v5-1, v6+1, v7+1 ),
   ( v1+1, v2-1, v3+1, v4-1, v6+1, v7+1 ),
   ( v1+1, v2-1, v3+1, v4+1, v6+1, v7-1 ),
   ( v1+1, v2-1, v3+1, v4+1, v5-1, v6+1 ),
   ( v2-1, v3+1, v4+1, v5-1, v6+1 ),
   ( v1+1, v3-1, v4+1, v5-1, v6+1 ),
   ( v1+1, v2-1, v4+1, v6+1, v5*v7-1*v7-v5+1 ),
   ( v1+1, v2-1, v4+1, v5-1, v6+1 ),
   ( v1+1, v2+1, v3-1, v5-1, v6+1, v7+1 ),
   ( v1+1, v2+1, v3-1, v4+1, v5-1 ),
   ( v2-1, v3-1, v4+1, v6+1, v1*v5*v7-1*v5*v7-v1*v7+1*v7-v1*v5+1*v5+v1-1 ),
   ( v2-1, v3-1, v4+1, v5-1, v6+1 ),
   ( v1-1, v2-1, v3+1, v6+1, v7+1 ),
   ( v1-1, v2-1, v3+1, v4+1, v6+1 ),
   ( v1-1, v2-1, v6+1, v7+1 ),
   ( v1-1, v2-1, v4+1, v6+1 ),
   ( v2-1, v3+1, v4-1, v6+1, v7+1 ),
   ( v2-1, v3+1, v4+1, v6+1, v7-1 ),
   ( v1-1, v3-1, v4+1, v6+1, v7-1 ),
   ( v1-1, v2+1, v3-1, v4+1, v6+1, v7-1 ),
   ( v1-1, v2+1, v3-1, v4+1, v5-1, v7-1 ),
   ( v1-1, v2+1, v3-1, v4+1, v5-1, v6-1 ),
   ( v1-1, v3-1, v4-1, v6+1, v7+1 ),
   ( v1-1, v2+1, v3-1, v4-1, v6+1, v7+1 ),
   ( v1-1, v2+1, v3-1, v4-1, v5-1, v7+1 ),
   ( v1-1, v2+1, v3-1, v5-1, v6-1, v7+1 ),
   ( v2+1, v3-1, v4+1, v5-1, v7-1 ),
   ( v2+1, v3-1, v4+1, v5-1, v6-1 ),
   ( v2+1, v3-1, v4-1, v5-1, v6+1, v7+1 ),
   ( v2+1, v3-1, v4+1, v5-1, v1*v6*v7+1*v6*v7-v1*v7-1*v7-v1*v6-1*v6+v1+1 ),
   ( v1-1, v3-1, v2^2*v4-1*v4-v2^2+1, v5-1, v2*v6+1*v6+v2+1, v7+1 ),
   ( v1-1, v2-1, v3-1, v4+1, v7-1 ),
   ( v1-1, v2-1, v4+1, v5-1, v7-1 ),
   ( v1-1, v2-1, v4+1, v5-1, v6+1 ),
   ( v1-1, v3-1, v4-1, v5-1, v6+1, v7+1 ),
   ( v1-1, v3-1, v4+1, v5-1, v7-1 ),
   ( v1-1, v3-1, v4+1, v5-1, v6+1, v7-1 ) )