/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file PolyShadingTechniqueAttributes.cc
    \brief Implementation of PolyShadingTechnique Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Apr 15 17:55:21 2013
*/    

#include "PolyShadingTechniqueAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


PolyShadingTechniqueAttributes::PolyShadingTechniqueAttributes():
	method_(MagTranslator<string, PolyShadingMethod>().magics("contour_shade_method"))
{
} 



PolyShadingTechniqueAttributes::~PolyShadingTechniqueAttributes()
{
}

    
void PolyShadingTechniqueAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	prefix[0] = "contour_shade";
	prefix[1] = "contour_shade";
	prefix[2] = "contour_shade";
	prefix[3] = "contour";
	prefix[4] = "contour";

	setMember(prefix, "contour_shade_method", method_, params);
}

void PolyShadingTechniqueAttributes::copy(const PolyShadingTechniqueAttributes& other)
{
	method_ = auto_ptr<PolyShadingMethod>(other.method_->clone());
} 


bool PolyShadingTechniqueAttributes::accept(const string& node)
{	
	if ( magCompare(node, "polygon")  )
		return true;

	if ( acceptNode(node, method_) )
		return true;
	return false;
}

void PolyShadingTechniqueAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "polygon") )
		set(node.attributes());
	else {
		setMember(node.name(), method_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), method_, *(*elt)); 
	}
}

void PolyShadingTechniqueAttributes::print(ostream& out)  const
{
	out << "PolyShadingTechniqueAttributes[";
	out << "method = " << *method_;
	out << "]" << "\n";
}


void PolyShadingTechniqueAttributes::toxml(ostream& out)  const
{
     out <<  "\"polygon\"";
	 out << ", \"contour_shade_method\":";
	 method_->toxml(out);
}
static MagicsParameter<string> contour_shade_method("contour_shade_method", "dot", "");
#include "HatchPolyShadingMethod.h"
#include "DotPolyShadingMethod.h"
#include "PolyShadingMethod.h"
static SimpleObjectMaker<PolyShadingMethod, PolyShadingMethod> area_fill_PolyShadingMethod("area_fill");
static SimpleObjectMaker<DotPolyShadingMethod, PolyShadingMethod> dot_DotPolyShadingMethod("dot");
static SimpleObjectMaker<HatchPolyShadingMethod, PolyShadingMethod> hatch_HatchPolyShadingMethod("hatch");
