# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object import DataObject


class BSPCuts(DataObject):
    r"""
    BSPCuts - This class represents an axis-aligned Binary Spatial
       Partitioning of a 3D space.
    
    Superclass: DataObject
    
    This class converts between the KdTree
       representation of a tree of KdNodes (used by
    DistributedDataFilter)
       and a compact array representation that might be provided by a
       graph partitioning library like Zoltan.  Such a representation
       could be used in message passing.
    
    @sa
         KdTree KdNode DistributedDataFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBSPCuts, obj, update, **traits)
    
    def get_arrays(self, *args):
        """
        get_arrays(self, len:int, dim:[int, ...], coord:[float, ...],
            lower:[int, ...], upper:[int, ...], lowerDataCoord:[float,
            ...], upperDataCoord:[float, ...], npoints:[int, ...]) -> int
        C++: int get_arrays(int len, int *dim, double *coord, int *lower,
            int *upper, double *lowerDataCoord, double *upperDataCoord,
            int *npoints)
        Get the arrays representing the cuts in the partitioning.
        """
        ret = self._wrap_call(self._vtk_obj.GetArrays, *args)
        return ret

    def _get_kd_node_tree(self):
        return wrap_vtk(self._vtk_obj.GetKdNodeTree())
    kd_node_tree = traits.Property(_get_kd_node_tree, desc=\
        r"""
        Return a tree of KdNode's representing the cuts specified in
        this object.  This is our copy, don't delete it.
        """
    )

    def _get_number_of_cuts(self):
        return self._vtk_obj.GetNumberOfCuts()
    number_of_cuts = traits.Property(_get_number_of_cuts, desc=\
        r"""
        Get the number of cuts in the partitioning, which also the size
        of the arrays in the array representation of the partitioning.
        """
    )

    def create_cuts(self, *args):
        """
        create_cuts(self, bounds:[float, ...], ncuts:int, dim:[int, ...],
            coord:[float, ...], lower:[int, ...], upper:[int, ...],
            lowerDataCoord:[float, ...], upperDataCoord:[float, ...],
            npoints:[int, ...]) -> None
        C++: void create_cuts(double *bounds, int ncuts, int *dim,
            double *coord, int *lower, int *upper, double *lowerDataCoord,
             double *upperDataCoord, int *npoints)
        create_cuts(self, kd:KdNode) -> None
        C++: void create_cuts(KdNode *kd)
        Initialize the cuts with arrays of information.  This type of
        information would be obtained from a graph partitioning software
        package like Zoltan.
        
        * bounds - the bounds (xmin, xmax, ymin, ymax, zmin, zmax) of the
        * space being partitioned
        * ncuts - the number cuts, also the size of the following arrays
        * dim   - the dimension along which the cut is made (x/y/z -
          0/1/2)
        * coord - the location of the cut along the axis
        * lower - array index for the lower region bounded by the cut
        * upper - array index for the upper region bounded by the cut
        * lowerdata_coord - optional upper bound of the data in the lower
          region
        * upperdata_coord - optional lower bound of the data in the upper
          region
        * npoints - optional number of points in the spatial region
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CreateCuts, *my_args)
        return ret

    def equals(self, *args):
        """
        equals(self, other:BSPCuts, tolerance:float=0.0) -> int
        C++: int equals(BSPCuts *other, double tolerance=0.0)
        Compare these cuts with those of the other tree.  Returns true if
        the two trees are the same.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Equals, *my_args)
        return ret

    def print_arrays(self):
        """
        print_arrays(self) -> None
        C++: void print_arrays()"""
        ret = self._vtk_obj.PrintArrays()
        return ret
        

    def print_tree(self):
        """
        print_tree(self) -> None
        C++: void print_tree()"""
        ret = self._vtk_obj.PrintTree()
        return ret
        

    _updateable_traits_ = \
    (('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BSPCuts, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BSPCuts properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag'], [], ['object_name']),
            title='Edit BSPCuts properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BSPCuts properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

