# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class DensifyPointCloudFilter(PolyDataAlgorithm):
    r"""
    DensifyPointCloudFilter - add points to a point cloud to make it
    denser
    
    Superclass: PolyDataAlgorithm
    
    DensifyPointCloudFilter adds new points to an input point cloud.
    The new points are created in such a way that all points in any local
    neighborhood are within a target distance of one another. Optionally,
    attribute data can be interpolated from the input point cloud as
    well.
    
    A high-level overview of the algorithm is as follows. For each input
    point, the distance to all points in its neighborhood is computed. If
    any of its neighbors is further than the target distance, the edge
    connecting the point and its neighbor is bisected and a new point is
    inserted at the bisection point (optionally the attribute data is
    interpolated as well). A single pass is completed once all the input
    points are visited. Then the process repeats to the limit of the
    maximum number of iterations.
    
    @warning
    This class can generate a lot of points very quickly. The maximum
    number of iterations is by default set to =1.0 for this reason.
    Increase the number of iterations very carefully. Also the
    maximum_number_of_points data member can be set to limit the explosion
    of points. It is also recommended that a N closest neighborhood is
    used.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    VoxelGridFilter EuclideanClusterExtraction
    BoundedPointSource
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDensifyPointCloudFilter, obj, update, **traits)
    
    interpolate_attribute_data = tvtk_base.true_bool_trait(desc=\
        r"""
        Turn on/off the interpolation of attribute data from the input
        point cloud to new, added points.
        """
    )

    def _interpolate_attribute_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolateAttributeData,
                        self.interpolate_attribute_data_)

    neighborhood_type = tvtk_base.RevPrefixMap({'n_closest': 1, 'radius': 0}, default_value='n_closest', desc=\
        r"""
        Specify how the local point neighborhood is defined. By default
        an N closest neighborhood is used. This tends to avoid explosive
        point creation.
        """
    )

    def _neighborhood_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNeighborhoodType,
                        self.neighborhood_type_)

    maximum_number_of_iterations = traits.Trait(3, traits.Range(1, 32767, enter_set=True, auto_set=False), desc=\
        r"""
        The maximum number of iterations to run. By default the maximum
        is one.
        """
    )

    def _maximum_number_of_iterations_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumNumberOfIterations,
                        self.maximum_number_of_iterations)

    maximum_number_of_points = traits.Trait(9223372036854775807, traits.Range(1, 9223372036854775807, enter_set=True, auto_set=False), desc=\
        r"""
        Set a limit on the maximum number of points that can be created.
        This data member serves as a crude barrier to explosive point
        creation; it does not guarantee that precisely these many points
        will be created. Once this limit is hit, it may result in
        premature termination of the algorithm. Consider it a pressure
        relief valve.
        """
    )

    def _maximum_number_of_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumNumberOfPoints,
                        self.maximum_number_of_points)

    number_of_closest_points = traits.Trait(6, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Define a local neighborhood in terms of the N closest points. By
        default the number of the closest points is =6. This data member
        is relevant only if the neighborhood type is N_CLOSEST.
        """
    )

    def _number_of_closest_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfClosestPoints,
                        self.number_of_closest_points)

    radius = traits.Trait(1.0, traits.Range(1.0, 1e+299, enter_set=True, auto_set=False), desc=\
        r"""
        Define a local neighborhood for each point in terms of a local
        radius. By default, the radius is 1.0. This data member is
        relevant only if the neighborhood type is RADIUS.
        """
    )

    def _radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRadius,
                        self.radius)

    target_distance = traits.Trait(0.5, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        r"""
        Set / get the target point distance. Points will be created in an
        iterative fashion until all points in their local neighborhood
        are the target distance apart or less. Note that the process may
        terminate early due to the limit on the maximum number of
        iterations. By default the target distance is set to 0.5. Note
        that the target_distance should be less than the Radius or nothing
        will change on output.
        """
    )

    def _target_distance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTargetDistance,
                        self.target_distance)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('interpolate_attribute_data', 'GetInterpolateAttributeData'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('neighborhood_type', 'GetNeighborhoodType'),
    ('maximum_number_of_iterations', 'GetMaximumNumberOfIterations'),
    ('maximum_number_of_points', 'GetMaximumNumberOfPoints'),
    ('number_of_closest_points', 'GetNumberOfClosestPoints'), ('radius',
    'GetRadius'), ('target_distance', 'GetTargetDistance'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'interpolate_attribute_data', 'release_data_flag',
    'neighborhood_type', 'maximum_number_of_iterations',
    'maximum_number_of_points', 'number_of_closest_points', 'object_name',
    'progress_text', 'radius', 'target_distance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DensifyPointCloudFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DensifyPointCloudFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['interpolate_attribute_data'], ['neighborhood_type'],
            ['maximum_number_of_iterations', 'maximum_number_of_points',
            'number_of_closest_points', 'object_name', 'radius',
            'target_distance']),
            title='Edit DensifyPointCloudFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DensifyPointCloudFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

