# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_prop_picker import AbstractPropPicker


class HardwarePicker(AbstractPropPicker):
    r"""
    HardwarePicker - pick a point or snap to point of an actor/prop
    using graphics hardware
    
    Superclass: AbstractPropPicker
    
    HardwarePicker is used to pick point or snap to point of an
    actor/prop given a selection point (in display coordinates) and a
    renderer. This class uses graphics hardware/rendering system to pick
    rapidly (as compared to using ray casting as does CellPicker and
    PointPicker). This class determines the actor/prop pick position,
    and pick normal in world coordinates; pointId is determined if
    snapping is enabled, otherwise the cellId is determined. if no
    actor/prop is picked, pick position = camera focal point, and pick
    normal = camera plane normal.
    
    @warning This class supports only picking in a screen, and not in VR.
    
    @sa
    PropPicker Picker WorldPointPicker CellPicker
    PointPicker
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHardwarePicker, obj, update, **traits)
    
    snap_to_mesh_point = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get if the picker will snap to the closest mesh point or get
        the actual intersected point. Default is off.
        """
    )

    def _snap_to_mesh_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSnapToMeshPoint,
                        self.snap_to_mesh_point_)

    pixel_tolerance = traits.Int(5, enter_set=True, auto_set=False, desc=\
        r"""
        When snap_to_mesh_point is on, this is the pixel tolerance to use
        when snapping. Default is 5.
        """
    )

    def _pixel_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPixelTolerance,
                        self.pixel_tolerance)

    def _get_cell_id(self):
        return self._vtk_obj.GetCellId()
    cell_id = traits.Property(_get_cell_id, desc=\
        r"""
        Get the id of the picked cell.
        
        If a prop is picked:
        
        1) If snap_on_mesh_point is on, cell_id = -1.
        2) If snap_on_mesh_point is off, the cellId of the prop's dataset
           will be returned
        
        if a prop is not picked, cell_id = -1.
        """
    )

    def _get_composite_data_set(self):
        return wrap_vtk(self._vtk_obj.GetCompositeDataSet())
    composite_data_set = traits.Property(_get_composite_data_set, desc=\
        r"""
        Get a pointer to the composite dataset that was picked (if any).
        If nothing was picked or a non-composite data object was picked
        then nullptr is returned.
        
        Note: Use WeakPointer. This is because the composite_data_set
        may be deleted.
        """
    )

    def _get_data_set(self):
        return wrap_vtk(self._vtk_obj.GetDataSet())
    data_set = traits.Property(_get_data_set, desc=\
        r"""
        Get a pointer to the dataset that was picked (if any). If nothing
        was picked then nullptr is returned.
        
        Note: Use WeakPointer. This is because the data_set may be
        deleted.
        """
    )

    def _get_flat_block_index(self):
        return self._vtk_obj.GetFlatBlockIndex()
    flat_block_index = traits.Property(_get_flat_block_index, desc=\
        r"""
        Get the flat block index of the DataSet in the composite
        dataset that was picked (if any). If nothing was picked or a
        non-composite data object was picked then -1 is returned.
        """
    )

    def _get_mapper(self):
        return wrap_vtk(self._vtk_obj.GetMapper())
    mapper = traits.Property(_get_mapper, desc=\
        r"""
        Return mapper that was picked (if any).
        
        Note: Use WeakPointer. This is because the Mapper may be
        deleted.
        """
    )

    def _get_normal_flipped(self):
        return self._vtk_obj.GetNormalFlipped()
    normal_flipped = traits.Property(_get_normal_flipped, desc=\
        r"""
        Get if normal is flipped.
        
        The normal will be flipped if point normals don't exist and the
        angle between the picked_normal and the camera plane normal is
        more than pi / 2.
        """
    )

    def _get_p_coords(self):
        return self._vtk_obj.GetPCoords()
    p_coords = traits.Property(_get_p_coords, desc=\
        r"""
        Get the parametric coordinates of the picked cell. PCoords can be
        used to compute the weights that are needed to interpolate data
        values within the cell.
        
        If a prop is picked:
        
        1) If snap_on_mesh_point is on, PCoords will be a vector of
           std::numeric_limits::quiet_NaN().
        2) If snap_on_mesh_point is off, PCoords will be extracted and the
           intersection point of the cell.
        
        if a prop is not picked, PCoords will be a vector of
        std::numeric_limits::quiet_NaN().
        """
    )

    def _get_pick_normal(self):
        return self._vtk_obj.GetPickNormal()
    pick_normal = traits.Property(_get_pick_normal, desc=\
        r"""
        Get the normal of the point at the pick_position.
        
        If a prop is picked:
        
        1) If snap_on_mesh_point is on, the picked normal will be extracted
           from the point_data normals, if they exist, otherwise a vector
           of std::numeric_limits::quiet_NaN() will be returned.
        2) If snap_on_mesh_point is off, the picked normal on the
           intersected cell will be extracted using ray intersection, if
           the ray intersections was successful, otherwise a vector of
           std::numeric_limits::quiet_NaN() will be returned.
        
        if a prop is not picked, the camera plane normal will be returned
        will be returned.
        """
    )

    def _get_point_id(self):
        return self._vtk_obj.GetPointId()
    point_id = traits.Property(_get_point_id, desc=\
        r"""
        Get the id of the picked point.
        
        If a prop is picked:
        
        1) if snap_on_mesh_point is on, the pointId of the prop's dataset
           will be returned
        2) If snap_on_mesh_point is off, point_id = -1;
        
        If a prop is not picked, point_id = -1;
        """
    )

    def _get_sub_id(self):
        return self._vtk_obj.GetSubId()
    sub_id = traits.Property(_get_sub_id, desc=\
        r"""
        Get the subId of the picked cell. This is useful, for example, if
        the data is made of triangle strips.
        
        If a prop is picked:
        
        1) If snap_on_mesh_point is on, sub_id = -1.
        2) If snap_on_mesh_point is off and the picked cell is a triangle
           strip, the subId of the intersected triangle will be returned,
        otherwise sub_id = -1.
        
        If a prop is not picked, sub_id = -1.
        """
    )

    _updateable_traits_ = \
    (('snap_to_mesh_point', 'GetSnapToMeshPoint'), ('pick_from_list',
    'GetPickFromList'), ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('pixel_tolerance', 'GetPixelTolerance'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'pick_from_list',
    'snap_to_mesh_point', 'object_name', 'pixel_tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HardwarePicker, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HardwarePicker properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['pick_from_list', 'snap_to_mesh_point'], [], ['object_name',
            'pixel_tolerance']),
            title='Edit HardwarePicker properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HardwarePicker properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

