# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.table_algorithm import TableAlgorithm


class JoinTables(TableAlgorithm):
    r"""
    JoinTables - SQL-style Join operation on two tables.
    
    Superclass: TableAlgorithm
    
    JoinTables is a filter that operates on two Table objects to
    perform an SQL-style Join operation. It outputs one Table object.
    The goal is to combine the rows of both tables into one bigger table
    based on a related column between them (both inputs have their "key
    column"). The two input tables are referred to as left and right. In
    each input table, the values in the key column act like unique IDs
    for their respective  rows. During the merge, the attributes of each
    item will be given with respect to its ID.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkJoinTables, obj, update, **traits)
    
    left_key = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Specifies which column of the left table to use for the join
        operation.
        """
    )

    def _left_key_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLeftKey,
                        self.left_key)

    mode = traits.Trait(0, traits.Range(0, 3, enter_set=True, auto_set=False), desc=\
        r"""
        The mode of the Join Tables filter. This is meaningful when the
        two key columns do not share exactly the same set of values. The
        different Join modes that this filter implements are :
        - INTERSECTION : Keeps only the keys that are in both columns.
        - UNION : Keeps all of the keys from both tables.
        - LEFT : Keeps the keys from the left table.
        - RIGHT : Keeps the keys from the right table.
        """
    )

    def _mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMode,
                        self.mode)

    replacement_value = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        Value to be imputed in numeric columns of the output when the
        data for a given key in a given column is unknown.
        """
    )

    def _replacement_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReplacementValue,
                        self.replacement_value)

    right_key = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Specifies which column of the right table to use for the join
        operation.
        """
    )

    def _right_key_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRightKey,
                        self.right_key)

    def set_source_connection(self, *args):
        """
        set_source_connection(self, source:AlgorithmOutput) -> None
        C++: void set_source_connection(AlgorithmOutput *source)
        Set a pipeline connection on port 1 for the right table. This
        method is equivalent to set_input_connection(1, source).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceConnection, *my_args)
        return ret

    def set_source_data(self, *args):
        """
        set_source_data(self, source:Table) -> None
        C++: void set_source_data(Table *source)
        Specify input data on port 1 for the right table. This method is
        equivalent to set_input_data(1, source).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceData, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('left_key',
    'GetLeftKey'), ('mode', 'GetMode'), ('replacement_value',
    'GetReplacementValue'), ('right_key', 'GetRightKey'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'left_key', 'mode', 'object_name',
    'progress_text', 'replacement_value', 'right_key'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(JoinTables, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit JoinTables properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['left_key', 'mode', 'object_name', 'replacement_value',
            'right_key']),
            title='Edit JoinTables properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit JoinTables properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

