# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class MutableGraphHelper(Object):
    r"""
    MutableGraphHelper - Helper class for building a directed or
      directed graph
    
    Superclass: Object
    
    MutableGraphHelper has helper methods add_vertex and add_edge which
    add vertices/edges to the underlying mutable graph. This is helpful
    in filters which need to (re)construct graphs which may be either
    directed or undirected.
    
    @sa
    Graph MutableDirectedGraph MutableUndirectedGraph
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMutableGraphHelper, obj, update, **traits)
    
    def _get_graph(self):
        return wrap_vtk(self._vtk_obj.GetGraph())
    def _set_graph(self, arg):
        old_val = self._get_graph()
        self._wrap_call(self._vtk_obj.SetGraph,
                        deref_vtk(arg))
        self.trait_property_changed('graph', old_val, arg)
    graph = traits.Property(_get_graph, _set_graph, desc=\
        r"""
        
        """
    )

    def add_edge(self, *args):
        """
        add_edge(self, u:int, v:int) -> EdgeType
        C++: EdgeType add_edge(IdType u, IdType v)
        Add an edge to the underlying mutable graph.
        """
        ret = self._wrap_call(self._vtk_obj.AddEdge, *args)
        return wrap_vtk(ret)

    def add_graph_edge(self, *args):
        """
        add_graph_edge(self, u:int, v:int) -> GraphEdge
        C++: GraphEdge *add_graph_edge(IdType u, IdType v)"""
        ret = self._wrap_call(self._vtk_obj.AddGraphEdge, *args)
        return wrap_vtk(ret)

    def add_vertex(self):
        """
        add_vertex(self) -> int
        C++: IdType add_vertex()
        Add a vertex to the underlying mutable graph.
        """
        ret = self._vtk_obj.AddVertex()
        return ret
        

    def remove_edge(self, *args):
        """
        remove_edge(self, e:int) -> None
        C++: void remove_edge(IdType e)
        Remove an edge from the underlying mutable graph.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveEdge, *args)
        return ret

    def remove_edges(self, *args):
        """
        remove_edges(self, edges:IdTypeArray) -> None
        C++: void remove_edges(IdTypeArray *edges)
        Remove a collection of edges from the underlying mutable graph.
        """
        my_args = deref_array(args, [['vtkIdTypeArray']])
        ret = self._wrap_call(self._vtk_obj.RemoveEdges, *my_args)
        return ret

    def remove_vertex(self, *args):
        """
        remove_vertex(self, v:int) -> None
        C++: void remove_vertex(IdType v)
        Remove a vertex from the underlying mutable graph.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveVertex, *args)
        return ret

    def remove_vertices(self, *args):
        """
        remove_vertices(self, verts:IdTypeArray) -> None
        C++: void remove_vertices(IdTypeArray *verts)
        Remove a collection of vertices from the underlying mutable
        graph.
        """
        my_args = deref_array(args, [['vtkIdTypeArray']])
        ret = self._wrap_call(self._vtk_obj.RemoveVertices, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MutableGraphHelper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MutableGraphHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit MutableGraphHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MutableGraphHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

