# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_algorithm import UnstructuredGridAlgorithm


class StaticCleanUnstructuredGrid(UnstructuredGridAlgorithm):
    r"""
    StaticCleanUnstructuredGrid - merge duplicate points, removed
    unused points, in an UnstructuredGrid
    
    Superclass: UnstructuredGridAlgorithm
    
    StaticCleanUnstructuredGrid is a filter that takes a
    UnstructuredGrid as input and produces a UnstructuredGrid on
    output, merging coincident points (as defined by a merging tolerance)
    and optionally removing unused points. The filter does not modify the
    topology of the input dataset, nor change the types of cells. It may
    however, renumber the cell connectivity ids.
    
    For better performance, this filter employs threading using
    StaticPointLocator and its associated threaded methods. When the
    merging tolerances==0.0, execution speeds are much faster as compared
    to non-zero tolerances. When the merging tolerance > 0.0, there are
    issues of processing order which can be controlled through the
    locator (returned via get_locator()). This behavior can be controlled
    by the set_traversal_order() method - by default threading occurs via
    BIN_ORDER (see StaticPointLocator for more information).
    
    @warning
    Merging points can alter cell geometry and produce degenerate cells.
    The tolerance should be chosen carefully to avoid these problems. For
    example, in an extreme case with a relatively large tolerance, all
    points of a Hexahedron could be merged to a single point, in which
    case the resulting hexahedron would be defined by eight repeats of
    the same point.
    
    @warning
    If remove_unused_points is enabled, then any point not used by any of
    the unstructured grid cells is eliminated (and not passed to the
    output). Enabling this feature does impact performance.
    
    @warning
    If produce_merge_map is enabled, then an output data array is produced,
    associated with the output field data, that maps each input point to
    an output point (or to -1 if an input point is unused in the output).
    
    @warning
    Merging points affects point coordinates and data attributes. By
    default, if points are merged, the point position and attribute data
    of only one point (i.e., the point that all other points are merged
    to) is retained. If average_point_data is enabled, then the resulting
    point position and attribute data values are determined by averaging
    the position and attribute values of all the points that are merged
    together. This option may have a significant performance impact if
    enabled.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    CleanPolyData StaticCleanPolyData StaticPointLocator
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkStaticCleanUnstructuredGrid, obj, update, **traits)
    
    average_point_data = tvtk_base.false_bool_trait(desc=\
        r"""
        Indicate whether point coordinates and point data of merged
        points are averaged. By default, the point coordinates and
        attribute data are not averaged, and the point coordinate and
        data of the single, remaining merged point is retained.
        Otherwise, the data coordinates and attribute values of all
        merged points are averaged. By default this feature is disabled.
        """
    )

    def _average_point_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAveragePointData,
                        self.average_point_data_)

    piece_invariant = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _piece_invariant_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPieceInvariant,
                        self.piece_invariant_)

    produce_merge_map = tvtk_base.false_bool_trait(desc=\
        r"""
        Indicate whether a merge map should be produced on output. The
        merge map, if requested, maps each input point to its output
        point id, or provides a value of -1 if the input point is not
        used in the output. The merge map is associated with the filter's
        output field data and is named "point_merge_map". By default,
        produce_merge_map is disabled.
        """
    )

    def _produce_merge_map_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProduceMergeMap,
                        self.produce_merge_map_)

    remove_unused_points = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether points unused by any cell are removed from the
        output. By default this point removal is on. Note that when this
        is off, the filter can successfully process datasets with no
        cells (and just points). If on in this case, and there are no
        cells, than the output will be empty.
        """
    )

    def _remove_unused_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRemoveUnusedPoints,
                        self.remove_unused_points_)

    tolerance_is_absolute = tvtk_base.false_bool_trait(desc=\
        r"""
        Specify how the point merging tolerance is defined. By default
        tolerance_is_absolute is false and the tolerance is a fraction of
        the input's bounding box diagonal. If true, absolute_tolerance is
        the tolerance used when performing point merging.
        """
    )

    def _tolerance_is_absolute_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetToleranceIsAbsolute,
                        self.tolerance_is_absolute_)

    absolute_tolerance = traits.Trait(0.0, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the absolute point merging tolerance. The default value
        is
        0. This tolerance is used then tolerance_is_absolute is true.
        """
    )

    def _absolute_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAbsoluteTolerance,
                        self.absolute_tolerance)

    merging_array = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Specify the name of a point data array associated with the point
        merging process. If a data array is specified, and exists in the
        input point data, then point merging will switch into a mode
        where merged points must be both geometrically coincident and
        have matching point data (i.e., an exact match of position and
        data - tolerances have no effect). Note that the number of tuples
        in the merging data array must be equal to the number of points
        in the input. By default, no data array is associated with the
        input points (i.e., the name of the data array is empty).
        """
    )

    def _merging_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergingArray,
                        self.merging_array)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the desired precision for the output point type. See the
        documentation for the Algorithm::DesiredOutputPrecision enum
        for an explanation of the available precision settings.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    tolerance = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the point merging tolerance in terms of the fraction of
        the input dataset's bounding box length.  The default is 0. This
        tolerance is used then tolerance_is_absolute is false.
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    locator = traits.Property(_get_locator, desc=\
        r"""
        Retrieve the internal locator to manually configure it, for
        example specifying the number of points per bucket, or
        controlling the traversal order. This method is generally used
        for debugging or testing purposes.
        """
    )

    _updateable_traits_ = \
    (('average_point_data', 'GetAveragePointData'), ('piece_invariant',
    'GetPieceInvariant'), ('produce_merge_map', 'GetProduceMergeMap'),
    ('remove_unused_points', 'GetRemoveUnusedPoints'),
    ('tolerance_is_absolute', 'GetToleranceIsAbsolute'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('absolute_tolerance',
    'GetAbsoluteTolerance'), ('merging_array', 'GetMergingArray'),
    ('output_points_precision', 'GetOutputPointsPrecision'), ('tolerance',
    'GetTolerance'), ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'average_point_data', 'debug',
    'global_warning_display', 'piece_invariant', 'produce_merge_map',
    'release_data_flag', 'remove_unused_points', 'tolerance_is_absolute',
    'absolute_tolerance', 'merging_array', 'object_name',
    'output_points_precision', 'progress_text', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(StaticCleanUnstructuredGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit StaticCleanUnstructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['average_point_data', 'piece_invariant', 'produce_merge_map',
            'remove_unused_points', 'tolerance_is_absolute'], [],
            ['absolute_tolerance', 'merging_array', 'object_name',
            'output_points_precision', 'tolerance']),
            title='Edit StaticCleanUnstructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit StaticCleanUnstructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

