# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_poly_data_mapper import OpenGLPolyDataMapper


class SurfaceLICMapper(OpenGLPolyDataMapper):
    r"""
    SurfaceLICMapper - mapper that performs LIC on the surface of
     arbitrary geometry.
    
    Superclass: OpenGLPolyDataMapper
    
    SurfaceLICMapper performs LIC on the surface of arbitrary
     geometry. Point vectors are used as the vector field for generating
    the LIC.
     The implementation was originallu  based on "Image Space Based
    Visualization
     on Unsteady Flow on Surfaces" by Laramee, Jobard and Hauser appeared
    in
     proceedings of IEEE Visualization '03, pages 131-138.
    
    
     Internal pipeline:
    
    noise
        |
        [ PROJ (GAT) (COMP) LIC2D (SCAT) SHADE (CCE) DEP]
        |                                               | vectors        
                                    surface LIC  PROj  - project vectors
    onto surface GAT   - gather data for compositing and guard pixel
    generation  (parallel only) COMP  - composite gathered data LIC2D -
    line intengral convolution, see LineIntegralConvolution2D. SCAT  -
    scatter result (parallel only, not all compositors use it) SHADE -
    combine LIC and scalar colors CCE   - color contrast enhancement
    (optional) DEP   - depth test and copy to back buffer
    
    The result of each stage is cached in a texture so that during
    interaction a stage may be skipped if the user has not modified its
    parameters or input data.
    
    The parallel parts of algorithm are implemented in
    PSurfaceLICMapper. Note that for MPI enabled builds this class
    will be automatically created by the object factory.
    
    @sa
    LineIntegralConvolution2D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSurfaceLICMapper, obj, update, **traits)
    
    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input as a DataSet.  This method is overridden in the
        specialized mapper classes to return more specific data types.
        """
    )

    def _get_lic_interface(self):
        return wrap_vtk(self._vtk_obj.GetLICInterface())
    lic_interface = traits.Property(_get_lic_interface, desc=\
        r"""
        Get the SurfaceLICInterface used by this mapper
        """
    )

    _updateable_traits_ = \
    (('pause_shift_scale', 'GetPauseShiftScale'), ('seamless_u',
    'GetSeamlessU'), ('seamless_v', 'GetSeamlessV'),
    ('interpolate_scalars_before_mapping',
    'GetInterpolateScalarsBeforeMapping'), ('scalar_visibility',
    'GetScalarVisibility'), ('static', 'GetStatic'),
    ('use_lookup_table_scalar_range', 'GetUseLookupTableScalarRange'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('color_mode',
    'GetColorMode'), ('resolve_coincident_topology',
    'GetResolveCoincidentTopology'), ('scalar_mode', 'GetScalarMode'),
    ('cell_id_array_name', 'GetCellIdArrayName'),
    ('composite_id_array_name', 'GetCompositeIdArrayName'),
    ('point_id_array_name', 'GetPointIdArrayName'),
    ('populate_selection_settings', 'GetPopulateSelectionSettings'),
    ('process_id_array_name', 'GetProcessIdArrayName'),
    ('vbo_shift_scale_method', 'GetVBOShiftScaleMethod'), ('ghost_level',
    'GetGhostLevel'), ('number_of_pieces', 'GetNumberOfPieces'),
    ('number_of_sub_pieces', 'GetNumberOfSubPieces'), ('piece',
    'GetPiece'), ('array_access_mode', 'GetArrayAccessMode'),
    ('array_component', 'GetArrayComponent'), ('array_id', 'GetArrayId'),
    ('array_name', 'GetArrayName'), ('field_data_tuple_id',
    'GetFieldDataTupleId'), ('render_time', 'GetRenderTime'),
    ('resolve_coincident_topology_polygon_offset_faces',
    'GetResolveCoincidentTopologyPolygonOffsetFaces'),
    ('resolve_coincident_topology_z_shift',
    'GetResolveCoincidentTopologyZShift'), ('scalar_range',
    'GetScalarRange'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'interpolate_scalars_before_mapping', 'pause_shift_scale',
    'release_data_flag', 'scalar_visibility', 'seamless_u', 'seamless_v',
    'static', 'use_lookup_table_scalar_range', 'color_mode',
    'resolve_coincident_topology', 'scalar_mode', 'array_access_mode',
    'array_component', 'array_id', 'array_name', 'cell_id_array_name',
    'composite_id_array_name', 'field_data_tuple_id', 'ghost_level',
    'number_of_pieces', 'number_of_sub_pieces', 'object_name', 'piece',
    'point_id_array_name', 'populate_selection_settings',
    'process_id_array_name', 'progress_text', 'render_time',
    'resolve_coincident_topology_polygon_offset_faces',
    'resolve_coincident_topology_z_shift', 'scalar_range',
    'vbo_shift_scale_method'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SurfaceLICMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SurfaceLICMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['interpolate_scalars_before_mapping', 'pause_shift_scale',
            'scalar_visibility', 'seamless_u', 'seamless_v', 'static',
            'use_lookup_table_scalar_range'], ['color_mode',
            'resolve_coincident_topology', 'scalar_mode'], ['array_access_mode',
            'array_component', 'array_id', 'array_name', 'cell_id_array_name',
            'composite_id_array_name', 'field_data_tuple_id', 'ghost_level',
            'number_of_pieces', 'number_of_sub_pieces', 'object_name', 'piece',
            'point_id_array_name', 'populate_selection_settings',
            'process_id_array_name', 'render_time',
            'resolve_coincident_topology_polygon_offset_faces',
            'resolve_coincident_topology_z_shift', 'scalar_range',
            'vbo_shift_scale_method']),
            title='Edit SurfaceLICMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SurfaceLICMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

