/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <stdio.h>
#include <stdarg.h>
#include "Ask.h"
#include "MetviewUI.h"
#include <Xm/Text.h>

Ask::Ask()
{
	create(MetviewUI::root());
}

Ask::~Ask()
{
}

bool Ask::show(string& val,const char* fmt,...)
{
	char buf[1024];
	va_list arg;
	va_start(arg,fmt);
	vsprintf(buf,fmt,arg);
	va_end(arg);

	return instance().show(buf,val);
}

bool Ask::show(const char* msg,string& val)
{
	XmTextSetString(value_,(char*)val.c_str());

	if(!modal(msg,true))
		return false;

	char* p = XmTextGetString(value_);
	val = p;
	XtFree(p);
	return true;
}


