/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Language.h
// Baudouin Raoult - ECMWF Aug 99

#ifndef Language_H
#define Language_H

#include <string>
using std::string;


#ifndef Path_H
#include "Path.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

class IconClass;
class Parameter;

class LanguageScanner {
public:
	virtual void next(const Parameter&) = 0;
};


class Language {
public:

// -- Exceptions
	// None

// -- Contructors

	Language(const IconClass*);
	Language(const IconClass*, const Request&);

// -- Destructor

	~Language(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	const char* getInfo() const;
	const char* getKind() const;

	Request expand(const Request&);
	Request expand(const Request&,long,bool=true);
	void scan(LanguageScanner&);
	vector<string> interfaces(const char*);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	
	static Language& find(const IconClass*);

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Language(const Language&);
	Language& operator=(const Language&);

// -- Members

	bool               inited_;
	request*           lang_;
	rule*              rule_;
	long               flags_;
	const IconClass*   class_;
	vector<Parameter*> params_;

// -- Methods

	void init();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Language& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Language**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Language);
//#endif

#endif
