/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FileObject_H
#include "FileObject.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#include "IconClass.h"

#include <algorithm>

FileObject::FileObject(Folder* parent,const IconClass& kind,
	const string& name,IconInfo* info):
	IconObject(parent,kind,name,info)
{
}

FileObject::~FileObject()
{
}

void FileObject::doubleClick()
{
	string dc=iconClass().doubleClickMethod();
	std::transform(dc.begin(), dc.end(), dc.begin(), ::tolower);
	
	if(!dc.empty())
	{
	  	command(dc);
	}
	else
	  	edit();
}

set<string> FileObject::can()
{
	return IconObject::can();
}

void FileObject::createFiles()
{
	IconObject::createFiles();
	Path p = path();
	if(!p.exists()) 
		p.touch();
}

Request FileObject::request() const
{
	const char* n = className().c_str();
	Request r(n);
	r("PATH") = path().str().c_str();
	return r;
}

void FileObject::request(const Request& r)
{
	IconObject::request(r);
}

static IconMaker<FileObject> maker1("File");
static IconMaker<FileObject> maker2("Macro");
