/*   
    This code is written by Davide Albanese, albanese@fbk.it or
    davide.albanese@gmail.com. 2007 MPBA Group at FBK Ricerca Scientifica
    e tecnologica, Trento, ITALY.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <Python.h>
#include <numpy/arrayobject.h>
#include <stdlib.h>
#include "numpysupport.h"


double **dmatrix_from_numpy(PyObject *elem)
{ 
  int nx = (int) PyArray_DIM(elem, 0);
  int ny = (int) PyArray_DIM(elem, 1);
  double **elempp;
  double *elemp;
  int i;
  
  elemp = (double *) PyArray_DATA(elem);
  elempp = (double **) malloc(nx * sizeof(double*));
  
  for(i=0; i<nx; i++)
    elempp[i] = &(elemp[i * ny]);
  
  return elempp;
  
  /* Quando non serve piu' elempp e' sufficente
   * fare una chiamata a free(elempp).
   */
}


int **imatrix_from_numpy(PyObject *elem)
{
  int nx = (int) PyArray_DIM(elem, 0);
  int ny = (int) PyArray_DIM(elem, 1);
  int **elempp;
  int *elemp;
  int i;

  elemp = (int *) PyArray_DATA(elem);
  elempp = (int **) malloc(nx * sizeof(int*));
  
  for(i=0; i<nx; i++)
    elempp[i] = &(elemp[i * ny]);
  
  return elempp;

  /* Quando non serve piu' elempp e' sufficente
   * fare una chiamata a free(elempp).
   */
}


long **lmatrix_from_numpy(PyObject *elem)
{
  int nx = (int) PyArray_DIM(elem, 0);
  int ny = (int) PyArray_DIM(elem, 1);
  long **elempp;
  long *elemp;
  int i;

  elemp = (long *) PyArray_DATA(elem);
  elempp = (long **) malloc(nx * sizeof(long*));
  
  for(i=0; i<nx; i++)
    elempp[i] = &(elemp[i * ny]);
  
  return elempp;

  /* Quando non serve piu' elempp e' sufficente
   * fare una chiamata a free(elempp).
   */
}
