# Snapshot report for `test/test.js`

The actual snapshot is saved in `test.js.snap`.

Generated by [AVA](https://avajs.dev).

## produces optimized code when importing esm with a known default export

> Snapshot 1

    `'use strict';␊
    ␊
    var require$$0 = "default";␊
    ␊
    var main = require$$0;␊
    ␊
    module.exports = main;␊
    `

## produces optimized code when importing esm without a default export

> Snapshot 1

    `'use strict';␊
    ␊
    function getAugmentedNamespace(n) {␊
    	if (n.__esModule) return n;␊
    	var a = Object.defineProperty({}, '__esModule', {value: true});␊
    	Object.keys(n).forEach(function (k) {␊
    		var d = Object.getOwnPropertyDescriptor(n, k);␊
    		Object.defineProperty(a, k, d.get ? d : {␊
    			enumerable: true,␊
    			get: function () {␊
    				return n[k];␊
    			}␊
    		});␊
    	});␊
    	return a;␊
    }␊
    ␊
    const value = "value";␊
    ␊
    var esm = /*#__PURE__*/Object.freeze({␊
    	__proto__: null,␊
    	value: value␊
    });␊
    ␊
    var require$$0 = /*@__PURE__*/getAugmentedNamespace(esm);␊
    ␊
    var main = require$$0;␊
    ␊
    module.exports = main;␊
    `

## handles array destructuring assignment

> Snapshot 1

    `'use strict';␊
    ␊
    Object.defineProperty(exports, '__esModule', { value: true });␊
    ␊
    var main = {};␊
    ␊
    /* eslint-disable */␊
    ␊
    function shuffleArray(array) {␊
      for (let i = array.length - 1; i > 0; i--) {␊
        const j = Math.floor(Math.random() * (i + 1));␊
        [array[i], array[j]] = [array[j], array[i]];␊
      }␊
    }␊
    ␊
    var shuffleArray_1 = main.shuffleArray = shuffleArray;␊
    ␊
    exports["default"] = main;␊
    exports.shuffleArray = shuffleArray_1;␊
    `

## can spread an object into module.exports

> Snapshot 1

    `'use strict';␊
    ␊
    const obj = {␊
      a: 'b',␊
      b: 'c'␊
    };␊
    ␊
    var main = {␊
      ...obj␊
    };␊
    ␊
    module.exports = main;␊
    `

## imports .cjs file extension by default

> Snapshot 1

    `'use strict';␊
    ␊
    var main = {};␊
    ␊
    var _export = {␊
      test: 42␊
    };␊
    ␊
    const { test } = _export;␊
    ␊
    console.log(test);␊
    ␊
    module.exports = main;␊
    `
