--  Abstract :
--
--  Tokens for use by Ada code generated by wisi-output_ada_emacs
--
--  Copyright (C) 2014  All Rights Reserved.
--
--  This program is free software; you can redistribute it and/or
--  modify it under terms of the GNU General Public License as
--  published by the Free Software Foundation; either version 3, or (at
--  your option) any later version. This program is distributed in the
--  hope that it will be useful, but WITHOUT ANY WARRANTY; without even
--  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
--  PURPOSE. See the GNU General Public License for more details. You
--  should have received a copy of the GNU General Public License
--  distributed with this program; see file COPYING. If not, write to
--  the Free Software Foundation, 51 Franklin Street, Suite 500, Boston,
--  MA 02110-1335, USA.

pragma License (GPL);

with OpenToken.Token.Enumerated.Nonterminal;
with OpenToken.Token.Enumerated.List;
generic
   type Token_IDs is (<>);
   First_Terminal : in Token_IDs;
   Last_Terminal  : in Token_IDs;

   with function Token_Image (Item : in Token_IDs) return String;
   with package Tokens is new OpenToken.Token.Enumerated
     (Token_IDs, First_Terminal, Last_Terminal, Token_Image);
   with package Token_Lists  is new Tokens.List;
   with package Nonterminals is new Tokens.Nonterminal (Token_Lists);
package OpenToken.Wisi_Tokens is

   type Instance is new Nonterminals.Instance with record
      Buffer_Range : Tokens.Buffer_Range;
   end record;

   subtype Class is Instance'Class;

   type Handle is access all Class;

   overriding
   function Image (Token : in Instance) return String;

   function Get (ID : in Token_IDs) return Nonterminals.Instance'Class;
   --  For use in Syntax; sets null Buffer_Range

   overriding
   procedure Create
     (Lexeme     : in     String;
      Bounds     : in     Tokens.Buffer_Range;
      Recognizer : in     Tokens.Recognizer_Handle;
      New_Token  : in out Instance);
   --  Callback from Analyzer; stores Buffer_Range in New_Token

   function Get (ID : in Token_IDs; Buffer_Range : in Tokens.Buffer_Range) return Nonterminals.Instance'Class;
   --  For use in Actions.

   procedure Self
     (New_Token : out Nonterminals.Class;
      Source    : in  Token_Lists.Instance'Class;
      To_ID     : in  Token_IDs);
   --  For use in Actions.

   ----------
   --  Other functions for wisi actions in generated Ada code for
   --  Ada_Emacs target.

   function Total_Buffer_Range (Tokens : in Token_Lists.Instance'Class) return Wisi_Tokens.Tokens.Buffer_Range;

   function To_Codes (Tokens : in Token_Lists.Instance'Class) return String;

end OpenToken.Wisi_Tokens;
