# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1899-1 (strongswan)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65006);
 script_cve_id("CVE-2009-1957", "CVE-2009-1958", "CVE-2009-2185", "CVE-2009-2661");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 1899-1 (strongswan)");

 desc = "The remote host is missing an update to strongswan
announced via advisory DSA 1899-1.

Several remote vulnerabilities have been discovered in strongswan, an
implementation of the IPSEC and IKE protocols.  The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2009-1957
CVE-2009-1958

The charon daemon can crash when processing certain crafted IKEv2
packets.  (The old stable distribution (etch) was not affected by
these two problems because it lacks IKEv2 support.)

CVE-2009-2185
CVE-2009-2661

The pluto daemon could crash when processing a crafted X.509
certificate.

For the old stable distribution (etch), these problems have been fixed
in version 2.8.0+dfsg-1+etch2.

For the stable distribution (lenny), these problems have been fixed in
version 4.2.4-5+lenny3.

For the unstable distribution (sid), these problems have been fixed in
version 4.3.2-1.1.

We recommend that you upgrade your strongswan packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201899-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1899-1 (strongswan)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"strongswan", ver:"2.8.0+dfsg-1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"strongswan", ver:"4.2.4-5+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
